/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.util.cloud;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.base.license.LicenseException;
import com.kingdee.eas.base.permission.app.util.interior.UserLicenseGroupTool;
import com.kingdee.eas.util.ToolUtils;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class UserPermGroupsUtil {
    private static Logger logger = Logger.getLogger(UserPermGroupsUtil.class);
    protected static Set<String> permGroups = new HashSet<String>();

    public static Map<String, Set<String>> batchGatherCurUserPermGroupsValid(Context ctx, List<String> userIds) throws BOSException {
        HashMap<String, Set<String>> curUserGroups = new HashMap<String, Set<String>>();
        for (String userId : userIds) {
            Set<String> gatherCurUserPermGroups = UserPermGroupsUtil.gatherCurUserPermGroupsValid(ctx, userId);
            curUserGroups.put(userId, gatherCurUserPermGroups);
        }
        return curUserGroups;
    }

    public static Set<String> gatherCurUserPermGroupsValid(Context ctx, String userId) throws BOSException {
        Map<Object, Object> validLicenseMapWithoutFunc = new HashMap();
        try {
            validLicenseMapWithoutFunc = UserLicenseGroupTool.getValidLicenseMapWithoutFunc(ctx);
        }
        catch (LicenseException e) {
            logger.error((Object)e);
        }
        Set<String> permItemMapGroup = UserPermGroupsUtil.getPermItemMapGroup(ctx);
        permItemMapGroup.retainAll(validLicenseMapWithoutFunc.keySet());
        return UserPermGroupsUtil.gatherCurUserPermGroups(ctx, userId, permItemMapGroup);
    }

    public static Set<String> gatherCurUserPermGroups(Context ctx, String userId, Set<String> filterGroups) throws BOSException {
        HashSet<String> groupNumbers = new HashSet<String>();
        StringBuilder sqlBuilder = new StringBuilder();
        String permuigroup = UserLicenseGroupTool.getPermUIGroupTableName(ctx);
        sqlBuilder.append("SELECT distinct pp.fgroupnumber                                 ");
        sqlBuilder.append("  FROM " + permuigroup + " pp                                       ");
        sqlBuilder.append(" inner join t_pm_permitem permitem                              ");
        sqlBuilder.append("    on pp.FPERMITEMID = permitem.fid                            ");
        sqlBuilder.append(" where permitem.FISLEAF = 1                                     ");
        if (filterGroups != null && !filterGroups.isEmpty()) {
            String groupNumbersStr = ToolUtils.aryToStr(filterGroups, (boolean)true);
            sqlBuilder.append("      and pp.fgroupnumber in (" + groupNumbersStr + ")");
        }
        sqlBuilder.append("   and (exists (SELECT 1                                        ");
        sqlBuilder.append("                  from t_pm_userorgperm UserOrgPerm             ");
        sqlBuilder.append("                 where UserOrgPerm.Fowner = ?                   ");
        sqlBuilder.append("                   and UserOrgPerm.FPERMITEMID = permitem.fid   ");
        sqlBuilder.append("                   and UserOrgPerm.FPermType = 10) or exists    ");
        sqlBuilder.append("        (SELECT 1                                               ");
        sqlBuilder.append("           FROM T_PM_UserRoleOrg userRoleOrg                    ");
        sqlBuilder.append("          inner join t_pm_roleperm rolePerm                     ");
        sqlBuilder.append("             on userRoleOrg.FROLEID = rolePerm.FROLEID          ");
        sqlBuilder.append("          where userRoleOrg.fuserid = ?                         ");
        sqlBuilder.append("            and roleperm.fpermitemid = permitem.fid             ");
        sqlBuilder.append("            and rolePerm.FPermType = 10))                       ");
        IRowSet rowSet = null;
        try {
            rowSet = DbUtil.executeQuery((Context)ctx, (String)sqlBuilder.toString(), (Object[])new Object[]{userId, userId});
            while (rowSet.next()) {
                groupNumbers.add(rowSet.getString("fgroupnumber"));
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage());
            throw new BOSException("query data error!");
        }
        return groupNumbers;
    }

    public static Set<String> getPermItemMapGroup(Context ctx) throws BOSException {
        if (permGroups == null || permGroups.isEmpty()) {
            permGroups = new HashSet<String>();
            String permuigroup = UserLicenseGroupTool.getPermUIGroupTableName(ctx);
            StringBuilder sqlBuilder = new StringBuilder();
            sqlBuilder.append("SELECT distinct gp.FGROUPNUMBER  FROM ").append(permuigroup).append(" gp INNER JOIN T_PM_PERMITEM perm on gp.FPERMITEMID = perm.FID ");
            sqlBuilder.append("where perm.FISLEAF = 1 and gp.FGROUPNUMBER is not null");
            IRowSet rowSet = null;
            try {
                rowSet = DbUtil.executeQuery((Context)ctx, (String)sqlBuilder.toString());
                while (rowSet.next()) {
                    permGroups.add(rowSet.getString("fgroupnumber"));
                }
            }
            catch (SQLException e) {
                logger.error((Object)e.getMessage());
                throw new BOSException("query data error!");
            }
        }
        return new HashSet<String>(permGroups);
    }

    public Map<String, Set<String>> getDbGroups(Context ctx, List<String> erpNumber) throws BOSException, SQLException {
        HashMap<String, Set<String>> userGroups = new HashMap<String, Set<String>>();
        StringBuilder sqlBuilder = new StringBuilder();
        sqlBuilder.append("select u.fid           userid,                         ").append("       u.fnumber       userNumber,                       ").append("       up.fid          ugid,                             ").append("       up.fgroupNumber groupNumber,                      ").append("       up.fisactive    isActive                          ").append("  from t_pm_user u                                       ").append(" inner join t_pm_userlicensegroup up                     ").append("    on u.fid = up.fuserid                                ").append(" where up.fgroupNumber in ('PRO_FISCMPM', 'STAFF')       ").append("   and u.ftype not in (10, 60, 70)                       ").append("   and lower(u.fnumber) not in ('administrator',         ").append("                                'user',                  ").append("                                'authenadmin',           ").append("                                'sscadmin',              ").append("                                'auditadmin',            ").append("                                'virtualuser')           ").append(" and up.fisactive = 1                                    ");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sqlBuilder.toString());
        while (rs.next()) {
            String userNumber = rs.getString("userNumber");
            Set<String> groups = userGroups.get(userNumber);
            if (groups != null) continue;
            groups = new HashSet<String>();
            groups.add(rs.getString("groupNumber"));
        }
        return userGroups;
    }
}

