/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.util.xt;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.permission.util.xt.XunTongSynUtils;
import com.kingdee.eas.basedata.org.AdminOrgUnitCollection;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class PrepareBizData {
    public static final String ADDNEW = "addnew";
    public static final String ADDNEWORUPDATE = "addneworupdate";
    public static final String DELETE = "delete";
    public static final String UPDATE = "update";
    private static final Logger logger = Logger.getLogger(PrepareBizData.class);

    public static HashMap<String, HashMap<String, String>> prepareAdminMap(Context ctx) throws BOSException {
        HashMap<String, HashMap<String, String>> adminMap = new HashMap<String, HashMap<String, String>>();
        String sql = "select fid,fparentid,fname_l2 from t_org_admin";
        IRowSet rowSet = XunTongSynUtils.query(ctx, sql.toString());
        try {
            while (rowSet.next()) {
                HashMap<String, String> each = new HashMap<String, String>();
                each.put("id", rowSet.getString("fid"));
                each.put("parent", rowSet.getString("fparentid"));
                each.put("name", rowSet.getString("fname_l2"));
                adminMap.put(rowSet.getString("fid"), each);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return adminMap;
    }

    public static ArrayList<String> preparePersonPhone(Context ctx) throws BOSException {
        ArrayList<String> phone = new ArrayList<String>();
        String sql = "select  fcell from t_bd_person person inner join T_HR_BDEmployeeType empType  on empType.fid=person.FEmployeeTypeID  where empType.FIsInCount=1 and fcell is not null group by fcell having count(*)=1 ";
        IRowSet rowSet = XunTongSynUtils.query(ctx, sql.toString());
        try {
            while (rowSet.next()) {
                if (StringUtils.isEmpty((String)rowSet.getString("fcell"))) continue;
                phone.add(rowSet.getString("fcell"));
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return phone;
    }

    public static String getAdminFullName(String adminId, HashMap<String, HashMap<String, String>> adminMap, HashMap<String, String> fullPathMap) {
        if (fullPathMap.containsKey(adminId)) {
            return fullPathMap.get(adminId);
        }
        HashMap<String, String> each = adminMap.get(adminId);
        if (each == null) {
            return "";
        }
        if (StringUtils.isEmpty((String)each.get("parent"))) {
            fullPathMap.put(adminId, each.get("name"));
            return each.get("name");
        }
        String parentName = PrepareBizData.getAdminFullName(each.get("parent"), adminMap, fullPathMap);
        String currentName = parentName + "\\" + each.get("name");
        fullPathMap.put(adminId, currentName);
        return currentName;
    }

    public static Map<String, Object> prepareOrgIds(Context ctx, Timestamp lastUpdateTime) throws BOSException {
        if (lastUpdateTime == null) {
            Calendar c = Calendar.getInstance();
            c.set(1970, 1, 1);
            lastUpdateTime = new Timestamp(c.getTimeInMillis());
        }
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String dateStr = format.format(lastUpdateTime);
        StringBuffer sql = new StringBuffer();
        sql.append("select admin.Fid fid,admin.FIsSealUp fissealup,admin.FCreateTime fcreatetime,xtorg.fadminorgunitid fadminorgunitid,xtorg.FLastOrgKey flastorgkey,xtorg.FCurrentOrgKey FCurrentOrgKey ").append(" from t_org_admin admin").append(" left join t_bd_hrxuntorgmapping xtorg on xtorg.fadminorgunitid = admin.fid ");
        sql.append(" where (admin.FLastUpdateTime>={ts'").append(dateStr).append("'}");
        sql.append(" or admin.fid not in(select FAdminOrgUnitId from t_bd_hrxuntorgmapping))  order by flastorgkey desc ,FCurrentOrgKey desc");
        IRowSet rowSet = XunTongSynUtils.query(ctx, sql.toString());
        ArrayList<String> addNew = new ArrayList<String>();
        ArrayList update = new ArrayList();
        ArrayList<String> delete = new ArrayList<String>();
        try {
            String id = null;
            boolean isSealUp = false;
            Timestamp createTime = null;
            while (rowSet.next()) {
                id = rowSet.getString("Fid");
                isSealUp = rowSet.getBoolean("FIsSealUp");
                createTime = rowSet.getTimestamp("FCreateTime");
                String flastforgkey = rowSet.getString("flastorgkey");
                String FCurrentOrgKey = rowSet.getString("FCurrentOrgKey");
                if (FCurrentOrgKey == null) {
                    FCurrentOrgKey = "";
                }
                if (isSealUp) {
                    if (StringUtils.isEmpty((String)flastforgkey)) continue;
                    delete.add(flastforgkey);
                }
                if (FCurrentOrgKey.equals(flastforgkey)) continue;
                if (StringUtils.isEmpty((String)flastforgkey)) {
                    addNew.add(FCurrentOrgKey);
                    continue;
                }
                if (FCurrentOrgKey.equals(flastforgkey)) continue;
                HashMap<String, String> node = new HashMap<String, String>();
                node.put("department", flastforgkey);
                node.put("todepartment", FCurrentOrgKey);
                update.add(node);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (delete.size() > 0) {
            map.put(DELETE, delete);
        }
        if (addNew.size() > 0) {
            map.put(ADDNEW, addNew);
        }
        if (update.size() > 0) {
            map.put(UPDATE, update);
        }
        return map;
    }

    public static Map<String, Object> preparePersonIDs(Context ctx, Timestamp lastUpdateTime) throws BOSException {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String dateStr = format.format(lastUpdateTime);
        StringBuffer sql = new StringBuffer();
        sql.append("select person.Fid fid,empType.FIsInCount fisincount,person.FCreateTime,person.fcell fcell,xtuser.fopenid fopenid ").append(" from t_bd_person person ").append(" inner join T_ORG_PositionMember pm on pm.fpersonid = person.fid").append(" left join T_HR_PersonContactMethod pcm on pcm.fpersonid = person.fid").append(" inner join t_hr_bdemployeetype emptype on person.FEmployeeTypeID = emptype.fid ").append(" left join t_bd_hrxuntusermapping xtuser on xtuser.fpersonid = person.fid ");
        sql.append(" where person.FLastUpdateTime>={ts'").append(dateStr).append("'}").append(" or pm.FLastUpdateTime>={ts'").append(dateStr).append("'}").append(" or pcm.FLastUpdateTime>={ts'").append(dateStr).append("'}").append(" or person.fid not in(select fpersonid from t_bd_hrxuntusermapping)");
        logger.error((Object)("preparePersonIDs sql==" + sql.toString()));
        Object[] param = new Object[]{lastUpdateTime, lastUpdateTime, lastUpdateTime};
        IRowSet rowSet = XunTongSynUtils.query(ctx, sql.toString());
        HashSet<String> addNewOrUpdate = new HashSet<String>();
        HashSet<String> update = new HashSet<String>();
        ArrayList<String> delete = new ArrayList<String>();
        try {
            String personId = null;
            boolean isInCount = false;
            Timestamp createTime = null;
            while (rowSet.next()) {
                personId = rowSet.getString("Fid");
                isInCount = rowSet.getBoolean("FIsInCount");
                createTime = rowSet.getTimestamp("FCreateTime");
                if (StringUtils.isEmpty((String)rowSet.getString("fcell"))) {
                    logger.info((Object)(rowSet.getString("Fid") + "   no  homefhone not synchronize !"));
                }
                if (createTime.after(lastUpdateTime)) {
                    if (!isInCount) continue;
                    addNewOrUpdate.add(personId);
                    continue;
                }
                if (isInCount) {
                    if (StringUtils.isEmpty((String)rowSet.getString("fopenid"))) {
                        addNewOrUpdate.add(personId);
                        continue;
                    }
                    update.add(personId);
                    continue;
                }
                if (StringUtils.isEmpty((String)rowSet.getString("fopenid"))) continue;
                delete.add(rowSet.getString("fopenid"));
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (delete.size() > 0) {
            map.put(DELETE, delete);
        }
        if (addNewOrUpdate.size() > 0) {
            map.put(ADDNEW, addNewOrUpdate);
        }
        if (update.size() > 0) {
            map.put(UPDATE, update);
        }
        return map;
    }

    public static List<Map<String, Object>> getOrgUnitList(Context ctx, Set<String> idSet, HashMap<String, HashMap<String, String>> adminMap, HashMap<String, String> fullPathMap) throws BOSException {
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("description"));
        sic.add(new SelectorItemInfo("parent.id"));
        sic.add(new SelectorItemInfo("isSealUp"));
        entityViewInfo.setSelector(sic);
        FilterInfo filter = new FilterInfo();
        if (idSet != null) {
            filter.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
        } else {
            filter.getFilterItems().add(new FilterItemInfo("isSealUp", (Object)false));
        }
        entityViewInfo.setFilter(filter);
        SorterItemCollection sorterItemCollection = new SorterItemCollection();
        SorterItemInfo sortInfo = new SorterItemInfo("longNumber");
        sortInfo.setSortType(SortType.ASCEND);
        sorterItemCollection.add(sortInfo);
        entityViewInfo.setSorter(sorterItemCollection);
        AdminOrgUnitCollection c = null;
        c = ctx == null ? AdminOrgUnitFactory.getRemoteInstance().getAdminOrgUnitCollection(entityViewInfo) : AdminOrgUnitFactory.getLocalInstance((Context)ctx).getAdminOrgUnitCollection(entityViewInfo);
        ArrayList<Map<String, Object>> orgList = new ArrayList<Map<String, Object>>();
        HashMap<String, String> map = null;
        AdminOrgUnitInfo info = null;
        for (int i = 0; i < c.size(); ++i) {
            map = new HashMap<String, String>();
            info = c.get(i);
            map.put("id", info.getId().toString());
            map.put("name", info.getName());
            map.put("description", info.getDescription());
            if (info.getParent() != null) {
                map.put("parentId", info.getParent().getId().toString());
            } else {
                map.put("parentId", null);
            }
            map.put("department", PrepareBizData.getAdminFullName(info.getId().toString(), adminMap, fullPathMap));
            orgList.add(map);
        }
        return orgList;
    }

    public static List<Map<String, Object>> getPersonList(Context ctx, Set<String> idSet, HashMap<String, HashMap<String, String>> adminMap, HashMap<String, String> fullPathMap) throws BOSException {
        boolean isInit = idSet == null || idSet.size() == 0;
        StringBuffer sql = new StringBuffer();
        sql.append(" select person.fid id,").append(" person.fname_l2 name,").append(" person.fgender gender,").append(" person.FCell cell, ").append(" person.FEMail email,").append(" pos.FName_l2 posName,").append(" xtuser.fopenid openid,").append(" pos.FAdminOrgUnitId orgId ").append("from t_bd_person person ").append(" inner join T_ORG_PositionMember pm on pm.fpersonid = person.fid").append(" inner join T_ORG_Position pos on pm.FPositionID = pos.fid").append(" left join t_bd_hrxuntusermapping xtuser on xtuser.fpersonid = person.fid and pm.FIsPrimary=1 ");
        if (isInit) {
            sql.append(" inner join T_HR_EmpLaborRelation emplabor on emplabor.FPersonId = person.FID").append(" inner join t_hr_bdemployeetype emptype on emplabor.FLaborRelationStateID = emptype.fid ");
            sql.append(" where emptype.FIsInCount=1");
            sql.append(" and person.fcell in(select a.fcell  fcell from (select fcell from t_bd_person per inner join T_HR_BDEmployeeType eType on eType.fid=per.FEmployeeTypeID and eType.FIsInCount=1 where fcell is not null) a    group by a.fcell having count(*)=1)");
        } else {
            sql.append(" where person.fid in ").append(XunTongSynUtils.convertSetToString(idSet));
            sql.append(" and person.fcell in(select a.fcell  fcell from (select fcell from t_bd_person where fcell is not null) a    group by a.fcell having count(*)=1)");
        }
        ArrayList<Map<String, Object>> resultList = new ArrayList<Map<String, Object>>();
        try {
            IRowSet rowSet = XunTongSynUtils.query(ctx, sql.toString());
            Map<String, ArrayList<Map<String, String>>> personMap = null;
            String personId = null;
            ArrayList<Map<String, String>> orgJobs = null;
            HashMap<String, Map<String, ArrayList<Map<String, String>>>> personRGMap = new HashMap<String, Map<String, ArrayList<Map<String, String>>>>(rowSet.size());
            while (rowSet.next()) {
                personId = rowSet.getString("id");
                if (StringUtils.isEmpty((String)rowSet.getString("cell"))) continue;
                if (personRGMap.containsKey(personId)) {
                    personMap = (Map)personRGMap.get(personId);
                } else {
                    personMap = new HashMap();
                    personMap.put("id", (ArrayList<Map<String, String>>)((Object)personId));
                    personMap.put("name", (ArrayList<Map<String, String>>)((Object)rowSet.getString("name")));
                    if (rowSet.getInt("gender") == 1 || rowSet.getInt("gender") == 2) {
                        personMap.put("gender", (ArrayList<Map<String, String>>)((Object)String.valueOf(rowSet.getInt("gender"))));
                    } else {
                        personMap.put("gender", (ArrayList<Map<String, String>>)((Object)"0"));
                    }
                    personMap.put("phone", (ArrayList<Map<String, String>>)((Object)rowSet.getString("cell")));
                    personMap.put("email", (ArrayList<Map<String, String>>)((Object)rowSet.getString("email")));
                    personMap.put("jobTitle", (ArrayList<Map<String, String>>)((Object)rowSet.getString("posName")));
                    personMap.put("job", (ArrayList<Map<String, String>>)((Object)rowSet.getString("posName")));
                    personMap.put("openId", (ArrayList<Map<String, String>>)((Object)rowSet.getString("openid")));
                    personMap.put("regSource", (ArrayList<Map<String, String>>)((Object)"sHR"));
                    personRGMap.put(personId, personMap);
                    if (!StringUtils.isEmpty((String)rowSet.getString("orgId"))) {
                        personMap.put("department", (ArrayList<Map<String, String>>)((Object)PrepareBizData.getAdminFullName(rowSet.getString("orgId"), adminMap, fullPathMap)));
                    }
                    resultList.add(personMap);
                }
                HashMap<String, String> orgJobMap = new HashMap<String, String>();
                orgJobMap.put("id", rowSet.getString("orgId"));
                orgJobMap.put("job", rowSet.getString("posName"));
                if (personMap.containsKey("orgJobs")) {
                    orgJobs = (ArrayList<Map<String, String>>)personMap.get("orgJobs");
                } else {
                    orgJobs = new ArrayList<Map<String, String>>(5);
                    personMap.put("orgJobs", orgJobs);
                }
                PrepareBizData.processOrgJob(orgJobs, orgJobMap);
                if (!isInit || idSet == null) continue;
                idSet.add(personId);
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return resultList;
    }

    private static void processOrgJob(List<Map<String, String>> orgJobs, Map<String, String> orgJobMap) {
        String orgId = orgJobMap.get("id");
        boolean exist = false;
        for (Map<String, String> orgJob : orgJobs) {
            if (!orgId.equals(orgJob.get("id"))) continue;
            exist = true;
            orgJob.put("job", orgJob.get("job") + "," + orgJobMap.get("job"));
            break;
        }
        if (!exist) {
            orgJobs.add(orgJobMap);
        }
    }
}

