/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.data.engine.rowsfile;

import com.kingdee.bos.ctrl.reportone.data.engine.resultset.BasicResultSet;
import com.kingdee.bos.ctrl.reportone.data.engine.resultset.IPersistent;
import com.kingdee.bos.ctrl.reportone.data.engine.rowsfile.RowsFile;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;

public class RowsFileBasedResultSet
extends BasicResultSet
implements ResultSet,
IPersistent {
    RowsFile rowsFile;
    int rowNo = 0;
    Object[] rowData;

    RowsFileBasedResultSet(RowsFile rowsFile) {
        this.rowsFile = rowsFile;
    }

    public RowsFile getRowsFile() {
        return this.rowsFile;
    }

    @Override
    public int getRow() throws SQLException {
        this.checkCursor(false);
        return this.rowNo;
    }

    @Override
    public boolean next() throws SQLException {
        this.checkCursor(true);
        this.rowData = null;
        if (++this.rowNo <= this.rowsFile.getRowCount()) {
            return true;
        }
        this.cursorStatus = -2;
        return false;
    }

    @Override
    public boolean absolute(int row) throws SQLException {
        super.checkCursor(false);
        if (row > this.rowsFile.getRowCount() + 1) {
            throw new SQLException("Bad parameter for absolutly move cursor. row=" + row);
        }
        this.rowNo = row == -1 ? this.rowsFile.getRowCount() : row;
        this.rowData = null;
        this.cursorStatus = 0;
        return true;
    }

    protected final void ensureData() throws SQLException {
        try {
            this.rowsFile.seek(this.rowNo - 1);
            this.rowData = this.rowsFile.readNextRow();
        }
        catch (IOException ex) {
            throw new SQLException(ex.toString());
        }
    }

    @Override
    public Object getObject(int i) throws SQLException {
        this.checkCursor(false);
        if (i < 1 || i > this.getMetaData().getColumnCount()) {
            throw new SQLException("Bad column index:" + i);
        }
        if (this.rowData == null) {
            this.ensureData();
        }
        return this.rowData[i - 1];
    }

    @Override
    public ResultSetMetaData getMetaData() {
        return this.rowsFile.getMetaData();
    }

    @Override
    public void close() throws SQLException {
        super.close();
        this.rowsFile.destroy();
    }

    public Object getObject(int columnIndex, Class type) throws SQLException {
        return null;
    }

    public Object getObject(String columnLabel, Class type) throws SQLException {
        return null;
    }
}

