/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.data.framework.bos;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.FullPath;
import com.kingdee.bos.ctrl.common.util.DBUtil;
import com.kingdee.bos.ctrl.common.util.LogUtil;
import com.kingdee.bos.ctrl.data.DataDefType;
import com.kingdee.bos.ctrl.reportone.data.framework.bos.BosUtil;
import com.kingdee.bos.ctrl.reportone.data.invoke.IDataExecutor;
import com.kingdee.bos.ctrl.reportone.data.invoke.SimpleSqlTempTableResult;
import com.kingdee.bos.ctrl.reportone.data.process.dataset.ITempTableManager;
import com.kingdee.bos.ctrl.reportone.forapp.eas.Eas_DataEnvProvider;
import com.kingdee.bos.dao.query.EntityExecutorFactory;
import com.kingdee.bos.dao.query.IDataProvider;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.query.QueryInfo;
import java.security.InvalidParameterException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class BosExecutor
implements IDataExecutor {
    private static final Logger log = LogUtil.getPackageLogger(BosExecutor.class);
    private Context ctx;
    private static BosExecutor remoteInstance = new BosExecutor(null);

    public static BosExecutor getRemoteInstance() {
        return remoteInstance;
    }

    public static BosExecutor newLocalInstance(Context ctx) {
        return new BosExecutor(ctx);
    }

    protected BosExecutor(Context ctx) {
        this.ctx = ctx;
    }

    @Override
    public Object execute(String category, Object obj, HashMap args, IDataExecutor env) throws Exception {
        if (obj instanceof QueryInfo) {
            return this.executeQuery(((QueryInfo)obj).getFullName(), args);
        }
        if (obj instanceof EntityViewInfo) {
            return this.executeEntity(((QueryInfo)obj).getFullName(), args);
        }
        if (obj instanceof FullPath) {
            FullPath fp = (FullPath)obj;
            DataDefType type = DataDefType.fromName((String)fp.getCategory());
            if (DataDefType.BOS_QUERY == type) {
                return this.executeQuery(fp.getDots(), args);
            }
            if (DataDefType.BOS_ENTITY == type) {
                return this.executeEntity(fp.getDots(), args);
            }
        }
        throw new UnsupportedOperationException();
    }

    private boolean isRemote() {
        return this.ctx == null;
    }

    protected IQueryExecutor getQueryExecutor(String fullName) {
        MetaDataPK pk = new MetaDataPK(fullName);
        if (this.isRemote()) {
            return QueryExecutorFactory.getRemoteInstance((IMetaDataPK)pk);
        }
        return QueryExecutorFactory.getLocalInstance((Context)this.ctx, (IMetaDataPK)pk);
    }

    protected IDataProvider getEntityExecutor(String fullName) {
        MetaDataPK pk = new MetaDataPK(fullName);
        if (this.isRemote()) {
            return EntityExecutorFactory.getRemoteInstance((IMetaDataPK)pk);
        }
        return EntityExecutorFactory.getLocalInstance((Context)this.ctx, (IMetaDataPK)pk);
    }

    public Object executeQuery(String fullName, HashMap args) throws BOSException, SQLException, Exception {
        IQueryExecutor exec = this.getQueryExecutor(fullName);
        try {
            QueryInfo qi = BosUtil.getMetaDataLoader().getQuery((IMetaDataPK)new MetaDataPK(fullName));
            EntityViewInfo evi = this.prepareDataView(args, qi);
            if (evi != null) {
                exec.setObjectView(evi);
            }
        }
        catch (Exception ex) {
            log.error((Object)"\u52a0\u6570\u636e\u89c6\u56fe\u5931\u8d25\uff0c\u5ffd\u7565\u9519\u8bef\u7ee7\u7eed\u8fd0\u884c", (Throwable)ex);
        }
        return this.executeWithMode((IDataProvider)exec, args);
    }

    public Object executeEntity(String fullName, HashMap args) throws BOSException, SQLException, Exception {
        IDataProvider exec = this.getEntityExecutor(fullName);
        try {
            EntityObjectInfo eoi = BosUtil.getMetaDataLoader().getEntity((IMetaDataPK)new MetaDataPK(fullName));
            EntityViewInfo evi = this.prepareDataView(args, eoi);
            if (evi != null) {
                exec.setObjectView(evi);
            }
        }
        catch (Exception ex) {
            log.error((Object)"\u52a0\u6570\u636e\u89c6\u56fe\u5931\u8d25\uff0c\u5ffd\u7565\u9519\u8bef\u7ee7\u7eed\u8fd0\u884c", (Throwable)ex);
        }
        return this.executeWithMode(exec, args);
    }

    protected EntityViewInfo prepareDataView(HashMap args, QueryInfo qi) throws Exception {
        return null;
    }

    protected EntityViewInfo prepareDataView(HashMap args, EntityObjectInfo eoi) throws Exception {
        return null;
    }

    private Object executeWithMode(IDataProvider exec, HashMap args) throws BOSException, SQLException, Exception {
        Object argExecMode = args.get("executeMode");
        if (argExecMode == null) {
            exec.option().isAutoTranslateEnum = true;
            if (log.isInfoEnabled()) {
                log.info((Object)("\r\n" + exec.getSQL()));
            }
            return exec.executeQuery();
        }
        if ("SQL".equals(argExecMode) || "SQL_TEMP".equals(argExecMode)) {
            exec.option().isAutoTranslateEnum = false;
            String sql = exec.getSQL();
            if (log.isInfoEnabled()) {
                log.info((Object)("\r\n" + sql));
            }
            if ("SQL".equals(argExecMode)) {
                return sql;
            }
            return new SimpleSqlTempTableResult(sql, (ITempTableManager)new Eas_DataEnvProvider(null).get("_ENV_TEMP_TABLE_NAME_PROVIDER"));
        }
        if ("RESULT_SET".equals(argExecMode)) {
            exec.option().isAutoTranslateEnum = false;
            String sql = exec.getSQL();
            if (log.isInfoEnabled()) {
                log.info((Object)("\r\n" + sql));
            }
            Connection conn = EJBFactory.getQueryConnection((Context)this.ctx);
            return DBUtil.executeSql((Connection)conn, (String)sql);
        }
        throw new InvalidParameterException("Unknown execute mode:" + argExecMode);
    }
}

