/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.data.wizard.process.simple_gt;

import com.kingdee.bos.ctrl.common.CtrlUIEnv;
import com.kingdee.bos.ctrl.common.DataType;
import com.kingdee.bos.ctrl.common.layout.table.Table;
import com.kingdee.bos.ctrl.common.layout.table.TableLayout;
import com.kingdee.bos.ctrl.common.ui.ListView;
import com.kingdee.bos.ctrl.common.ui.WindowUtil;
import com.kingdee.bos.ctrl.data.modal.IDefObjList;
import com.kingdee.bos.ctrl.reportone.data.modal.IDataDef;
import com.kingdee.bos.ctrl.reportone.data.modal.query.Column;
import com.kingdee.bos.ctrl.reportone.data.modal.types.CalculateType;
import com.kingdee.bos.ctrl.reportone.data.modal.types.DataSetType;
import com.kingdee.bos.ctrl.reportone.data.modal.types.IDataSetTypeProvider;
import com.kingdee.bos.ctrl.reportone.data.modal.types.grouping.Group;
import com.kingdee.bos.ctrl.reportone.data.modal.types.grouping.Grouping;
import com.kingdee.bos.ctrl.reportone.data.modal.types.grouping.Groups;
import com.kingdee.bos.ctrl.reportone.data.modal.types.grouping.Total;
import com.kingdee.bos.ctrl.reportone.data.modal.types.rows.OutputColumns;
import com.kingdee.bos.ctrl.reportone.data.process.IDataProcessModel;
import com.kingdee.bos.ctrl.reportone.data.process.dataset.group.defs.GroupTotalDef;
import com.kingdee.bos.ctrl.reportone.data.process.dataset.group.defs.GroupTotalDefs;
import com.kingdee.bos.ctrl.reportone.data.process.dataset.group.defs.SimpleGroupsDef;
import com.kingdee.bos.ctrl.reportone.data.process.dataset.group.defs.TotalDef;
import com.kingdee.bos.ctrl.reportone.data.wizard.dataprocess.GroupEditorDialog;
import com.kingdee.bos.ctrl.reportone.data.wizard.dataprocess.GroupListCellRenderer;
import com.kingdee.bos.ctrl.reportone.data.wizard.process.AbstractModelEditor;
import com.kingdee.bos.ctrl.reportone.data.wizard.process.Process2Resource;
import com.kingdee.bos.ctrl.reportone.data.wizard.process.WizardHelper;
import com.kingdee.bos.ctrl.reportone.data.wizard.process.simple_gt.SimpleGroupTotalModel;
import com.kingdee.bos.ctrl.reportone.data.wizard.process.simple_gt.TotalEditorDialog;
import com.kingdee.bos.ctrl.res.Resource;
import com.kingdee.bos.ctrl.swing.KDFrame;
import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.ctrl.swing.KDList;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDScrollPane;
import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.lang.reflect.Method;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class SimpleGroupTotalEditor
extends AbstractModelEditor {
    private KDPanel panSupply;
    private KDPanel panSelected;
    protected KDWorkButton grpBtnSelect;
    private KDWorkButton grpBtnDelete;
    protected KDWorkButton ttlBtnSelectForAll;
    protected KDWorkButton ttlBtnSelect;
    private KDWorkButton ttlBtnDelete;
    private ListView lvGroups;
    private ListView lvTotals;
    private GroupEditorDialog groupEditorDialog;
    private TotalEditorDialog totalEditorDialog;
    private KDList lstSupply;

    public SimpleGroupTotalEditor() {
        this.setOpaque(false);
        this.init();
    }

    private void init() {
        KDLabel labSuply = new KDLabel();
        this.panSupply = new KDPanel();
        labSuply.setText(Process2Resource.getString("res_58"));
        labSuply.setPreferredSize(new Dimension(200, 21));
        this.lstSupply = new KDList();
        this.setSupplyCtrl((JComponent)this.lstSupply);
        TableLayout tl = TableLayout.split((int)1, (int)2);
        tl.colStyle(0).setWidth(-40);
        tl.colStyle(0).setPriX(1);
        tl.colStyle(1).setWidth(-60);
        tl.colStyle(1).setPriX(1);
        Table col0 = tl.cell(0).split(2, 1);
        col0.rowStyle(0).setHeight(20);
        col0.rowStyle(1).setPriY(1);
        this.setLayout((LayoutManager)tl);
        this.add((Component)labSuply, col0.cell(0, 0));
        this.add((Component)this.panSupply, col0.cell(1, 0));
        this.add((Component)this.createGroupPane(), tl.cell(1));
        this.syncButton();
        this.installListener();
    }

    private void installListener() {
        KDList groupList = this.lvGroups.getList();
        groupList.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    SimpleGroupTotalEditor.this.editGroup();
                }
            }
        });
        groupList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                SimpleGroupTotalEditor.this.syncSelectButton();
                SimpleGroupTotalEditor.this.syncDeleteButton(0);
                SimpleGroupTotalEditor.this.syncEditButton(SimpleGroupTotalEditor.this.lvGroups);
                SimpleGroupTotalEditor.this.syncTotalNewButton();
                SimpleGroupTotalEditor.this.listTotal(SimpleGroupTotalEditor.this.lvGroups.getList().getSelectedValue());
            }
        });
        KDList totalList = this.lvTotals.getList();
        totalList.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    SimpleGroupTotalEditor.this.editTotal();
                }
            }
        });
        totalList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                SimpleGroupTotalEditor.this.syncDeleteButton(1);
                SimpleGroupTotalEditor.this.syncEditButton(SimpleGroupTotalEditor.this.lvTotals);
            }
        });
        this.lstSupply.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                SimpleGroupTotalEditor.this.syncButton();
            }
        });
        ActionHandler actionHandler = new ActionHandler();
        this.grpBtnSelect.addActionListener((ActionListener)actionHandler);
        this.grpBtnDelete.addActionListener((ActionListener)actionHandler);
        this.ttlBtnSelectForAll.addActionListener((ActionListener)actionHandler);
        this.ttlBtnSelect.addActionListener((ActionListener)actionHandler);
        this.ttlBtnDelete.addActionListener((ActionListener)actionHandler);
    }

    private void syncButton() {
        this.syncSelectButton();
        this.syncDeleteButton(0);
        this.syncDeleteButton(1);
        this.syncEditButton(this.lvGroups);
        this.syncEditButton(this.lvTotals);
        this.syncTotalNewButton();
    }

    public void setSupplyCtrl(JComponent comp) {
        this.panSupply.removeAll();
        this.panSupply.setLayout((LayoutManager)new BorderLayout());
        this.panSupply.add((Component)new KDScrollPane((Component)comp), (Object)"Center");
    }

    public KDTree getSupplyTree() {
        return null;
    }

    private KDPanel createGroupPane() {
        this.lvGroups = new ListView(){

            protected boolean onBeforeUp(int selectedIndex) {
                return selectedIndex >= 2;
            }

            protected boolean onBeforeDown(int selectedIndex) {
                Group gp = (Group)((Object)this.getList().getElement(selectedIndex));
                if (gp.isRootGroup()) {
                    return false;
                }
                return selectedIndex != this.getList().getElementCount() - 1;
            }
        };
        this.lvGroups.getList().setCellRenderer((ListCellRenderer)((Object)new GroupListCellRenderer()));
        this.lvTotals = new ListView();
        this.lvTotals.setEnableMoveItem(false);
        this.lvGroups.setTitle(Process2Resource.getString("res_59"));
        this.lvTotals.setTitle(Process2Resource.getString("res_60"));
        this.lvGroups.addButton((Action)new ActionNewGroup(), "new");
        this.lvGroups.addButton((Action)new ActionEditGroup(), "edit");
        this.lvTotals.addButton((Action)new ActionNewTotal(), "new");
        this.lvTotals.addButton((Action)new ActionEditTotal(), "edit");
        this.grpBtnSelect = new KDWorkButton(Process2Resource.getString("res_61"), (Icon)Resource.ICON_MOVE_LEFT);
        this.grpBtnDelete = new KDWorkButton(Process2Resource.getString("res_62"), (Icon)Resource.ICON_MOVE_RIGHT);
        this.ttlBtnSelectForAll = new KDWorkButton(Process2Resource.getString("res_63"));
        this.ttlBtnSelect = new KDWorkButton(Process2Resource.getString("res_64"), (Icon)Resource.ICON_MOVE_LEFT);
        this.ttlBtnDelete = new KDWorkButton(Process2Resource.getString("res_65"), (Icon)Resource.ICON_MOVE_RIGHT);
        TableLayout tl = TableLayout.split((int)2, (int)2);
        tl.rowStyle(0).setHeight(-40);
        tl.rowStyle(1).setHeight(-60);
        tl.rowStyle(0).setPriY(1);
        tl.rowStyle(1).setPriY(1);
        tl.colStyle(0).setMargin(3, 0, 3, 0);
        tl.colStyle(0).setWidth(28);
        tl.colStyle(1).setPriX(1);
        Table btnArea1 = tl.cell(0, 0).split(5, 1);
        btnArea1.rowStyle(0).setPriY(1);
        for (int i = 1; i < 4; ++i) {
            btnArea1.rowStyle(i).setHeight(21);
            btnArea1.rowStyle(i).setMarginBottom(3);
        }
        btnArea1.rowStyle(4).setPriY(1);
        Table btnArea2 = tl.cell(1, 0).split(5, 1);
        btnArea2.rowStyle(0).setPriY(1);
        for (int i = 1; i < 4; ++i) {
            btnArea2.rowStyle(i).setHeight(21);
            btnArea2.rowStyle(i).setMarginBottom(3);
        }
        btnArea2.rowStyle(4).setPriY(1);
        this.panSelected = new KDPanel((LayoutManager)tl);
        this.panSelected.setOpaque(false);
        this.panSelected.add((Component)this.lvGroups, (Object)tl.cell(0, 1));
        this.panSelected.add((Component)this.lvTotals, (Object)tl.cell(1, 1));
        this.panSelected.add((Component)this.grpBtnSelect, (Object)btnArea1.cell(2, 0));
        this.panSelected.add((Component)this.grpBtnDelete, (Object)btnArea1.cell(3, 0));
        this.panSelected.add((Component)this.ttlBtnSelectForAll, (Object)btnArea2.cell(1, 0));
        this.panSelected.add((Component)this.ttlBtnSelect, (Object)btnArea2.cell(2, 0));
        this.panSelected.add((Component)this.ttlBtnDelete, (Object)btnArea2.cell(3, 0));
        return this.panSelected;
    }

    private void listTotal(Object element) {
        this.lvTotals.getList().removeAllElements();
        if (element == null) {
            return;
        }
        IDefObjList list = ((Group)((Object)element)).getTotals();
        for (int i = 0; i < list.size(); ++i) {
            this.lvTotals.getList().addElement(list.get(i));
        }
    }

    private void addToTtlList(Total ttl) {
        if (this.lvGroups.getList().getSelectedValue() == null) {
            return;
        }
        Group gp = (Group)((Object)this.lvGroups.getList().getSelectedValue());
        gp.getTotals().add((Object)ttl);
    }

    private void deleteTtlList(Total ttl) {
        IDefObjList list = ((Group)((Object)this.lvGroups.getList().getSelectedValue())).getTotals();
        for (int j = 0; j < list.size(); ++j) {
            if (!((Total)list.get(j)).getColumn().equals(ttl.getColumn())) continue;
            list.remove(j);
        }
    }

    private boolean findByName(KDList list, String nameGetter, String name) {
        for (int i = 0; i < list.getElementCount(); ++i) {
            Object obj = list.getElement(i);
            try {
                Method method = obj.getClass().getMethod(nameGetter, null);
                String tempName = (String)method.invoke(obj, null);
                if (!tempName.equals(name)) continue;
                return true;
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return false;
            }
        }
        return false;
    }

    private Total makeTotal(String columnName, DataType columnType, Group group) {
        Total total = new Total();
        total.setColumn(columnName);
        total.setColumnType(columnType);
        if (DataType.isNumberType((DataType)columnType)) {
            total.setFunction(CalculateType.CAL_SUM.getName());
        } else {
            total.setFunction(CalculateType.CAL_COUNT.getName());
        }
        total.setGroup(group);
        return total;
    }

    private void onSelect(KDList list, int type) {
        Object[] objects = this.lstSupply.getSelectedValues();
        for (int i = 0; i < objects.length; ++i) {
            Group group;
            Column column = (Column)((Object)objects[i]);
            if (type == 0) {
                if (this.findByName(list, "getName", column.getName())) continue;
                group = new Group();
                group.setName(column.getName());
                group.setAlias(column.getAlias());
                list.addElement((Object)group);
                continue;
            }
            Total targetTotal = null;
            KDList groupList = this.lvGroups.getList();
            if (type == 1) {
                if (this.findByName(list, "getColumn", column.getName())) continue;
                group = (Group)((Object)groupList.getSelectedValue());
                targetTotal = this.makeTotal(column.getName(), column.getDataType(), group);
            } else {
                for (int j = 0; j < groupList.getElementCount(); ++j) {
                    group = (Group)((Object)groupList.getElement(j));
                    if (group.findTotal(column.getName()) != null) continue;
                    Total total = this.makeTotal(column.getName(), column.getDataType(), group);
                    group.getTotals().add((Object)total);
                    if (j != groupList.getSelectedIndex()) continue;
                    targetTotal = total;
                }
            }
            if (targetTotal == null) continue;
            list.addElement(targetTotal);
        }
    }

    private void onDeleteGroup() {
        KDList list = this.lvGroups.getList();
        int[] idxs = list.getSelectedIndices();
        for (int i = idxs.length - 1; i >= 0; --i) {
            list.removeElementAt(idxs[i]);
        }
        if (idxs[0] < list.getElementCount()) {
            list.setSelectedIndex(idxs[0]);
        } else {
            list.setSelectedIndex(list.getElementCount() - 1);
        }
    }

    public void refreshGroups(List availableColumns) {
    }

    private void onDeleteTotal() {
        KDList list = this.lvTotals.getList();
        int[] idxs = list.getSelectedIndices();
        for (int i = idxs.length - 1; i >= 0; --i) {
            this.deleteTtlList((Total)list.getElement(idxs[i]));
            list.removeElementAt(idxs[i]);
        }
        if (idxs[0] < list.getElementCount()) {
            list.setSelectedIndex(idxs[0]);
        } else {
            list.setSelectedIndex(list.getElementCount() - 1);
        }
    }

    private void syncSelectButton() {
        Object[] objs = this.lstSupply.getSelectedValues();
        if (objs.length > 0) {
            this.grpBtnSelect.setEnabled(true);
            if (this.lvGroups.getList().getSelectedValue() != null) {
                this.ttlBtnSelect.setEnabled(true);
            } else {
                this.ttlBtnSelect.setEnabled(false);
            }
            if (this.lvGroups.getList().getElementCount() > 0) {
                this.ttlBtnSelectForAll.setEnabled(true);
            } else {
                this.ttlBtnSelectForAll.setEnabled(false);
            }
        } else {
            this.grpBtnSelect.setEnabled(false);
            this.ttlBtnSelectForAll.setEnabled(false);
            this.ttlBtnSelect.setEnabled(false);
        }
        this.lvGroups.getButton("new").setEnabled(false);
    }

    private void syncDeleteButton(int type) {
        switch (type) {
            case 0: {
                this.grpBtnDelete.setEnabled(false);
                Object[] objects = this.lvGroups.getList().getSelectedValues();
                for (int i = 0; i < objects.length; ++i) {
                    if (!((Group)((Object)objects[i])).isRootGroup()) continue;
                    return;
                }
                this.grpBtnDelete.setEnabled(true);
                break;
            }
            case 1: {
                if (this.lvTotals.getList().getSelectedIndex() == -1) {
                    this.ttlBtnDelete.setEnabled(false);
                    break;
                }
                this.ttlBtnDelete.setEnabled(true);
            }
        }
    }

    private void syncEditButton(ListView lv) {
        if (lv == this.lvGroups) {
            lv.getButton("edit").setEnabled(false);
        } else if (lv.getList().getSelectedIndex() == -1 || lv.getList().getSelectedIndices().length > 1) {
            lv.getButton("edit").setEnabled(false);
        } else {
            lv.getButton("edit").setEnabled(true);
        }
    }

    private void syncTotalNewButton() {
        this.lvTotals.getButton("new").setEnabled(false);
    }

    private void editGroup() {
        Group column = (Group)((Object)this.lvGroups.getList().getSelectedValue());
        if (column == null) {
            return;
        }
        GroupEditorDialog editor = this.getGpFieldDialog();
        editor.setTitle(Process2Resource.getString("res_67"));
        editor.setTxtName(column.getName());
        editor.setAlias(column.getAlias());
        editor.setType(column.isRootGroup());
        if (editor.showDialog()) {
            column.setName(editor.getTxtName());
            column.setAlias(editor.getAlias());
            this.lvGroups.getList().repaint();
        }
    }

    private GroupEditorDialog getGpFieldDialog() {
        if (this.groupEditorDialog == null) {
            this.groupEditorDialog = (GroupEditorDialog)((Object)WindowUtil.createWindow(GroupEditorDialog.class, (Component)((Object)this)));
        }
        return this.groupEditorDialog;
    }

    private void editTotal() {
        Total column = (Total)this.lvTotals.getList().getSelectedValue();
        if (column == null) {
            return;
        }
        TotalEditorDialog editor = this.getTtlFieldDialog();
        editor.setTitle(Process2Resource.getString("res_68"));
        editor.setTxtName(column.getColumn());
        editor.installFunctions(column.getColumnType());
        editor.setFunction(CalculateType.fromName(column.getFunction()));
        if (editor.showDialog()) {
            column.setColumn(editor.getTxtName());
            column.setFunction(editor.getFunction().getName());
            this.lvGroups.getList().repaint();
        }
    }

    private TotalEditorDialog getTtlFieldDialog() {
        if (this.totalEditorDialog == null) {
            this.totalEditorDialog = (TotalEditorDialog)((Object)WindowUtil.createWindow(TotalEditorDialog.class, (Component)((Object)this)));
        }
        return this.totalEditorDialog;
    }

    public static void main(String[] args) {
        CtrlUIEnv.setKingdeeLAF();
        SimpleGroupTotalEditor s = new SimpleGroupTotalEditor();
        KDFrame f = new KDFrame();
        f.setDefaultCloseOperation(3);
        f.setSize(800, 600);
        f.getContentPane().add((Component)((Object)s));
        f.show();
    }

    public Grouping getGrouping(Grouping grouping) {
        Groups groups = new Groups();
        for (int i = 0; i < this.lvGroups.getList().getElementCount(); ++i) {
            Group gp = (Group)((Object)this.lvGroups.getList().getElement(i));
            groups.add((Object)gp);
        }
        grouping.setGroups(groups);
        return grouping;
    }

    public void showValue(IDataDef dataObj) {
        IDataSetTypeProvider ds;
        if (dataObj.getOutputs() == null) {
            return;
        }
        if (dataObj.getOutputs().size() > 0 && (ds = (IDataSetTypeProvider)dataObj.getOutputs().get(0)).getType().equals(DataSetType.GROUPING)) {
            Grouping grouping = (Grouping)dataObj.getOutputs().get(0);
            for (int i = 0; i < grouping.getGroups().size(); ++i) {
                this.lvGroups.getList().addElement(grouping.getGroups().get(i));
            }
        }
    }

    SimpleGroupTotalModel myModel() {
        return (SimpleGroupTotalModel)this.getModel();
    }

    @Override
    public void setModel(IDataProcessModel model) {
        super.setModel(model);
        Grouping grouping = this.myModel().getGrouping();
        KDList groupList = this.lvGroups.getList();
        for (int i = 0; i < grouping.getGroups().size(); ++i) {
            groupList.addElement(grouping.getGroups().get(i));
        }
        if (groupList.getElementCount() > 0) {
            groupList.setSelectedIndex(0);
        }
        WizardHelper.setKDListOutputCols(this.lstSupply, grouping.getFields(), false);
    }

    public void updateModel() {
        SimpleGroupTotalModel myModel = this.myModel();
        KDList groupList = this.lvGroups.getList();
        SimpleGroupsDef sgDefs = null;
        GroupTotalDefs gtDefs = null;
        OutputColumns inputOCs = (OutputColumns)myModel.getInput();
        int size = groupList.getElementCount();
        for (int i = 0; i < size; ++i) {
            if (sgDefs == null) {
                sgDefs = new SimpleGroupsDef(size - 1);
                gtDefs = new GroupTotalDefs(size - 1);
            }
            Group group = (Group)((Object)groupList.getElement(i));
            if (i != 0) {
                int groupFieldIndex = 1 + inputOCs.indexOf(group.getName());
                sgDefs.setGroupColumn(i, groupFieldIndex);
            }
            GroupTotalDef gtDef = new GroupTotalDef();
            gtDefs.setGroupTotalDef(i, gtDef);
            IDefObjList totals = group.getTotals();
            for (int total = 0; total < totals.size(); ++total) {
                Total totalObj = (Total)totals.get(total);
                int totalFieldIndex = 1 + inputOCs.indexOf(totalObj.getColumn());
                TotalDef totalDef = new TotalDef(totalFieldIndex, totalObj.getFunction(), "");
                gtDef.addTotalDef(totalDef);
            }
        }
        myModel.setGroupTotalDefs(gtDefs);
        myModel.setSimpleGroupsDef(sgDefs);
    }

    @Override
    public void onLostEditor() {
        this.updateModel();
    }

    private class ActionEditTotal
    extends AbstractAction {
        public ActionEditTotal() {
            this.putValue("SmallIcon", Resource.ICON_EDIT);
            this.putValue("ShortDescription", Process2Resource.getString("res_68"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SimpleGroupTotalEditor.this.editTotal();
        }
    }

    private class ActionNewTotal
    extends AbstractAction {
        public ActionNewTotal() {
            this.putValue("SmallIcon", Resource.ICON_NEW_FILE);
            this.putValue("ShortDescription", Process2Resource.getString("res_64"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Total column = new Total();
            TotalEditorDialog editor = SimpleGroupTotalEditor.this.getTtlFieldDialog();
            editor.setTitle(Process2Resource.getString("res_64"));
            editor.setTxtName("");
            editor.setFunction(null);
            if (editor.showDialog()) {
                column.setColumn(editor.getTxtName());
                column.setFunction(editor.getFunction().getName());
                SimpleGroupTotalEditor.this.lvTotals.getList().addElement((Object)column);
                SimpleGroupTotalEditor.this.lvTotals.getList().setSelectedValue((Object)column, true);
                SimpleGroupTotalEditor.this.addToTtlList(column);
            }
        }
    }

    private class ActionEditGroup
    extends AbstractAction {
        public ActionEditGroup() {
            this.putValue("SmallIcon", Resource.ICON_EDIT);
            this.putValue("ShortDescription", Process2Resource.getString("res_66"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SimpleGroupTotalEditor.this.editGroup();
        }
    }

    private class ActionNewGroup
    extends AbstractAction {
        public ActionNewGroup() {
            this.putValue("SmallIcon", Resource.ICON_NEW_FILE);
            this.putValue("ShortDescription", Process2Resource.getString("res_61"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Group column = new Group();
            GroupEditorDialog editor = SimpleGroupTotalEditor.this.getGpFieldDialog();
            editor.setTitle(Process2Resource.getString("res_61"));
            editor.setTxtName("");
            editor.setAlias("");
            editor.setType(false);
            if (editor.showDialog()) {
                column.setName(editor.getTxtName());
                column.setAlias(editor.getAlias());
                column.setRootGroup(editor.isSelected());
                SimpleGroupTotalEditor.this.lvGroups.getList().addElement((Object)column);
                SimpleGroupTotalEditor.this.lvGroups.getList().setSelectedValue((Object)column, true);
            }
        }
    }

    private class ActionHandler
    implements ActionListener {
        private ActionHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object source = e.getSource();
            if (source == SimpleGroupTotalEditor.this.grpBtnSelect) {
                SimpleGroupTotalEditor.this.onSelect(SimpleGroupTotalEditor.this.lvGroups.getList(), 0);
            } else if (source == SimpleGroupTotalEditor.this.ttlBtnSelectForAll) {
                SimpleGroupTotalEditor.this.onSelect(SimpleGroupTotalEditor.this.lvTotals.getList(), 2);
            } else if (source == SimpleGroupTotalEditor.this.ttlBtnSelect) {
                SimpleGroupTotalEditor.this.onSelect(SimpleGroupTotalEditor.this.lvTotals.getList(), 1);
            } else if (source == SimpleGroupTotalEditor.this.grpBtnDelete) {
                SimpleGroupTotalEditor.this.onDeleteGroup();
                SimpleGroupTotalEditor.this.syncDeleteButton(0);
            } else if (source == SimpleGroupTotalEditor.this.ttlBtnDelete) {
                SimpleGroupTotalEditor.this.onDeleteTotal();
                SimpleGroupTotalEditor.this.syncDeleteButton(1);
            }
            SimpleGroupTotalEditor.this.syncSelectButton();
        }
    }
}

