/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.forapp.eas;

import com.kingdee.bos.ctrl.common.util.LogUtil;
import com.kingdee.bos.ctrl.common.util.PathUtil;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.reportone.data.framework.bos.BosUtil;
import com.kingdee.bos.ctrl.reportone.forapp.eas.EasResource;
import com.kingdee.bos.ctrl.reportone.kdrs.biz.content.ContentCategory;
import com.kingdee.bos.ctrl.reportone.kdrs.biz.content.IBizContent;
import com.kingdee.bos.ctrl.reportone.kdrs.engine.server.IServerSideEngine;
import com.kingdee.bos.ctrl.reportone.kdrs.engine.server.IServerSideSession;
import com.kingdee.bos.ctrl.reportone.kdrs.exception.KDRSException;
import com.kingdee.bos.ctrl.reportone.kdrs.frameworks.bos.KdrsBosServerEngine;
import com.kingdee.bos.ctrl.reportone.kdrs.frameworks.standard.AbstractHook;
import com.kingdee.bos.ctrl.reportone.kdrs.frameworks.standard.IAisStartupHook;
import com.kingdee.bos.ctrl.reportone.kdrs.storage.IStorage;
import com.kingdee.bos.ctrl.reportone.kdrs.storage.ResourceType;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.view.BusinessObjectBriefView;
import com.kingdee.bos.metadata.view.IBriefViewTreeNode;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class Eas_KdrsInit
extends AbstractHook
implements IAisStartupHook {
    private static final Logger log = LogUtil.getPackageLogger(Eas_KdrsInit.class);

    @Override
    public void onAisStartup(String ais, IStorage sto, IServerSideEngine engine) throws KDRSException {
        if (!StringUtil.isEmptyString((String)ais)) {
            KdrsBosServerEngine kdrs = KdrsBosServerEngine.getInstance();
            IServerSideSession ssn = kdrs.createSession(sto, null);
            IBizContent bizCnt = (IBizContent)kdrs.getBizObject(IBizContent.class, ssn);
            this.init(bizCnt);
            ssn.destroy();
        }
    }

    public void init(IBizContent bizCnt) throws KDRSException {
        if (bizCnt.isExist("/EAS_Report.kdrs")) {
            return;
        }
        log.info((Object)"Init EAS report project ...");
        HashMap<String, String> atts = new HashMap<String, String>();
        atts.put("category", ContentCategory.KDRS_PROJECT.getName());
        atts.put("alias", EasResource.getString("res_19"));
        bizCnt.create("/EAS_Report.kdrs", atts);
        IMetaDataLoader mdl = BosUtil.getMetaDataLoader();
        BusinessObjectBriefView bmdView = mdl.getBusinessObjectBriefView((IMetaDataPK)new MetaDataPK("eas_base_subsystem"));
        IBriefViewTreeNode root = bmdView.getViewRoot();
        Eas_KdrsInit.parseBriefPackage(root, bizCnt, "/EAS_Report.kdrs");
        log.info((Object)"EAS report project build success.");
    }

    public static void parseBriefPackage(IBriefViewTreeNode node, IBizContent bizCnt, String parentPath) throws KDRSException {
        HashMap<String, String> atts = new HashMap<String, String>();
        int z = node.getChildCount();
        for (int i = 0; i < z; ++i) {
            IBriefViewTreeNode childNode = (IBriefViewTreeNode)node.getChildAt(i);
            if (!childNode.isPackage()) continue;
            String childPath = PathUtil.makeChildPath((String)parentPath, (String)childNode.getName());
            log.info((Object)("Init subsystem:" + childPath));
            atts.put("type", ResourceType.FOLDER.getName());
            atts.put("alias", childNode.getAlias());
            atts.put("package", childNode.getPackageName());
            if (!bizCnt.isExist(childPath)) {
                bizCnt.create(childPath, atts);
            }
            Eas_KdrsInit.parseBriefPackage(childNode, bizCnt, childPath);
        }
    }
}

