/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.kdrs.frameworks.bos.service;

import com.kingdee.bos.AbstractBOSObject;
import com.kingdee.bos.ctrl.common.util.LogUtil;
import com.kingdee.bos.ctrl.common.util.PathUtil;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.reportone.kdrs.biz.BizRpcReducer;
import com.kingdee.bos.ctrl.reportone.kdrs.exception.KDRSException;
import com.kingdee.bos.ctrl.reportone.kdrs.frameworks.bos.common.IBosSystem;
import com.kingdee.bos.ctrl.reportone.kdrs.frameworks.bos.common.IServiceWrapper;
import com.kingdee.bos.ctrl.reportone.kdrs.frameworks.bos.service.BosContentService;
import com.kingdee.bos.ctrl.reportone.kdrs.frameworks.bos.service.BosSecurityService;
import com.kingdee.bos.ctrl.reportone.kdrs.frameworks.bos.service.BosStorageService;
import com.kingdee.bos.ctrl.reportone.kdrs.frameworks.bos.service.BosSystemService;
import com.kingdee.bos.ctrl.reportone.kdrs.frameworks.standard.rpc.common.IRpcContent;
import com.kingdee.bos.ctrl.reportone.kdrs.frameworks.standard.rpc.common.IRpcSecurity;
import com.kingdee.bos.ctrl.reportone.kdrs.frameworks.standard.rpc.common.IRpcStorage;
import com.kingdee.bos.util.BOSObjectType;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class ServiceWrapper
extends AbstractBOSObject
implements IServiceWrapper {
    private static final Logger log = LogUtil.getPackageLogger(ServiceWrapper.class);
    private IBosSystem bosSystemService = new BosSystemService();
    private IRpcStorage storageService = new BosStorageService();
    private IRpcSecurity securityService = new BosSecurityService();
    private IRpcContent contentService = new BosContentService();

    public BOSObjectType getType() {
        return null;
    }

    @Override
    public String login(String ais, String lang) throws KDRSException {
        return this.bosSystemService.login(ais, lang);
    }

    @Override
    public void logout(String sid) throws KDRSException {
        this.bosSystemService.logout(sid);
    }

    @Override
    public boolean isExistForContent(String sid, String path) throws KDRSException {
        return this.contentService.isExist(sid, path);
    }

    @Override
    public boolean isExist(String sid, String path) throws KDRSException {
        return this.storageService.isExist(sid, path);
    }

    @Override
    public boolean isAtomicForContent(String sid, String path) throws KDRSException {
        return this.contentService.isAtomic(sid, path);
    }

    @Override
    public boolean isAtomic(String sid, String path) throws KDRSException {
        return this.storageService.isAtomic(sid, path);
    }

    @Override
    public void createForContent(String sid, String s, HashMap attrs) throws KDRSException {
        this.contentService.create(sid, s, attrs);
    }

    @Override
    public void create(String sid, String s, HashMap attrs) throws KDRSException {
        this.storageService.create(sid, s, attrs);
    }

    @Override
    public void deleteForContent(String sid, String path) throws KDRSException {
        this.contentService.delete(sid, path);
    }

    @Override
    public void delete(String sid, String path) throws KDRSException {
        this.storageService.delete(sid, path);
    }

    @Override
    public void renameForContent(String sid, String path, String newName) throws KDRSException {
        this.contentService.rename(sid, path, newName);
    }

    @Override
    public void rename(String sid, String path, String newName) throws KDRSException {
        this.storageService.rename(sid, path, newName);
    }

    @Override
    public HashMap getAttributesForContent(String sid, String path, String[] keys) throws KDRSException {
        HashMap result = this.contentService.getAttributes(sid, path, keys);
        if (keys != null && keys.length == 2 && "isselected".equals(keys[0]) && "prttimes".equals(keys[1])) {
            String parentPath = path;
            while (!"1".equals(result.get(keys[0])) && (parentPath = PathUtil.getParentPath((String)parentPath)) != null && parentPath.length() >= 2) {
                result = this.contentService.getAttributes(sid, parentPath, keys);
            }
        }
        return result;
    }

    @Override
    public HashMap getAttributes(String sid, String path, String[] keys) throws KDRSException {
        return this.storageService.getAttributes(sid, path, keys);
    }

    @Override
    public void setAttributesForContent(String sid, String path, HashMap attrs) throws KDRSException {
        this.contentService.setAttributes(sid, path, attrs);
    }

    @Override
    public void setAttributes(String sid, String path, HashMap attrs) throws KDRSException {
        this.storageService.setAttributes(sid, path, attrs);
    }

    @Override
    public byte[] readFileForContent(String sid, String path, int offset, int length) throws KDRSException {
        return this.contentService.readFile(sid, path, offset, length);
    }

    @Override
    public byte[] readFile(String sid, String path, int offset, int length) throws KDRSException {
        return this.storageService.readFile(sid, path, offset, length);
    }

    @Override
    public void writeFileForContent(String sid, String path, int offset, byte[] data) throws KDRSException {
        this.contentService.writeFile(sid, path, offset, data);
    }

    @Override
    public void writeFile(String sid, String path, int offset, byte[] data) throws KDRSException {
        this.storageService.writeFile(sid, path, offset, data);
    }

    @Override
    public void copyForContent(String sid, String src, String dest) throws KDRSException {
        this.contentService.copy(sid, src, dest);
    }

    @Override
    public void copy(String sid, String src, String dest) throws KDRSException {
        this.storageService.copy(sid, src, dest);
    }

    @Override
    public HashMap listForContent(String sid, String path, HashMap attrs) throws KDRSException {
        return this.contentService.list(sid, path, attrs);
    }

    @Override
    public HashMap list(String sid, String path, HashMap attrs) throws KDRSException {
        return this.storageService.list(sid, path, attrs);
    }

    @Override
    public HashMap[] list2ForContent(String sid, String path, HashMap attrs) throws KDRSException {
        return this.contentService.list2(sid, path, attrs);
    }

    @Override
    public HashMap[] list2(String sid, String path, HashMap attrs) throws KDRSException {
        return this.storageService.list2(sid, path, attrs);
    }

    @Override
    public String executeStart(String sid, String path, HashMap args) throws KDRSException {
        return this.contentService.executeStart(sid, path, args);
    }

    @Override
    public Object executeCall(String sid, String objId, String method, String[] argTypeNames, Object[] args) throws KDRSException {
        return this.contentService.executeCall(sid, objId, method, argTypeNames, args);
    }

    @Override
    public void executeEnd(String sid, String objId) throws KDRSException {
        this.contentService.executeEnd(sid, objId);
    }

    @Override
    public String viewHistory(String sid, String path, String name) throws KDRSException {
        return this.contentService.viewHistory(sid, path, name);
    }

    @Override
    public String viewSnapshot(String sid, String path) throws KDRSException {
        return this.contentService.viewSnapshot(sid, path);
    }

    @Override
    public byte[] readTemplate(String sid, String objPath) throws KDRSException {
        return this.contentService.readTemplate(sid, objPath);
    }

    @Override
    public void writeTemplate(String sid, String objPath, byte[] data) throws KDRSException {
        this.contentService.writeTemplate(sid, objPath, data);
    }

    @Override
    public byte[] readConfig(String sid, String objPath) throws KDRSException {
        return this.contentService.readConfig(sid, objPath);
    }

    @Override
    public void writeConfig(String sid, String objPath, byte[] data) throws KDRSException {
        this.contentService.writeConfig(sid, objPath, data);
    }

    @Override
    public HashMap listHistory(String sid, String objPath, HashMap atts) throws KDRSException {
        return this.contentService.listHistory(sid, objPath, atts);
    }

    @Override
    public void deleteHistory(String sid, String objPath, String name) throws KDRSException {
        this.contentService.deleteHistory(sid, objPath, name);
    }

    @Override
    public String createSnapshot(String sid, String objPath, HashMap atts) throws KDRSException {
        return this.contentService.createSnapshot(sid, objPath, atts);
    }

    @Override
    public void deleteSnapshot(String sid, String objPath) throws KDRSException {
        this.contentService.deleteSnapshot(sid, objPath);
    }

    @Override
    public HashMap listObjects(String sid, int objType, String[] attrNames) throws KDRSException {
        return this.securityService.listObjects(sid, objType, attrNames);
    }

    @Override
    public int createObject(String sid, int objType, HashMap attrs) throws KDRSException {
        return this.securityService.createObject(sid, objType, attrs);
    }

    @Override
    public void deleteObject(String sid, int objType, int id) throws KDRSException {
        this.securityService.deleteObject(sid, objType, id);
    }

    @Override
    public void setObjectInfo(String sid, int objType, int id, HashMap attrs) throws KDRSException {
        this.securityService.setObjectInfo(sid, objType, id, attrs);
    }

    @Override
    public HashMap getObjectInfo(String sid, int objType, int id, String[] attrsNames) throws KDRSException {
        return this.securityService.getObjectInfo(sid, objType, id, attrsNames);
    }

    @Override
    public void setRule(String sid, String path, HashMap ruleDef) throws KDRSException {
        this.securityService.setRule(sid, path, ruleDef);
    }

    @Override
    public HashMap getRule(String sid, String path) throws KDRSException {
        return this.securityService.getRule(sid, path);
    }

    @Override
    public Map batchCall(Map batchRecords) throws KDRSException {
        Object login = batchRecords.remove("login");
        String sessionId = null;
        if (login instanceof String) {
            sessionId = (String)login;
        } else if (login instanceof Object[]) {
            Object[] loginParams = (Object[])login;
            String ais = (String)loginParams[0];
            String lang = (String)loginParams[1];
            sessionId = this.login(ais, lang);
        }
        HashMap tempSpecialResult = null;
        for (String key : batchRecords.keySet()) {
            if (key.startsWith("Special.")) {
                tempSpecialResult = new HashMap();
                this.doSpecial(batchRecords, key, sessionId, tempSpecialResult);
                continue;
            }
            String[] dKey = BizRpcReducer.decodeKey(key);
            String method = dKey[1];
            if ("IBizContent".equals(dKey[0])) {
                method = method + "ForContent";
            }
            Class[] paramsType = (Class[])BizRpcReducer.ParamsType.get(key);
            Class[] realParamsType = new Class[paramsType.length + 1];
            System.arraycopy(paramsType, 0, realParamsType, 1, paramsType.length);
            realParamsType[0] = String.class;
            Map paramss = (Map)batchRecords.get(key);
            for (Object[] paramsValue : paramss.keySet()) {
                Object result;
                Object[] realParamsValue = new Object[paramsValue.length + 1];
                System.arraycopy(paramsValue, 0, realParamsValue, 1, paramsValue.length);
                realParamsValue[0] = sessionId;
                try {
                    result = ServiceWrapper.class.getMethod(method, realParamsType).invoke((Object)this, realParamsValue);
                }
                catch (Exception e) {
                    log.error((Object)("ServiceWrapper.batchCall error. " + key), (Throwable)e);
                    result = KDRSException.makeException(e);
                }
                paramss.put(paramsValue, result);
            }
        }
        batchRecords.put("login", sessionId);
        if (tempSpecialResult != null) {
            for (String key : tempSpecialResult.keySet()) {
                batchRecords.put(key, tempSpecialResult.get(key));
            }
        }
        return batchRecords;
    }

    private void doSpecial(Map batchRecords, String key, String sessionId, Map result) {
        if ("Special.fileVer".equals(key)) {
            String[] vs = (String[])batchRecords.get(key);
            String filePath = vs[0];
            String clientFileVer = vs[1];
            String[] paramsValue = new String[]{"last-tpl-modified"};
            try {
                HashMap tempResult = this.getAttributesForContent(sessionId, filePath, paramsValue);
                String serverFileVer = (String)tempResult.get("last-tpl-modified");
                if (StringUtil.equals((String)clientFileVer, (String)serverFileVer)) {
                    result.put("template", BizRpcReducer.SameVersion);
                } else {
                    byte[] content = this.readTemplate(sessionId, filePath);
                    result.put("template", content);
                }
                result.put("Special.fileVer", serverFileVer);
            }
            catch (KDRSException ex) {
                log.error((Object)("ServiceWrapper.doSpecial error. " + key), (Throwable)ex);
                result.put("template", ex);
            }
        }
    }
}

