/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.kdrs.frameworks.standard;

import com.kingdee.bos.ctrl.common.util.LogUtil;
import com.kingdee.bos.ctrl.reportone.kdrs.exception.KDRSException;
import com.kingdee.bos.ctrl.reportone.kdrs.frameworks.standard.AbstractHook;
import com.kingdee.bos.ctrl.reportone.kdrs.frameworks.standard.HookDef;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;

public class HookFactory {
    public static final Logger log = LogUtil.getLogger(HookFactory.class);
    private HashMap hookDefs;

    public HookFactory(HashMap hookDefs) {
        this.hookDefs = hookDefs;
    }

    public Object createHook(Class hookType) throws KDRSException {
        List hooks = (List)this.hookDefs.get(hookType);
        if (hooks == null) {
            return null;
        }
        try {
            return Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{hookType}, (InvocationHandler)new HooksHandler(hooks));
        }
        catch (Exception ex) {
            throw KDRSException.makeException("hookType:" + hookType, ex);
        }
    }

    private static class HooksHandler
    implements InvocationHandler {
        private ArrayList hooks = new ArrayList();

        public HooksHandler(List hookDefs) throws Exception {
            for (int i = 0; i < hookDefs.size(); ++i) {
                HookDef hookDef = (HookDef)hookDefs.get(i);
                Constructor c = hookDef.getHookImplClass().getConstructor(null);
                Object hook = c.newInstance(null);
                if (hook instanceof AbstractHook) {
                    ((AbstractHook)hook).setProperties(hookDef.getProperties());
                }
                this.hooks.add(hook);
            }
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            for (int i = 0; i < this.hooks.size(); ++i) {
                Object hook = this.hooks.get(i);
                try {
                    method.invoke(hook, args);
                    continue;
                }
                catch (Exception ex) {
                    if (ex instanceof InvocationTargetException) {
                        throw ((InvocationTargetException)ex).getTargetException();
                    }
                    throw ex;
                }
            }
            return null;
        }
    }
}

