/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.kdrs.objectx.objs;

import com.kingdee.bos.ctrl.reportone.kdrs.Path;
import com.kingdee.bos.ctrl.reportone.kdrs.exception.InvalidParameterException;
import com.kingdee.bos.ctrl.reportone.kdrs.exception.KDRSException;
import com.kingdee.bos.ctrl.reportone.kdrs.objectx.AbstractSingleObject;
import com.kingdee.bos.ctrl.reportone.kdrs.objectx.objs.IFileObject;
import com.kingdee.bos.ctrl.reportone.kdrs.storage.IRandomAccessStream;
import com.kingdee.bos.ctrl.reportone.kdrs.storage.IStorage;
import com.kingdee.bos.ctrl.reportone.kdrs.storage.ResourceType;
import com.kingdee.bos.ctrl.reportone.r1.form.designer.util.MultiLanguageUtil;
import java.io.IOException;
import java.util.HashMap;

public class FileObject
extends AbstractSingleObject
implements IFileObject {
    public FileObject(IStorage storage, Path path, String type) {
        super(storage, path, type);
    }

    public static final void build(IStorage storage, Path path, HashMap attrs) throws KDRSException {
        storage.create(path, ResourceType.FILE, attrs);
    }

    @Override
    public void reset() throws KDRSException {
        this.writeFile(-1, new byte[0]);
    }

    @Override
    public IRandomAccessStream openStream(boolean autoClear, boolean autoCreate) throws KDRSException {
        return this.storage.getFileStream(this.path, autoClear, false);
    }

    @Override
    public byte[] readFile(int offset, int length) throws KDRSException {
        if (offset < 0) {
            throw new InvalidParameterException("Bad offset for read file!!!");
        }
        if (length < 0) {
            throw new InvalidParameterException("Bad length for read file!!!");
        }
        byte[] data = null;
        IRandomAccessStream stream = null;
        try {
            stream = this.storage.getFileStream(this.path, false, true);
            int fileSize = (int)stream.length();
            if (fileSize > 0 && offset >= fileSize) {
                throw new InvalidParameterException("Invalid offset for read from");
            }
            if (length > fileSize - offset) {
                length = fileSize - offset;
            }
            stream.seek(offset);
            data = new byte[length];
            stream.read(data);
        }
        catch (IOException ex) {
            throw KDRSException.makeException(MultiLanguageUtil.getMLS("objs.FileObject.readFileFailed", ""), ex);
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException ex) {
                    throw KDRSException.makeException(MultiLanguageUtil.getMLS("objs.FileObject.closeFileFailed", ""), ex);
                }
            }
        }
        return data;
    }

    @Override
    public void writeFile(int offset, byte[] data) throws KDRSException {
        IRandomAccessStream stream = null;
        try {
            if (offset < 0) {
                offset = 0;
                stream = this.storage.getFileStream(this.path, true, false);
            } else {
                stream = this.storage.getFileStream(this.path, false, false);
            }
            stream.seek(offset);
            stream.write(data);
            this.storage.setAttribute(this.path, "last-modified", "" + System.currentTimeMillis());
        }
        catch (IOException ex) {
            throw KDRSException.makeException(MultiLanguageUtil.getMLS("objs.FileObject.writeFileFailed", ""), ex);
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (Exception ex) {
                    throw KDRSException.makeException(MultiLanguageUtil.getMLS("objs.FileObject.closeFileFailed", ""), ex);
                }
            }
        }
    }

    @Override
    public int getFileLength() throws KDRSException {
        return this.storage.getFileLength(this.path);
    }

    @Override
    public Object getAttribute(String name) throws KDRSException {
        if ("size".equals(name)) {
            return String.valueOf(this.getFileLength());
        }
        return super.getAttribute(name);
    }
}

