/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.kdrs.storage.fs;

import com.kingdee.bos.ctrl.common.util.FileUtil;
import com.kingdee.bos.ctrl.common.util.LogUtil;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.reportone.kdrs.Path;
import com.kingdee.bos.ctrl.reportone.kdrs.exception.AlreadyExistsException;
import com.kingdee.bos.ctrl.reportone.kdrs.exception.CreateException;
import com.kingdee.bos.ctrl.reportone.kdrs.exception.DeleteException;
import com.kingdee.bos.ctrl.reportone.kdrs.exception.KDRSException;
import com.kingdee.bos.ctrl.reportone.kdrs.exception.NotFoundException;
import com.kingdee.bos.ctrl.reportone.kdrs.exception.UnsupportedOperationException;
import com.kingdee.bos.ctrl.reportone.kdrs.storage.IRandomAccessStream;
import com.kingdee.bos.ctrl.reportone.kdrs.storage.ISpaceProvider;
import com.kingdee.bos.ctrl.reportone.kdrs.storage.ResourceType;
import com.kingdee.bos.ctrl.reportone.kdrs.storage.fs.FsResource;
import com.kingdee.bos.ctrl.reportone.kdrs.storage.fs.RandomAccessFileStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class FSSpaceProvider
implements ISpaceProvider {
    private static final Logger log = LogUtil.getPackageLogger(FSSpaceProvider.class);
    private String fsRootDir;

    public FSSpaceProvider(String fsRootDir) {
        this.fsRootDir = fsRootDir;
        log.debug((Object)("FS root directory is:" + fsRootDir));
    }

    public FSSpaceProvider(File rootFile) {
        this(rootFile.getAbsolutePath());
    }

    public static final String makeFilePath(Path resPath, String fsRootDir) {
        if (resPath.isRoot()) {
            return fsRootDir;
        }
        return fsRootDir + resPath.getPathText().replace('/', FileUtil.FILE_SEPARATOR_CHAR);
    }

    private final File checkExist(Path resPath) throws KDRSException {
        String filePath = FSSpaceProvider.makeFilePath(resPath, this.fsRootDir);
        File file = new File(filePath);
        if (!file.exists()) {
            try {
                file.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return file;
        }
        return file;
    }

    private final File checkExistFile(Path resPath) throws KDRSException {
        File file = this.checkExist(resPath);
        if (!file.isFile()) {
            try {
                file.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return file;
        }
        return file;
    }

    @Override
    public void allocate(Path resPath, boolean isFile) throws KDRSException {
        File file;
        String filePath;
        block8: {
            if (log.isDebugEnabled()) {
                log.debug((Object)("allocat resPath:" + resPath + " isFile:" + isFile));
            }
            filePath = FSSpaceProvider.makeFilePath(resPath, this.fsRootDir);
            file = new File(filePath);
            if (isFile) {
                try {
                    if (file.createNewFile()) {
                        return;
                    }
                    break block8;
                }
                catch (IOException ex) {
                    throw KDRSException.makeException(FsResource.getString("res_1"), ex);
                }
            }
            if (file.mkdir()) {
                return;
            }
        }
        if (file.exists()) {
            if (isFile && file.isFile() || !isFile && file.isDirectory()) {
                throw new AlreadyExistsException("The specified resource war already exists!!! filePath:" + filePath);
            }
            throw new UnsupportedOperationException("The specified resource war already exists, but type dismatched!!! filePath:" + filePath);
        }
        throw new CreateException("Create specified resource failed!!! filePath:" + filePath);
    }

    @Override
    public void copyFile(Path fromPath, Path toPath) throws KDRSException {
        File fromFile = this.checkExistFile(fromPath);
        File toFile = this.checkExistFile(toPath);
        try {
            FileUtil.copyFile((File)fromFile, (File)toFile);
        }
        catch (IOException ex) {
            throw KDRSException.makeException(FsResource.getString("res_2"), ex);
        }
    }

    @Override
    public int exist(Path resource) {
        File file = new File(FSSpaceProvider.makeFilePath(resource, this.fsRootDir));
        if (file.exists()) {
            return file.isFile() ? 1 : 2;
        }
        return 0;
    }

    @Override
    public void free(Path resPath) throws KDRSException {
        File file;
        File f;
        if (log.isDebugEnabled()) {
            log.debug((Object)("free resPath:" + resPath));
        }
        if ((f = FileUtil.deleteFile((File)(file = this.checkExist(resPath)))) != null) {
            throw new DeleteException("Couldn't delete filePath:" + f.getAbsolutePath());
        }
    }

    @Override
    public void rename(Path resPath, String newName) throws KDRSException {
        if (StringUtil.equals((String)resPath.getName(), (String)newName)) {
            return;
        }
        File file = this.checkExist(resPath);
        Path toPath = resPath.getBrother(newName);
        String toFilePath = FSSpaceProvider.makeFilePath(toPath, this.fsRootDir);
        File toFile = new File(toFilePath);
        if (toFile.exists()) {
            throw new AlreadyExistsException("The specified resource was already exists!!! filePath:" + toFile.getAbsolutePath());
        }
        if (!file.renameTo(toFile)) {
            throw new KDRSException("Couldn't rename " + file.getAbsolutePath() + " to " + toFile.getAbsolutePath());
        }
    }

    @Override
    public void move(Path path1, Path path2) throws KDRSException {
        if (path1.getParent().equals(path2.getParent())) {
            this.rename(path1, path2.getName());
            return;
        }
        File fileSrc = this.checkExist(path1);
        File fileTarget = new File(FSSpaceProvider.makeFilePath(path2, this.fsRootDir));
        if (fileTarget.exists()) {
            throw new AlreadyExistsException("The specified resource was already exists!!! filePath:" + fileTarget.getAbsolutePath());
        }
        if (!fileSrc.renameTo(fileTarget)) {
            throw new KDRSException("Couldn't rename " + fileSrc.getAbsolutePath() + " to " + fileTarget.getAbsolutePath());
        }
    }

    @Override
    public IRandomAccessStream openStream(Path resPath, boolean clear, boolean autoCreate, boolean readOnly) throws KDRSException {
        String filePath = FSSpaceProvider.makeFilePath(resPath, this.fsRootDir);
        File file = new File(filePath);
        if (!file.exists() && autoCreate) {
            try {
                if (!file.createNewFile()) {
                    throw new CreateException("Automatically create resource failed!!! filePath:" + file.getAbsolutePath());
                }
            }
            catch (IOException ex) {
                throw KDRSException.makeException(ex);
            }
            clear = false;
        }
        try {
            return new RandomAccessFileStream(file, clear, readOnly);
        }
        catch (FileNotFoundException e2) {
            throw new NotFoundException(e2.toString());
        }
    }

    @Override
    public int getLength(Path resource) throws KDRSException {
        return (int)this.checkExistFile(resource).length();
    }

    @Override
    public HashMap list(Path folderPath) throws KDRSException {
        File file = this.checkExist(folderPath);
        if (file.isFile()) {
            throw new UnsupportedOperationException("Couldn't support 'listChildren' on file type resource.");
        }
        HashMap<String, ResourceType> map = new HashMap<String, ResourceType>();
        File[] files = file.listFiles();
        for (int i = 0; i < files.length; ++i) {
            map.put(files[i].getName(), files[i].isDirectory() ? ResourceType.FOLDER : ResourceType.FILE);
        }
        return map;
    }

    public String toString() {
        return "FSSpaceProvider@" + this.hashCode() + "[root=" + this.fsRootDir + "]";
    }
}

