/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.grid;

import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.kdf.util.style.ShareStyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Style;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.AbstractReportObject;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.ElementPath;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.ICompositeContainer;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.ICompositeObject;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.IContainer;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.IElement;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.IReportObject;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.grid.AbstractCell;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.grid.AbstractColumn;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.grid.AbstractRow;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.grid.IGridsFactory;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.grid.merge.MergeBlock;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.exception.R1DesignerRuntimeException;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.gui.core.StructureTree;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.gui.mouseoperate.GridState;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.gui.mouseoperate.IMouseOperate;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.gui.mouseoperate.IMouseOperateState;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.gui.property.IPropertyPanel;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.gui.ruler.IR1Ruler;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.gui.ruler.RulerMark;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.gui.undo.UndoHelper;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.model.ReportSelectionModel;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.renderer.operate.GridLineAdjustRenderer;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.renderer.selection.GridElementSelectionRenderer;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.renderer.selection.ICompositeSelectionRenderer;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.util.ContainerUtil;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.util.MergeUtil;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.util.MultiLanguageUtil;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.util.Util;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.tree.MutableTreeNode;

public abstract class AbstractGrid
extends AbstractReportObject
implements ICompositeObject,
IMouseOperate {
    protected ArrayList _rows;
    protected ArrayList _columns;
    private static GridLineAdjustRenderer _lineAdjustRenderer = new GridLineAdjustRenderer();
    protected GridState _gridMouseOperateState = new GridState();
    private Rectangle lastDragRect = null;

    protected abstract IGridsFactory getGridsFactory();

    public AbstractGrid() {
        this._rows = new ArrayList();
        this._columns = new ArrayList();
    }

    public int getFeatHeight() {
        int h = 0;
        int rowCnt = this.getRowsCount();
        for (int i = 0; i < rowCnt; ++i) {
            h += this.getRow(i).getFeatHeight();
        }
        return h;
    }

    public int getFeatWidth() {
        int w = 0;
        int colCnt = this.getColumnsCount();
        for (int j = 0; j < colCnt; ++j) {
            w += this.getColumn(j).getFeatWidth();
        }
        return w;
    }

    public AbstractRow insertRow(int type, int rowIndex) {
        if (rowIndex < 0 || rowIndex > this._rows.size()) {
            return null;
        }
        return this.createRow(type, rowIndex);
    }

    public AbstractRow addRow(int type) {
        return this.createRow(type, this._rows.size());
    }

    protected AbstractRow createRow(int type, int rowIndex) {
        AbstractRow row = this.getGridsFactory().createRow(type, this._columns.size());
        row.setHeightLom(50);
        this._rows.add(rowIndex, row);
        MergeUtil.adjustInserRow(this, rowIndex);
        return row;
    }

    public boolean insertRow(AbstractRow row, int idx) {
        if (row.getCellCount() == this.getColumnsCount() && idx >= 0 && idx <= this.getRowsCount()) {
            int c = row.getCellCount();
            for (int i = 0; i < c; ++i) {
                row.getCell(i).setMergeBlock(null);
            }
            this._rows.add(idx, row);
            MergeUtil.adjustInserRow(this, idx);
            return true;
        }
        return false;
    }

    public boolean removeRow(AbstractRow row) {
        int idx = this.getIndexOfRow(row);
        boolean result = this.getRows().remove(row);
        if (result) {
            MergeUtil.adjustDeleteRow(this, idx);
        }
        return result;
    }

    public AbstractRow getRow(int rowIndex) {
        return (AbstractRow)this._rows.get(rowIndex);
    }

    private List getRows() {
        return this._rows;
    }

    public int getRowsCount() {
        return this.getRows().size();
    }

    public AbstractColumn addColumn() {
        return this.createColumn(this._columns.size());
    }

    public AbstractColumn insertColumn(int colIndex) {
        if (colIndex < 0 || colIndex > this._columns.size()) {
            return null;
        }
        return this.createColumn(colIndex);
    }

    private AbstractColumn createColumn(int colIndex) {
        AbstractColumn col = this.getGridsFactory().createColumn();
        col.setWidthLom(40);
        this._columns.add(colIndex, col);
        for (int i = 0; i < this.getRowsCount(); ++i) {
            this.getRow(i).insertCell(colIndex);
        }
        MergeUtil.adjustInserCol(this, colIndex);
        return col;
    }

    public boolean removeColumn(AbstractColumn col) {
        int colIdx = this.getIndexOfColumn(col);
        boolean isRemoved = this.getColumns().remove(col);
        if (isRemoved) {
            for (int i = 0; i < this.getRowsCount(); ++i) {
                this.getRow(i).removeCell(colIdx);
            }
            MergeUtil.adjustDeleteCol(this, colIdx);
        }
        return isRemoved;
    }

    public void removeAllCell() {
        this.getColumns().clear();
        this.getRows().clear();
    }

    public AbstractColumn getColumn(int colIndex) {
        return (AbstractColumn)this._columns.get(colIndex);
    }

    private List getColumns() {
        return this._columns;
    }

    public int getColumnsCount() {
        return this.getColumns().size();
    }

    protected abstract int getRowChildrenMinRemain(int var1);

    protected abstract int getColumnChildrenMinRemain(int var1);

    private int getIndexOfRowByPoint(int pixelYAtGrid) {
        if (pixelYAtGrid < 0) {
            return -1;
        }
        int h = this.getOffsetY();
        int rowCnt = this.getRowsCount();
        for (int i = 0; i < rowCnt; ++i) {
            if (pixelYAtGrid >= (h += this.getRow(i).getFeatHeight())) continue;
            return i;
        }
        return -1;
    }

    protected int getIndexOfColumnByPoint(int pixelXAtGrid) {
        if (pixelXAtGrid < 0) {
            return -1;
        }
        int w = this.getOffsetX();
        int colCnt = this.getColumnsCount();
        for (int j = 0; j < colCnt; ++j) {
            if (pixelXAtGrid >= (w += this.getColumn(j).getFeatWidth())) continue;
            return j;
        }
        return -1;
    }

    public Point getIndexOfCell(AbstractCell cell) {
        int c = this.getRowsCount();
        for (int i = 0; i < c; ++i) {
            int idx = this.getRow(i).getCells().indexOf(cell);
            if (idx < 0) continue;
            return new Point(i, idx);
        }
        return new Point(-1, -1);
    }

    public int getIndexOfRow(AbstractRow row) {
        return this.getRows().indexOf(row);
    }

    public int getIndexOfColumn(AbstractColumn col) {
        return this.getColumns().indexOf(col);
    }

    public AbstractCell getCell(int rowIndex, int colIndex) {
        return this.getRow(rowIndex).getCell(colIndex);
    }

    public Style getCellStyle(int rowIndex, int colIndex) {
        Style style = this.getCell(rowIndex, colIndex).getStyle();
        if (style == null && (style = this.getRow(rowIndex).getStyle()) == null && (style = this.getColumn(colIndex).getStyle()) == null) {
            style = this.getStyle();
        }
        return style;
    }

    @Override
    public Point getRelativePosition(IElement ele) {
        int x = 0;
        int y = 0;
        Point rowColIdx = new Point(0, 0);
        if (ele instanceof AbstractCell) {
            rowColIdx = this.getIndexOfCell((AbstractCell)ele);
        } else if (ele instanceof AbstractRow) {
            rowColIdx.x = this.getIndexOfRow((AbstractRow)ele);
        } else if (ele instanceof AbstractColumn) {
            rowColIdx.y = this.getIndexOfColumn((AbstractColumn)ele);
        }
        for (int i = 0; i < rowColIdx.x; ++i) {
            y += this.getRow(i).getFeatHeight();
        }
        for (int j = 0; j < rowColIdx.y; ++j) {
            x += this.getColumn(j).getFeatWidth();
        }
        return new Point(x + this.getOffsetX(), y + this.getOffsetY());
    }

    @Override
    public Rectangle getSubElementRectangle(IElement ele) {
        Rectangle rect = new Rectangle();
        Point pt = this.getRelativePosition(ele);
        if (ele instanceof AbstractCell) {
            Point rowColIdx = this.getIndexOfCell((AbstractCell)ele);
            rect.x = pt.x;
            rect.y = pt.y;
            MergeBlock mb = ((AbstractCell)ele).getMergeBlock();
            if (mb != null && mb.isFirstCell(rowColIdx.x, rowColIdx.y)) {
                rect.width = mb.getBlockWidth(this);
                rect.height = mb.getBlockHeight(this);
            } else {
                rect.width = this.getColumn(rowColIdx.y).getFeatWidth();
                rect.height = this.getRow(rowColIdx.x).getFeatHeight();
            }
        } else if (ele instanceof AbstractRow) {
            int r = this.getIndexOfRow((AbstractRow)ele);
            rect.x = this.getOffsetX();
            rect.y = pt.y;
            rect.width = this.getFeatWidth();
            rect.height = this.getRow(r).getFeatHeight();
        } else if (ele instanceof AbstractColumn) {
            int c = this.getIndexOfColumn((AbstractColumn)ele);
            rect.x = pt.x;
            rect.y = this.getOffsetY();
            rect.width = this.getColumn(c).getFeatWidth();
            rect.height = this.getFeatHeight();
        }
        return rect;
    }

    protected ArrayList getCellsList() {
        ArrayList<AbstractCell> result = new ArrayList<AbstractCell>();
        int rc = this.getRowsCount();
        for (int i = 0; i < rc; ++i) {
            int cc = this.getColumnsCount();
            for (int j = 0; j < cc; ++j) {
                result.add(this.getRow(i).getCell(j));
            }
        }
        return result;
    }

    @Override
    public IElement[] getViewSubElements() {
        return this.getCellsList().toArray(new IElement[0]);
    }

    @Override
    public IElement[] getAllSubElements() {
        int i;
        ArrayList result = this.getCellsList();
        int rc = this.getRowsCount();
        for (i = 0; i < rc; ++i) {
            result.add(this.getRow(i));
        }
        int lc = this.getColumnsCount();
        for (i = 0; i < lc; ++i) {
            result.add(this.getColumn(i));
        }
        return result.toArray(new IElement[0]);
    }

    @Override
    public IElement[] getSubSubElements(IElement ele) {
        int idxCol;
        if (ele instanceof AbstractRow) {
            return ((AbstractRow)ele).getCells().toArray(new IElement[0]);
        }
        if (ele instanceof AbstractColumn && (idxCol = this.getIndexOfColumn((AbstractColumn)ele)) >= 0) {
            int c = this.getRowsCount();
            IElement[] cells = new IElement[c];
            for (int i = 0; i < c; ++i) {
                cells[i] = this.getRow(i).getCell(idxCol);
            }
            return cells;
        }
        return null;
    }

    @Override
    public ElementPath makeElementPath(IElement ele) {
        if (ele instanceof AbstractCell) {
            Point rowAndCol = this.getIndexOfCell((AbstractCell)ele);
            ElementPath elementPath = new ElementPath(new Object[]{this, this.getRow(rowAndCol.x), ele});
            return elementPath;
        }
        if (ele instanceof AbstractRow) {
            ElementPath elementPath = new ElementPath(new Object[]{this, ele});
            return elementPath;
        }
        if (ele instanceof AbstractColumn) {
            ElementPath elementPath = new ElementPath(new Object[]{this, ele});
            return elementPath;
        }
        return null;
    }

    @Override
    public boolean isPointInSubElement(IElement ele, Point ptAtPage) {
        Point ptAtObj = new Point(ptAtPage);
        Point ptThisAtPage = ContainerUtil.getPointAtPage(this);
        ptAtObj.translate(-ptThisAtPage.x, -ptThisAtPage.y);
        Rectangle rect = this.getSubElementRectangle(ele);
        int right = rect.x + rect.width;
        int bottom = rect.y + rect.height;
        return ptAtObj.x > rect.x && ptAtObj.x < right && ptAtObj.y > rect.y && ptAtObj.y < bottom;
    }

    @Override
    public ICompositeSelectionRenderer getInnerSelectionRenderer() {
        GridElementSelectionRenderer r = new GridElementSelectionRenderer();
        r.setCompositeObject(this);
        return r;
    }

    @Override
    public IMouseOperateState getMouseOperateState() {
        return this._gridMouseOperateState;
    }

    protected boolean isNearEnough(int value, int target) {
        return Util.isNearEnough(value, target, 3);
    }

    @Override
    public boolean mouseMoved(MouseEvent evt, Point ptAtPage) {
        int colIdx;
        int rowIdx;
        Point gridAtPage = ContainerUtil.getPointAtPage(this);
        Point ptAtGrid = new Point(ptAtPage);
        ptAtGrid.translate(-gridAtPage.x, -gridAtPage.y);
        if (this.isNearEnough(ptAtGrid.x, 0) && (rowIdx = this.getIndexOfRowByPoint(ptAtGrid.y)) >= 0) {
            this._gridMouseOperateState.setOperate(48);
            this._gridMouseOperateState.setTargetLineIdx(rowIdx);
            return true;
        }
        if (this.isNearEnough(ptAtGrid.y, 0) && (colIdx = this.getIndexOfColumnByPoint(ptAtGrid.x)) >= 0) {
            this._gridMouseOperateState.setOperate(64);
            this._gridMouseOperateState.setTargetLineIdx(colIdx);
            return true;
        }
        if (ptAtGrid.y < Math.min(this.getOffsetY() + this.getFeatHeight(), this.getHeight()) && ptAtGrid.y > 0) {
            int w = this.getOffsetX();
            int colCnt = this.getColumnsCount();
            if (this.isKeepParentSize(true, evt.isControlDown())) {
                --colCnt;
            }
            for (int j = 0; j < colCnt; ++j) {
                if (!this.isNearEnough(ptAtGrid.x, w += this.getColumn(j).getFeatWidth())) continue;
                this._gridMouseOperateState.setOperate(16);
                this._gridMouseOperateState.setTargetLineIdx(j + 1);
                return true;
            }
        }
        if (ptAtGrid.x < Math.min(this.getOffsetX() + this.getFeatWidth(), this.getWidth()) && ptAtGrid.x > 0) {
            int h = this.getOffsetY();
            int rowCnt = this.getRowsCount();
            if (this.isKeepParentSize(false, evt.isControlDown())) {
                --rowCnt;
            }
            for (int i = 0; i < rowCnt; ++i) {
                if (!this.isNearEnough(ptAtGrid.y, h += this.getRow(i).getFeatHeight())) continue;
                this._gridMouseOperateState.setOperate(32);
                this._gridMouseOperateState.setTargetLineIdx(i + 1);
                return true;
            }
        }
        this._gridMouseOperateState.setOperate(0);
        return false;
    }

    @Override
    public void mouseDragged(Graphics g, MouseEvent evt, Point dragStartPoint, IR1Ruler hRuler, IR1Ruler vRuler) {
        if (this._gridMouseOperateState.isHorizontalAdjust() || this._gridMouseOperateState.isVerticalAdjust()) {
            this.adjustLine(g, dragStartPoint, evt.getPoint(), false, evt.isControlDown(), hRuler, vRuler);
        }
    }

    @Override
    public void mouseReleased(Graphics g, MouseEvent evt, Point dragStartPoint, UndoHelper undoHelper) {
        boolean isAdjust = false;
        if (this._gridMouseOperateState.isHorizontalAdjust()) {
            undoHelper.store(MultiLanguageUtil.getMLS("grid.AbstractGrid.colWidthAdjust", ""));
            isAdjust = true;
        } else if (this._gridMouseOperateState.isVerticalAdjust()) {
            undoHelper.store(MultiLanguageUtil.getMLS("grid.AbstractGrid.rowHeigthAdjust", ""));
            isAdjust = true;
        }
        if (isAdjust) {
            this.adjustLine(g, dragStartPoint, evt.getPoint(), true, evt.isControlDown(), null, null);
            this.afterAdjusted();
        }
    }

    private Point getDeltaWidthKeepParentSize(Point dragStartPoint, Point dragCurrentPoint) {
        Point delta = dragCurrentPoint;
        delta.translate(-dragStartPoint.x, -dragStartPoint.y);
        int idx = this._gridMouseOperateState.getTargetLineIdx();
        if (this._gridMouseOperateState.isHorizontalAdjust()) {
            if (idx == this.getColumnsCount()) {
                delta.x = 0;
            } else if (delta.x > 0) {
                AbstractColumn colNext = this.getColumn(idx);
                int colNextW = Util.lom2Pixel(colNext.getWidthLom());
                int n = colNextW = colNextW > 0 ? colNextW - 1 : colNextW;
                if (colNextW < delta.x) {
                    delta.x = colNextW;
                }
            } else {
                AbstractColumn col = this.getColumn(idx - 1);
                int colW = Util.lom2Pixel(col.getWidthLom());
                int n = colW = colW > 0 ? colW - 1 : colW;
                if (colW < -delta.x) {
                    delta.x = -colW;
                }
            }
        } else if (idx == this.getRowsCount()) {
            delta.y = 0;
        } else if (delta.y > 0) {
            AbstractRow rowNext = this.getRow(idx);
            int rowNextH = Util.lom2Pixel(rowNext.getHeightLom());
            int n = rowNextH = rowNextH > 0 ? rowNextH - 1 : rowNextH;
            if (rowNextH < delta.y) {
                delta.y = rowNextH;
            }
        } else {
            AbstractRow row = this.getRow(idx - 1);
            int rowH = Util.lom2Pixel(row.getHeightLom()) - 1;
            int n = rowH = rowH > 0 ? rowH - 1 : rowH;
            if (rowH < -delta.y) {
                delta.y = -rowH;
            }
        }
        return delta;
    }

    protected Point getDelta(Point dragStartPoint, Point dragCurrentPoint) {
        Point delta = dragCurrentPoint;
        delta.translate(-dragStartPoint.x, -dragStartPoint.y);
        int idx = this._gridMouseOperateState.getTargetLineIdx();
        if (this._gridMouseOperateState.isHorizontalAdjust()) {
            if (delta.x > 0) {
                int gridNewRight = this.getXLom() + this.getWidthLom() + Util.pixel2Lom(delta.x);
                ElementPath ep = this.getParent();
                IElement ele = (IElement)ep.getLastPathComponent();
                int parentWidthLom = -1;
                if (ele instanceof IReportObject) {
                    parentWidthLom = ((IReportObject)ele).getWidthLom();
                } else {
                    IReportObject ro = (IReportObject)ep.getRootPathComponent();
                    if (ro instanceof ICompositeContainer) {
                        parentWidthLom = ((ICompositeContainer)((Object)ro)).getSubContainerInsetsWidthLom((IContainer)((Object)ele));
                    }
                }
                if (parentWidthLom > 0 && gridNewRight > parentWidthLom) {
                    delta.x = Util.lom2Pixel(parentWidthLom - this.getXLom() - this.getWidthLom());
                }
            } else {
                int childrenMinRemain = this.getColumnChildrenMinRemain(idx - 1);
                int pixChildrenMinRemain = Util.lom2Pixel(childrenMinRemain);
                if (-delta.x > pixChildrenMinRemain) {
                    delta.x = -pixChildrenMinRemain;
                }
            }
        } else if (this._gridMouseOperateState.isVerticalAdjust()) {
            if (delta.y > 0) {
                int gridNewBottom = this.getYLom() + this.getHeightLom() + Util.pixel2Lom(delta.y);
                ElementPath ep = this.getParent();
                IElement ele = (IElement)ep.getLastPathComponent();
                int parentHeightLom = -1;
                if (ele instanceof IReportObject) {
                    parentHeightLom = ((IReportObject)ele).getHeightLom();
                } else {
                    IReportObject ro = (IReportObject)ep.getRootPathComponent();
                    if (ro instanceof ICompositeContainer) {
                        parentHeightLom = ((ICompositeContainer)((Object)ro)).getSubContainerInsetsHeightLom((IContainer)((Object)ele));
                    }
                }
                if (parentHeightLom > 0 && gridNewBottom > parentHeightLom) {
                    delta.y = Util.lom2Pixel(parentHeightLom - this.getYLom() - this.getHeightLom());
                }
            } else {
                int childrenMinRemain = this.getRowChildrenMinRemain(idx - 1);
                int pixChildrenMinRemain = Util.lom2Pixel(childrenMinRemain);
                if (-delta.y > pixChildrenMinRemain) {
                    delta.y = -pixChildrenMinRemain;
                }
            }
        }
        return delta;
    }

    protected boolean isKeepParentSize(boolean isHorizontalAdjust, boolean isCtrlDown) {
        boolean isKeepParentSize = false;
        isKeepParentSize = isHorizontalAdjust ? (this.isHorizontalFill() ? true : isCtrlDown) : (this.isVerticalFill() ? true : isCtrlDown);
        return isKeepParentSize;
    }

    protected void adjustLine(Graphics g, Point dragStartPoint, Point dragCurrentPoint, boolean isEnd, boolean isCtrlDown, IR1Ruler hRuler, IR1Ruler vRuler) {
        Point gridAtPage = ContainerUtil.getPointAtPage(this);
        g.translate(gridAtPage.x, gridAtPage.y);
        boolean isHorizontalAdjust = this._gridMouseOperateState.isHorizontalAdjust();
        boolean isKeepParentSize = this.isKeepParentSize(isHorizontalAdjust, isCtrlDown);
        Point delta = isKeepParentSize ? this.getDeltaWidthKeepParentSize(dragStartPoint, dragCurrentPoint) : this.getDelta(dragStartPoint, dragCurrentPoint);
        Rectangle rect = null;
        if (!isEnd) {
            rect = this.getAdjustingLine(delta, isKeepParentSize);
        }
        int objMax = isHorizontalAdjust ? this.getOffsetX() + this.getFeatWidth() : this.getOffsetY() + this.getFeatHeight();
        _lineAdjustRenderer.draw(g, this.lastDragRect, rect, isHorizontalAdjust, objMax);
        this.lastDragRect = rect;
        if (isEnd) {
            int idx = this._gridMouseOperateState.getTargetLineIdx();
            if (this._gridMouseOperateState.isHorizontalAdjust() && delta.x != 0) {
                if (isKeepParentSize) {
                    AbstractColumn col = this.getColumn(idx - 1);
                    AbstractColumn colNext = this.getColumn(idx);
                    int adjustValue = Util.pixel2Lom(delta.x);
                    col.setWidthLom(col.getWidthLom() + adjustValue);
                    colNext.setWidthLom(colNext.getWidthLom() - adjustValue);
                } else {
                    AbstractColumn col = this.getColumn(idx - 1);
                    col.setWidthLom(col.getWidthLom() + Util.pixel2Lom(delta.x));
                }
            } else if (this._gridMouseOperateState.isVerticalAdjust() && delta.y != 0) {
                if (isKeepParentSize) {
                    AbstractRow row = this.getRow(idx - 1);
                    AbstractRow rowNext = this.getRow(idx);
                    int adjustValue = Util.pixel2Lom(delta.y);
                    row.setHeightLom(row.getHeightLom() + adjustValue);
                    rowNext.setHeightLom(rowNext.getHeightLom() - adjustValue);
                } else {
                    AbstractRow row = this.getRow(idx - 1);
                    row.setHeightLom(row.getHeightLom() + Util.pixel2Lom(delta.y));
                }
            }
        }
        if (rect != null) {
            if (hRuler != null) {
                RulerMark hRulerMark = new RulerMark(rect.x + gridAtPage.x, rect.x + gridAtPage.x);
                hRuler.setMarkPosition(hRulerMark);
            }
            if (vRuler != null) {
                RulerMark vRulerMark = new RulerMark(rect.y + gridAtPage.y, rect.y + gridAtPage.y);
                vRuler.setMarkPosition(vRulerMark);
            }
        }
    }

    protected Rectangle getAdjustingLine(Point delta, boolean isKeepParentSize) {
        int idx = this._gridMouseOperateState.getTargetLineIdx();
        if (this._gridMouseOperateState.isHorizontalAdjust()) {
            int w = 0;
            for (int j = 0; j < idx; ++j) {
                w += this.getColumn(j).getFeatWidth();
            }
            int rectW = 0;
            if (!isKeepParentSize) {
                rectW = this.getFeatWidth() - w;
            }
            return new Rectangle(w + delta.x + this.getOffsetX(), this.getOffsetY(), rectW, this.getFeatHeight());
        }
        if (this._gridMouseOperateState.isVerticalAdjust()) {
            int h = 0;
            for (int i = 0; i < idx; ++i) {
                h += this.getRow(i).getFeatHeight();
            }
            int rectH = 0;
            if (!isKeepParentSize) {
                rectH = this.getFeatHeight() - h;
            }
            return new Rectangle(this.getOffsetX(), h + delta.y + this.getOffsetY(), this.getFeatWidth(), rectH);
        }
        return null;
    }

    @Override
    public ElementPath[] getSelection(ReportSelectionModel selectionModel, ElementPath epSelecting) {
        ElementPath current = selectionModel.getCurrent();
        if (current == null) {
            return new ElementPath[]{epSelecting};
        }
        ArrayList<ElementPath> result = new ArrayList<ElementPath>();
        Object objCurrentLast = current.getLastPathComponent();
        Object objSelectingLast = epSelecting.getLastPathComponent();
        if (objCurrentLast instanceof AbstractCell && objSelectingLast instanceof AbstractCell) {
            Point pt1 = this.getIndexOfCell((AbstractCell)objCurrentLast);
            Point pt2 = this.getIndexOfCell((AbstractCell)objSelectingLast);
            int x1 = pt1.x;
            int y1 = pt1.y;
            int x2 = pt2.x;
            int y2 = pt2.y;
            int i = x1;
            while (x1 > x2 ? i >= x2 : i <= x2) {
                int j = y1;
                while (y1 > y2 ? j >= y2 : j <= y2) {
                    AbstractCell cell = this.getCell(i, j);
                    if (cell.getMergeBlock() == null || cell.getMergeBlock().isFirstCell(i, j)) {
                        result.add(this.makeElementPath(cell));
                    }
                    j += y1 > y2 ? -1 : 1;
                }
                i += x1 > x2 ? -1 : 1;
            }
        } else if (objCurrentLast instanceof AbstractRow && objSelectingLast instanceof AbstractRow) {
            int r1 = this.getIndexOfRow((AbstractRow)objCurrentLast);
            int r2 = this.getIndexOfRow((AbstractRow)objSelectingLast);
            int i = r1;
            while (r1 > r2 ? i >= r2 : i <= r2) {
                result.add(this.makeElementPath(this.getRow(i)));
                i += r1 > r2 ? -1 : 1;
            }
        } else if (objCurrentLast instanceof AbstractColumn && objSelectingLast instanceof AbstractColumn) {
            int c1 = this.getIndexOfColumn((AbstractColumn)objCurrentLast);
            int c2 = this.getIndexOfColumn((AbstractColumn)objSelectingLast);
            int j = c1;
            while (c1 > c2 ? j >= c2 : j <= c2) {
                result.add(this.makeElementPath(this.getColumn(j)));
                j += c1 > c2 ? -1 : 1;
            }
        }
        if (result.size() > 0) {
            return result.toArray(new ElementPath[0]);
        }
        return null;
    }

    @Override
    public ElementPath getSelection(Point ptAtPage) {
        int target = this._gridMouseOperateState.getTargetLineIdx();
        if (this._gridMouseOperateState.isToSelectRow()) {
            return this.makeElementPath(this.getRow(target));
        }
        if (this._gridMouseOperateState.isToSelectColumn()) {
            return this.makeElementPath(this.getColumn(target));
        }
        return null;
    }

    @Override
    public boolean isSubElementCanRemove(IElement ele) {
        if (ele instanceof AbstractRow) {
            return -1 != this.getIndexOfRow((AbstractRow)ele);
        }
        if (ele instanceof AbstractColumn) {
            return -1 != this.getIndexOfColumn((AbstractColumn)ele);
        }
        return false;
    }

    @Override
    public boolean removeSubElement(IElement ele) {
        if (ele instanceof AbstractRow) {
            return this.removeRow((AbstractRow)ele);
        }
        if (ele instanceof AbstractColumn) {
            return this.removeColumn((AbstractColumn)ele);
        }
        return false;
    }

    public boolean isContains(Object ele) {
        if (ele instanceof AbstractCell) {
            return this.getIndexOfCell((AbstractCell)((AbstractCell)ele)).x != -1;
        }
        if (ele instanceof AbstractRow) {
            return this.getRows().contains(ele);
        }
        if (ele instanceof AbstractColumn) {
            return this.getColumns().contains(ele);
        }
        throw new R1DesignerRuntimeException("Element in Grid must be Row/Column/Cell.");
    }

    @Override
    public void updateStructureTree(StructureTree.Updater treeUpdater, DefaultKingdeeTreeNode nodeSelf) {
        StringBuffer sb;
        int i;
        int c = this.getColumnsCount();
        for (i = 0; i < c; ++i) {
            AbstractColumn col = this.getColumn(i);
            sb = new StringBuffer(MultiLanguageUtil.getMLS("grid.AbstractGrid.the", ""));
            sb.append(i + 1);
            sb.append(MultiLanguageUtil.getMLS("grid.AbstractGrid.column", "\u5217"));
            StructureTree.Node nodeCol = treeUpdater.createNode(col, sb.toString());
            treeUpdater.getTree().addNodeInto((MutableTreeNode)((Object)nodeCol), (MutableTreeNode)nodeSelf);
        }
        c = this.getRowsCount();
        for (i = 0; i < c; ++i) {
            AbstractRow row = this.getRow(i);
            sb = new StringBuffer(MultiLanguageUtil.getMLS("grid.AbstractGrid.the", ""));
            sb.append(i + 1);
            sb.append(MultiLanguageUtil.getMLS("grid.AbstractGrid.row", "\u884c"));
            if (!StringUtil.isEmptyString((String)row.getTypePrompt())) {
                sb.append("(");
                sb.append(row.getTypePrompt());
                sb.append(")");
            }
            StructureTree.Node nodeRow = treeUpdater.createNode(row, sb.toString());
            treeUpdater.getTree().addNodeInto((MutableTreeNode)((Object)nodeRow), (MutableTreeNode)nodeSelf);
            int cc = row.getCellCount();
            for (int k = 0; k < cc; ++k) {
                AbstractCell cell = row.getCell(k);
                MergeBlock mb = cell.getMergeBlock();
                if (mb != null && !mb.isFirstCell(i, k)) continue;
                sb = new StringBuffer(MultiLanguageUtil.getMLS("grid.AbstractGrid.the", ""));
                sb.append(k + 1);
                sb.append(MultiLanguageUtil.getMLS("grid.AbstractGrid.unit", ""));
                StructureTree.Node nodeCell = treeUpdater.createNode(cell, sb.toString());
                treeUpdater.getTree().addNodeInto((MutableTreeNode)((Object)nodeCell), (MutableTreeNode)((Object)nodeRow));
                if (!(cell instanceof IContainer)) continue;
                treeUpdater.updateContainer(nodeCell, (IContainer)((Object)cell));
            }
        }
    }

    public int getOffsetX() {
        return 0;
    }

    public int getOffsetY() {
        return 0;
    }

    @Override
    public void applySubElementStyle(IElement ele, StyleAttributes sa) {
        block10: {
            block11: {
                block9: {
                    StyleAttributes saOld = ele.getNotNullSA();
                    saOld.replaceDirty((ShareStyleAttributes)sa);
                    ele.setStyleAttribute(saOld);
                    if (!(ele instanceof AbstractColumn)) break block9;
                    AbstractColumn col = (AbstractColumn)ele;
                    int idx = this.getIndexOfColumn(col);
                    if (idx < 0) {
                        return;
                    }
                    for (int i = this.getRowsCount() - 1; i >= 0; --i) {
                        AbstractCell cell = this.getCell(i, idx);
                        StyleAttributes saTemp = cell.getStyleAttribute();
                        if (saTemp == null) {
                            saTemp = Styles.getSA((StyleAttributes)sa);
                        } else {
                            saTemp.replaceDirty((ShareStyleAttributes)sa);
                        }
                        cell.setStyleAttribute(saTemp);
                    }
                    break block10;
                }
                if (!(ele instanceof AbstractRow)) break block11;
                AbstractRow row = (AbstractRow)ele;
                for (int i = row.getCellCount() - 1; i >= 0; --i) {
                    AbstractCell cell = row.getCell(i);
                    StyleAttributes saTemp = cell.getStyleAttribute();
                    if (saTemp == null) {
                        saTemp = Styles.getSA((StyleAttributes)sa);
                    } else {
                        saTemp.replaceDirty((ShareStyleAttributes)sa);
                    }
                    cell.setStyleAttribute(saTemp);
                }
                break block10;
            }
            if (ele != this) break block10;
            for (int i = this.getRowsCount() - 1; i >= 0; --i) {
                AbstractRow row = this.getRow(i);
                for (int j = row.getCellCount() - 1; j >= 0; --j) {
                    AbstractCell cell = row.getCell(j);
                    StyleAttributes saTemp = cell.getNotNullSA();
                    saTemp.replace((ShareStyleAttributes)sa);
                    cell.setStyleAttribute(saTemp);
                }
            }
        }
    }

    @Override
    public StyleAttributes mixSubElementStyle(IElement ele) {
        ArrayList<StyleAttributes> listSAs = new ArrayList<StyleAttributes>();
        StyleAttributes saDefault = Styles.getDefaultSA();
        if (ele == this) {
            for (int i = this.getRowsCount() - 1; i >= 0; --i) {
                AbstractRow row = this.getRow(i);
                for (int j = row.getCellCount() - 1; j >= 0; --j) {
                    StyleAttributes sa = row.getCell(j).getStyleAttribute();
                    listSAs.add(sa == null || sa.isEmpty() ? saDefault : sa);
                }
            }
        } else if (ele instanceof AbstractRow) {
            AbstractRow row = (AbstractRow)ele;
            for (int i = row.getCellCount() - 1; i >= 0; --i) {
                StyleAttributes sa = row.getCell(i).getStyleAttribute();
                listSAs.add(sa == null || sa.isEmpty() ? saDefault : sa);
            }
        } else if (ele instanceof AbstractColumn) {
            AbstractColumn column = (AbstractColumn)ele;
            int idxCol = this.getIndexOfColumn(column);
            for (int i = this.getRowsCount() - 1; i >= 0; --i) {
                StyleAttributes sa = this.getCell(i, idxCol).getStyleAttribute();
                listSAs.add(sa == null || sa.isEmpty() ? saDefault : sa);
            }
        } else if (ele instanceof AbstractCell) {
            StyleAttributes sa = ele.getStyleAttribute();
            listSAs.add(sa == null || sa.isEmpty() ? saDefault : sa);
        }
        StyleAttributes mixSA = Styles.mixSA((ShareStyleAttributes[])listSAs.toArray(new StyleAttributes[0]));
        ShareStyleAttributes mixSsa = Styles.mergeSSA((ShareStyleAttributes[])new StyleAttributes[]{mixSA, saDefault});
        return Styles.getSA((ShareStyleAttributes)mixSsa);
    }

    public int getRowDrawingTimes(AbstractRow row) {
        return 1;
    }

    @Override
    public IPropertyPanel getExtendPropertyPanel(String key) {
        return null;
    }

    public boolean isMergedCell(AbstractCell cell) {
        if (cell.getMergeBlock() == null) {
            return false;
        }
        return !cell.getMergeBlock().isFirstCell(this.getIndexOfCell(cell));
    }

    public AbstractCell getMainCell(int rowIndex, int colIndex) {
        return this.getMainCell(this.getRow(rowIndex), rowIndex, colIndex);
    }

    public AbstractCell getMainCell(AbstractRow row, int colIndex) {
        int rowIndex = this.getIndexOfRow(row);
        return this.getMainCell(row, rowIndex, colIndex);
    }

    private AbstractCell getMainCell(AbstractRow row, int rowIndex, int colIndex) {
        AbstractCell cell = row.getCell(colIndex);
        MergeBlock mb = cell.getMergeBlock();
        if (mb == null || mb.isFirstCell(rowIndex, colIndex)) {
            return cell;
        }
        return this.getCell(mb.getTop(), mb.getLeft());
    }
}

