/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.r1.common.designercore.gui.ruler;

import com.kingdee.bos.ctrl.kdf.util.render.TextRender;
import com.kingdee.bos.ctrl.kdf.util.style.ShareStyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Style;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.gui.core.ComboPanel;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.gui.ruler.AbstractRuler;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.gui.ruler.IR1Ruler;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.gui.ruler.RulerMark;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;

public class VRuler
extends AbstractRuler
implements IR1Ruler {
    private ComboPanel comboPanel;
    private Style style;

    public VRuler(ComboPanel comboPanel) {
        this.comboPanel = comboPanel;
    }

    private Style getStyle() {
        StyleAttributes sa = Styles.getDefaultSA();
        sa.setRotation(this.getDrawingRotation());
        this.style = Styles.getStyle((ShareStyleAttributes)sa);
        return this.style;
    }

    @Override
    public void drawGraduation(Graphics g) {
        double scale = this.comboPanel.getScale();
        int zeroOfMark = (int)Math.round((double)this.getZeroOfmark() * scale);
        int zeroOffset = (int)Math.round((double)this.getZeroOffset() * scale);
        int scrollOffset = Math.round(this.getScrollOffset());
        Graphics g2vruler = g.create();
        g2vruler.translate(0, zeroOfMark + zeroOffset - scrollOffset);
        g2vruler.setColor(Color.BLACK);
        int height = zeroOfMark - scrollOffset;
        int width = this.getCtrl().getWidth();
        float endGraduation = (float)((double)this.pixelToUnit(height + 1) / scale);
        int loopStart = height < 0 ? 0 : (int)Math.round((double)this.unitToPixel(height) * scale);
        int xUnitStart = width - 3;
        int xFiveUnitStart = width - 5;
        int xTenUnitStart = width - 7;
        g2vruler.drawLine(width - 1, 0, width - 1, -loopStart);
        g2vruler.setColor(new Color(10, 10, 10, 100));
        g2vruler.fillRect(xTenUnitStart, -loopStart, 7, loopStart);
        g2vruler.setColor(Color.BLACK);
        for (int j = 0; j <= (int)endGraduation; ++j) {
            int x;
            int y = (int)Math.round((double)this.unitToPixel(-j) * scale);
            int graduationType = j % 10;
            if (graduationType == 0) {
                x = xTenUnitStart;
                String str = String.valueOf(j * this.getDrawingTenUnit() / 10);
                int h = (int)Math.round((double)this.unitToPixel(10.0f) * scale);
                Rectangle rect = new Rectangle(0, y - h / 2, xTenUnitStart - 1, h);
                TextRender.sharedInstance().draw(g2vruler, (Shape)rect, str, this.getStyle());
            } else {
                x = graduationType == 5 ? xFiveUnitStart : xUnitStart;
            }
            g2vruler.drawLine(x, y, width, y);
        }
        float startGraduation = (float)((double)this.pixelToUnit(height) / scale);
        height = this.getCtrl().getHeight() - height;
        endGraduation = (float)((double)this.pixelToUnit(height) / scale);
        loopStart = startGraduation > 0.0f ? 0 : -((int)startGraduation);
        g2vruler.drawLine(width - 1, loopStart - zeroOffset, width - 1, height);
        int i = loopStart;
        while ((float)i < endGraduation) {
            int x;
            int y = (int)Math.round((double)this.unitToPixel(i) * scale);
            int graduationType = i % 10;
            if (graduationType == 0) {
                x = xTenUnitStart;
                String str = String.valueOf(i * this.getDrawingTenUnit() / 10);
                int h = (int)Math.round((double)this.unitToPixel(10.0f) * scale);
                Rectangle rect = new Rectangle(0, y - h / 2, xTenUnitStart - 1, h);
                TextRender.sharedInstance().draw(g2vruler, (Shape)rect, str, this.getStyle());
            } else {
                x = graduationType == 5 ? xFiveUnitStart : xUnitStart;
            }
            g2vruler.drawLine(x, y, width, y);
            ++i;
        }
        g.setColor(Color.BLUE);
        RulerMark markNew = this.getMarkPosition();
        if (markNew != null) {
            int v1 = markNew.getValue1();
            int v2 = markNew.getValue2();
            v1 = (int)Math.round((double)v1 * scale);
            v2 = (int)Math.round((double)v2 * scale);
            g.drawLine(0, v1 += zeroOffset + zeroOfMark - scrollOffset, width, v1);
            g.drawLine(0, v2 += zeroOffset + zeroOfMark - scrollOffset, width, v2);
        }
    }
}

