/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.r1.form.engine.x.common.xygrid;

import com.kingdee.bos.ctrl.reportone.r1.form.engine.x.common.AutoGrowGrid;
import com.kingdee.bos.ctrl.reportone.r1.form.engine.x.common.MergingGrid;
import com.kingdee.bos.ctrl.reportone.r1.form.engine.x.common.css.CssUtil;
import com.kingdee.bos.ctrl.reportone.r1.form.engine.x.common.css.Style;
import com.kingdee.bos.ctrl.reportone.r1.form.engine.x.common.xygrid.IXYBean;
import com.kingdee.bos.ctrl.reportone.r1.form.engine.x.common.xygrid.XYArrange;
import com.kingdee.bos.ctrl.reportone.r1.form.engine.x.common.xygrid.XYCell;
import com.kingdee.bos.ctrl.reportone.r1.form.engine.x.common.xygrid.XYInfo;
import java.awt.Dimension;
import java.util.Iterator;

public class XYGrid
extends XYCell
implements IXYBean {
    private boolean changed = true;
    private MergingGrid grid;
    private Style rowStyle;
    private Style colStyle;
    private Style cellStyle;
    private Dimension totalSize;
    private Dimension minTotalSize;
    private Dimension maxTotalSize;
    private Dimension prefTotalSize;

    public XYGrid() {
    }

    public XYGrid(int rowCount, int colCount) {
        this.init(rowCount, colCount);
    }

    public void init(int rowCount, int colCount) {
        int i;
        this.grid = new MergingGrid();
        this.grid.setColCount(colCount);
        this.grid.setRowCount(rowCount);
        for (i = 0; i < colCount; ++i) {
            this.grid.setCol(i, new XYInfo());
        }
        for (i = 0; i < rowCount; ++i) {
            this.grid.setRow(i, new XYInfo());
        }
        this.maxTotalSize = new Dimension();
        this.minTotalSize = new Dimension();
        this.prefTotalSize = new Dimension();
        this.totalSize = new Dimension();
        super.setBean(this);
    }

    @Override
    public Dimension getMaxBeanSize() {
        this.initLayout();
        return this.maxTotalSize;
    }

    @Override
    public Dimension getMinBeanSize() {
        this.initLayout();
        return this.minTotalSize;
    }

    @Override
    public Dimension getPrefBeanSize() {
        this.initLayout();
        return this.prefTotalSize;
    }

    public void layout(int width, int height) {
        this.initLayout();
        super.setBounds(0, 0, width, height);
    }

    @Override
    public void setBeanBounds(int x, int y, int width, int height) {
        XYArrange xarr = new XYArrange();
        xarr.init(this.grid.getColCount(), this.grid.iterateCols());
        xarr.arrange(width);
        XYArrange yarr = new XYArrange();
        yarr.init(this.grid.getRowCount(), this.grid.iterateRows());
        yarr.arrange(height);
        this.totalXY(this.grid.iterateCols(), true);
        this.totalXY(this.grid.iterateRows(), false);
        int rowCount = this.grid.getRowCount();
        int colCount = this.grid.getColCount();
        for (int rowIdx = 0; rowIdx < rowCount; ++rowIdx) {
            XYInfo row = (XYInfo)this.grid.getRow(rowIdx);
            for (int colIdx = 0; colIdx < colCount; ++colIdx) {
                int cy;
                int cx;
                MergingGrid.MergeInfo mi;
                XYCell cell = (XYCell)this.grid.getCell(rowIdx, colIdx);
                if (cell == null || (mi = this.grid.getMergeInfo(rowIdx, colIdx)) != null && (mi.getRowIndex() != rowIdx || mi.getColIndex() != colIdx)) continue;
                XYInfo col = this.colXYInfo(colIdx);
                if (mi != null) {
                    int j;
                    int colIdx2 = colIdx + mi.getColSpan() - 1;
                    int rowIdx2 = rowIdx + mi.getRowSpan() - 1;
                    cx = -this.colXYInfo(colIdx).getBeforeContent() - this.colXYInfo(colIdx2).getAfterContent();
                    cy = -this.rowXYInfo(rowIdx).getBeforeContent() - this.rowXYInfo(rowIdx2).getAfterContent();
                    for (j = colIdx; j <= colIdx2; ++j) {
                        cx += this.colXYInfo(j).getCxy();
                    }
                    for (j = rowIdx; j <= rowIdx2; ++j) {
                        cy += this.rowXYInfo(j).getCxy();
                    }
                } else {
                    cx = col.getContentCxy();
                    cy = row.getContentCxy();
                }
                cell.setBounds(x + col.getContentXY(), y + row.getContentXY(), cx, cy);
            }
        }
    }

    public final boolean isChanged() {
        return this.changed;
    }

    public final void change() {
        this.changed = true;
    }

    public final Style getCellStyle() {
        return this.cellStyle;
    }

    public final void setCellStyle(Style cellStyle) {
        this.cellStyle = cellStyle;
    }

    public final Style getColStyle() {
        return this.colStyle;
    }

    public final void setColStyle(Style colStyle) {
        this.colStyle = colStyle;
    }

    public final Style getRowStyle() {
        return this.rowStyle;
    }

    public final void setRowStyle(Style rowStyle) {
        this.rowStyle = rowStyle;
    }

    public void initLayout() {
        Style rtStyle;
        if (!this.changed) {
            return;
        }
        this.changed = false;
        this.setRuntimeStyle(this.getStyle());
        int rowCount = this.grid.getRowCount();
        int colCount = this.grid.getColCount();
        Style[] styles = new Style[2];
        for (int colIdx = 0; colIdx < colCount; ++colIdx) {
            XYInfo col = (XYInfo)this.grid.getCol(colIdx);
            styles[0] = this.colStyle;
            styles[1] = col.getStyle();
            rtStyle = CssUtil.addStyles(styles);
            if (rtStyle == null) continue;
            col.setRuntimeStyle(rtStyle);
            col.setMarginBefore(rtStyle.getMarginLeft());
            col.setMarginAfter(rtStyle.getMarginRight());
            col.setPaddingBefore(rtStyle.getPaddingLeft());
            col.setPaddingAfter(rtStyle.getPaddingRight());
        }
        for (int rowIdx = 0; rowIdx < rowCount; ++rowIdx) {
            XYInfo row = (XYInfo)this.grid.getRow(rowIdx);
            styles[0] = this.rowStyle;
            styles[1] = row.getStyle();
            rtStyle = CssUtil.addStyles(styles);
            if (rtStyle != null) {
                row.setRuntimeStyle(rtStyle);
                row.setMarginBefore(rtStyle.getMarginTop());
                row.setMarginAfter(rtStyle.getMarginBottom());
                row.setPaddingBefore(rtStyle.getPaddingTop());
                row.setPaddingAfter(rtStyle.getPaddingBottom());
            }
            for (int colIdx = 0; colIdx < colCount; ++colIdx) {
                MergingGrid.MergeInfo mi;
                XYCell cell = (XYCell)this.grid.getCell(rowIdx, colIdx);
                if (cell == null || (mi = this.grid.getMergeInfo(rowIdx, colIdx)) != null && (mi.getRowIndex() != rowIdx || mi.getColIndex() != colIdx)) continue;
                XYInfo col = (XYInfo)this.grid.getCol(colIdx);
                styles[0] = this.cellStyle;
                styles[1] = cell.getStyle();
                cell.setRuntimeStyle(CssUtil.addStyles(styles));
                Dimension szPref = cell.getPrefSize();
                Dimension szMin = cell.getMinSize();
                Dimension szMax = cell.getMaxSize();
                if (mi == null || mi.getColSpan() == 1) {
                    if (!col.isPrefCxy() && (col.prefCxy <= 0 || szMin != null && col.minCxy < szMin.width) && szPref != null) {
                        col.prefCxy = szPref.width;
                    }
                    if (!col.isMinCxy() && szMin != null && col.minCxy < szMin.width) {
                        col.minCxy = szMin.width;
                    }
                    if (!col.isMaxCxy() && szMax != null && col.maxCxy < szMax.width) {
                        col.maxCxy = szMax.width;
                    }
                }
                if (mi != null && mi.getRowSpan() != 1) continue;
                if (!row.isPrefCxy() && (row.prefCxy <= 0 || szMin != null && row.minCxy < szMin.height) && szPref != null) {
                    row.prefCxy = szPref.height;
                }
                if (!row.isMinCxy() && szMin != null && row.minCxy < szMin.height) {
                    row.minCxy = szMin.height;
                }
                if (row.isMaxCxy() || szMax == null || row.maxCxy >= szMax.height) continue;
                row.maxCxy = szMax.height;
            }
        }
        this.validateXYInfo(this.grid.iterateCols());
        this.validateXYInfo(this.grid.iterateRows());
        this.totalXYInfo(this.grid.iterateCols(), true);
        this.totalXYInfo(this.grid.iterateRows(), false);
    }

    private void validateXYInfo(Iterator i) {
        while (i.hasNext()) {
            XYInfo info = (XYInfo)i.next();
            int minCxy = info.getMinCxy();
            int maxCxy = info.getMaxCxy();
            int prefCxy = info.getPrefCxy();
            if (minCxy < maxCxy) {
                if (prefCxy < minCxy) {
                    info.setPrefCxy(minCxy);
                    continue;
                }
                if (prefCxy <= maxCxy) continue;
                info.setPrefCxy(maxCxy);
                continue;
            }
            info.setMaxCxy(minCxy);
            info.setPrefCxy(minCxy);
        }
    }

    private void totalXYInfo(Iterator i, boolean isX) {
        int maxCxy;
        int minCxy = 0;
        long maxCxyL = 0L;
        int prefCxy = 0;
        while (i.hasNext()) {
            XYInfo info = (XYInfo)i.next();
            minCxy += info.getMinCxy();
            maxCxyL += (long)info.getMaxCxy();
            prefCxy += info.getPrefCxy();
        }
        int n = maxCxy = maxCxyL < Integer.MAX_VALUE ? (int)maxCxyL : Integer.MAX_VALUE;
        if (isX) {
            this.minTotalSize.width = minCxy;
            this.maxTotalSize.width = maxCxy;
            this.prefTotalSize.width = prefCxy;
        } else {
            this.minTotalSize.height = minCxy;
            this.maxTotalSize.height = maxCxy;
            this.prefTotalSize.height = prefCxy;
        }
    }

    private void totalXY(Iterator i, boolean isX) {
        int xy = 0;
        while (i.hasNext()) {
            XYInfo info = (XYInfo)i.next();
            info.setXY(xy);
            xy += info.getCxy();
        }
        if (isX) {
            this.totalSize.width = xy;
        } else {
            this.totalSize.height = xy;
        }
    }

    public int getColCount() {
        return this.grid.getColCount();
    }

    public int getRowCount() {
        return this.grid.getRowCount();
    }

    public XYInfo rowXYInfo(int rowIdx) {
        return (XYInfo)this.grid.getRow(rowIdx);
    }

    public XYInfo colXYInfo(int colIdx) {
        return (XYInfo)this.grid.getCol(colIdx);
    }

    public final XYCell findCell(String name) {
        AutoGrowGrid.CellsIterator i = this.grid.iterateCells();
        while (i.hasNext()) {
            XYCell cell = (XYCell)i.next();
            if (!name.equals(cell.getName())) continue;
            return cell;
        }
        return null;
    }

    public XYCell cellXY(int rowIdx, int colIdx) {
        XYCell cell = (XYCell)this.grid.getCell(rowIdx, colIdx);
        if (cell == null) {
            cell = new XYCell();
            this.grid.setCell(rowIdx, colIdx, cell);
        }
        return cell;
    }

    public void merge(int rowIdx, int colIdx, int rowSpan, int colSpan) {
        this.grid.merge(rowIdx, colIdx, rowSpan, colSpan);
    }

    public void split(int rowIdx, int colIdx) {
        this.grid.split(rowIdx, colIdx);
    }
}

