/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.r1.form.engine.x.data.grouping;

import com.kingdee.bos.ctrl.reportone.r1.form.engine.x.common.ListMap;
import com.kingdee.bos.ctrl.reportone.r1.form.engine.x.data.grouping.GroupingEngine;
import com.kingdee.bos.ctrl.reportone.r1.form.engine.x.data.grouping.IGroupingListener;
import com.kingdee.bos.ctrl.reportone.r1.form.engine.x.data.grouping.SimpleValue;
import com.kingdee.bos.ctrl.reportone.r1.form.engine.x.data.grouping.StatCell;
import com.kingdee.bos.ctrl.reportone.r1.form.engine.x.data.grouping.StatGroup;
import com.kingdee.bos.ctrl.reportone.r1.form.engine.x.data.rs.RsUtil;
import com.kingdee.bos.ctrl.reportone.r1.form.engine.x.data.rs.SimpleColumnMD;
import com.kingdee.bos.ctrl.reportone.r1.form.engine.x.data.rs.SimpleResultSet;
import com.kingdee.bos.ctrl.reportone.r1.form.engine.x.data.rs.SimpleResultSetMD;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.List;

public final class GroupRSCache {
    private ResultSet rows;
    private int groupCount;
    private ACache[] caches;
    private DetailCache detailCache = null;
    private GroupingEngine engine;

    public static String buildOutputStatColName(String statType, int dataCol) throws SQLException {
        if ("COUNT".equals(statType) || "COUNT_CHILD".equals(statType)) {
            return statType;
        }
        return statType + dataCol;
    }

    public void init(ResultSet rows, StatGroup[] groups, int[] detailCols) throws SQLException {
        this.rows = rows;
        this.groupCount = groups.length;
        this.engine = new GroupingEngine();
        this.engine.init(rows, groups);
        this.engine.setListener(new CacheHandler());
        if (detailCols != null) {
            this.detailCache = new DetailCache();
            this.detailCache.init(detailCols);
            this.caches = new ACache[this.groupCount + 1];
            this.caches[this.groupCount] = this.detailCache;
        } else {
            this.caches = new ACache[this.groupCount];
        }
        for (int i = 0; i < this.groupCount; ++i) {
            GroupCache groupCache = new GroupCache();
            groupCache.init(groups[i], i);
            this.caches[i] = groupCache;
        }
    }

    public final int getDepth() {
        return this.caches.length;
    }

    public final int findGroupCol(int level, String statType, int dataCol) throws SQLException {
        return RsUtil.locateColIndex(this.caches[level].getCachingRS().getMetaData(), GroupRSCache.buildOutputStatColName(statType, dataCol));
    }

    public final int findDetailCol(int dataCol) throws SQLException {
        return RsUtil.locateColIndex(this.detailCache.getCachingRS().getMetaData(), String.valueOf(dataCol));
    }

    public final boolean hasNextGroup() {
        return this.engine.hasNextGroup();
    }

    public final int nextGroup(int exitDepth) throws SQLException {
        return this.engine.nextGroup(exitDepth);
    }

    public final boolean nextOutputRow(int level) throws SQLException {
        ACache cache = this.caches[level];
        if (cache.next()) {
            if (++level < this.caches.length) {
                this.caches[level].setCount(cache.getRSCount());
            }
            return true;
        }
        return false;
    }

    public final ResultSet getOutputRow(int level) throws SQLException {
        return this.caches[level].getCachingRS();
    }

    public final ResultSet ensureRow(int level) throws SQLException {
        if (level < this.groupCount) {
            ACache groupCache = this.caches[level];
            if (groupCache.isPending()) {
                this.nextGroup(level);
            }
            return groupCache.getCachingRS();
        }
        return this.detailCache.getCachingRS();
    }

    public final int getOffset(int level) {
        return (level < this.groupCount ? this.caches[level] : this.detailCache).getOffset();
    }

    private class CacheHandler
    implements IGroupingListener {
        private CacheHandler() {
        }

        @Override
        public void startGroup(int level) throws SQLException {
            for (int i = level; i < GroupRSCache.this.groupCount; ++i) {
                GroupRSCache.this.caches[i].addRow();
            }
        }

        @Override
        public void stepDetail() throws SQLException {
            if (GroupRSCache.this.detailCache != null) {
                GroupRSCache.this.detailCache.addRow();
            }
        }

        @Override
        public void endGroup(int level) throws SQLException {
            for (int i = level; i < GroupRSCache.this.groupCount; ++i) {
                ((GroupCache)GroupRSCache.this.caches[i]).updateStatValues();
            }
        }
    }

    private class DetailCache
    extends ACache {
        private int[] colMap;

        private DetailCache() {
        }

        final void init(int[] colMap) throws SQLException {
            ResultSetMetaData rowsMD = GroupRSCache.this.rows.getMetaData();
            this.colMap = colMap;
            SimpleResultSetMD rsmd = new SimpleResultSetMD(this.colMap.length - 1);
            for (int i = 1; i < this.colMap.length; ++i) {
                int dataCol = this.colMap[i];
                SimpleColumnMD colMD = new SimpleColumnMD(rowsMD, dataCol);
                colMD.setName(String.valueOf(dataCol));
                rsmd.setColumn(i, colMD);
            }
            this.cachingRS = new SimpleResultSet(rsmd);
        }

        @Override
        final void addRow() throws SQLException {
            this.cachingRS.moveToInsertRow();
            for (int i = 1; i < this.colMap.length; ++i) {
                this.cachingRS.updateObject(i, GroupRSCache.this.rows.getObject(this.colMap[i]));
            }
            this.cachingRS.insertRow();
        }

        @Override
        final boolean isPending() throws SQLException {
            return false;
        }
    }

    private class GroupCache
    extends ACache {
        private SimpleValue[] statValues;
        private boolean pending;

        private GroupCache() {
        }

        final void init(StatGroup group, int level) throws SQLException {
            ListMap col2stat = new ListMap();
            int z = group.getStatCellCount();
            for (int i = -1; i < z; ++i) {
                int dataCol;
                String statType;
                if (i == -1) {
                    statType = "COUNT";
                    dataCol = 0;
                } else {
                    StatCell cell = group.getStatCell(i);
                    statType = cell.getStatType();
                    dataCol = cell.getDataCol();
                }
                String colName = GroupRSCache.buildOutputStatColName(statType, dataCol);
                SimpleValue statVal = GroupRSCache.this.engine.findStat(statType, dataCol).getStatValue(level);
                col2stat.put(colName, statVal);
            }
            List colNames = col2stat.getKeys();
            List statVals = col2stat.getValues();
            int colCount = colNames.size();
            this.statValues = new SimpleValue[1 + colCount];
            SimpleResultSetMD rsmd = new SimpleResultSetMD(colCount);
            int i = 0;
            int colIdx = 1;
            while (i < colCount) {
                SimpleValue statVal;
                this.statValues[colIdx] = statVal = (SimpleValue)statVals.get(i);
                SimpleColumnMD colMD = new SimpleColumnMD();
                colMD.setName((String)colNames.get(i));
                colMD.setType(statVal.getType().getJdbcType());
                rsmd.setColumn(colIdx, colMD);
                ++i;
                ++colIdx;
            }
            this.countCol = 1;
            this.cachingRS = new SimpleResultSet(rsmd);
        }

        @Override
        final void addRow() throws SQLException {
            this.pending = true;
            this.cachingRS.moveToInsertRow();
            for (int i = 1; i < this.statValues.length; ++i) {
                this.cachingRS.updateObject(i, this.statValues[i].objectValue());
            }
            this.cachingRS.insertRow();
        }

        final void updateStatValues() throws SQLException {
            for (int i = 1; i < this.statValues.length; ++i) {
                this.cachingRS.updateObject(i, this.statValues[i].objectValue());
            }
            this.cachingRS.updateRow();
            this.cachingRS.moveToCurrentRow();
            this.pending = false;
        }

        @Override
        final boolean isPending() throws SQLException {
            return this.pending;
        }
    }

    private abstract class ACache {
        protected ResultSet cachingRS;
        protected int count = Integer.MAX_VALUE;
        protected int countCol = 0;
        private int offset;

        private ACache() {
        }

        final ResultSet getCachingRS() {
            return this.cachingRS;
        }

        abstract void addRow() throws SQLException;

        abstract boolean isPending() throws SQLException;

        final void setCount(int count) {
            this.count = count;
            this.offset = 0;
        }

        final int getRSCount() throws SQLException {
            return this.countCol > 0 ? this.cachingRS.getInt(this.countCol) : 1;
        }

        final int getOffset() {
            return this.offset;
        }

        final boolean next() throws SQLException {
            if (this.count > 0) {
                ++this.offset;
                if (this.cachingRS.next()) {
                    this.count -= this.getRSCount();
                    return true;
                }
            }
            return false;
        }
    }
}

