/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.r1.form.engine.x.data.grouping;

import com.kingdee.bos.ctrl.reportone.r1.form.engine.x.common.log.LogUtil;
import com.kingdee.bos.ctrl.reportone.r1.form.engine.x.common.log.Logger;
import com.kingdee.bos.ctrl.reportone.r1.form.engine.x.data.grouping.GroupingCols;
import com.kingdee.bos.ctrl.reportone.r1.form.engine.x.data.grouping.GroupingStats;
import com.kingdee.bos.ctrl.reportone.r1.form.engine.x.data.grouping.IGroupingListener;
import com.kingdee.bos.ctrl.reportone.r1.form.engine.x.data.grouping.ParseStatGroups;
import com.kingdee.bos.ctrl.reportone.r1.form.engine.x.data.grouping.SimpleValue;
import com.kingdee.bos.ctrl.reportone.r1.form.engine.x.data.grouping.StatGroup;
import com.kingdee.bos.ctrl.reportone.r1.form.engine.x.data.grouping.stat.AGroupingStat;
import java.sql.ResultSet;
import java.sql.SQLException;

public final class GroupingEngine {
    private static final Logger log = LogUtil.getLogger(GroupingEngine.class, 1);
    private IGroupingListener listener;
    protected boolean detailRows = true;
    private int currentLevel = -1;
    private int lastLevel;
    private boolean hasNextGroup = true;
    private int groupCount;
    private int groupTotal;
    protected GroupingCols gcols;
    protected GroupingStats gstats;

    public void init(ResultSet rows, StatGroup[] groups) throws SQLException {
        ParseStatGroups im = new ParseStatGroups();
        im.parse(rows, groups);
        this.groupTotal = im.getGroupTotal();
        this.groupCount = im.getGroupCount();
        this.gcols = new GroupingCols();
        this.gcols.init(im);
        this.gstats = new GroupingStats();
        this.gstats.setBaseStats(im.getBaseStats());
        this.gstats.setAdvStats(im.getAdvStats());
    }

    public final IGroupingListener getListener() {
        return this.listener;
    }

    public final void setListener(IGroupingListener x) {
        this.listener = x;
    }

    protected void fireStartGroup(int level) throws SQLException {
        if (this.listener != null) {
            this.listener.startGroup(level);
        }
    }

    protected void fireStepDetail() throws SQLException {
        if (this.listener != null) {
            this.listener.stepDetail();
        }
    }

    protected void fireEndGroup(int level) throws SQLException {
        if (this.listener != null) {
            this.listener.endGroup(level);
        }
    }

    public final boolean isDetailRows() {
        return this.detailRows;
    }

    public final void setDetailRows(boolean x) {
        this.detailRows = x;
    }

    public final int getCurrentLevel() {
        return this.currentLevel;
    }

    public final boolean hasNextGroup() {
        return this.hasNextGroup;
    }

    public final AGroupingStat findStat(String statType, int colIdx) throws SQLException {
        SimpleValue colVal = colIdx > 0 ? this.gcols.findColValue(colIdx) : null;
        return this.gstats.findStat(statType, colVal);
    }

    private void startGroup(int level) throws SQLException {
        if (log.isDebugEnable()) {
            log.debug("Start group ... " + level);
        }
        this.gcols.syncLastValues(level == 0 ? 0 : level - this.groupTotal);
        this.gstats.start(level);
        this.fireStartGroup(level);
        if (this.detailRows) {
            this.stepDetail();
        }
    }

    private void stepDetail() throws SQLException {
        if (log.isDebugEnable()) {
            log.debug("Step detail ... ");
        }
        this.gstats.stepStat();
        this.fireStepDetail();
    }

    private void endGroup(int level) throws SQLException {
        if (log.isDebugEnable()) {
            log.debug("End group ... " + level);
        }
        this.gstats.finalStat(level);
        this.fireEndGroup(level);
    }

    public final int nextGroup(int exitDepth) throws SQLException {
        if (this.currentLevel != -1) {
            this.startGroup(this.currentLevel);
        }
        while (true) {
            this.hasNextGroup = this.gcols.nextRow();
            if (!this.hasNextGroup) break;
            this.lastLevel = this.currentLevel;
            int n = this.currentLevel = this.currentLevel == -1 ? 0 : this.groupTotal + this.gcols.findDifferent();
            if (this.currentLevel == this.groupCount) {
                this.stepDetail();
                continue;
            }
            if (this.lastLevel != -1) {
                this.endGroup(this.currentLevel);
                if (this.currentLevel <= exitDepth) {
                    return this.currentLevel;
                }
            }
            this.startGroup(this.currentLevel);
        }
        if (this.currentLevel == -1) {
            return -1;
        }
        this.currentLevel = 0;
        this.endGroup(0);
        return 0;
    }
}

