/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.r1.print.barcode;

import com.kingdee.bos.ctrl.common.DataType;
import com.kingdee.bos.ctrl.common.layout.table.Table;
import com.kingdee.bos.ctrl.common.layout.table.TableLayout;
import com.kingdee.bos.ctrl.extendcontrols.BizDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.IDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.kdf.util.render.ObjectValueRender;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.data.IR1DataManager;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.ElementPath;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.gui.core.ComboPanel;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.gui.property.AbstractPropertyPanel;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.util.MultiLanguageUtil;
import com.kingdee.bos.ctrl.reportone.r1.print.barcode.BarcodeBindSource;
import com.kingdee.bos.ctrl.reportone.r1.print.barcode.BarcodeObject;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDButton;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDFilterTextField;
import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.ctrl.swing.KDLabelContainer;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDSpinner;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.util.CtrlSwingUtilities;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;

public class PanelBarcode
extends AbstractPropertyPanel {
    private static final long serialVersionUID = -1888942998770391611L;
    private IR1DataManager dm;
    private KDTable dataTable = new KDTable();
    private KDComboBox comboType = new KDComboBox();
    private KDComboBox comboSymbolShape = new KDComboBox();
    private KDLabelContainer lbcSymbol = CtrlSwingUtilities.createLabelContainer((JComponent)this.comboSymbolShape, (String)"\u5f62\u72b6", (int)100);
    private KDButton btnUp;
    private KDButton btnDown;
    private KDButton btnRemove;
    private KDButton btnAddTxt;
    private KDBizPromptBox dictF7;
    private KDSpinner dpiSpin = new KDSpinner((SpinnerModel)new SpinnerNumberModel(300, 10, 2400, 1));
    private KDSpinner modelWithSpin = new KDSpinner((SpinnerModel)new SpinnerNumberModel(0.0, 0.0, 4.999, 0.001));
    private KDComboBox cmbScale;
    private KDTextField sampleTxt = new KDTextField();
    private KDCheckBox chkShowSample = new KDCheckBox();
    private KDSpinner fontSizeSpin = new KDSpinner((SpinnerModel)new SpinnerNumberModel(11, 0, 2000, 1));
    public static String[] symbolShape = new String[]{"\u9ed8\u8ba4", "\u6b63\u65b9\u5f62", "\u77e9\u5f62"};
    public static String[] barcodeTypeItem = new String[]{"(1\u7ef4)code128", "(1\u7ef4)ean-128", "(2\u7ef4)datamatrix", "(2\u7ef4)qr", "(1\u7ef4)code39", "(1\u7ef4)code39-ext", "(1\u7ef4)code93", "(1\u7ef4)code93-ext", "(1\u7ef4)codabar", "(1\u7ef4)code11", "(1\u7ef4)intl2of5", "(1\u7ef4)standard2of5", "(1\u7ef4)ean-13", "(1\u7ef4)ean-8", "(1\u7ef4)upc-a", "(1\u7ef4)upc-e", "(1\u7ef4)postnet", "(1\u7ef4)msi", "(2\u7ef4)pdf417"};

    public PanelBarcode() {
        this.init();
        this.installListener();
    }

    protected void init() {
        this.setLayout(new BorderLayout());
        this.lbcSymbol.setVisible(false);
        IColumn ic = this.dataTable.addColumn();
        ic.setKey("data");
        ic.setWidth(180);
        ic = this.dataTable.addColumn();
        ic.setKey("dict");
        ic.setWidth(100);
        ic = this.dataTable.addColumn();
        ic.setKey("format");
        ic.setWidth(100);
        IRow headRow = this.dataTable.addHeadRow();
        headRow.getCell(0).setValue((Object)"\u6570\u636e\u6e90/\u6587\u672c");
        headRow.getCell(1).setValue((Object)"\u6761\u5f62\u7801\u5b57\u5178");
        headRow.getCell(2).setValue((Object)"\u6570\u5b57\u683c\u5f0f");
        this.dataTable.getColumn(0).getStyleAttributes().setLocked(true);
        this.dataTable.getSelectManager().setSelectMode(2);
        this.dictF7 = new KDBizPromptBox();
        this.dictF7.setVisible(true);
        this.dictF7.setEditable(true);
        this.dictF7.setDisplayFormat("$number$");
        this.dictF7.setEditFormat("$number$");
        this.dictF7.setCommitFormat("$number$");
        this.dictF7.setQueryInfo("com.kingdee.eas.barcode.scm.app.BarcodeDictQuery");
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("status", (Object)1, CompareType.EQUALS));
        ev.setFilter(filter);
        this.dictF7.setEntityViewInfo(ev);
        KDTDefaultCellEditor object_CellEditor = new KDTDefaultCellEditor((IKDEditor)this.dictF7);
        this.dataTable.getColumn(1).setEditor((ICellEditor)object_CellEditor);
        ObjectValueRender avr = new ObjectValueRender();
        avr.setFormat((IDataFormat)new BizDataFormat("$number$"));
        this.dataTable.getColumn(1).setRenderer((IBasicRender)avr);
        this.btnUp = new KDButton();
        this.btnUp.setPreferredSize(new Dimension(20, 20));
        this.btnUp.setText("\u4e0a\u79fb");
        this.btnDown = new KDButton();
        this.btnDown.setPreferredSize(new Dimension(20, 20));
        this.btnDown.setText("\u4e0b\u79fb");
        this.btnRemove = new KDButton();
        this.btnRemove.setPreferredSize(new Dimension(20, 20));
        this.btnRemove.setText("\u5220\u9664");
        this.btnAddTxt = new KDButton();
        this.btnAddTxt.setPreferredSize(new Dimension(20, 20));
        this.btnAddTxt.setText("\u52a0\u6587\u672c");
        this.comboType = new KDComboBox();
        this.comboType.setSize(new Dimension(100, 30));
        this.comboType.addItems((Object[])barcodeTypeItem);
        KDLabelContainer lbcType = CtrlSwingUtilities.createLabelContainer((JComponent)this.comboType, (String)"\u7801\u5236", (int)100);
        this.comboSymbolShape.addItems((Object[])symbolShape);
        TableLayout btnTl = TableLayout.split((int)15, (int)1);
        btnTl.rowStyle(0).setHeight(10);
        btnTl.rowStyle(1).setHeight(10);
        btnTl.rowStyle(2).setHeight(10);
        btnTl.rowStyle(3).setHeight(10);
        KDPanel btnPanel = new KDPanel((LayoutManager)btnTl);
        btnPanel.add((Component)this.btnUp, (Object)btnTl.cell(0));
        btnPanel.add((Component)this.btnDown, (Object)btnTl.cell(1));
        btnPanel.add((Component)this.btnRemove, (Object)btnTl.cell(2));
        btnPanel.add((Component)this.btnAddTxt, (Object)btnTl.cell(3));
        KDPanel panData = new KDPanel();
        panData.setLayout((LayoutManager)new BorderLayout());
        panData.setBorder((Border)BorderFactory.createTitledBorder("\u6570\u636e"));
        panData.add((Component)this.dataTable, (Object)"Center");
        panData.add((Component)btnPanel, (Object)"East");
        TableLayout tlOwner = TableLayout.split((int)3, (int)1);
        tlOwner.getStyle().setMargin(8, 8, 8, 8);
        tlOwner.rowStyle(0).setMargin(0, 0, 0, 6);
        tlOwner.rowStyle(1).setMargin(0, 0, 0, 3);
        tlOwner.rowStyle(0).setHeight(300);
        tlOwner.rowStyle(1).setHeight(80);
        tlOwner.rowStyle(1).setPriY(1);
        this.cmbScale = new KDComboBox((Object[])new String[]{MultiLanguageUtil.getMLS("property.PanelPicture.noZoom", "\u539f\u59cb\u5927\u5c0f"), MultiLanguageUtil.getMLS("property.PanelPicture.zoomByScale", "\u6309\u6bd4\u4f8b\u7f29\u653e")});
        KDLabelContainer lbcScale = CtrlSwingUtilities.createLabelContainer((JComponent)this.cmbScale, (String)MultiLanguageUtil.getMLS("property.PanelPicture.zoom", "\u7f29\u653e"), (int)100);
        KDLabelContainer lbcSampleTxt = CtrlSwingUtilities.createLabelContainer((JComponent)this.sampleTxt, (String)"\u793a\u4f8b\u6570\u636e", (int)100);
        KDLabelContainer lbcFontSize = CtrlSwingUtilities.createLabelContainer((JComponent)this.fontSizeSpin, (String)"\u5b57\u4f53\u76f8\u5bf9\u5927\u5c0f", (int)100);
        KDLabelContainer lbcModelWidth = CtrlSwingUtilities.createLabelContainer((JComponent)this.modelWithSpin, (String)"\u6a21\u5757\u5bbd\u5ea6(mm)", (int)100);
        KDLabelContainer lbcDpi = CtrlSwingUtilities.createLabelContainer((JComponent)this.dpiSpin, (String)"DPI", (int)100);
        KDLabel modelWidthLab = new KDLabel();
        this.chkShowSample.setText("\u663e\u793a\u793a\u4f8b\u56fe\u7247");
        modelWidthLab.setText("\u4e3a0\u5c06\u53d6\u9ed8\u8ba4\u503c");
        KDLabel dpiLab = new KDLabel();
        dpiLab.setText("dpi\u8303\u56f4:10-2400");
        Table row1 = tlOwner.cell(1).split(4, 2);
        row1.rowStyle(0).setMarginBottom(5);
        row1.rowStyle(0).setHeight(20);
        row1.rowStyle(1).setMarginBottom(5);
        row1.rowStyle(1).setHeight(20);
        row1.rowStyle(2).setMarginBottom(5);
        row1.rowStyle(2).setHeight(20);
        row1.rowStyle(3).setMarginBottom(5);
        row1.rowStyle(3).setHeight(20);
        row1.colStyle(0).setWidth(180);
        row1.colStyle(0).setMarginRight(10);
        row1.colStyle(1).setWidth(180);
        row1.colStyle(1).setMarginRight(10);
        this.setLayout((LayoutManager)tlOwner);
        this.add((Component)panData, tlOwner.cell(0));
        this.add((Component)lbcType, row1.cell(0, 0));
        this.add((Component)this.lbcSymbol, row1.cell(0, 1));
        this.add((Component)lbcDpi, row1.cell(1, 0));
        this.add((Component)dpiLab, row1.cell(1, 1));
        this.add((Component)lbcSampleTxt, row1.cell(2, 0));
        this.add((Component)this.chkShowSample, row1.cell(2, 1));
        this.add((Component)lbcFontSize, row1.cell(3, 0));
    }

    private void installListener() {
        this.dataTable.addKDTEditListener(new KDTEditListener(){

            public void editValueChanged(KDTEditEvent e) {
            }

            public void editStopping(KDTEditEvent e) {
            }

            public void editStopped(KDTEditEvent e) {
                PanelBarcode.this.dataTable_editStopped(e);
            }

            public void editStarting(KDTEditEvent e) {
            }

            public void editStarted(KDTEditEvent e) {
            }

            public void editCanceled(KDTEditEvent e) {
            }
        });
        this.comboType.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                PanelBarcode.this.comboType_itemStateChanged(e);
            }
        });
        this.btnUp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PanelBarcode.this.btnUp_actionPerformed(e);
            }
        });
        this.btnDown.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PanelBarcode.this.btnDown_actionPerformed(e);
            }
        });
        this.btnRemove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PanelBarcode.this.btnRemove_actionPerformed(e);
            }
        });
        this.btnAddTxt.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PanelBarcode.this.btnAddTxt_actionPerformed(e);
            }
        });
    }

    protected void dataTable_editStopped(KDTEditEvent e) {
        int rowIndex = e.getRowIndex();
        int colIndex = e.getColIndex();
        if (colIndex == 2) {
            Object o = this.dataTable.getCell(rowIndex, colIndex).getValue();
            if (o != null && !o.toString().equals("")) {
                int endInd;
                int startInd = o.toString().indexOf(".");
                if (startInd != (endInd = o.toString().lastIndexOf("."))) {
                    this.dataTable.getCell(rowIndex, colIndex).setValue(e.getOldValue());
                } else if (startInd == 0) {
                    this.dataTable.getCell(rowIndex, colIndex).setValue((Object)("0" + o.toString()));
                }
            } else {
                this.dataTable.getCell(rowIndex, colIndex).setValue(e.getOldValue());
            }
        }
    }

    protected void comboType_itemStateChanged(ItemEvent e) {
        String temp = (String)e.getItem();
        if (temp != null) {
            if ((temp = temp.substring(4)).equals("datamatrix")) {
                this.lbcSymbol.setVisible(true);
            } else {
                this.lbcSymbol.setVisible(false);
            }
            String sampleBarcode = (String)BarcodeObject.SAMPLE_BARCODE.get(temp);
            if (sampleBarcode != null && (this.sampleTxt.getText() == null || this.sampleTxt.getText().length() != sampleBarcode.length())) {
                this.sampleTxt.setText(sampleBarcode);
            }
        }
    }

    protected void checkAutoResize_stateChanged(ChangeEvent e) {
    }

    protected void btnRemove_actionPerformed(ActionEvent e) {
        int index = this.dataTable.getSelectManager().getActiveRowIndex();
        if (index == -1) {
            return;
        }
        this.dataTable.removeRow(index);
    }

    protected void btnDown_actionPerformed(ActionEvent e) {
        int index = this.dataTable.getSelectManager().getActiveRowIndex();
        if (index == -1 || index == this.dataTable.getRowCount() - 1) {
            return;
        }
        this.dataTable.addRow(index + 2, this.dataTable.getRow(index));
        this.dataTable.removeRow(index);
        this.dataTable.getSelectManager().select(index + 1, 2);
    }

    protected void btnUp_actionPerformed(ActionEvent e) {
        int index = this.dataTable.getSelectManager().getActiveRowIndex();
        if (index == -1 || index == 0) {
            return;
        }
        this.dataTable.addRow(index - 1, this.dataTable.getRow(index));
        this.dataTable.removeRow(index + 1);
        this.dataTable.getSelectManager().select(index - 1, 2);
    }

    protected void btnAddTxt_actionPerformed(ActionEvent e) {
        IRow row = this.dataTable.addRow();
        BarcodeBindSource bbs = new BarcodeBindSource();
        bbs.setType("Text");
        row.setUserObject((Object)bbs);
        row.getCell(0).getStyleAttributes().setLocked(false);
        row.getCell(1).getStyleAttributes().setLocked(true);
        row.getCell(2).getStyleAttributes().setLocked(true);
    }

    @Override
    protected void updateElementValue(ElementPath elePath) {
        BarcodeObject bo = (BarcodeObject)elePath.getLastPathComponent();
        this.storeObject(bo);
    }

    @Override
    public String getTitle() {
        return "\u6761\u5f62\u7801";
    }

    private void loadObject(BarcodeObject bo) {
        this.dataTable.removeRows();
        for (int i = 0; i < bo.getFields().size(); ++i) {
            IRow row = this.dataTable.addRow();
            BarcodeBindSource bbs = bo.getFields().get(i);
            row.setUserObject((Object)bbs);
            row.getCell(0).setValue((Object)bbs.toString());
            if ("DataSource".equals(bbs.getType())) {
                if (bbs != null && bbs.getDictId() != null) {
                    IObjectValue value = null;
                    try {
                        value = (IObjectValue)Class.forName(BarcodeBindSource.getDictEntity().getObjectValueClassRuntime()).newInstance();
                        value.put("number", (Object)bbs.getDictNumber());
                        value.put("id", (Object)BOSUuid.read((String)bbs.getDictId()));
                        row.getCell(1).setValue((Object)value);
                    }
                    catch (Exception e1) {
                        e1.printStackTrace();
                        row.getCell(1).setValue(null);
                    }
                } else {
                    row.getCell(1).setValue(null);
                }
                row.getCell(2).setValue((Object)bbs.getFormat());
                DataType dt = bbs.getBindField().getField().getDataType();
                if (dt != null && (dt.intValue() == 5 || dt.intValue() == 3)) {
                    KDFilterTextField txt = new KDFilterTextField();
                    txt.setFilterType(1);
                    txt.setValidCharacters(".");
                    txt.setMaxLength(80);
                    row.getCell(2).setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)txt));
                    row.getCell(2).getStyleAttributes().setLocked(false);
                    row.getCell(2).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
                    continue;
                }
                row.getCell(2).getStyleAttributes().setLocked(true);
                continue;
            }
            if (!"Text".equals(bbs.getType())) continue;
            row.getCell(0).getStyleAttributes().setLocked(false);
            row.getCell(1).getStyleAttributes().setLocked(true);
            row.getCell(2).getStyleAttributes().setLocked(true);
        }
        this.comboType.setSelectedIndex(this.getIndexForBarType(bo.getBarcodeType()));
        this.cmbScale.setSelectedIndex(bo.getScale() == 0 ? 0 : 1);
        this.dpiSpin.setValue((Object)bo.getDpi());
        this.modelWithSpin.setValue((Object)bo.getModelWidth());
        this.comboSymbolShape.setSelectedIndex(this.getIndexFromItems(this.comboSymbolShape, this.getAliasBySymbolShape(bo.getShape())));
        this.sampleTxt.setText(bo.getSampleTxt());
        this.chkShowSample.setSelected(bo.isShowSample());
        this.fontSizeSpin.setValue((Object)bo.getFontSize());
    }

    private int getIndexForBarType(String str) {
        if (str == null) {
            return -1;
        }
        for (int i = 0; i < this.comboType.getItemCount(); ++i) {
            String item = (String)this.comboType.getItemAt(i);
            if (!str.equals(item = item.substring(4))) continue;
            return i;
        }
        return -1;
    }

    private void storeObject(BarcodeObject bo) {
        bo.getFields().clear();
        for (int i = 0; i < this.dataTable.getRowCount(); ++i) {
            IRow row = this.dataTable.getRow(i);
            BarcodeBindSource bbs = (BarcodeBindSource)row.getUserObject();
            if ("Text".equals(bbs.getType())) {
                String text = (String)row.getCell(0).getValue();
                if (text == null || "".equals(text)) continue;
                bbs.setText(text);
            } else if ("DataSource".equals(bbs.getType())) {
                if (row.getCell(1).getValue() != null) {
                    IObjectValue value = (IObjectValue)row.getCell(1).getValue();
                    bbs.setDictId(value.get("id").toString());
                    bbs.setDictNumber(value.get("number").toString());
                } else {
                    bbs.setDictId(null);
                    bbs.setDictNumber(null);
                }
                if (row.getCell(2).getValue() != null) {
                    bbs.setFormat(row.getCell(2).getValue().toString());
                } else {
                    bbs.setFormat("");
                }
            }
            bo.getFields().add(bbs);
        }
        String barType = (String)this.comboType.getSelectedItem();
        barType = barType.substring(4);
        bo.setBarcodeType(barType);
        bo.setDpi((Integer)this.dpiSpin.getValue());
        if (this.cmbScale.getSelectedIndex() >= 0) {
            bo.setScale(this.cmbScale.getSelectedIndex() == 0 ? 0 : 3);
        }
        try {
            bo.setModelWidth((Double)this.modelWithSpin.getValue());
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
        bo.setShape(this.getSymbolShapeByAlias((String)this.comboSymbolShape.getSelectedItem()));
        if (this.sampleTxt.getText() != null && !"".equals(this.sampleTxt)) {
            bo.setSampleTxt(this.sampleTxt.getText());
        }
        if (this.chkShowSample.isSelected()) {
            bo.setShowSample(true);
        } else {
            bo.setShowSample(false);
        }
        bo.setFontSize((Integer)this.fontSizeSpin.getValue());
    }

    private int getIndexFromItems(KDComboBox cb, String str) {
        if (str == null) {
            return -1;
        }
        for (int i = 0; i < cb.getItemCount(); ++i) {
            if (!str.equals(cb.getItemAt(i))) continue;
            return i;
        }
        return -1;
    }

    private String getAliasBySymbolShape(String symbolShape) {
        if ("force-square".equals(symbolShape)) {
            return "\u6b63\u65b9\u5f62";
        }
        if ("force-rectangle".equals(symbolShape)) {
            return "\u77e9\u5f62";
        }
        return "\u9ed8\u8ba4";
    }

    private String getSymbolShapeByAlias(String alias) {
        if ("\u6b63\u65b9\u5f62".equals(alias)) {
            return "force-square";
        }
        if ("\u77e9\u5f62".equals(alias)) {
            return "force-rectangle";
        }
        return "force-none";
    }

    @Override
    public void prepareCtrlValue(ElementPath[] eps) {
    }

    @Override
    public void prepareSupplyValue(ComboPanel core, ElementPath[] eles) {
        this.dm = core.getModel().getDataManager();
        BarcodeObject bo = (BarcodeObject)eles[0].getLastPathComponent();
        this.loadObject(bo);
    }
}

