/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.r1.print.designer.actions.operate;

import com.kingdee.bos.ctrl.common.layout.table.Table;
import com.kingdee.bos.ctrl.common.layout.table.TableLayout;
import com.kingdee.bos.ctrl.common.ui.SimpleDialog;
import com.kingdee.bos.ctrl.common.ui.WindowUtil;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.kdf.util.render.ImageRender;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.actions.operate.AbstractOperate;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.gui.core.ComboPanel;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.util.MultiLanguageUtil;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.util.Util;
import com.kingdee.bos.ctrl.reportone.r1.print.common.ImageUtil;
import com.kingdee.bos.ctrl.reportone.r1.print.common.R1PrintInfo;
import com.kingdee.bos.ctrl.reportone.r1.print.designer.element.R1PrintPage;
import com.kingdee.bos.ctrl.reportone.r1.print.designer.model.R1PrintModelHelper;
import com.kingdee.bos.ctrl.swing.KDButtonGroup;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDFileChooser;
import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.ctrl.swing.KDLabelContainer;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDRadioButton;
import com.kingdee.bos.ctrl.swing.KDSpinner;
import com.kingdee.bos.ctrl.swing.KDTextArea;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.ctrl.swing.util.CtrlSwingUtilities;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.filechooser.FileFilter;

public class BackgroundPictureOperate
extends AbstractOperate {
    @Override
    public boolean operate() {
        PanelPageSet panel = new PanelPageSet();
        panel.prepareValue(this.getCore());
        SimpleDialog dlg = SimpleDialog.create((Component)this.getParentCtrl());
        dlg.setComponent((Component)((Object)panel));
        dlg.setTitle(MultiLanguageUtil.getMLS("operate.BackgroundPictureOperate.setBacPicture", ""));
        dlg.setSize(480, 360);
        if (dlg.showDialog()) {
            this.getCore().storeUndoState(dlg.getTitle());
            panel.updateValue(this.getCore());
            this.getCore().getModel().setDirty(true);
            this.getCore().getPageContainer().repaint();
        }
        return true;
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    public boolean isNeedShowUI() {
        return true;
    }

    private static class PanelPageSet
    extends KDPanel {
        private KDSpinner spnOffX;
        private KDSpinner spnOffY;
        private KDWorkButton btnSelectPic;
        private KDWorkButton btnClearPic;
        private KDCheckBox chkSyncPaper;
        private KDCheckBox chkPrint;
        private PreviewPane previewPanel;
        private KDRadioButton paperButton;
        private KDRadioButton pageButton;
        private String filePath;
        private Image imageForDraw;
        private R1PrintInfo printInfo;

        public PanelPageSet() {
            this.initComponents();
            this.addListener();
        }

        public void setConsultPage(boolean isConsultPage) {
            if (isConsultPage) {
                this.pageButton.setSelected(true);
            } else {
                this.paperButton.setSelected(true);
            }
        }

        public boolean isConsultPage() {
            return this.pageButton.isSelected();
        }

        private void addListener() {
            this.spnOffX.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    previewPanel.repaint();
                }
            });
            this.spnOffY.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    previewPanel.repaint();
                }
            });
            this.btnSelectPic.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    KDFileChooser chooser = new KDFileChooser();
                    chooser.setMultiSelectionEnabled(false);
                    chooser.setDialogType(0);
                    chooser.setFileFilter(new FileFilter(){

                        @Override
                        public boolean accept(File f) {
                            if (f.isDirectory()) {
                                return true;
                            }
                            String name = f.getName();
                            String ext = name.substring(name.lastIndexOf(".") + 1);
                            return "jpg".equalsIgnoreCase(ext) || "jpeg".equalsIgnoreCase(ext) || "bmp".equalsIgnoreCase(ext) || "dib".equalsIgnoreCase(ext) || "gif".equalsIgnoreCase(ext) || "png".equalsIgnoreCase(ext);
                        }

                        @Override
                        public String getDescription() {
                            return "Image files (*.jpg;*.bmp;*.gif;*.png)";
                        }
                    });
                    if (chooser.showOpenDialog((Component)((Object)this)) == 0) {
                        filePath = chooser.getSelectedFile().getPath();
                        imageForDraw = ImageUtil.getImage(filePath);
                        btnClearPic.setEnabled(true);
                        previewPanel.repaint();
                    }
                }
            });
            this.btnClearPic.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    filePath = null;
                    imageForDraw = null;
                    btnClearPic.setEnabled(false);
                    previewPanel.repaint();
                }
            });
        }

        private void initComponents() {
            this.btnClearPic = new KDWorkButton(MultiLanguageUtil.getMLS("operate.BackgroundPictureOperate.cleanPicture", ""));
            this.btnSelectPic = new KDWorkButton(MultiLanguageUtil.getMLS("operate.BackgroundPictureOperate.choosePicture", ""));
            this.spnOffX = new KDSpinner((SpinnerModel)new SpinnerNumberModel(0, -10000, 10000, 1));
            this.spnOffY = new KDSpinner((SpinnerModel)new SpinnerNumberModel(0, -10000, 10000, 1));
            this.previewPanel = new PreviewPane();
            this.previewPanel.setBorder(BorderFactory.createLineBorder(Color.BLACK));
            this.pageButton = new KDRadioButton(MultiLanguageUtil.getMLS("operate.BackgroundPictureOperate.relativePage", ""));
            this.paperButton = new KDRadioButton(MultiLanguageUtil.getMLS("operate.BackgroundPictureOperate.relativePaper", ""));
            KDButtonGroup bg = new KDButtonGroup();
            bg.add((AbstractButton)this.pageButton);
            bg.add((AbstractButton)this.paperButton);
            KDLabelContainer lbcOffX = CtrlSwingUtilities.createLabelContainer((JComponent)this.spnOffX, (String)MultiLanguageUtil.getMLS("operate.BackgroundPictureOperate.excursionX", ""), (int)60);
            KDLabelContainer lbcOffY = CtrlSwingUtilities.createLabelContainer((JComponent)this.spnOffY, (String)MultiLanguageUtil.getMLS("operate.BackgroundPictureOperate.excursionY", ""), (int)60);
            this.chkSyncPaper = new KDCheckBox(MultiLanguageUtil.getMLS("operate.BackgroundPictureOperate.sameSizePaper", ""));
            this.chkSyncPaper.setSelected(false);
            this.chkPrint = new KDCheckBox(MultiLanguageUtil.getMLS("operate.BackgroundPictureOperate.printBackground", ""));
            this.chkPrint.setSelected(false);
            StringBuffer sbPrompt = new StringBuffer();
            sbPrompt.append(MultiLanguageUtil.getMLS("operate.BackgroundPictureOperate.explain1", ""));
            sbPrompt.append(StringUtil.RETURN);
            sbPrompt.append(MultiLanguageUtil.getMLS("operate.BackgroundPictureOperate.explain2", ""));
            sbPrompt.append(StringUtil.RETURN);
            sbPrompt.append(MultiLanguageUtil.getMLS("operate.BackgroundPictureOperate.explain3", ""));
            KDTextArea txaPrompt = new KDTextArea(sbPrompt.toString());
            txaPrompt.setBorder(null);
            txaPrompt.setEditable(false);
            TableLayout tl = TableLayout.split((int)1, (int)2);
            tl.colStyle(0).setWidth(200);
            tl.colStyle(0).setMarginRight(10);
            tl.colStyle(1).setPriX(1);
            Table t1 = tl.cell(0, 0).split(7, 1);
            t1.rowStyle(0).setMarginBottom(10);
            t1.rowStyle(1).setMarginBottom(6);
            t1.rowStyle(2).setMarginBottom(6);
            t1.rowStyle(3).setMarginBottom(6);
            t1.rowStyle(4).setMarginBottom(6);
            t1.rowStyle(5).setMarginBottom(6);
            t1.rowStyle(6).setPriY(1);
            Table t11 = t1.cell(0, 0).split(1, 2);
            t11.colStyle(0).setMarginRight(3);
            Table t22 = t1.cell(1, 0).split(1, 2);
            t22.colStyle(0).setMarginLeft(0);
            t22.colStyle(1).setMarginRight(0);
            Table t33 = t1.cell(2, 0).split(1, 2);
            t33.colStyle(0).setMarginRight(3);
            t33.colStyle(1).setPriX(1);
            Table t44 = t1.cell(3, 0).split(1, 2);
            t44.colStyle(0).setMarginRight(3);
            t44.colStyle(1).setPriX(1);
            this.setLayout((LayoutManager)tl);
            this.add((Component)this.btnSelectPic, t11.cell(0, 0));
            this.add((Component)this.btnClearPic, t11.cell(0, 1));
            this.add((Component)this.pageButton, t22.cell(0, 0));
            this.add((Component)this.paperButton, t22.cell(0, 1));
            this.add((Component)lbcOffX, t33.cell(0, 0));
            this.add((Component)new KDLabel(MultiLanguageUtil.getMLS("operate.BackgroundPictureOperate.unit", "")), t33.cell(0, 1));
            this.add((Component)lbcOffY, t44.cell(0, 0));
            this.add((Component)new KDLabel(MultiLanguageUtil.getMLS("operate.BackgroundPictureOperate.unit", "")), t44.cell(0, 1));
            this.add((Component)this.chkSyncPaper, t1.cell(4, 0));
            this.add((Component)this.chkPrint, t1.cell(5, 0));
            this.add((Component)txaPrompt, t1.cell(6, 0));
            this.add((Component)((Object)this.previewPanel), tl.cell(0, 1));
        }

        protected void updateValue(ComboPanel core) {
            R1PrintPage page = (R1PrintPage)core.getModel().getPage();
            if (this.imageForDraw == null) {
                this.printInfo.setHaveBackground(false);
                page.setImageContent(null);
                page.setPictureOffSetX(0);
                page.setPictureOffSetY(0);
            } else {
                if (this.filePath != null) {
                    this.printInfo.setHaveBackground(true);
                    page.setImageContent(ImageUtil.getImageByteContent(this.filePath));
                }
                page.setConsultPage(this.isConsultPage());
                int offsetX = this.spnOffX.getIntegerVlaue();
                int offsetY = this.spnOffY.getIntegerVlaue();
                int pageWidth = Util.pixel2Lom(this.imageForDraw.getWidth(null));
                int pageHeight = Util.pixel2Lom(this.imageForDraw.getHeight(null));
                if (this.chkSyncPaper.isSelected()) {
                    boolean[] isOutside = page.checkChildrenOutside(pageWidth, pageHeight);
                    if (isOutside[0] || isOutside[1]) {
                        StringBuffer sb = new StringBuffer();
                        sb.append(MultiLanguageUtil.getMLS("operate.BackgroundPictureOperate.warning1", ""));
                        sb.append(MultiLanguageUtil.getMLS("operate.BackgroundPictureOperate.warning2", ""));
                        sb.append(pageWidth);
                        sb.append("\uff0c");
                        sb.append(pageHeight);
                        sb.append("\uff09\u3002");
                        WindowUtil.msgboxWarning((Object)sb.toString(), (String)core.getPromptTitle(), (Component)((Object)this));
                    } else if (this.pageButton.isSelected()) {
                        this.printInfo.setPrintableAreaSize(new Dimension(pageWidth, pageHeight));
                        page.setWidthLom(pageWidth);
                        page.setHeightLom(pageHeight);
                    } else {
                        pageWidth = Math.max(pageWidth, this.printInfo.getMarginLeft() + this.printInfo.getMarginRight());
                        pageHeight = Math.max(pageHeight, this.printInfo.getMarginTop() + this.printInfo.getMarginBottom());
                        if (this.printInfo.getOrientation() == "PORTRAIT") {
                            this.printInfo.setCustomPaper(pageWidth, pageHeight);
                        } else {
                            this.printInfo.setCustomPaper(pageHeight, pageWidth);
                        }
                        page.setWidthLom(this.printInfo.getPrintableAreaSize().width);
                        page.setHeightLom(this.printInfo.getPrintableAreaSize().height);
                    }
                }
                page.setPictureOffSetX(offsetX);
                page.setPictureOffSetY(offsetY);
                boolean isPrintBackground = this.chkPrint.isSelected();
                page.setPrintBackground(isPrintBackground);
            }
        }

        public void prepareValue(ComboPanel core) {
            this.printInfo = R1PrintModelHelper.getPrintInfo(core.getModel());
            R1PrintPage page = (R1PrintPage)core.getModel().getPage();
            if (page.getImageContent() == null) {
                this.btnClearPic.setEnabled(false);
            }
            this.imageForDraw = page.getImg();
            this.spnOffX.setValue((Object)new Integer(page.getPictureOffSetX()));
            this.spnOffY.setValue((Object)new Integer(page.getPictureOffSetY()));
            this.setConsultPage(page.isConsultPage());
            this.previewPanel.repaint();
            this.chkPrint.setSelected(page.isPrintBackground());
        }

        class PreviewPane
        extends KDPanel {
            private JLabel iconLabel = new JLabel();

            public PreviewPane() {
                this.add(this.iconLabel, "Center");
            }

            public void paintComponent(Graphics g) {
                try {
                    g.clearRect(0, 0, this.getWidth(), this.getHeight());
                    if (PanelPageSet.this.imageForDraw != null) {
                        int x = Util.lom2Pixel(PanelPageSet.this.spnOffX.getIntegerVlaue());
                        int y = Util.lom2Pixel(PanelPageSet.this.spnOffY.getIntegerVlaue());
                        ImageRender render = new ImageRender();
                        render.setGraphics2D((Graphics2D)g.create());
                        Point pt = new Point(x, y);
                        render.draw(pt, PanelPageSet.this.imageForDraw);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

