/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.r1.print.designer.element.loop;

import com.kingdee.bos.ctrl.data.meta.MetaClass;
import com.kingdee.bos.ctrl.data.meta.MetaField;
import com.kingdee.bos.ctrl.kdf.util.style.ShareStyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.data.BindDataSource;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.data.Field;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.data.IBind;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.data.IR1DataManager;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.AbstractReportObject;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.ElementPath;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.ICompositeContainer;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.ICompositeObject;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.IContainer;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.IElement;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.IReportObject;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.grid.cellvalue.CellField;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.grid.cellvalue.ICellValue;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.gui.core.StructureTree;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.gui.mouseoperate.IMouseOperate;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.gui.mouseoperate.IMouseOperateState;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.gui.mouseoperate.Line;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.gui.property.IPropertyPanel;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.gui.ruler.IR1Ruler;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.gui.ruler.RulerMark;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.gui.undo.UndoHelper;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.model.ReportSelectionModel;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.renderer.IReportObjectRenderer;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.renderer.operate.LineAdjustRenderer;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.renderer.selection.ICompositeSelectionRenderer;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.util.ContainerUtil;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.util.DataUtil;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.util.MultiLanguageUtil;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.util.Util;
import com.kingdee.bos.ctrl.reportone.r1.print.designer.data.R1PrintBindDataSource;
import com.kingdee.bos.ctrl.reportone.r1.print.designer.element.loop.CustomMouseState;
import com.kingdee.bos.ctrl.reportone.r1.print.designer.element.loop.CustomSelectionRenderer;
import com.kingdee.bos.ctrl.reportone.r1.print.designer.element.loop.LoopContainer;
import com.kingdee.bos.ctrl.reportone.r1.print.designer.element.loop.TransposeDataModel;
import com.kingdee.bos.ctrl.reportone.r1.print.designer.gui.icon.R1PrintIcons;
import com.kingdee.bos.ctrl.reportone.r1.print.designer.renderer.LoopAreaRenderer;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.R1PrintConstant;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.tree.MutableTreeNode;

public class LoopArea
extends AbstractReportObject
implements ICompositeContainer,
IMouseOperate,
IBind {
    private LoopContainer _loopContainer = new LoopContainer();
    private BindDataSource _bindDs = new R1PrintBindDataSource();
    private boolean _isRepeatHorizontal = true;
    private boolean _isAdjustHeight;
    private boolean _isUseOutWidth;
    private boolean _blankRowStrategy;
    private TransposeDataModel _transposeModel;
    private IReportObjectRenderer _render;
    private CustomMouseState _mouseState;
    private LineAdjustRenderer _lineAdjustRenderer;
    private ICompositeSelectionRenderer _innerSelectionRenderer;
    private Line _lastDragLine;

    private LineAdjustRenderer getLineAdjustRenderer() {
        if (this._lineAdjustRenderer == null) {
            this._lineAdjustRenderer = new LineAdjustRenderer();
        }
        return this._lineAdjustRenderer;
    }

    @Override
    public void setWidthLom(int width) {
        super.setWidthLom(width);
        if (this._loopContainer.getWidthLom() < 0) {
            this._loopContainer.setWidthLom(width / 3);
        } else if (width < this._loopContainer.getWidthLom()) {
            this._loopContainer.setWidthLom(width);
        }
    }

    @Override
    public void setHeightLom(int height) {
        super.setHeightLom(height);
        if (this._loopContainer.getHeightLom() < 0) {
            if (height == 0 || this.getWidthLom() / height > 3) {
                this._loopContainer.setHeightLom(height);
            } else {
                this._loopContainer.setHeightLom(height / 3);
            }
        } else if (height < this._loopContainer.getHeightLom()) {
            this._loopContainer.setHeightLom(height);
        }
    }

    @Override
    public String getType() {
        return R1PrintConstant.Node_LoopArea;
    }

    @Override
    public String getIdPrefix() {
        return "dynamicList";
    }

    @Override
    public String getTypePrompt() {
        return MultiLanguageUtil.getMLS("loop.LoopArea.typePrompt", "\u52a8\u6001\u5217\u8868");
    }

    @Override
    public String[] getPropertyPanelKeys(ICompositeObject co) {
        return new String[]{"loopArea", "border", "objectCommon"};
    }

    @Override
    public IPropertyPanel getExtendPropertyPanel(String key) {
        return null;
    }

    @Override
    public void initTreeNode(DefaultKingdeeTreeNode node) {
        node.setCustomIcon((Icon)R1PrintIcons.SEC_LOOPAREA);
    }

    @Override
    protected IReportObjectRenderer createRenderer() {
        if (this._render == null) {
            this._render = new LoopAreaRenderer();
        }
        return this._render;
    }

    public LoopContainer getLoopContainer() {
        return this._loopContainer;
    }

    @Override
    public IContainer[] getSubContainers() {
        return new IContainer[]{this._loopContainer};
    }

    @Override
    public void addChild(IContainer subElement, IReportObject child) {
        if (subElement != this._loopContainer) {
            throw new IllegalArgumentException("SubElement must be loop-Container it owned.");
        }
        this._loopContainer.addChild(child, null);
        ElementPath elementPath = this.makeElementPath(this._loopContainer);
        child.setParent(elementPath);
    }

    @Override
    public void removeChild(IContainer subElement, IReportObject child) {
        if (subElement != this._loopContainer) {
            throw new IllegalArgumentException("SubElement must be loop-Container it owned.");
        }
        this._loopContainer.removeChild(child);
        child.setParent(null);
    }

    @Override
    public int getSubContainerInsetsHeightLom(IContainer subElement) {
        return subElement.getInsetsHeightLom();
    }

    @Override
    public int getSubContainerInsetsWidthLom(IContainer subElement) {
        return subElement.getInsetsWidthLom();
    }

    @Override
    public void layoutAllSubContainer() {
        if (this._loopContainer.getChildrenCount() > 0) {
            for (IReportObject ro : this._loopContainer.getChildren()) {
                if (ro.isHorizontalFill()) {
                    ro.setXLom(0);
                    ro.setWidthLom(this.getSubContainerInsetsWidthLom(this._loopContainer));
                }
                if (ro.isVerticalFill()) {
                    ro.setYLom(0);
                    ro.setHeightLom(this.getSubContainerInsetsHeightLom(this._loopContainer));
                }
                if (ro instanceof IContainer) {
                    ((IContainer)((Object)ro)).layout();
                    continue;
                }
                if (!(ro instanceof ICompositeContainer)) continue;
                ((ICompositeContainer)((Object)ro)).layoutAllSubContainer();
            }
        }
    }

    @Override
    public void applySubElementStyle(IElement ele, StyleAttributes sa) {
        StyleAttributes saOld = ele.getNotNullSA();
        saOld.replaceDirty((ShareStyleAttributes)sa);
        ele.setStyleAttribute(saOld);
    }

    @Override
    public IElement[] getAllSubElements() {
        return new IElement[]{this._loopContainer};
    }

    @Override
    public IElement[] getSubSubElements(IElement ele) {
        return null;
    }

    @Override
    public IElement[] getViewSubElements() {
        return this.getAllSubElements();
    }

    @Override
    public ICompositeSelectionRenderer getInnerSelectionRenderer() {
        if (this._innerSelectionRenderer == null) {
            this._innerSelectionRenderer = new CustomSelectionRenderer();
            this._innerSelectionRenderer.setCompositeObject(this);
        }
        return this._innerSelectionRenderer;
    }

    @Override
    public Point getRelativePosition(IElement ele) {
        return new Point(0, 0);
    }

    @Override
    public Rectangle getSubElementRectangle(IElement ele) {
        return new Rectangle(0, 0, Util.lom2Pixel(this._loopContainer.getWidthLom()), Util.lom2Pixel(this._loopContainer.getHeightLom()));
    }

    @Override
    public boolean isPointInSubElement(IElement ele, Point ptAtPage) {
        Point ptAtObj = new Point(ptAtPage);
        Point ptThisAtPage = ContainerUtil.getPointAtPage(this);
        ptAtObj.translate(-ptThisAtPage.x, -ptThisAtPage.y);
        Rectangle rect = this.getSubElementRectangle(ele);
        int right = rect.x + rect.width;
        int bottom = rect.y + rect.height;
        return ptAtObj.x > rect.x && ptAtObj.x < right && ptAtObj.y > rect.y && ptAtObj.y < bottom;
    }

    @Override
    public boolean isSubElementCanRemove(IElement ele) {
        return false;
    }

    @Override
    public boolean removeSubElement(IElement ele) {
        return false;
    }

    @Override
    public ElementPath makeElementPath(IElement ele) {
        if (ele == this._loopContainer) {
            return new ElementPath(new Object[]{this, ele});
        }
        return null;
    }

    @Override
    public StyleAttributes mixSubElementStyle(IElement ele) {
        return ele.getNotNullSA();
    }

    @Override
    public void updateStructureTree(StructureTree.Updater treeUpdater, DefaultKingdeeTreeNode nodeSelf) {
        StructureTree.Node nodeChild = treeUpdater.createNode(this._loopContainer, this._loopContainer.getTypePrompt());
        treeUpdater.getTree().addNodeInto((MutableTreeNode)((Object)nodeChild), (MutableTreeNode)nodeSelf);
        if (this._loopContainer.getChildrenCount() > 0) {
            treeUpdater.updateContainer(nodeChild, this._loopContainer);
        }
    }

    @Override
    public IMouseOperateState getMouseOperateState() {
        if (this._mouseState == null) {
            this._mouseState = new CustomMouseState();
        }
        return this._mouseState;
    }

    @Override
    public ElementPath[] getSelection(ReportSelectionModel selectionModel, ElementPath epSelecting) {
        ElementPath current = selectionModel.getCurrent();
        if (current == null) {
            return new ElementPath[]{epSelecting};
        }
        return null;
    }

    @Override
    public ElementPath getSelection(Point ptAtPage) {
        return null;
    }

    @Override
    public boolean mouseMoved(MouseEvent evt, Point ptAtPage) {
        Point gridAtPage = ContainerUtil.getPointAtPage(this);
        Point ptAtObj = new Point(ptAtPage);
        ptAtObj.translate(-gridAtPage.x, -gridAtPage.y);
        CustomMouseState state = (CustomMouseState)this.getMouseOperateState();
        int w = Util.lom2Pixel(this._loopContainer.getWidthLom());
        int h = Util.lom2Pixel(this._loopContainer.getHeightLom());
        if ((ptAtObj.y < 20 || ptAtObj.y < h) && this.isNearEnough(ptAtObj.x, w)) {
            state.setOperate(16);
            return true;
        }
        if ((ptAtObj.x < 20 || ptAtObj.x < w) && this.isNearEnough(ptAtObj.y, h)) {
            state.setOperate(32);
            return true;
        }
        this.getMouseOperateState().setOperate(0);
        return false;
    }

    private boolean isNearEnough(int value, int target) {
        return Util.isNearEnough(value, target, 3);
    }

    @Override
    public void mouseDragged(Graphics g, MouseEvent evt, Point dragStartPoint, IR1Ruler hRuler, IR1Ruler vRuler) {
        CustomMouseState state = (CustomMouseState)this.getMouseOperateState();
        if (state.isHorizontalAdjust() || state.isVerticalAdjust()) {
            this.adjustLine(g, dragStartPoint, evt.getPoint(), false, hRuler, vRuler);
        }
    }

    private void adjustLine(Graphics g, Point dragStartPoint, Point dragCurrentPoint, boolean isEnd, IR1Ruler hRuler, IR1Ruler vRuler) {
        Point gridAtPage = ContainerUtil.getPointAtPage(this);
        g.translate(gridAtPage.x, gridAtPage.y);
        CustomMouseState state = (CustomMouseState)this.getMouseOperateState();
        Point delta = this.getDelta(dragStartPoint, dragCurrentPoint);
        Line line = null;
        if (!isEnd) {
            line = this.getAdjustingLine(delta);
        }
        this.getLineAdjustRenderer().draw(this, g, this._lastDragLine, line);
        this._lastDragLine = line;
        if (isEnd) {
            if (state.isHorizontalAdjust() && delta.x != 0) {
                this._loopContainer.setWidthLom(this._loopContainer.getWidthLom() + Util.pixel2Lom(delta.x));
            } else if (state.isVerticalAdjust() && delta.y != 0) {
                this._loopContainer.setHeightLom(this._loopContainer.getHeightLom() + Util.pixel2Lom(delta.y));
            }
        }
        if (line != null) {
            if (hRuler != null) {
                RulerMark hRulerMark = new RulerMark(line.getX1() + gridAtPage.x, line.getX2() + gridAtPage.x);
                hRuler.setMarkPosition(hRulerMark);
            }
            if (vRuler != null) {
                RulerMark vRulerMark = new RulerMark(line.getY1() + gridAtPage.y, line.getY2() + gridAtPage.y);
                vRuler.setMarkPosition(vRulerMark);
            }
        }
    }

    private Point getDelta(Point dragStartPoint, Point dragCurrentPoint) {
        Point delta = dragCurrentPoint;
        delta.translate(-dragStartPoint.x, -dragStartPoint.y);
        CustomMouseState state = (CustomMouseState)this.getMouseOperateState();
        if (state.isHorizontalAdjust()) {
            if (delta.x > 0) {
                int maxToAdjust = this.getWidthLom() - this._loopContainer.getWidthLom();
                if (Util.pixel2Lom(delta.x) > maxToAdjust) {
                    delta.x = Util.lom2Pixel(maxToAdjust);
                }
            } else {
                int maxChildrenRight = 0;
                if (this._loopContainer.getChildrenCount() > 0) {
                    for (IReportObject ro : this._loopContainer.getChildren()) {
                        int right;
                        if (ro.isHorizontalFill() || maxChildrenRight >= (right = ro.getXLom() + ro.getWidthLom())) continue;
                        maxChildrenRight = right;
                    }
                }
                int maxCanAdjust = this._loopContainer.getWidthLom() - maxChildrenRight;
                if (-delta.x > (maxCanAdjust = Util.lom2Pixel(maxCanAdjust))) {
                    delta.x = -maxCanAdjust;
                }
            }
        } else if (state.isVerticalAdjust()) {
            if (delta.y > 0) {
                int maxToAdjust = this.getHeightLom() - this._loopContainer.getHeightLom();
                if (Util.pixel2Lom(delta.y) > maxToAdjust) {
                    delta.y = Util.lom2Pixel(maxToAdjust);
                }
            } else {
                int maxChildrenBottom = 0;
                if (this._loopContainer.getChildrenCount() > 0) {
                    for (IReportObject ro : this._loopContainer.getChildren()) {
                        int bottom;
                        if (ro.isVerticalFill() || maxChildrenBottom >= (bottom = ro.getYLom() + ro.getHeightLom())) continue;
                        maxChildrenBottom = bottom;
                    }
                }
                int maxCanAdjust = this._loopContainer.getHeightLom() - maxChildrenBottom;
                if (-delta.y > (maxCanAdjust = Util.lom2Pixel(maxCanAdjust))) {
                    delta.y = -maxCanAdjust;
                }
            }
        }
        return delta;
    }

    private Line getAdjustingLine(Point delta) {
        CustomMouseState state = (CustomMouseState)this.getMouseOperateState();
        if (state.isHorizontalAdjust()) {
            int x = Util.lom2Pixel(this._loopContainer.getWidthLom()) + delta.x;
            return new Line(x, 0, x, Util.lom2Pixel(this.getHeightLom()));
        }
        if (state.isVerticalAdjust()) {
            int y = Util.lom2Pixel(this._loopContainer.getHeightLom()) + delta.y;
            return new Line(0, y, Util.lom2Pixel(this.getWidthLom()), y);
        }
        return null;
    }

    @Override
    public void mouseReleased(Graphics g, MouseEvent evt, Point dragStartPoint, UndoHelper undoHelper) {
        CustomMouseState state = (CustomMouseState)this.getMouseOperateState();
        boolean isAdjust = false;
        if (state.isHorizontalAdjust()) {
            undoHelper.store("\u8c03\u6574\u52a8\u6001\u5355\u5143\u5bbd\u5ea6");
            isAdjust = true;
        } else if (state.isVerticalAdjust()) {
            undoHelper.store("\u8c03\u6574\u52a8\u6001\u5355\u5143\u9ad8\u5ea6");
            isAdjust = true;
        }
        if (isAdjust) {
            this.adjustLine(g, dragStartPoint, evt.getPoint(), true, null, null);
            this.afterAdjusted();
        }
    }

    @Override
    public void afterAdjusted() {
        this.layoutAllSubContainer();
    }

    @Override
    public boolean isDraggedCanBind(MetaClass mc, MetaField mf, IElement subElement) {
        return false;
    }

    @Override
    public void bindDraggedData(String dsName, MetaField mf, IElement subElement, JComponent ctrl, String promptTitle, MouseEvent mouseEvent) {
    }

    @Override
    public IBind.IBindDataSource getDataSource() {
        return this._bindDs;
    }

    @Override
    public IBind.IBindField getBindField() {
        return null;
    }

    @Override
    public IBind.IBindField getShowField() {
        return null;
    }

    @Override
    public void updateFieldInfo(IR1DataManager dm) {
        Object dataObj = dm.getObject(this.getDataSource().getDs());
        if (dataObj instanceof MetaClass) {
            CellField cf;
            Field field;
            MetaClass mc = (MetaClass)dataObj;
            ICellValue cv = this._loopContainer.getValue();
            if (cv != null && cv.getCellType() == 2 && (field = DataUtil.updateFieldInfo(cf = (CellField)cv, mc)) != null) {
                this._loopContainer.setValue(CellField.create(field));
            }
        }
    }

    public void setRepeatHorizontal(boolean isHR) {
        this._isRepeatHorizontal = isHR;
    }

    public boolean isRepeatHorizontal() {
        return this._isRepeatHorizontal;
    }

    public void setAdjustHeight(boolean isAdjustHeight) {
        this._isAdjustHeight = isAdjustHeight;
    }

    public boolean isAdjustHeight() {
        return this._isAdjustHeight;
    }

    public void setUseOutWidth(boolean isUseOutWidth) {
        this._isUseOutWidth = isUseOutWidth;
    }

    public boolean isUseOutWidth() {
        return this._isUseOutWidth;
    }

    public void setBlankRowStrategy(boolean blankRowStrategy) {
        this._blankRowStrategy = blankRowStrategy;
    }

    public boolean isBlankRowStrategy() {
        return this._blankRowStrategy;
    }

    public TransposeDataModel getTransposeModel() {
        if (this._transposeModel == null) {
            this._transposeModel = new TransposeDataModel();
        }
        return this._transposeModel;
    }

    public void setTransposeModel(TransposeDataModel model) {
        this._transposeModel = model;
    }
}

