/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.r1.print.designer.gui.formulatree;

import com.kingdee.bos.ctrl.common.ui.WindowUtil;
import com.kingdee.bos.ctrl.common.util.LogUtil;
import com.kingdee.bos.ctrl.common.util.StreamUtil;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.common.util.xml.XmlUtil;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.ElementPath;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.IElement;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.gui.core.ComboPanel;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.gui.core.PageContainer;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.gui.icon.R1DesignerIcons;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.gui.mouseoperate.CursorManager;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.util.MultiLanguageUtil;
import com.kingdee.bos.ctrl.reportone.r1.print.designer.gui.formulatree.FormulaInfo;
import com.kingdee.bos.ctrl.reportone.r1.print.designer.gui.formulatree.IDragFormula;
import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.ctrl.swing.KDTreeView;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.ctrl.swing.tree.ITreeNode;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.InputStream;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;
import org.jdom2.Element;

public class FormulaTree {
    private Logger log = LogUtil.getLogger(FormulaTree.class);
    private ComboPanel _core;
    private KDTree _treeCtrl;
    private KDTreeView _treeView;

    public FormulaTree(ComboPanel core) {
        this._core = core;
        this.init();
    }

    private void init() {
        this._treeCtrl = new KDTree((ITreeNode)new DefaultKingdeeTreeNode(), false);
        this._treeCtrl.setRootVisible(false);
        this._treeCtrl.setShowsRootHandles(true);
        this._treeCtrl.setShowPopMenuDefaultItem(false);
        this._treeView = new KDTreeView(this._treeCtrl);
        this._treeView.setShowButton(false);
        MouseHandler mouseHandler = new MouseHandler(this._core);
        this._treeCtrl.addMouseListener((MouseListener)mouseHandler);
        this._treeCtrl.addMouseMotionListener((MouseMotionListener)mouseHandler);
        Element xml = null;
        try {
            InputStream in = StreamUtil.loadResource(FormulaTree.class, (String)"formulas.xml");
            xml = XmlUtil.loadXmlStream((InputStream)in);
        }
        catch (Exception e) {
            this.log.error((Object)"\u52a0\u8f7d\u5e38\u7528\u516c\u5f0f\u914d\u7f6e\u6587\u4ef6\u5f02\u5e38", (Throwable)e);
        }
        this.initFormula(xml);
    }

    private void initFormula(Element xml) {
        DefaultKingdeeTreeNode nodeFormulas = new DefaultKingdeeTreeNode((Object)MultiLanguageUtil.getMLS("formulatree.FormulaTree.usualFormula", ""));
        DefaultKingdeeTreeNode nodeCases = new DefaultKingdeeTreeNode((Object)MultiLanguageUtil.getMLS("formulatree.FormulaTree.usualEg", ""));
        if (xml != null) {
            Element xmlFormulas = xml.getChild("Formulas");
            for (Element xmlFormula : xmlFormulas.getChildren()) {
                String name = xmlFormula.getAttributeValue("name");
                String desc = xmlFormula.getAttributeValue("desc");
                String formula = xmlFormula.getTextTrim();
                FormulaInfo info = new FormulaInfo();
                info.setFormula(formula);
                info.setName(name);
                info.setDescription(desc);
                FormulaTreeNode formulaNode = new FormulaTreeNode(info);
                this.initText_FormulaNode(formulaNode, info);
                nodeFormulas.add((MutableTreeNode)((Object)formulaNode));
            }
            Element xmlCases = xml.getChild("Cases");
            for (Element xmlCase : xmlCases.getChildren()) {
                String name = xmlCase.getAttributeValue("name");
                String desc = xmlCase.getAttributeValue("desc");
                String formula = xmlCase.getTextTrim();
                FormulaInfo info = new FormulaInfo();
                info.setFormula(formula);
                info.setName(name);
                info.setDescription(desc);
                FormulaTreeNode formulaNode = new FormulaTreeNode(info);
                this.initText_CaseNode(formulaNode, info);
                nodeCases.add((MutableTreeNode)((Object)formulaNode));
            }
        }
        DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)this._treeCtrl.getModel().getRoot();
        this._treeCtrl.addNodeInto((MutableTreeNode)nodeFormulas, (MutableTreeNode)root);
        this._treeCtrl.addNodeInto((MutableTreeNode)nodeCases, (MutableTreeNode)root);
        this._treeCtrl.expandAllNodes(true, (TreeNode)root);
    }

    private void initText_FormulaNode(DefaultKingdeeTreeNode node, FormulaInfo info) {
        StringBuffer sb = new StringBuffer();
        sb.append(info.getName());
        sb.append("\uff1a");
        sb.append(info.getFormula());
        node.setText(sb.toString());
    }

    private void initText_CaseNode(DefaultKingdeeTreeNode node, FormulaInfo info) {
        StringBuffer sb = new StringBuffer();
        sb.append(info.getName());
        node.setText(sb.toString());
    }

    public JComponent getCtrl() {
        return this._treeView;
    }

    static class MouseHandler
    extends MouseAdapter
    implements MouseMotionListener {
        private ComboPanel core;
        private FormulaInfo info;
        private IDragFormula target;
        private boolean isCanDrop = false;

        public MouseHandler(ComboPanel core) {
            this.core = core;
        }

        @Override
        public void mousePressed(MouseEvent e) {
            Object nodeObj;
            this.isCanDrop = false;
            this.info = null;
            if (!SwingUtilities.isLeftMouseButton(e)) {
                return;
            }
            KDTree tree = (KDTree)e.getSource();
            TreePath path = tree.getClosestPath(e.getX(), e.getY());
            if (path != null && path.getLastPathComponent() instanceof DefaultKingdeeTreeNode && (nodeObj = ((DefaultKingdeeTreeNode)path.getLastPathComponent()).getUserObject()) instanceof FormulaInfo) {
                this.info = (FormulaInfo)nodeObj;
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            KDTree tree = (KDTree)e.getSource();
            tree.setCursor(CursorManager.getDefault());
            PageContainer pc = this.core.getPageContainer();
            pc.setCursor(CursorManager.getDefault());
            if (this.isCanDrop) {
                if (this.target.isAskClearContent()) {
                    StringBuffer sb = new StringBuffer();
                    sb.append(MultiLanguageUtil.getMLS("formulatree.FormulaTree.info", ""));
                    this.isCanDrop = WindowUtil.msgboxYesNo((Component)this.core.getPanel(), (Object)sb.toString(), (String)this.core.getPromptTitle());
                }
                if (this.isCanDrop) {
                    this.core.storeUndoState("\u62d6\u62fd\u516c\u5f0f");
                    this.target.dropFormula(this.info);
                    this.core.getModel().setDirty(true);
                    this.core.getPanel().repaint();
                }
            }
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if (this.info != null && SwingUtilities.isLeftMouseButton(e)) {
                Point ptAtPageContainer;
                ElementPath targetEp;
                KDTree tree = (KDTree)e.getSource();
                PageContainer pc = this.core.getPageContainer();
                if (tree.getCursor() != CursorManager.getDragDrop()) {
                    tree.setCursor(CursorManager.getDragDrop());
                }
                if ((targetEp = pc.searchTopElement(ptAtPageContainer = SwingUtilities.convertPoint((Component)tree, e.getX(), e.getY(), pc))) == null) {
                    this.isCanDrop = false;
                } else {
                    IElement ele = (IElement)targetEp.getLastPathComponent();
                    if (ele instanceof IDragFormula) {
                        this.target = (IDragFormula)((Object)ele);
                        this.isCanDrop = this.target.isFormulaCanDrop();
                    } else {
                        this.isCanDrop = false;
                    }
                }
                if (this.isCanDrop) {
                    pc.setCursor(R1DesignerIcons.CURSOR_MOVEDDROP);
                } else {
                    pc.setCursor(R1DesignerIcons.CURSOR_FORBID);
                }
            }
        }

        @Override
        public void mouseMoved(MouseEvent e) {
        }
    }

    static class FormulaTreeNode
    extends DefaultKingdeeTreeNode {
        public FormulaTreeNode(FormulaInfo info) {
            super((Object)info);
        }

        public String toString() {
            String desc;
            Object obj = this.getUserObject();
            if (obj instanceof FormulaInfo && !StringUtil.isEmptyString((String)(desc = ((FormulaInfo)obj).getDescription()))) {
                return desc;
            }
            return super.toString();
        }
    }
}

