/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.r1.print.designer.gui.property.compute;

import com.kingdee.bos.ctrl.common.layout.table.TableLayout;
import com.kingdee.bos.ctrl.common.ui.SimpleDialog;
import com.kingdee.bos.ctrl.common.ui.WindowUtil;
import com.kingdee.bos.ctrl.data.meta.MetaClass;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.grid.group.R1DataGridGroup;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.gui.common.RadioButtonGroup;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.util.MultiLanguageUtil;
import com.kingdee.bos.ctrl.reportone.r1.print.common.gridcompute.AbstractExpr;
import com.kingdee.bos.ctrl.reportone.r1.print.designer.gui.property.compute.SingleEditor_Constant;
import com.kingdee.bos.ctrl.reportone.r1.print.designer.gui.property.compute.SingleEditor_Field;
import com.kingdee.bos.ctrl.reportone.r1.print.designer.gui.property.compute.SingleEditor_MultiField;
import com.kingdee.bos.ctrl.reportone.r1.print.designer.gui.property.compute.SingleEditor_Stat;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDRadioButton;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import javax.swing.JComponent;

class SingleExprEditorOwner
extends KDPanel
implements SimpleDialog.PanelOfSimpleDialog {
    private boolean _isCompositeSupport = true;
    private KDPanel _panSingleExprOwner;
    private RadioButtonGroup _exprTypes;

    public SingleExprEditorOwner(boolean isCompositeSupport) {
        this._isCompositeSupport = isCompositeSupport;
        this.init();
    }

    private void init() {
        SingleEditor_Constant eeConstant = new SingleEditor_Constant();
        SingleEditor_Field eeField = new SingleEditor_Field();
        TypeChangeHandler handler = new TypeChangeHandler();
        this._exprTypes = new RadioButtonGroup();
        this.initRadioButton(MultiLanguageUtil.getMLS("compute.SingleExprEditorOwner.numberConstant", ""), eeConstant, handler);
        this.initRadioButton(MultiLanguageUtil.getMLS("compute.SingleExprEditorOwner.oneField", ""), eeField, handler);
        if (this._isCompositeSupport) {
            SingleEditor_MultiField eeMultiField = new SingleEditor_MultiField();
            SingleEditor_Stat eeStat = new SingleEditor_Stat();
            this.initRadioButton(MultiLanguageUtil.getMLS("compute.SingleExprEditorOwner.multiField", ""), eeMultiField, handler);
            this.initRadioButton(MultiLanguageUtil.getMLS("compute.SingleExprEditorOwner.stat", ""), eeStat, handler);
        }
        this._panSingleExprOwner = new KDPanel((LayoutManager)new BorderLayout());
        this._panSingleExprOwner.setCustomInsets(new Insets(10, 0, 0, 0));
        TableLayout tl = TableLayout.split((int)2, (int)1);
        tl.rowStyle(0).setHeight(50);
        tl.rowStyle(1).setPriY(1);
        this.setLayout((LayoutManager)tl);
        this.add((Component)this._exprTypes.createTitlePane(MultiLanguageUtil.getMLS("compute.SingleExprEditorOwner.exprType", ""), 1, 4), tl.cell(0));
        this.add((Component)this._panSingleExprOwner, tl.cell(1));
        this._exprTypes.setSelectedValue(eeField);
        this.changeSingleExprUI(eeField);
    }

    private void initRadioButton(String text, Object value, TypeChangeHandler handler) {
        KDRadioButton rad = new KDRadioButton(text);
        rad.setUserObject(value);
        this._exprTypes.add(rad);
        rad.addActionListener((ActionListener)handler);
    }

    boolean isCompositeSupport() {
        return this._isCompositeSupport;
    }

    void setDialogWidth(int w) {
        Enumeration e = this._exprTypes.getButtons();
        while (e.hasMoreElements()) {
            ASingleExprEditor singleEE = (ASingleExprEditor)((KDRadioButton)e.nextElement()).getUserObject();
            singleEE.setPreferredWidth(w);
        }
    }

    public JComponent getCtrl() {
        return this;
    }

    private void changeSingleExprUI(ASingleExprEditor singleEE) {
        this._panSingleExprOwner.removeAll();
        this._panSingleExprOwner.add((Component)singleEE.getCtrl(), (Object)"Center");
        this._panSingleExprOwner.validate();
        this._panSingleExprOwner.repaint();
    }

    public void setExpr(AbstractExpr expr) {
        Enumeration e = this._exprTypes.getButtons();
        while (e.hasMoreElements()) {
            ASingleExprEditor singleEE = (ASingleExprEditor)((KDRadioButton)e.nextElement()).getUserObject();
            if (!singleEE.isExprMatch(expr)) continue;
            singleEE.setExpr(expr);
            this._exprTypes.setSelectedValue(singleEE);
            this.changeSingleExprUI(singleEE);
            break;
        }
    }

    public AbstractExpr getExpr() {
        ASingleExprEditor singleEE = (ASingleExprEditor)this._exprTypes.getSelectedValue();
        return singleEE.getExpr();
    }

    public void setSupply(MetaClass mc, R1DataGridGroup[] groups, int currentLevel) {
        Enumeration e = this._exprTypes.getButtons();
        while (e.hasMoreElements()) {
            ASingleExprEditor singleEE = (ASingleExprEditor)((KDRadioButton)e.nextElement()).getUserObject();
            singleEE.setSupply(mc, groups, currentLevel);
            singleEE.clearCtrlValue();
        }
    }

    public boolean verify() {
        StringBuffer prompt;
        ASingleExprEditor singleEE = (ASingleExprEditor)this._exprTypes.getSelectedValue();
        boolean result = singleEE.verify(prompt = new StringBuffer());
        if (!result) {
            if (prompt.length() > 0) {
                WindowUtil.msgboxError((Object)prompt.toString(), (String)MultiLanguageUtil.getMLS("compute.SingleExprEditorOwner.gridCompute", ""), (Component)this.getCtrl());
            } else {
                WindowUtil.msgboxError((Object)MultiLanguageUtil.getMLS("compute.SingleExprEditorOwner.errInfo_HalfBaked", ""), (String)MultiLanguageUtil.getMLS("compute.SingleExprEditorOwner.gridCompute", ""), (Component)this.getCtrl());
            }
        }
        return result;
    }

    static abstract class ASingleExprEditor {
        protected MetaClass _metaClass;
        protected R1DataGridGroup[] _groups;
        protected int _currentLevel;

        ASingleExprEditor() {
        }

        abstract JComponent getCtrl();

        abstract boolean isExprMatch(AbstractExpr var1);

        abstract void setExpr(AbstractExpr var1);

        abstract AbstractExpr getExpr();

        abstract void clearCtrlValue();

        void setSupply(MetaClass mc, R1DataGridGroup[] groups, int currentLevel) {
            this._metaClass = mc;
            this._groups = groups;
            this._currentLevel = currentLevel;
            this.prepareCtrlSupply();
        }

        abstract void prepareCtrlSupply();

        void setPreferredWidth(int width) {
        }

        abstract boolean verify(StringBuffer var1);
    }

    private class TypeChangeHandler
    implements ActionListener {
        private TypeChangeHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            KDRadioButton btn = (KDRadioButton)e.getSource();
            ASingleExprEditor singleEE = (ASingleExprEditor)btn.getUserObject();
            SingleExprEditorOwner.this.changeSingleExprUI(singleEE);
        }
    }
}

