/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.r1.print.designer.gui.property.grid.cell;

import com.kingdee.bos.ctrl.common.layout.table.TableLayout;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.ElementPath;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.grid.cellvalue.Text;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.util.MultiLanguageUtil;
import com.kingdee.bos.ctrl.reportone.r1.print.designer.element.grid.ICellValueSupported;
import com.kingdee.bos.ctrl.reportone.r1.print.designer.gui.property.grid.cell.ACellPane;
import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.ctrl.swing.KDScrollPane;
import com.kingdee.bos.ctrl.swing.KDTextArea;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;

class TextPane
extends ACellPane {
    private KDTextArea _txaText;
    private boolean _isTxtEdited;

    public TextPane() {
        this.init();
        this.installListener();
    }

    private void init() {
        this._txaText = new KDTextArea();
        KDLabel labTitle = new KDLabel(MultiLanguageUtil.getMLS("cell.TextPane.text", ""));
        TableLayout tl = TableLayout.splitRow((int)2);
        tl.rowStyle(0).setHeight(20);
        tl.rowStyle(1).setPriY(1);
        this.setLayout((LayoutManager)tl);
        this.add((Component)labTitle, tl.cell(0));
        this.add((Component)new KDScrollPane((Component)this._txaText), tl.cell(1));
    }

    private void installListener() {
        this._txaText.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                TextPane.this._isTxtEdited = true;
            }
        });
    }

    @Override
    public void prepareCtrlValue(ElementPath[] eps) {
        this._isTxtEdited = false;
        ICellValueSupported cell = (ICellValueSupported)eps[0].getLastPathComponent();
        String text = ((Text)cell.getValue()).getText();
        boolean isTextUnsure = false;
        for (int i = 1; i < eps.length; ++i) {
            cell = (ICellValueSupported)eps[i].getLastPathComponent();
            if (isTextUnsure || StringUtil.equals((String)text, (String)((Text)cell.getValue()).getText())) continue;
            isTextUnsure = true;
        }
        if (isTextUnsure) {
            this._txaText.setText(null);
        } else {
            this._txaText.setText(text);
        }
    }

    @Override
    protected void updateElementValue(ElementPath elePath) {
        if (this._isTxtEdited) {
            ICellValueSupported cell = (ICellValueSupported)elePath.getLastPathComponent();
            cell.setValue(new Text(this._txaText.getText()));
        }
    }

    @Override
    public void enter() {
        this._isTxtEdited = true;
    }

    @Override
    public void initCtrlValue() {
        super.initCtrlValue();
        this._txaText.setText(null);
    }
}

