/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.affair.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTPropertyChangeEvent;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.bizunit.BizUnitInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.ep.client.util.CoreUICustom;
import com.kingdee.eas.ep.client.util.UictUtils;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.multiDetail.DetailPanel;
import com.kingdee.eas.framework.client.multiDetail.DetailPanelEvent;
import com.kingdee.eas.framework.client.multiDetail.IDetailPanelListener;
import com.kingdee.eas.hr.affair.EmpEnrollTemplateBillCollection;
import com.kingdee.eas.hr.affair.EmpEnrollTemplateBillEntryCollection;
import com.kingdee.eas.hr.affair.EmpEnrollTemplateBillEntryInfo;
import com.kingdee.eas.hr.affair.EmpEnrollTemplateBillInfo;
import com.kingdee.eas.hr.affair.HRAffairBizBillEntryInfo;
import com.kingdee.eas.hr.affair.IEmpEnrollTemplateBill;
import com.kingdee.eas.hr.affair.client.AbstractEmpEnrollTemplateBillEditUI;
import com.kingdee.eas.hr.affair.client.EmpEnrollTempEditUICustom;
import com.kingdee.eas.hr.affair.client.EmpEnrollTemplateBillEditUIBiz;
import com.kingdee.eas.hr.affair.util.AffairForCmpUtil;
import com.kingdee.eas.hr.base.CodingRuleManageFacadeFactory;
import com.kingdee.eas.hr.base.HRBillStateEnum;
import com.kingdee.eas.hr.base.ICodingRuleManageFacade;
import com.kingdee.eas.hr.base.PersonCheckException;
import com.kingdee.eas.hr.base.client.CodingRuleManager;
import com.kingdee.eas.hr.base.client.IHRBillEditUIBiz;
import com.kingdee.eas.hr.base.util.IDCardCommonUtil;
import com.kingdee.eas.hr.compensation.SalariatHiberPropsInfo;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.StringUtils;
import java.awt.event.ActionEvent;
import java.util.Date;
import org.apache.log4j.Logger;

public class EmpEnrollTemplateBillEditUI
extends AbstractEmpEnrollTemplateBillEditUI {
    private static final Logger logger = CoreUIObject.getLogger(EmpEnrollTemplateBillEditUI.class);
    private EmpEnrollTempEditUICustom custom = null;
    private final String IDCARDNUMBER = "IDCardNo";
    private final String PASSPORTNUMBER = "passportNo";
    private IDetailPanelListener addListener = null;

    @Override
    public void loadFields() {
        ((EmpEnrollTemplateBillEditUIBiz)this.biz).beforeLoadData();
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    public void onLoad() throws Exception {
        super.onLoad();
        this.kdtEntrys_detailPanel.addAddListener(this.custom.getDetailPanelListener());
        IDetailPanelListener addListener = this.getAddLineListener();
        this.kdtEntrys_detailPanel.addAddListener(addListener);
        this.kdtEntrys_detailPanel.addInsertListener(addListener);
    }

    @Override
    public void initLayout() {
        try {
            this.loadCustomConfig();
        }
        catch (Exception e) {
            this.handUIExceptionAndAbort(e);
        }
        super.initLayout();
        this.kdtEntrys.getColumn("isParPerson").getStyleAttributes().setHided(true);
    }

    private void loadCustomConfig() throws Exception {
        this.custom = new EmpEnrollTempEditUICustom(this.getUIContext());
        this.custom.setEntryProperyName(this.getEntryProperyName());
        this.custom.init();
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return this.custom.getBizInterface(this.getMainOrgContext());
    }

    protected IObjectValue createNewDetailData(KDTable table) {
        return null;
    }

    @Override
    protected IObjectValue createNewData() {
        EmpEnrollTemplateBillInfo objectValue = new EmpEnrollTemplateBillInfo();
        objectValue.setCreator((UserInfo)SysContext.getSysContext().getCurrentUser());
        UserInfo info = SysContext.getSysContext().getCurrentUserInfo();
        objectValue.setBillState(HRBillStateEnum.SAVED);
        objectValue.setApplier(info.getPerson());
        this.custom.initNewData(objectValue);
        return objectValue;
    }

    @Override
    public HRAffairBizBillEntryInfo getNewBillEntryInfo() {
        EmpEnrollTemplateBillEntryInfo entryInfo = new EmpEnrollTemplateBillEntryInfo();
        this.custom.initNewDetailData(entryInfo);
        return entryInfo;
    }

    @Override
    protected String getEditUIName() {
        if (this.custom == null) {
            return super.getEditUIName();
        }
        return this.custom.getMetaDataPK().getFullName();
    }

    @Override
    public IMetaDataPK getMetaDataPK() {
        if (this.custom == null) {
            return null;
        }
        return this.custom.getMetaDataPK();
    }

    @Override
    protected IMetaDataPK getTDQueryPK() {
        CoreUICustom.CustomEntity entity = this.custom.getEntity();
        BizUnitInfo bizUnitInfo = UictUtils.loadBizUnit((IMetaDataPK)new MetaDataPK(entity.getEntity().getBizUnitPK()));
        return new MetaDataPK((String)bizUnitInfo.get("queryPK"));
    }

    @Override
    protected IHRBillEditUIBiz getBillBiz() {
        return new EmpEnrollTemplateBillEditUIBiz();
    }

    public IDetailPanelListener getAddLineListener() {
        if (this.addListener == null) {
            this.addListener = new IDetailPanelListener(){

                public void beforeEvent(DetailPanelEvent event) throws Exception {
                    EmpEnrollTemplateBillEntryInfo entryInfo = (EmpEnrollTemplateBillEntryInfo)event.getObjectValue();
                    if (entryInfo.getId() == null) {
                        entryInfo.setId(BOSUuid.create((BOSObjectType)entryInfo.getBOSType()));
                    }
                    PersonInfo personInfo = new PersonInfo();
                    personInfo.setCU(SysContext.getSysContext().getCurrentCtrlUnit());
                    ICodingRuleManageFacade icrmFacade = CodingRuleManageFacadeFactory.getRemoteInstance();
                    CodingRuleManager personRule = new CodingRuleManager(EmpEnrollTemplateBillEditUI.this.kdtEntrys.getColumn("empNumber"), (IObjectValue)personInfo, icrmFacade);
                    entryInfo.setEmpNumber(personRule.apply());
                    EmpEnrollTemplateBillEditUI.this.setDefaultBizDefine(entryInfo);
                }

                public void afterEvent(DetailPanelEvent event) throws Exception {
                }
            };
        }
        return this.addListener;
    }

    @Override
    protected DetailPanel getIgnoredDetailPanel() {
        return null;
    }

    @Override
    protected boolean isNeedSetUserPermission() {
        return true;
    }

    protected boolean isShowMenuTable() {
        return true;
    }

    @Override
    protected boolean isShowPersonDetail() {
        return false;
    }

    protected void lockUIForViewStatus() {
        super.lockUIForViewStatus();
        this.kdtEntrys_detailPanel.getAddNewLineButton().setEnabled(false);
        this.kdtEntrys_detailPanel.getInsertLineButton().setEnabled(false);
        this.kdtEntrys_detailPanel.getRemoveLinesButton().setEnabled(false);
    }

    @Override
    protected void setAutoNumberByOrg(String orgType) {
    }

    protected String getWFUIFuctionName() {
        if (this.custom == null) {
            return super.getWFUIFuctionName();
        }
        return this.custom.getWfFunctionName();
    }

    @Override
    public String getOldPositionColumnKey() {
        return null;
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        super.doBeforeSave(e);
        IRow row = null;
        String personNum = null;
        boolean enrollAgain = false;
        String enrollAgainPersonID = null;
        int count = this.kdtEntrys.getRowCount();
        for (int i = 0; i < count; ++i) {
            row = this.kdtEntrys.getRow(i);
            personNum = (String)row.getCell("empNumber").getValue();
            enrollAgain = row.getCell("enrollAgain").getValue() != null ? (Boolean)row.getCell("enrollAgain").getValue() : false;
            enrollAgainPersonID = row.getCell("existPersonID").getValue() != null ? row.getCell("existPersonID").getValue().toString() : null;
            this.checkEmpNumber(personNum, enrollAgain, enrollAgainPersonID);
            if (row.getCell("xinDian").getStyleAttributes().isHided() || row.getCell("xinDian").getValue() == null) continue;
            SalariatHiberPropsInfo pointInfo = (SalariatHiberPropsInfo)row.getCell("xinDian").getValue();
            pointInfo.put("pointInfo", null);
        }
    }

    protected void checkEmpNumber(String number, boolean enrollAgain, String enrollAgainPersonID) throws Exception {
        EmpEnrollTemplateBillCollection c;
        StringBuffer oql = new StringBuffer("select entrys.empNumber,id where entrys.empNumber='" + number + "'");
        if (!this.getOprtState().equals(OprtState.ADDNEW)) {
            oql.append(" and id <>'").append(this.editData.getId()).append("'");
        }
        if ((c = ((IEmpEnrollTemplateBill)this.getBizInterface()).getEmpEnrollTemplateBillCollection(oql.toString())).size() > 0) {
            throw new PersonCheckException(PersonCheckException.PERSONNUMBEREXIST, new Object[]{number});
        }
        if (!enrollAgain) {
            throw new PersonCheckException(PersonCheckException.PERSONNUMBEREXIST, new Object[]{number});
        }
        boolean isCanIn = this.checkExistsPersonCanAgainIn(enrollAgainPersonID, number);
        if (!isCanIn) {
            throw new PersonCheckException(PersonCheckException.PERSONNUMBEREXIST, new Object[]{number});
        }
    }

    private boolean checkExistsPersonCanAgainIn(String personID, String empNumber) throws BOSException, EASBizException {
        if (!StringUtils.isEmpty((String)personID)) {
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add("number");
            selector.add("employeeType.inService");
            PersonInfo perInfo = PersonFactory.getRemoteInstance().getPersonInfo((IObjectPK)new ObjectUuidPK(personID), selector);
            if (!perInfo.getNumber().equals(empNumber)) {
                return false;
            }
            if (perInfo != null && perInfo.getEmployeeType() != null && perInfo.getEmployeeType().getInService().getValue() != 2) {
                return false;
            }
        }
        return true;
    }

    @Override
    public void setDataObject(IObjectValue dataObject) {
        super.setDataObject(dataObject);
        if (OprtState.VIEW.equals(this.getOprtState()) || OprtState.EDIT.equals(this.getOprtState()) || "FINDVIEW".equals(this.getOprtState()) && this.editData != null) {
            EmpEnrollTemplateBillEntryCollection entryColl = this.editData.getEntrys();
            AffairForCmpUtil.setSalaryPointForEntry((IObjectCollection)entryColl, "xinDian");
        }
    }

    @Override
    protected void propertyValueChange(KDTPropertyChangeEvent evt) throws EASBizException {
        super.propertyValueChange(evt);
        String oprtState = this.getOprtState();
        if (oprtState.equals(OprtState.VIEW)) {
            return;
        }
        int colIndex = evt.getColIndex();
        int rowIndex = evt.getRowIndex();
        String colName = this.kdtEntrys.getColumnKey(evt.getColIndex());
        this.dealWithFormalDate(rowIndex, colIndex, evt.getNewValue());
        try {
            if ("IDCardNo".equals(colName) || "passportNo".equals(colName)) {
                this.checkIDCardNoAndPassport(rowIndex, colName, evt.getOldValue(), evt.getNewValue());
            }
        }
        catch (Exception e) {
            this.kdtEntrys.getCell(rowIndex, colIndex).setValue(null);
            this.handUIException(e);
        }
    }

    @Override
    public void afterTableChange(String colName, int rowIndex) {
    }

    private void dealWithFormalDate(int rowIndex, int colIndex, Object newValue) {
        Date enrollDate;
        if (this.kdtEntrys.getColumn("probation").getStyleAttributes().isHided()) {
            return;
        }
        IRow row = this.kdtEntrys.getRow(rowIndex);
        if (colIndex == this.kdtEntrys.getColumn("enrollDate").getColumnIndex()) {
            enrollDate = (Date)newValue;
            row.getCell("bizDate").setValue((Object)enrollDate);
            Integer probation = (Integer)row.getCell("probation").getValue();
            if (enrollDate != null) {
                Date formalDate = DateTimeUtils.addMonth((Date)enrollDate, (int)probation);
                row.getCell("formalDate").setValue((Object)formalDate);
            }
        }
        if (colIndex == this.kdtEntrys.getColumn("probation").getColumnIndex()) {
            enrollDate = (Date)row.getCell("enrollDate").getValue();
            int probation = (Integer)newValue;
            if (enrollDate != null) {
                Date proDate = DateTimeUtils.addMonth((Date)enrollDate, (int)probation);
                row.getCell("formalDate").setValue((Object)proDate);
            }
        }
    }

    private void checkIDCardNoAndPassport(int rowIndex, String colName, Object oldValue, Object newValue) throws Exception {
        IRow row = this.kdtEntrys.getRow(rowIndex);
        String number = (String)newValue;
        if (number != null && !number.equals(oldValue)) {
            boolean isError;
            if ("IDCardNo".equals(colName) && oldValue != null && oldValue instanceof String) {
                String _number = null;
                _number = number.length() == 15 ? IDCardCommonUtil.IDCardNO15To18((String)number) : IDCardCommonUtil.IDCardNO18To15((String)number);
                if (_number.equals(oldValue)) {
                    return;
                }
            }
            if (isError = ((EmpEnrollTemplateBillEditUIBiz)this.biz).IDCardNoOrPassportNoEdit(row, colName, (String)newValue)) {
                int colIndex = this.kdtEntrys.getColumn(colName).getColumnIndex();
                row.getCell(colName).setValue(null);
                this.kdtEntrys.getSelectManager().select(rowIndex, colIndex);
            }
        }
    }
}

