/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.affair.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.util.IUIActionPostman;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.org.AdminOrgUnitCollection;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.HROrgUnitFactory;
import com.kingdee.eas.basedata.org.HROrgUnitInfo;
import com.kingdee.eas.basedata.org.IHROrgUnit;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.eas.framework.batchHandler.client.UIActionPostman;
import com.kingdee.eas.hr.affair.client.AbstractEmployeeFlowFilterNewUI;
import com.kingdee.eas.hr.affair.client.HRAffairClientUtils;
import com.kingdee.eas.hr.base.util.OrgStringUtil;
import com.kingdee.eas.hr.emp.EmployeeCollectException;
import com.kingdee.eas.hr.org.client.AdminByOrgRangePromptBox;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.DateTimeUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;

public class EmployeeFlowFilterNewUI
extends AbstractEmployeeFlowFilterNewUI {
    public FilterInfo getFilterInfo() {
        return super.getFilterInfo();
    }

    public Object getParam() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("beginDate", this.dateBegin.getValue());
        map.put("endDate", this.dateEnd.getValue());
        map.put("orgInfo", this.promptOrg.getData());
        map.put("sealUp", this.chkShowSealUp.isSelected());
        map.put("ShowVirtualOrg", this.chkShowVirtualOrg.isSelected());
        return map;
    }

    public void setParam(Object param) {
        if (param == null) {
            return;
        }
        HashMap map = (HashMap)param;
        this.dateBegin.setValue(map.get("beginDate"));
        this.dateEnd.setValue(map.get("endDate"));
        this.promptOrg.setData(map.get("orgInfo"));
        if (map.get("sealUp") != null) {
            this.chkShowSealUp.setSelected(((Boolean)map.get("sealUp")).booleanValue());
        }
        if (map.get("ShowVirtualOrg") != null) {
            this.chkShowVirtualOrg.setSelected(((Boolean)map.get("ShowVirtualOrg")).booleanValue());
        }
    }

    public Date getBeginDate(Date date) {
        return DateTimeUtils.truncateDate((Date)date);
    }

    public void setCustomerParams(CustomerParams param) {
        this.clear();
        super.setCustomerParams(param);
        if (param == null) {
            return;
        }
        ObjectUuidPK pk = null;
        this.rdOrg.setSelected(param.getBoolean(this.rdOrg.getName()));
        this.rdOrgMult.setSelected(param.getBoolean(this.rdOrgMult.getName()));
        String orgIds = param.getCustomerParam(this.promptOrgMult.getName());
        if (orgIds != null) {
            Object[] orgs = OrgStringUtil.string2OrgInfoArr((String)orgIds);
            this.promptOrgMult.setData((Object)orgs);
        }
        if (param.getCustomerParam("orgInfo") != null) {
            pk = new ObjectUuidPK(BOSUuid.read((String)param.getCustomerParam("orgInfo")));
            AdminOrgUnitInfo adminInfo = null;
            try {
                if (this.isPrepareSetCustomerParams()) {
                    this.prepareSetCustomerParams((IObjectPK)pk).callHandler();
                }
                adminInfo = AdminOrgUnitFactory.getRemoteInstance().getAdminOrgUnitInfo((IObjectPK)pk);
                this.promptOrg.setData((Object)adminInfo);
            }
            catch (Exception e) {
                ExceptionHandler.handle((Throwable)e);
            }
        }
        if (param.getDate("beginDate") != null) {
            this.dateBegin.setValue((Object)param.getDate("beginDate"));
        }
        if (param.getDate("endDate") != null) {
            this.dateEnd.setValue((Object)param.getDate("endDate"));
        }
        this.chkShowSealUp.setSelected(param.getBoolean("sealUp"));
        this.chkShowVirtualOrg.setSelected(param.getBoolean("ShowVirtualOrg"));
        this.setOrgCommentEnabled();
    }

    public CustomerParams getCustomerParams() {
        CustomerParams params = new CustomerParams();
        if (this.rdOrgMult.isSelected()) {
            if (this.promptOrgMult.getData() != null) {
                params.addCustomerParam(this.promptOrgMult.getName(), OrgStringUtil.orgInfoArr2String((Object[])((Object[])this.promptOrgMult.getData())));
                params.putBoolean("ShowVirtualOrg", true);
            }
        } else {
            if (this.promptOrg.getData() != null) {
                params.addCustomerParam("orgInfo", ((AdminOrgUnitInfo)this.promptOrg.getData()).getId().toString());
            }
            params.putBoolean("sealUp", this.chkShowSealUp.isSelected());
            params.putBoolean("ShowVirtualOrg", this.chkShowVirtualOrg.isSelected());
        }
        params.putBoolean(this.rdOrg.getName(), this.rdOrg.isSelected());
        params.putBoolean(this.rdOrgMult.getName(), this.rdOrgMult.isSelected());
        params.putDate("beginDate", (Date)this.dateBegin.getValue());
        params.putDate("endDate", (Date)this.dateEnd.getValue());
        return params;
    }

    public SorterItemCollection getSorterItems() {
        return super.getSorterItems();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        HRAffairClientUtils.checkHasDefaultAdminOrg();
        this.lblRange.setIcon(EASResource.getIcon((String)"imgLableword_btn"));
        this.lblPeriod.setIcon(EASResource.getIcon((String)"imgLableword_btn"));
        this.initF7();
        this.dateBegin.setTimeEnabled(false);
        this.dateEnd.setTimeEnabled(false);
    }

    private void initF7() {
        AdminByOrgRangePromptBox f7 = new AdminByOrgRangePromptBox();
        f7.showChkSealUp(true);
        this.promptOrg.setSelector((KDPromptSelector)f7);
        this.promptOrg.setEditable(false);
        AdminByOrgRangePromptBox f7Mult = new AdminByOrgRangePromptBox();
        f7Mult.showChkSealUp(true);
        f7Mult.setIsSingleSelect(false);
        this.promptOrgMult.setSelector((KDPromptSelector)f7Mult);
        this.promptOrgMult.setEditable(false);
    }

    private AdminOrgUnitCollection getHRFilterAdmins() throws BOSException, EASBizException {
        HROrgUnitInfo hrOrgUnit = SysContext.getSysContext().getCurrentHRUnit();
        if (hrOrgUnit == null) {
            return new AdminOrgUnitCollection();
        }
        IHROrgUnit ihrou = HROrgUnitFactory.getRemoteInstance();
        return ihrou.getAdminOrgUnitCollectionWithOrgRangeFilter(hrOrgUnit.getId().toString());
    }

    public String getAdminId() {
        if (this.promptOrg.getValue() == null) {
            return null;
        }
        return ((AdminOrgUnitInfo)this.promptOrg.getValue()).getId().toString();
    }

    public boolean isMultOrg() {
        return this.rdOrgMult.isSelected();
    }

    public Object[] getAdminOrgs() {
        if (this.promptOrgMult.getData() == null) {
            return null;
        }
        Object[] orgs = (Object[])this.promptOrgMult.getData();
        return orgs;
    }

    public String[] getLongNumbers() throws Exception {
        if (this.rdOrgMult.isSelected()) {
            return null;
        }
        if (this.promptOrg.getValue() == null) {
            AdminOrgUnitCollection c = this.getHRFilterAdmins();
            String[] longNumbers = new String[c.size()];
            int size = c.size();
            for (int i = 0; i < size; ++i) {
                longNumbers[i] = c.get(i).getLongNumber();
            }
            return longNumbers;
        }
        return new String[]{((AdminOrgUnitInfo)this.promptOrg.getValue()).getLongNumber()};
    }

    public void clear() {
        this.rdOrg.setSelected(true);
        this.dateBegin.setValue((Object)new Date());
        this.dateEnd.setValue((Object)new Date());
        this.promptOrg.setValue(null);
        this.promptOrgMult.setValue(null);
        this.chkShowSealUp.setSelected(false);
        this.chkShowVirtualOrg.setSelected(false);
        this.setOrgCommentEnabled();
    }

    private void setOrgCommentEnabled() {
        boolean isRdOrgSelected = this.rdOrg.isSelected();
        boolean isRdOrgMultSelected = this.rdOrgMult.isSelected();
        this.promptOrg.setEnabled(isRdOrgSelected);
        this.chkShowSealUp.setEnabled(isRdOrgSelected);
        this.chkShowVirtualOrg.setEnabled(isRdOrgSelected);
        this.promptOrgMult.setEnabled(isRdOrgMultSelected);
    }

    public boolean verify() {
        if (this.dateBegin.getValue() == null) {
            MsgBox.showInfo((Component)((Object)this), (String)new EmployeeCollectException(EmployeeCollectException.RPT_BEGNIDATE_NULL).getMessage());
            this.dateBegin.requestFocusInWindow();
            return false;
        }
        if ((Date)this.dateEnd.getValue() == null) {
            MsgBox.showInfo((Component)((Object)this), (String)new EmployeeCollectException(EmployeeCollectException.RPT_ENDDATE_NULL).getMessage());
            this.dateEnd.requestFocusInWindow();
            return false;
        }
        if (this.rdOrgMult.isSelected() && this.promptOrgMult.getData() == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.hr.affair.AFFAIRAutoGenerateResource", (String)"48_AffairSynFilterUI"));
            this.promptOrgMult.requestFocusInWindow();
            return false;
        }
        return true;
    }

    @Override
    protected void rdOrg_actionPerformed(ActionEvent e) throws Exception {
        this.setOrgCommentEnabled();
    }

    @Override
    protected void rdOrgMult_actionPerformed(ActionEvent e) throws Exception {
        this.setOrgCommentEnabled();
    }

    public boolean isPrepareSetCustomerParams() {
        return false;
    }

    public IUIActionPostman prepareSetCustomerParams(IObjectPK pk) {
        IUIActionPostman handler = UIActionPostman.getInstance((IUIObject)this);
        RequestContext request = new RequestContext();
        request.setClassName(this.getUIHandlerClassName());
        request.setMethodName("_handSetCustomerParams");
        request.put("pk", (Object)pk);
        handler.setRequestContext((Serializable)request);
        return handler;
    }
}

