/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.affair.client;

import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.FieldAccessInfo;
import com.kingdee.eas.base.permission.FieldPermission;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.HROrgUnitInfo;
import com.kingdee.eas.basedata.org.JobInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.PositionInfo;
import com.kingdee.eas.basedata.org.PositionMemberInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.client.context.OrgChangeVO;
import com.kingdee.eas.hr.affair.EmployeePoolInfo;
import com.kingdee.eas.hr.affair.FlucInBizBillEntryCollection;
import com.kingdee.eas.hr.affair.FlucInBizBillEntryInfo;
import com.kingdee.eas.hr.affair.client.EmployeePoolPromptBox;
import com.kingdee.eas.hr.affair.client.HRAffairBillEditUIBiz;
import com.kingdee.eas.hr.base.DefaultJobGradeTypeEnum;
import com.kingdee.eas.hr.base.DefaultJobGradeTypeOutcome;
import com.kingdee.eas.hr.base.HRBillConfFactory;
import com.kingdee.eas.hr.base.HRBillConfParam;
import com.kingdee.eas.hr.base.HRBizDefineInfo;
import com.kingdee.eas.hr.base.PositionRelatedInfo;
import com.kingdee.eas.hr.base.client.IHRF7CommonRegister;
import com.kingdee.eas.hr.base.client.f7.EditorCreator;
import com.kingdee.eas.hr.base.client.util.HRBizDefineClientUtils;
import com.kingdee.eas.hr.base.util.HRUtilExtend;
import com.kingdee.eas.hr.emp.PersonPositionInfo;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class FlucInBizBillEditUIBiz
extends HRAffairBillEditUIBiz {
    private boolean isHasDefaultJobGrade = false;
    private boolean isJobGradeAndJobLevelRelated = false;
    HRBizDefineInfo biz_withOldPos = null;
    HRBizDefineInfo biz_fluction = null;

    @Override
    protected void initEditor() throws Exception {
        super.initEditor();
        this.kdtEntrys.getColumn("chkLength").setEditor(EditorCreator.getNumberCellEditor((int)3, (int)0, (int)1));
        this.biz_withOldPos = HRBizDefineClientUtils.getHRBizDefineInfo((String)"DawAAAAqVFPmaL7Z");
        this.biz_fluction = HRBizDefineClientUtils.getHRBizDefineInfo((String)"DawAAAAqVEvmaL7Z");
    }

    @Override
    public void registerContextChangeF7(IHRF7CommonRegister register) {
        super.registerContextChangeF7(register);
    }

    @Override
    protected IObjectValue createNewDetailData(PersonInfo pInfo) {
        FlucInBizBillEntryInfo info = new FlucInBizBillEntryInfo();
        info.setId(BOSUuid.create((BOSObjectType)info.getBOSType()));
        return this.setPersonValue(info, pInfo);
    }

    public void entryEditStopped(KDTEditEvent e) throws Exception {
        if (e.getColIndex() >= 0 && e.getRowIndex() >= 0 && this.kdtEntrys.getColumnIndex("holdPosition") == e.getColIndex()) {
            IRow row = this.kdtEntrys.getRow(e.getRowIndex());
            this.fillBizDefine(row);
        }
    }

    private void fillBizDefine(IRow row) {
        Boolean holdPosition = (Boolean)row.getCell("holdPosition").getValue();
        if (holdPosition.booleanValue()) {
            row.getCell("hrBizDefine").setValue((Object)this.biz_withOldPos);
        } else {
            row.getCell("hrBizDefine").setValue((Object)this.biz_fluction);
        }
    }

    public void entryEditStopping(KDTEditEvent e) throws Exception {
    }

    public void addLine(boolean isInsert) throws Exception {
        this.addEmpPoolF7(isInsert);
    }

    protected void addEmpPoolF7(boolean isInsert) throws Exception {
        EmployeePoolPromptBox f7 = new EmployeePoolPromptBox();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("source", (Object)1, CompareType.EQUALS));
        HROrgUnitInfo hro = (HROrgUnitInfo)this.ctx.getMainOrgContext().get((Object)OrgType.HRO);
        if (hro == null) {
            MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.hr.affair.AFFAIRAutoGenerateResource", (String)"55_FlucInBizBillEditUIBiz"));
            return;
        }
        filter.getFilterItems().add(new FilterItemInfo("targetPool.id", (Object)hro.getId(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("targetPool.id", null, CompareType.EQUALS));
        filter.setMaskString("#0 and (#1 or #2)");
        f7.setDefaultFilter(filter);
        f7.show();
        if (!f7.isCanceled() && f7.getData() != null) {
            ArrayList<PersonInfo> persons = new ArrayList<PersonInfo>();
            HashMap<String, EmployeePoolInfo> employeePoolMap = new HashMap<String, EmployeePoolInfo>();
            Object[] objs = (Object[])f7.getData();
            for (int i = 0; i < objs.length; ++i) {
                EmployeePoolInfo empPoolInfo = (EmployeePoolInfo)objs[i];
                persons.add(empPoolInfo.getPerson());
                employeePoolMap.put(empPoolInfo.getPerson().getId().toString(), empPoolInfo);
            }
            this.addLineByPersonList(persons, true);
            this.afterAddEmpPool(employeePoolMap);
        }
    }

    protected void afterAddEmpPool(Map employeePoolMap) {
        for (int i = 0; i < this.kdtEntrys.getRowCount(); ++i) {
            IRow row = this.kdtEntrys.getRow(i);
            PersonInfo person = (PersonInfo)row.getCell("person").getValue();
            EmployeePoolInfo empPoolInfo = (EmployeePoolInfo)employeePoolMap.get(person.getId().toString());
            if (empPoolInfo != null) {
                if (empPoolInfo.getBizSignal() == 1) {
                    row.getCell("holdPosition").setValue((Object)true);
                    row.getCell("hrBizDefine").setValue((Object)this.biz_withOldPos);
                } else {
                    row.getCell("hrBizDefine").setValue((Object)this.biz_fluction);
                }
                row.getCell("sourceEntryId").setValue((Object)empPoolInfo.getSourceEntryId());
            }
            if (this.xinDianHandler == null) continue;
            this.xinDianHandler.setXinDianEditor(row, null);
        }
    }

    @Override
    public void handleNewData(CoreBaseInfo info) throws Exception {
        super.handleNewData(info);
        List persons = new ArrayList<PersonInfo>();
        if (info != null && info.get("entrys") != null) {
            int i;
            FlucInBizBillEntryCollection fluCol = (FlucInBizBillEntryCollection)((Object)info.get("entrys"));
            int n = fluCol.size();
            for (i = 0; i < n; ++i) {
                FlucInBizBillEntryInfo flucInfo = fluCol.get(i);
                persons.add(flucInfo.getPerson());
            }
            if (persons != null && persons.size() > 0) {
                persons = this.getProcessedPersons(persons, null);
                n = persons.size();
                for (i = 0; i < n; ++i) {
                    PersonInfo pInfo = (PersonInfo)persons.get(i);
                    int j = fluCol.size();
                    for (int k = 0; k < j; ++k) {
                        FlucInBizBillEntryInfo flucInfo = fluCol.get(i);
                        if (!pInfo.getId().toString().equals(flucInfo.getPerson().getId().toString())) continue;
                        this.setPersonValue(flucInfo, pInfo);
                    }
                }
            }
        }
    }

    private FlucInBizBillEntryInfo setPersonValue(FlucInBizBillEntryInfo info, PersonInfo pInfo) {
        info.setPerson(pInfo);
        info.setOldEmpType(pInfo.getEmployeeType());
        info.setEmpType(pInfo.getEmployeeType());
        PersonPositionInfo ppInfo = (PersonPositionInfo)pInfo.get("personPosition");
        if (ppInfo != null) {
            info.setOldJobGrade(ppInfo.getJobGrade());
            info.setOldJobLevel(ppInfo.getJobLevel());
            info.setOldPosition(ppInfo.getPrimaryPosition());
            info.setOldAdminOrg(ppInfo.getPersonDep());
            if (ppInfo.getPrimaryPosition() != null) {
                info.setOldJob(ppInfo.getPrimaryPosition().getJob());
            }
            if (this.isHasDefaultJobGrade) {
                info.setJobLevel(info.getOldJobLevel());
                info.setJobGrade(info.getOldJobGrade());
            }
            if (ppInfo.getPrimaryPosition() != null) {
                PositionMemberInfo pmInfo = HRUtilExtend.getPMInfo((PersonInfo)pInfo, (PositionInfo)ppInfo.getPrimaryPosition());
                info.setCheckLenHis(pmInfo.getCheckLen());
                info.setCheckOverTimeHis(pmInfo.getCheckOverTime());
                info.setCheckStateHis(pmInfo.getCheckState());
                info.setPersonnelNumberHis(pmInfo.getPersonnelNumber());
            }
        }
        return info;
    }

    protected void initEmpPoolFu() {
    }

    @Override
    public boolean isAddPersonByF7() {
        return true;
    }

    @Override
    protected String[] getNotNullColumn() {
        return new String[]{"position", "adminOrg", "bizDate", "hrBizDefine"};
    }

    @Override
    protected String[] getNotDupColumn() {
        return new String[]{"person"};
    }

    protected String getPrintQuery(String dsName) {
        ((Object)((Object)this)).getClass();
        if ("baseInfo".equals(dsName)) {
            return "com.kingdee.eas.hr.affair.app.FlucInBizBillPrintQuery";
        }
        ((Object)((Object)this)).getClass();
        if ("approveInfo".equals(dsName)) {
            return "com.kingdee.eas.hr.affair.app.FlucInBizBillApprovePrintQuery";
        }
        return null;
    }

    protected String getPrintPath() {
        return "/HR/AffairBiz/FlucIn";
    }

    @Override
    public void initDataStatus() throws Exception {
        super.initDataStatus();
        UserInfo userInfo = SysContext.getSysContext().getCurrentUserInfo();
        HROrgUnitInfo hrOrgInfo = SysContext.getSysContext().getCurrentHRUnit();
        IPermission per = PermissionFactory.getRemoteInstance();
        FieldPermission fields = per.getFieldPermission(BOSObjectType.create((String)"E41B9A4E"), (IObjectPK)new ObjectUuidPK(userInfo.getId()), (IObjectPK)new ObjectUuidPK(hrOrgInfo.getId()));
        IColumn col = this.kdtEntrys.getColumn(this.getJobLevelCol());
        FieldAccessInfo accessInfo = fields.getFieldAccessInfo("entrys.jobLevel");
        if (accessInfo != null && !accessInfo.isEditable() && col != null) {
            col.getStyleAttributes().setBackground(this.CANNOT_INPUT_COLOR);
        }
        col = this.kdtEntrys.getColumn(this.getJobGradeCol());
        accessInfo = fields.getFieldAccessInfo("entrys.jobGrade");
        if (accessInfo != null && !accessInfo.isEditable() && col != null) {
            col.getStyleAttributes().setBackground(this.CANNOT_INPUT_COLOR);
        }
    }

    @Override
    public void afterMainOrgChanged(OrgChangeVO chgVo) throws Exception {
        super.afterMainOrgChanged(chgVo);
        this.isHasDefaultJobGrade = this.isHasDefaultJobGrade();
        HROrgUnitInfo hro = (HROrgUnitInfo)this.ctx.getUIContext().get(OrgType.HRO);
        this.isJobGradeAndJobLevelRelated = this.isJobGradeAndJobLevelRelated(hro);
    }

    private boolean initIsGradeType() {
        HROrgUnitInfo hro = (HROrgUnitInfo)this.ctx.getUIContext().get(OrgType.HRO);
        HRBillConfParam param = new HRBillConfParam(hro, this.ctx.getUI().getMetaDataPK().getFullName());
        DefaultJobGradeTypeOutcome outcome = null;
        try {
            outcome = (DefaultJobGradeTypeOutcome)HRBillConfFactory.getHRBillConfSupervisor((String)"gradeType").getConfigValue(param);
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        return hro != null && outcome != null && DefaultJobGradeTypeEnum.CURRENT.equals((Object)outcome.getGradeType());
    }

    @Override
    protected void setJobGradeAndJobLevelEditor(PositionRelatedInfo relatedInfo, IRow row, String positionCol, boolean isClearOldValue) throws Exception {
        if (this.isHasDefaultJobGrade) {
            super.setJobGradeAndJobLevelEditor(relatedInfo, row, positionCol, false);
        } else {
            super.setJobGradeAndJobLevelEditor(relatedInfo, row, positionCol, isClearOldValue);
        }
    }

    @Override
    protected String getWFUIFuctionName() {
        return "com.kingdee.eas.hr.affair.app.FlucInBizBillEditUIFunction";
    }

    @Override
    protected void positionChanged(IRow row, PositionInfo pInfo) throws Exception {
        super.positionChanged(row, pInfo);
        row.getCell("salaryPoint").setValue(null);
        if (this.isHasDefaultJobGrade) {
            JobInfo oldJob = (JobInfo)row.getCell("oldJob").getValue();
            JobInfo newJob = (JobInfo)row.getCell("job").getValue();
            if (oldJob != null && newJob != null && !oldJob.toString().equals(newJob.toString()) || oldJob == null && newJob != null || oldJob != null && newJob == null) {
                row.getCell("jobLevel").setValue(null);
                if (this.isJobGradeAndJobLevelRelated) {
                    row.getCell("jobGrade").setValue(null);
                }
            }
        }
    }

    protected boolean isCheckPersonInPool() {
        return false;
    }

    protected boolean isCheckPersonFlucOut() {
        return false;
    }

    public void copyColumn(KDTable table, boolean isSingleSelect) throws Exception {
        if (this.isCanCopyXinDian(isSingleSelect)) {
            super.copyColumn(table, isSingleSelect);
        }
    }

    @Override
    public boolean isComposeSalaryPointColumn() {
        return true;
    }

    @Override
    protected String positionF7IsShowSealup() {
        return "true";
    }

    @Override
    protected void fillRow(IRow row, Object value, IRow dataRow, int copyCol) throws Exception {
        super.fillRow(row, value, dataRow, copyCol);
        if (copyCol == row.getCell("holdPosition").getColumnIndex()) {
            this.fillBizDefine(row);
        }
    }
}

