/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.affair.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTPropertyChangeEvent;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.PositionInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.hr.affair.HRAffairException;
import com.kingdee.eas.hr.affair.LoanBackBizBillFactory;
import com.kingdee.eas.hr.affair.LoanBackBizBillInfo;
import com.kingdee.eas.hr.affair.client.AbstractLoanBackBizBillEditUI;
import com.kingdee.eas.hr.affair.client.LoanBackBizBillEditUIBiz;
import com.kingdee.eas.hr.base.HRBillStateEnum;
import com.kingdee.eas.hr.base.client.IHRBillEditUIBiz;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.event.ActionEvent;
import org.apache.log4j.Logger;

public class LoanBackBizBillEditUI
extends AbstractLoanBackBizBillEditUI {
    private static final Logger logger = CoreUIObject.getLogger(LoanBackBizBillEditUI.class);

    @Override
    public void onLoad() throws Exception {
        super.onLoad();
    }

    @Override
    protected void afterOnLoad() throws Exception {
        super.afterOnLoad();
        this.setPositionEditor();
    }

    @Override
    protected IHRBillEditUIBiz getBillBiz() {
        return new LoanBackBizBillEditUIBiz();
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return LoanBackBizBillFactory.getRemoteInstanceWithObjectContext(this.getMainOrgContext());
    }

    protected IObjectValue createNewDetailData(KDTable table) {
        return null;
    }

    @Override
    public String getTitle() {
        return EASResource.getString((String)"com.kingdee.eas.hr.affair.AffairBizResource", (String)"second_emp");
    }

    @Override
    protected IObjectValue createNewData() {
        UserInfo info = SysContext.getSysContext().getCurrentUserInfo();
        if ("TRUE".equalsIgnoreCase((String)this.getUIContext().get("IsPersonal"))) {
            this.checkLoanBackPerson(info.getPerson());
        }
        LoanBackBizBillInfo objectValue = new LoanBackBizBillInfo();
        objectValue.setCreator((UserInfo)SysContext.getSysContext().getCurrentUser());
        objectValue.setBillState(HRBillStateEnum.SAVED);
        objectValue.setApplier(info.getPerson());
        return objectValue;
    }

    private void checkLoanBackPerson(PersonInfo pInfo) {
        MetaDataPK queryPK = new MetaDataPK("com.kingdee.eas.hr.affair.app.LoanBackPersonsQuery");
        IQueryExecutor exec = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)queryPK);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("person.id", (Object)pInfo.getId(), CompareType.EQUALS));
        EntityViewInfo ev = new EntityViewInfo();
        ev.setFilter(filter);
        exec.setObjectView(ev);
        try {
            IRowSet selectItemRowSet = exec.executeQuery();
            if (!selectItemRowSet.next()) {
                throw new HRAffairException(HRAffairException.PERSON_NOT_IN_LOAD_STATE);
            }
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
            SysUtil.abort();
        }
    }

    @Override
    public void actionAddLine_actionPerformed(ActionEvent e) throws Exception {
        ((LoanBackBizBillEditUIBiz)this.biz).addLoanBackPerson(false);
    }

    @Override
    public void actionInsertLine_actionPerformed(ActionEvent e) throws Exception {
        ((LoanBackBizBillEditUIBiz)this.biz).addLoanBackPerson(true);
    }

    @Override
    protected void kdtEntrys_editStopped(KDTEditEvent e) throws Exception {
        ((LoanBackBizBillEditUIBiz)this.biz).entryEditStopped(e);
    }

    @Override
    protected void kdtEntrys_editStopping(KDTEditEvent e) throws Exception {
        ((LoanBackBizBillEditUIBiz)this.biz).entryEditStopping(e);
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        super.verifyInput(e);
        IRow row = null;
        int size = this.kdtEntrys.getRowCount();
        for (int i = 0; i < size; ++i) {
            row = this.kdtEntrys.getRow(i);
            if (!((PositionInfo)row.getCell("initPosition").getValue()).getId().equals((Object)((PositionInfo)row.getCell("oldPosition").getValue()).getId())) continue;
            throw new HRAffairException(HRAffairException.POSITION_ISSAME, new Object[]{new Integer(i + 1)});
        }
    }

    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        this.verifyInput(null);
        super.actionSave_actionPerformed(e);
        this.setPositionEditor();
    }

    @Override
    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        this.verifyInput(null);
        super.actionSubmit_actionPerformed(e);
        this.setPositionEditor();
    }

    private void setPositionEditor() throws BOSException, ParserException {
        IRow row = null;
        String personId = null;
        int size = this.kdtEntrys.getRowCount();
        for (int i = 0; i < size; ++i) {
            row = this.kdtEntrys.getRow(i);
            personId = ((PersonInfo)row.getCell("person").getValue()).getId().toString();
            ((LoanBackBizBillEditUIBiz)this.biz).setPositionEditor(row, personId);
        }
    }

    @Override
    protected void setAutoNumberByOrg(String orgType) {
    }

    @Override
    public String getTarEmpTypeKey() {
        return null;
    }

    @Override
    public String getOldEmpTypeColumnKey() {
        return null;
    }

    @Override
    public String getAdminColumnKey() {
        return "adminOrg";
    }

    @Override
    public String getPositionColumnKey() {
        return "position";
    }

    @Override
    public String getOldAdminColumnKey() {
        return "oldAdminOrg";
    }

    @Override
    public String getOldPositionColumnKey() {
        return "oldPosition";
    }

    @Override
    protected void propertyValueChange(KDTPropertyChangeEvent evt) throws EASBizException {
        super.propertyValueChange(evt);
    }

    @Override
    protected boolean isSourcePositionCanEqualsTargetPosition() {
        return true;
    }

    @Override
    protected boolean isNeedSetUserPermission() {
        return true;
    }
}

