/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.affair.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.FieldAccessInfo;
import com.kingdee.eas.base.permission.FieldPermission;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.HROrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.PositionInfo;
import com.kingdee.eas.basedata.org.PositionMemberCollection;
import com.kingdee.eas.basedata.org.PositionMemberFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.affair.LoanBackBizBillEntryInfo;
import com.kingdee.eas.hr.affair.client.HRAffairBillEditUIBiz;
import com.kingdee.eas.hr.base.HRBizDefineInfo;
import com.kingdee.eas.hr.base.client.IHRF7CommonRegister;
import com.kingdee.eas.hr.base.client.util.HRBizDefineClientUtils;
import com.kingdee.eas.hr.base.util.HRUtilExtend;
import com.kingdee.eas.hr.emp.IPersonLoan;
import com.kingdee.eas.hr.emp.PersonLoanCollection;
import com.kingdee.eas.hr.emp.PersonLoanFactory;
import com.kingdee.eas.hr.emp.PersonLoanInfo;
import com.kingdee.eas.hr.emp.PersonPositionInfo;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.JComboBox;

public class LoanBackBizBillEditUIBiz
extends HRAffairBillEditUIBiz {
    private boolean IsPersonal = true;
    HRBizDefineInfo bizDefLong_returnOldPos = null;
    HRBizDefineInfo bizDefTemp_returnOldPos = null;
    HRBizDefineInfo bizDef_notReturnOldPos = null;

    @Override
    protected void initEditor() throws Exception {
        super.initEditor();
        this.bizDefLong_returnOldPos = HRBizDefineClientUtils.getHRBizDefineInfo((String)"DawAAAAqGWbmaL7Z");
        this.bizDefTemp_returnOldPos = HRBizDefineClientUtils.getHRBizDefineInfo((String)"DawAAAAqRFTmaL7Z");
        this.bizDef_notReturnOldPos = HRBizDefineClientUtils.getHRBizDefineInfo((String)"DawAAAAqRFrmaL7Z");
    }

    @Override
    public void registerContextChangeF7(IHRF7CommonRegister register) {
        super.registerContextChangeF7(register);
    }

    public void entryEditStopped(KDTEditEvent e) throws Exception {
        if (e.getColIndex() >= 0 && e.getRowIndex() >= 0 && e.getValue() != null && (this.kdtEntrys.getColumnIndex("initPosition") == e.getColIndex() || this.kdtEntrys.getColumnIndex("oldPosition") == e.getColIndex() || this.kdtEntrys.getColumnIndex("position") == e.getColIndex())) {
            int rowNum = e.getRowIndex();
            this.doWithHrBizDefine(rowNum);
        }
    }

    private void doWithHrBizDefine(int rowNum) {
        IRow curRow = this.kdtEntrys.getRow(rowNum);
        if (curRow != null && curRow.getCell("initPosition").getValue() != null && curRow.getCell("oldPosition").getValue() != null && curRow.getCell("oldPosition").getValue() != null) {
            PositionInfo initPosition = (PositionInfo)curRow.getCell("initPosition").getValue();
            PositionInfo oldPosition = (PositionInfo)curRow.getCell("oldPosition").getValue();
            PositionInfo position = (PositionInfo)curRow.getCell("position").getValue();
            this.fillBizDefineByPosition(curRow, initPosition, oldPosition, position);
        }
    }

    private void fillBizDefineByPosition(IRow curRow, PositionInfo initPosition, PositionInfo oldPosition, PositionInfo position) {
        if (initPosition == null || oldPosition == null) {
            return;
        }
        boolean isLongTimeLoan = false;
        boolean isReturnOldPos = false;
        Boolean isPrimary = (Boolean)oldPosition.get("isPrimary");
        isLongTimeLoan = isPrimary != null && isPrimary == true;
        isReturnOldPos = HRUtilExtend.isObjectEquelsByPkValue((CoreBaseInfo)initPosition, (CoreBaseInfo)position);
        if (isReturnOldPos) {
            if (isLongTimeLoan) {
                curRow.getCell("hrBizDefine").setValue((Object)this.bizDefLong_returnOldPos);
            } else {
                curRow.getCell("hrBizDefine").setValue((Object)this.bizDefTemp_returnOldPos);
            }
        } else {
            curRow.getCell("hrBizDefine").setValue((Object)this.bizDef_notReturnOldPos);
        }
    }

    public void entryEditStopping(KDTEditEvent e) throws Exception {
    }

    @Override
    protected IObjectValue createNewDetailData(PersonInfo pInfo) {
        LoanBackBizBillEntryInfo info = new LoanBackBizBillEntryInfo();
        info.setId(BOSUuid.create((BOSObjectType)info.getBOSType()));
        this.setLoanBackPerson(pInfo, info);
        info.setPerson(pInfo);
        info.setOldEmpType(pInfo.getEmployeeType());
        info.setEmpType(pInfo.getEmployeeType());
        PersonPositionInfo ppInfo = (PersonPositionInfo)pInfo.get("personPosition");
        if (ppInfo != null) {
            info.setOldJobGrade(ppInfo.getJobGrade());
            info.setOldJobLevel(ppInfo.getJobLevel());
            info.setOldPosition(ppInfo.getPrimaryPosition());
            info.setOldAdminOrg(ppInfo.getPersonDep());
        }
        return info;
    }

    @Override
    protected void fillRow(IRow row, Object value, IRow dataRow, int copyCol) throws Exception {
        super.fillRow(row, value, dataRow, copyCol);
        if (copyCol == this.kdtEntrys.getColumn("initPosition").getColumnIndex() || copyCol == this.kdtEntrys.getColumn("oldPosition").getColumnIndex() || copyCol == this.kdtEntrys.getColumn("position").getColumnIndex()) {
            PositionInfo initPosition = (PositionInfo)row.getCell("initPosition").getValue();
            PositionInfo oldPosition = (PositionInfo)row.getCell("oldPosition").getValue();
            PositionInfo position = (PositionInfo)row.getCell("position").getValue();
            this.fillBizDefineByPosition(row, initPosition, oldPosition, position);
        }
    }

    private void setLoanBackPerson(PersonInfo pInfo, LoanBackBizBillEntryInfo loanEntryinfo) {
        try {
            if (this.IsPersonal) {
                StringBuffer oql = new StringBuffer();
                oql.append("select id,outPosition.id,outPosition.name,outPosition.number,outAdmin.id,outAdmin.name,outAdmin.number,outJob.id,outJob.name,outJob.number,outJobLevel.id,outJobLevel.name,outJobLevel.number,outJobGrade.id,outJobGrade.name,outJobGrade.number where state='");
                oql.append("1").append("' and person.id ='").append(pInfo.getId().toString() + "'");
                IPersonLoan ipersonLoan = PersonLoanFactory.getRemoteInstance();
                PersonLoanCollection col = ipersonLoan.getPersonLoanCollection(oql.toString());
                if (col.size() > 0) {
                    PersonLoanInfo personLoan = col.get(0);
                    loanEntryinfo.setInitPosition(personLoan.getOutPosition());
                    loanEntryinfo.setInitAdminOrg(personLoan.getOutAdmin());
                    loanEntryinfo.setInitJob(personLoan.getOutJob());
                    loanEntryinfo.setInitJobLevel(personLoan.getOutJobLevel());
                    loanEntryinfo.setInitJobGrade(personLoan.getOutJobGrade());
                }
            }
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
            SysUtil.abort();
        }
    }

    public void addLine(boolean isInsert) throws Exception {
        this.IsPersonal = false;
        this.addLoanBackPerson(isInsert);
    }

    protected void addLoanBackPerson(boolean isInsert) throws Exception {
        KDBizPromptBox f7 = new KDBizPromptBox();
        f7.setMyCommonUseEnabled(false);
        f7.setQueryInfo("com.kingdee.eas.hr.affair.app.LoanBackPersonsQuery");
        FilterInfo filter = new FilterInfo();
        HROrgUnitInfo hro = (HROrgUnitInfo)this.ctx.getMainOrgContext().get((Object)OrgType.HRO);
        if (hro == null) {
            MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.hr.affair.AFFAIRAutoGenerateResource", (String)"55_FlucInBizBillEditUIBiz"));
            return;
        }
        filter.getFilterItems().add(new FilterItemInfo("hrOrg.id", (Object)hro.getId(), CompareType.EQUALS));
        EntityViewInfo ev = new EntityViewInfo();
        ev.setFilter(filter);
        f7.setEntityViewInfo(ev);
        f7.setEnabledMultiSelection(true);
        f7.setDataBySelector();
        if (!f7.getSelector().isCanceled()) {
            ArrayList<PersonInfo> persons = new ArrayList<PersonInfo>();
            StringBuffer personLoanIds = new StringBuffer();
            if (f7.getData() instanceof Object[]) {
                Object[] objs = (Object[])f7.getData();
                for (int i = 0; i < objs.length; ++i) {
                    PersonLoanInfo personLoanInfo = (PersonLoanInfo)objs[i];
                    persons.add(personLoanInfo.getPerson());
                    personLoanIds.append("'").append(personLoanInfo.getId()).append("' ");
                }
            } else {
                PersonLoanInfo personLoanInfo = (PersonLoanInfo)f7.getData();
                persons.add(personLoanInfo.getPerson());
                personLoanIds.append("'").append(personLoanInfo.getId()).append("' ");
            }
            this.addLineByPersonList(persons, true);
            this.afterAddPersonLoan(personLoanIds.toString().trim().replaceAll(" ", ","));
        }
    }

    public void addLineByPersonList(List persons, boolean isInsert) throws Exception {
        super.addLineByPersonList(persons, isInsert);
        IRow row = null;
        String personId = null;
        int size = this.kdtEntrys.getRowCount();
        for (int i = 0; i < size; ++i) {
            row = this.kdtEntrys.getRow(i);
            personId = ((PersonInfo)row.getCell("person").getValue()).getId().toString();
            this.setPositionEditor(row, personId);
        }
    }

    private void afterAddPersonLoan(String personLoanIds) throws Exception {
        String oql = "select *,outPosition.*,outAdmin.*,outJob.*,outJobLevel.*,outJobGrade.*,inPosition.*,inAdmin.*,inJob.*,inJobLevel.*,inJobGrade.* where state='1' id in (" + personLoanIds + ")";
        IPersonLoan ipersonLoan = PersonLoanFactory.getRemoteInstance();
        PersonLoanCollection col = ipersonLoan.getPersonLoanCollection(oql);
        HashMap<String, PersonLoanInfo> personLoanMap = new HashMap<String, PersonLoanInfo>();
        StringBuffer personIdStr = new StringBuffer();
        for (PersonLoanInfo personLoan : col) {
            personLoanMap.put(personLoan.getPerson().getId().toString(), personLoan);
            personIdStr.append("'" + personLoan.getPerson().getId().toString() + "',");
        }
        HashMap pmMap = this.getPositionMemeber(personIdStr.substring(0, personIdStr.length() - 1));
        PositionMemberCollection personPmColl = null;
        for (int i = 0; i < this.kdtEntrys.getRowCount(); ++i) {
            IRow row = this.kdtEntrys.getRow(i);
            PersonInfo person = (PersonInfo)row.getCell("person").getValue();
            PersonLoanInfo personLoan = (PersonLoanInfo)personLoanMap.get(person.getId().toString());
            if (pmMap.get(person.getId().toString()) != null) {
                personPmColl = (PositionMemberCollection)pmMap.get(person.getId().toString());
            }
            if (personLoan == null) continue;
            PositionInfo outPositionInfo = this.getPositionInfo(personPmColl, personLoan.getOutPosition());
            if (outPositionInfo != null) {
                row.getCell("initPosition").setValue((Object)outPositionInfo);
            }
            row.getCell("initAdminOrg").setValue((Object)personLoan.getOutAdmin());
            row.getCell("initJob").setValue((Object)personLoan.getOutJob());
            row.getCell("initJobLevel").setValue((Object)personLoan.getOutJobLevel());
            row.getCell("initJobGrade").setValue((Object)personLoan.getOutJobGrade());
            PositionInfo inPositionInfo = this.getPositionInfo(personPmColl, personLoan.getInPosition());
            if (inPositionInfo != null) {
                row.getCell("oldPosition").setValue((Object)inPositionInfo);
            }
            row.getCell("oldAdminOrg").setValue((Object)personLoan.getInAdmin());
            row.getCell("oldJob").setValue((Object)personLoan.getInJob());
            row.getCell("oldJobLevel").setValue((Object)personLoan.getInJobLevel());
            row.getCell("oldJobGrade").setValue((Object)personLoan.getInJobGrade());
            row.getCell("position").setValue((Object)personLoan.getOutPosition());
            row.getCell("adminOrg").setValue((Object)personLoan.getOutAdmin());
            row.getCell("job").setValue((Object)personLoan.getOutJob());
            row.getCell("jobLevel").setValue((Object)personLoan.getOutJobLevel());
            row.getCell("jobGrade").setValue((Object)personLoan.getOutJobGrade());
            row.getCell("owner").setValue((Object)personLoan.getOwner());
            row.getCell("personLoan").setValue((Object)personLoan);
            this.setPositionEditor(row, person.getId().toString());
            this.fillBizDefineByPosition(row, (PositionInfo)row.getCell("initPosition").getValue(), (PositionInfo)row.getCell("oldPosition").getValue(), personLoan.getOutPosition());
        }
    }

    private HashMap getPositionMemeber(String personIdStr) throws BOSException {
        HashMap<String, PositionMemberCollection> map = new HashMap<String, PositionMemberCollection>();
        Object list = null;
        PositionMemberCollection personPmColl = null;
        String oql = "select position.id, position.name, position.number, person.id,isPrimary where person in (" + personIdStr + ")";
        PositionMemberCollection pmCol = PositionMemberFactory.getRemoteInstance().getPositionMemberCollection(oql);
        int size = pmCol.size();
        for (int i = 0; i < size; ++i) {
            if (map.get(pmCol.get(i).getPerson().getId().toString()) != null) {
                personPmColl = (PositionMemberCollection)map.get(pmCol.get(i).getPerson().getId().toString());
                personPmColl.add(pmCol.get(i));
                continue;
            }
            personPmColl = new PositionMemberCollection();
            personPmColl.add(pmCol.get(i));
            map.put(pmCol.get(i).getPerson().getId().toString(), personPmColl);
        }
        return map;
    }

    protected void setPositionEditor(IRow row, String personId) throws BOSException, ParserException {
        String oql = "select position.id, position.name, position.number,isPrimary where person = '" + personId + "'";
        PositionMemberCollection pmCol = PositionMemberFactory.getRemoteInstance().getPositionMemberCollection(oql);
        KDComboBox cboPosition = new KDComboBox();
        int size = pmCol.size();
        for (int i = 0; i < size; ++i) {
            PositionInfo pmPos = pmCol.get(i).getPosition();
            pmPos.put("isPrimary", (Object)pmCol.get(i).isIsPrimary());
            cboPosition.addItem((Object)pmCol.get(i).getPosition());
        }
        row.getCell("initPosition").setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)cboPosition));
        row.getCell("oldPosition").setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)cboPosition));
    }

    @Override
    public boolean isAddPersonByF7() {
        return true;
    }

    @Override
    protected String[] getNotDupColumn() {
        return new String[]{"person"};
    }

    @Override
    protected String[] getNotNullColumn() {
        return new String[]{"initPosition", "oldPosition", "position", "adminOrg", "bizDate", "loanEndDate", "outPositionStr", "outAdminStr", "inPositionStr", "inAdminStr", "hrBizDefine"};
    }

    protected String getPrintQuery(String dsName) {
        ((Object)((Object)this)).getClass();
        if ("baseInfo".equals(dsName)) {
            return "com.kingdee.eas.hr.affair.app.LoanBackBizBillPrintQuery";
        }
        ((Object)((Object)this)).getClass();
        if ("approveInfo".equals(dsName)) {
            return "com.kingdee.eas.hr.affair.app.LoanBackBizBillApprovePrintQuery";
        }
        return null;
    }

    protected String getPrintPath() {
        return "/HR/AffairBiz/LoanBack";
    }

    @Override
    public void initDataStatus() throws Exception {
        super.initDataStatus();
        UserInfo userInfo = SysContext.getSysContext().getCurrentUserInfo();
        HROrgUnitInfo hrOrgInfo = SysContext.getSysContext().getCurrentHRUnit();
        IPermission per = PermissionFactory.getRemoteInstance();
        FieldPermission fields = per.getFieldPermission(BOSObjectType.create((String)"E2673D70"), (IObjectPK)new ObjectUuidPK(userInfo.getId()), (IObjectPK)new ObjectUuidPK(hrOrgInfo.getId()));
        IColumn col = this.kdtEntrys.getColumn(this.getJobLevelCol());
        FieldAccessInfo accessInfo = fields.getFieldAccessInfo("entrys.jobLevel");
        if (accessInfo != null && !accessInfo.isEditable() && col != null) {
            col.getStyleAttributes().setBackground(this.CANNOT_INPUT_COLOR);
        }
        col = this.kdtEntrys.getColumn(this.getJobGradeCol());
        accessInfo = fields.getFieldAccessInfo("entrys.jobGrade");
        if (accessInfo != null && !accessInfo.isEditable() && col != null) {
            col.getStyleAttributes().setBackground(this.CANNOT_INPUT_COLOR);
        }
    }

    @Override
    protected String getWFUIFuctionName() {
        return "com.kingdee.eas.hr.affair.app.LoanBackBizBillEditUIFunction";
    }

    @Override
    protected String positionF7IsShowSealup() {
        return "true";
    }

    private PositionInfo getPositionInfo(PositionMemberCollection pmColl, PositionInfo positionInfo) {
        PositionInfo posInfo = null;
        if (pmColl != null) {
            int size = pmColl.size();
            for (int i = 0; i < size; ++i) {
                if (!HRUtilExtend.isObjectEquelsByPkValue((CoreBaseInfo)positionInfo, (CoreBaseInfo)pmColl.get(i).getPosition())) continue;
                posInfo = pmColl.get(i).getPosition();
                posInfo.put("isPrimary", (Object)pmColl.get(i).isIsPrimary());
                break;
            }
        }
        return posInfo;
    }
}

