/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.affair.client;

import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.FieldAccessInfo;
import com.kingdee.eas.base.permission.FieldPermission;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.HROrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.hr.affair.EmployeePoolInfo;
import com.kingdee.eas.hr.affair.LoanInBizBillEntryInfo;
import com.kingdee.eas.hr.affair.client.EmployeePoolPromptBox;
import com.kingdee.eas.hr.affair.client.HRAffairBillEditUIBiz;
import com.kingdee.eas.hr.base.HRBizDefineInfo;
import com.kingdee.eas.hr.base.LoanOwnerEnum;
import com.kingdee.eas.hr.base.client.IHRF7CommonRegister;
import com.kingdee.eas.hr.base.client.util.HRBizDefineClientUtils;
import com.kingdee.eas.hr.emp.IPersonLoan;
import com.kingdee.eas.hr.emp.LoanStrEnum;
import com.kingdee.eas.hr.emp.PersonLoanCollection;
import com.kingdee.eas.hr.emp.PersonLoanFactory;
import com.kingdee.eas.hr.emp.PersonLoanInfo;
import com.kingdee.eas.hr.emp.PersonPositionInfo;
import com.kingdee.eas.hr.org.client.AdminByOrgRangePromptBox;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class LoanInBizBillEditUIBiz
extends HRAffairBillEditUIBiz {
    HRBizDefineInfo bizDefLong = null;
    HRBizDefineInfo bizDefTemp = null;

    @Override
    protected void initEditor() throws Exception {
        super.initEditor();
    }

    @Override
    public void registerContextChangeF7(IHRF7CommonRegister register) {
        super.registerContextChangeF7(register);
        KDBizPromptBox prmtAdmin = new KDBizPromptBox();
        register.registerAdminByOrgRangePromptBox(prmtAdmin, this.kdtEntrys.getColumn("oldAdminOrg"));
        AdminByOrgRangePromptBox admin = (AdminByOrgRangePromptBox)prmtAdmin.getSelector();
        admin.setIncludeSealUp("true");
        this.bizDefLong = HRBizDefineClientUtils.getHRBizDefineInfo((String)"DawAAAAqVILmaL7Z");
        this.bizDefTemp = HRBizDefineClientUtils.getHRBizDefineInfo((String)"DawAAAAqVIvmaL7Z");
    }

    public void entryEditStopping(KDTEditEvent e) throws Exception {
    }

    public void entryEditStopped(KDTEditEvent e) throws Exception {
        if (e.getColIndex() >= 0 && e.getRowIndex() >= 0 && this.kdtEntrys.getColumnIndex("owner") == e.getColIndex()) {
            int rowNum = e.getRowIndex();
            IRow curRow = this.kdtEntrys.getRow(rowNum);
            this.fillBizDefineByLoanOwnerEnum(curRow);
        }
    }

    @Override
    protected IObjectValue createNewDetailData(PersonInfo pInfo) {
        LoanInBizBillEntryInfo info = new LoanInBizBillEntryInfo();
        info.setId(BOSUuid.create((BOSObjectType)info.getBOSType()));
        info.setPerson(pInfo);
        info.setOldEmpType(pInfo.getEmployeeType());
        info.setEmpType(pInfo.getEmployeeType());
        PersonPositionInfo ppInfo = (PersonPositionInfo)pInfo.get("personPosition");
        if (ppInfo != null) {
            info.setOldJobGrade(ppInfo.getJobGrade());
            info.setOldJobLevel(ppInfo.getJobLevel());
            info.setOldPosition(ppInfo.getPrimaryPosition());
            info.setOldAdminOrg(ppInfo.getPersonDep());
            if (ppInfo.getPrimaryPosition() != null) {
                info.setOldJob(ppInfo.getPrimaryPosition().getJob());
            }
            info.setInAdminStr(true);
        }
        return info;
    }

    public void addLine(boolean isInsert) throws Exception {
        this.addEmpPoolF7(isInsert);
    }

    protected void addEmpPoolF7(boolean isInsert) throws Exception {
        EmployeePoolPromptBox f7 = new EmployeePoolPromptBox();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("source", (Object)2, CompareType.EQUALS));
        HROrgUnitInfo hro = (HROrgUnitInfo)this.ctx.getMainOrgContext().get((Object)OrgType.HRO);
        if (hro == null) {
            MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.hr.affair.AFFAIRAutoGenerateResource", (String)"55_FlucInBizBillEditUIBiz"));
            return;
        }
        filter.getFilterItems().add(new FilterItemInfo("targetPool.id", (Object)hro.getId(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("targetPool.id", null, CompareType.EQUALS));
        filter.setMaskString("#0 and (#1 or #2)");
        f7.setDefaultFilter(filter);
        f7.show();
        if (!f7.isCanceled() && f7.getData() != null) {
            ArrayList<PersonInfo> persons = new ArrayList<PersonInfo>();
            StringBuffer personIds = new StringBuffer();
            HashMap<String, EmployeePoolInfo> employeePoolMap = new HashMap<String, EmployeePoolInfo>();
            Object[] objs = (Object[])f7.getData();
            for (int i = 0; i < objs.length; ++i) {
                EmployeePoolInfo empPoolInfo = (EmployeePoolInfo)objs[i];
                persons.add(empPoolInfo.getPerson());
                personIds.append("'").append(empPoolInfo.getPerson().getId()).append("' ");
                employeePoolMap.put(empPoolInfo.getPerson().getId().toString(), empPoolInfo);
            }
            this.addLineByPersonList(persons, true);
            this.afterAddEmpPool(personIds.toString().trim().replaceAll(" ", ","));
            this.addEmpPool(employeePoolMap);
        }
    }

    private void addEmpPool(Map employeePoolMap) {
        int size = this.kdtEntrys.getRowCount();
        for (int i = 0; i < size; ++i) {
            IRow row = this.kdtEntrys.getRow(i);
            PersonInfo person = (PersonInfo)row.getCell("person").getValue();
            EmployeePoolInfo empPoolInfo = (EmployeePoolInfo)employeePoolMap.get(person.getId().toString());
            if (empPoolInfo == null) continue;
            row.getCell("sourceEntryId").setValue((Object)empPoolInfo.getSourceEntryId());
        }
    }

    private void afterAddEmpPool(String personIds) throws Exception {
        String oql = "select *,outPosition.*,outAdmin.*,outJob.*,outJobLevel.*,outJobGrade.* where state='1' person.id in (" + personIds + ")";
        IPersonLoan ipersonLoan = PersonLoanFactory.getRemoteInstance();
        PersonLoanCollection col = ipersonLoan.getPersonLoanCollection(oql);
        HashMap<String, PersonLoanInfo> personLoanMap = new HashMap<String, PersonLoanInfo>();
        for (PersonLoanInfo personLoan : col) {
            personLoanMap.put(personLoan.getPerson().getId().toString(), personLoan);
        }
        for (int i = 0; i < this.kdtEntrys.getRowCount(); ++i) {
            HRBizDefineInfo bizDefineInfo;
            IRow row = this.kdtEntrys.getRow(i);
            PersonInfo person = (PersonInfo)row.getCell("person").getValue();
            PersonLoanInfo personLoan = (PersonLoanInfo)personLoanMap.get(person.getId().toString());
            if (personLoan == null) continue;
            row.getCell("oldPosition").setValue((Object)personLoan.getOutPosition());
            row.getCell("oldAdminOrg").setValue((Object)personLoan.getOutAdmin());
            row.getCell("oldJob").setValue((Object)personLoan.getOutJob());
            row.getCell("oldJobLevel").setValue((Object)personLoan.getOutJobLevel());
            row.getCell("oldJobGrade").setValue((Object)personLoan.getOutJobGrade());
            row.getCell("owner").setValue((Object)personLoan.getOwner());
            if (LoanOwnerEnum.IN.equals((Object)personLoan.getOwner())) {
                bizDefineInfo = HRBizDefineClientUtils.getHRBizDefineInfo((String)"DawAAAAqVILmaL7Z");
                row.getCell("hrBizDefine").setValue((Object)bizDefineInfo);
            } else {
                bizDefineInfo = HRBizDefineClientUtils.getHRBizDefineInfo((String)"DawAAAAqVIvmaL7Z");
                row.getCell("hrBizDefine").setValue((Object)bizDefineInfo);
            }
            row.getCell("outPositionStr").setValue((Object)false);
            row.getCell("outAdminStr").setValue((Object)false);
            if (LoanStrEnum.OUT.equals((Object)personLoan.getPositionStr())) {
                row.getCell("outPositionStr").setValue((Object)true);
            }
            if (LoanStrEnum.OUT.equals((Object)personLoan.getAdminStr())) {
                row.getCell("outAdminStr").setValue((Object)true);
            }
            row.getCell("loanEndDate").setValue((Object)personLoan.getLoanEndDate());
        }
    }

    @Override
    public boolean isAddPersonByF7() {
        return true;
    }

    @Override
    protected String[] getNotDupColumn() {
        return new String[]{"person"};
    }

    @Override
    protected String[] getNotNullColumn() {
        return new String[]{"position", "adminOrg", "bizDate", "loanEndDate", "hrBizDefine"};
    }

    protected String getPrintQuery(String dsName) {
        ((Object)((Object)this)).getClass();
        if ("baseInfo".equals(dsName)) {
            return "com.kingdee.eas.hr.affair.app.LoanInBizBillPrintQuery";
        }
        ((Object)((Object)this)).getClass();
        if ("approveInfo".equals(dsName)) {
            return "com.kingdee.eas.hr.affair.app.LoanInBizBillApprovePrintQuery";
        }
        return null;
    }

    protected String getPrintPath() {
        return "/HR/AffairBiz/LoanIn";
    }

    @Override
    public void initDataStatus() throws Exception {
        super.initDataStatus();
        UserInfo userInfo = SysContext.getSysContext().getCurrentUserInfo();
        HROrgUnitInfo hrOrgInfo = SysContext.getSysContext().getCurrentHRUnit();
        IPermission per = PermissionFactory.getRemoteInstance();
        FieldPermission fields = per.getFieldPermission(BOSObjectType.create((String)"6F8C96B2"), (IObjectPK)new ObjectUuidPK(userInfo.getId()), (IObjectPK)new ObjectUuidPK(hrOrgInfo.getId()));
        IColumn col = this.kdtEntrys.getColumn(this.getJobLevelCol());
        FieldAccessInfo accessInfo = fields.getFieldAccessInfo("entrys.jobLevel");
        if (accessInfo != null && !accessInfo.isEditable() && col != null) {
            col.getStyleAttributes().setBackground(this.CANNOT_INPUT_COLOR);
        }
        col = this.kdtEntrys.getColumn(this.getJobGradeCol());
        accessInfo = fields.getFieldAccessInfo("entrys.jobGrade");
        if (accessInfo != null && !accessInfo.isEditable() && col != null) {
            col.getStyleAttributes().setBackground(this.CANNOT_INPUT_COLOR);
        }
    }

    @Override
    protected String getWFUIFuctionName() {
        return "com.kingdee.eas.hr.affair.app.LoanInBizBillEditUIFunction";
    }

    protected boolean isCheckPersonInPool() {
        return false;
    }

    protected boolean isCheckPersonLoanOut() {
        return false;
    }

    @Override
    protected String positionF7IsShowSealup() {
        return "true";
    }

    private void fillBizDefineByLoanOwnerEnum(IRow curRow) {
        LoanOwnerEnum stateEnum = (LoanOwnerEnum)curRow.getCell("owner").getValue();
        if (LoanOwnerEnum.IN.equals((Object)stateEnum)) {
            curRow.getCell("hrBizDefine").setValue((Object)this.bizDefLong);
        } else {
            curRow.getCell("hrBizDefine").setValue((Object)this.bizDefTemp);
        }
    }

    public void addLineByPersonList(List persons, boolean isInsert) throws Exception {
        super.addLineByPersonList(persons, isInsert);
        IRow curRow = null;
        Object personId = null;
        int size = this.kdtEntrys.getRowCount();
        for (int i = 0; i < size; ++i) {
            curRow = this.kdtEntrys.getRow(i);
            this.fillBizDefineByLoanOwnerEnum(curRow);
        }
    }

    @Override
    protected void fillRow(IRow row, Object value, IRow dataRow, int copyCol) throws Exception {
        super.fillRow(row, value, dataRow, copyCol);
        if (copyCol == this.kdtEntrys.getColumn("owner").getColumnIndex()) {
            this.fillBizDefineByLoanOwnerEnum(row);
        }
    }
}

