/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.affair.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.org.PositionException;
import com.kingdee.eas.basedata.org.PositionInfo;
import com.kingdee.eas.basedata.org.PositionMemberCollection;
import com.kingdee.eas.basedata.org.PositionMemberFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.hr.affair.AffairBizException;
import com.kingdee.eas.hr.affair.PluralityAddBizBillEntryInfo;
import com.kingdee.eas.hr.affair.client.HRAffairBillEditUIBiz;
import com.kingdee.eas.hr.affair.client.OrgFullNameRender;
import com.kingdee.eas.hr.base.client.IHRF7CommonRegister;
import com.kingdee.eas.hr.base.client.f7.EditorCreator;
import com.kingdee.eas.hr.emp.PersonPositionInfo;
import com.kingdee.util.DateTimeUtils;
import java.awt.event.ActionEvent;
import java.util.Date;

public class PluralityAddBillEditUIBiz
extends HRAffairBillEditUIBiz {
    @Override
    public void afterOnLoad() throws Exception {
        super.afterOnLoad();
    }

    @Override
    protected void initEditor() throws Exception {
        super.initEditor();
        this.kdtEntrys.getColumn("rzType").setEditor(EditorCreator.getCommonF7CellEditor((String)"com.kingdee.eas.basedata.hraux.app.PersonRZTypeQuery"));
        this.kdtEntrys.getColumn("adminOrg").setRenderer((IBasicRender)new OrgFullNameRender());
        this.kdtEntrys.getColumn("chkLength").setEditor(EditorCreator.getNumberCellEditor((int)3, (int)0, (int)1));
        this.kdtEntrys.getColumn("chkLength").getStyleAttributes().setNumberFormat(EditorCreator.getIntFormatStr());
        this.kdtEntrys.getColumn("chkLength").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
    }

    public void entryEditStopping(KDTEditEvent e) throws Exception {
    }

    public void entryEditStopped(KDTEditEvent e) throws Exception {
    }

    @Override
    protected void positionChanged(IRow row, PositionInfo pInfo) throws Exception {
        super.positionChanged(row, pInfo);
        this.existPosition(row, pInfo.getId().toString(), ((PersonInfo)row.getCell("person").getValue()).getId().toString());
    }

    private void existPosition(IRow row, String positionId, String personId) throws Exception {
        if (positionId == null || personId == null) {
            return;
        }
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = new FilterItemInfo("position.id", (Object)positionId, CompareType.EQUALS);
        filter.getFilterItems().add(filterItem);
        FilterItemInfo filterItem2 = new FilterItemInfo("person.id", (Object)personId, CompareType.EQUALS);
        filter.getFilterItems().add(filterItem2);
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        PositionMemberCollection posiMemColl = PositionMemberFactory.getRemoteInstance().getPositionMemberCollection(view);
        if (posiMemColl != null && posiMemColl.size() > 0) {
            row.getCell("position").setValue(null);
            this.positionChanged(row, null);
            throw new PositionException(PositionException.EXIST_POSITION);
        }
    }

    @Override
    protected String getCompanyCol() {
        return null;
    }

    @Override
    protected String getJobCol() {
        return null;
    }

    @Override
    protected String getJobLevelCol() {
        return null;
    }

    @Override
    protected String getJobGradeCol() {
        return null;
    }

    @Override
    public void registerContextChangeF7(IHRF7CommonRegister register) {
        super.registerContextChangeF7(register);
    }

    @Override
    public boolean isAddPersonByF7() {
        return true;
    }

    @Override
    protected String[] getNotNullColumn() {
        return new String[]{"empNumber", "position", "beginDate", "hrBizDefine"};
    }

    @Override
    protected String[] getNotDupColumn() {
        return new String[]{"person"};
    }

    @Override
    protected IObjectValue createNewDetailData(PersonInfo pInfo) {
        PluralityAddBizBillEntryInfo info = new PluralityAddBizBillEntryInfo();
        info.setPerson(pInfo);
        info.setOldEmpType(pInfo.getEmployeeType());
        PersonPositionInfo ppInfo = (PersonPositionInfo)pInfo.get("personPosition");
        if (ppInfo != null) {
            PositionInfo pstInfo = ppInfo.getPrimaryPosition();
            info.setOldPosition(pstInfo);
            info.setOldAdminOrg(ppInfo.getPersonDep());
        }
        return info;
    }

    protected String getPrintQuery(String dsName) {
        ((Object)((Object)this)).getClass();
        if ("baseInfo".equals(dsName)) {
            return "com.kingdee.eas.hr.affair.app.PluralityAddBizBillPrintQuery";
        }
        ((Object)((Object)this)).getClass();
        if ("approveInfo".equals(dsName)) {
            return "com.kingdee.eas.hr.affair.app.PluralityAddBizBillApprovePrintQuery";
        }
        return null;
    }

    protected String getPrintPath() {
        return "/HR/AffairBiz/PlurAdd";
    }

    @Override
    public void beforeStoreField(ActionEvent e) throws Exception {
        super.beforeStoreField(e);
        StringBuffer sb = new StringBuffer();
        int rowCount = this.kdtEntrys.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            Date beginDate;
            Date endDate;
            IRow row = this.kdtEntrys.getRow(i);
            Object tmpDate = row.getCell("endDate").getValue();
            if (!(tmpDate instanceof Date) || !DateTimeUtils.dayBefore((Date)(endDate = (Date)tmpDate), (Date)(beginDate = (Date)row.getCell("beginDate").getValue()))) continue;
            sb.append(i + 1);
            sb.append("\u3001");
        }
        int length = sb.length();
        if (length > 0) {
            throw new AffairBizException(AffairBizException.PLURALITY_DATE_INVALID, new Object[]{sb.substring(0, length - 1)});
        }
    }

    @Override
    protected String getWFUIFuctionName() {
        return "com.kingdee.eas.hr.affair.app.PluralityAddBizBillEditUIFunction";
    }

    @Override
    protected String positionF7IsShowSealup() {
        return "true";
    }
}

