/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.affair.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.PositionException;
import com.kingdee.eas.basedata.org.PositionInfo;
import com.kingdee.eas.basedata.org.PositionMemberCollection;
import com.kingdee.eas.basedata.org.PositionMemberFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.hr.affair.ReinviteBizBillEntryInfo;
import com.kingdee.eas.hr.affair.client.HRAffairBillEditUIBiz;
import com.kingdee.eas.hr.affair.client.OrgFullNameRender;
import com.kingdee.eas.hr.base.client.IHRF7CommonRegister;
import com.kingdee.eas.hr.base.client.f7.EditorCreator;
import com.kingdee.eas.hr.emp.PersonPositionInfo;

public class ReinviteBillEditUIBiz
extends HRAffairBillEditUIBiz {
    protected ReinviteBizBillEntryInfo entryInfo = new ReinviteBizBillEntryInfo();

    @Override
    public void afterOnLoad() throws Exception {
        super.afterOnLoad();
    }

    @Override
    protected void initEditor() throws Exception {
        super.initEditor();
        this.kdtEntrys.getColumn("adminOrg").setRenderer((IBasicRender)new OrgFullNameRender());
        this.kdtEntrys.getColumn("enrollDate").setEditor(EditorCreator.getDateCellEditor());
    }

    public void entryEditStopping(KDTEditEvent e) throws Exception {
    }

    public void entryEditStopped(KDTEditEvent e) throws Exception {
    }

    @Override
    protected void positionChanged(IRow row, PositionInfo pInfo) throws Exception {
        super.positionChanged(row, pInfo);
        if (row.getCell("person").getValue() != null) {
            this.existPosition(row, pInfo.getId().toString(), ((PersonInfo)row.getCell("person").getValue()).getId().toString());
        }
    }

    private void existPosition(IRow row, String positionId, String personId) throws Exception {
        if (positionId == null || personId == null) {
            return;
        }
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = new FilterItemInfo("position.id", (Object)positionId, CompareType.EQUALS);
        filter.getFilterItems().add(filterItem);
        FilterItemInfo filterItem2 = new FilterItemInfo("person.id", (Object)personId, CompareType.EQUALS);
        filter.getFilterItems().add(filterItem2);
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        PositionMemberCollection posiMemColl = PositionMemberFactory.getRemoteInstance().getPositionMemberCollection(view);
        if (posiMemColl != null && posiMemColl.size() > 0) {
            row.getCell("position").setValue(null);
            this.positionChanged(row, null);
            throw new PositionException(PositionException.EXIST_POSITION);
        }
    }

    @Override
    protected String getCompanyCol() {
        return null;
    }

    @Override
    protected String getJobCol() {
        return null;
    }

    @Override
    protected String getJobLevelCol() {
        return null;
    }

    @Override
    protected String getJobGradeCol() {
        return null;
    }

    @Override
    public void registerContextChangeF7(IHRF7CommonRegister register) {
        super.registerContextChangeF7(register);
    }

    @Override
    public boolean isAddPersonByF7() {
        return true;
    }

    @Override
    protected String[] getNotNullColumn() {
        return new String[]{"empNumber", "position", "bizDate", "empType", "hrBizDefine"};
    }

    @Override
    protected String[] getNotDupColumn() {
        return new String[]{"person"};
    }

    @Override
    protected IObjectValue createNewDetailData(PersonInfo pInfo) {
        ReinviteBizBillEntryInfo info = new ReinviteBizBillEntryInfo();
        info.setId(BOSUuid.create((BOSObjectType)info.getBOSType()));
        info.setPerson(pInfo);
        info.setOldEmpType(pInfo.getEmployeeType());
        PersonPositionInfo ppInfo = (PersonPositionInfo)pInfo.get("personPosition");
        if (ppInfo != null) {
            PositionInfo pstInfo = ppInfo.getPrimaryPosition();
            info.setOldPosition(pstInfo);
            info.setOldAdminOrg(ppInfo.getPersonDep());
            info.setEnterDateHis(ppInfo.getEnterDate());
        }
        return info;
    }

    @Override
    protected void initEmpF7() {
        super.initEmpF7();
        this.empF7.showNoPositionPerson(true);
    }

    protected String getPrintQuery(String dsName) {
        ((Object)((Object)this)).getClass();
        if ("baseInfo".equals(dsName)) {
            return "com.kingdee.eas.hr.affair.app.ReinviteBizBillPrintQuery";
        }
        ((Object)((Object)this)).getClass();
        if ("approveInfo".equals(dsName)) {
            return "com.kingdee.eas.hr.affair.app.ReinviteBizBillApprovePrintQuery";
        }
        return null;
    }

    protected String getPrintPath() {
        return "/HR/AffairBiz/EmpReinvite";
    }

    @Override
    protected String getWFUIFuctionName() {
        return "com.kingdee.eas.hr.affair.app.ReinviteBizBillEditUIFunction";
    }

    @Override
    protected String positionF7IsShowSealup() {
        return "true";
    }
}

