/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.affair.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.data.datasource.BOSQueryDataSource;
import com.kingdee.bos.ctrl.kdf.data.impl.BOSQueryDelegate;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.KDNoteHelper;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.ui.util.IUIActionPostman;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.HROrgUnitFactory;
import com.kingdee.eas.basedata.org.HROrgUnitInfo;
import com.kingdee.eas.basedata.org.PositionInfo;
import com.kingdee.eas.basedata.org.client.f7.AdminByCurrentHROF7WithOrgRangeFilter;
import com.kingdee.eas.basedata.org.client.f7.AdminByHROF7;
import com.kingdee.eas.basedata.person.Genders;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.eas.hr.affair.AffairRegFacadeFactory;
import com.kingdee.eas.hr.affair.AffairTypeEnum;
import com.kingdee.eas.hr.affair.ApproveStateEnum;
import com.kingdee.eas.hr.affair.HRAffairException;
import com.kingdee.eas.hr.affair.HRAffairState;
import com.kingdee.eas.hr.affair.IAffairRegFacade;
import com.kingdee.eas.hr.affair.IResignBill;
import com.kingdee.eas.hr.affair.ResignBillEntryInfo;
import com.kingdee.eas.hr.affair.ResignBillFactory;
import com.kingdee.eas.hr.affair.ResignBillInfo;
import com.kingdee.eas.hr.affair.client.AbstractResignBillSelfEditUI;
import com.kingdee.eas.hr.affair.client.HRAffairClientUtils;
import com.kingdee.eas.hr.affair.util.AffairUtil;
import com.kingdee.eas.hr.base.DimissionReasonFactory;
import com.kingdee.eas.hr.base.DimissionReasonInfo;
import com.kingdee.eas.hr.base.DimissionReasonTypeInfo;
import com.kingdee.eas.hr.base.TechnicalPostInfo;
import com.kingdee.eas.hr.base.client.CustomerSettingsSwitch;
import com.kingdee.eas.hr.base.client.IHRF7CommonRegister;
import com.kingdee.eas.hr.emp.PersonPositionInfo;
import com.kingdee.eas.hr.emp.client.EmployeeMultiF7PromptBox;
import com.kingdee.eas.hr.org.client.AdminByOrgRangePromptBox;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import javax.swing.ComboBoxModel;
import javax.swing.SwingUtilities;

public class ResignBillSelfEditUI
extends AbstractResignBillSelfEditUI {
    protected BOSUuid entryId = null;
    private KDNoteHelper appHlp = new KDNoteHelper();
    private String resClass = "com.kingdee.eas.hr.affair.HRAffairResource.";
    public static final String RESIGN_FILENAME = "/HR/OrgUnit/ResignBill";
    private BOSUuid actPersonId;
    private String billId;
    private DimissionReasonTypeInfo reasonTypeType = null;
    private BOSUuid actEntryId;
    private boolean deleteFlag = false;

    protected void lockUIForViewStatus() {
        super.lockUIForViewStatus();
        this.txtPhone.setEditable(false);
        this.prmtReasonType.setEnabled(false);
        this.dateDesireDate.setEnabled(false);
        this.comboGender.setEnabled(false);
        this.txtRemark.setEditable(false);
        this.txtReason.setEditable(false);
        this.txtSuggestion.setEditable(false);
        this.dateDesireDate.setRequired(false);
        this.prmtNominalDept.setEnabled(false);
    }

    private void setEnableByClient() {
        String clientName = null;
        try {
            clientName = AffairUtil.getCurrentClientName();
        }
        catch (EASBizException e) {
            this.handUIException(e);
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        if ("hnjt".equals(clientName)) {
            this.kDBizPromptBox2.setVisible(true);
            this.kDBizPromptBox1.setVisible(true);
            this.kDLabelContainer1.setVisible(true);
            this.kDLabelContainer2.setVisible(true);
        } else {
            this.kDBizPromptBox2.setVisible(false);
            this.kDBizPromptBox1.setVisible(false);
            this.kDLabelContainer1.setVisible(false);
            this.kDLabelContainer2.setVisible(false);
        }
    }

    @Override
    protected IObjectValue createNewData() {
        ResignBillInfo info = new ResignBillInfo();
        info.setIsMultiEntry(false);
        info.setApplyDate(DateTimeUtils.truncateDate((Date)new Date()));
        if (this.nowDate != null) {
            info.setApplyDate(this.nowDate);
        }
        return info;
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return ResignBillFactory.getRemoteInstanceWithObjectContext(this.getMainOrgContext());
    }

    @Override
    public void loadFields() {
        super.loadFields();
        if (this.editData.getEntries() != null && this.editData.getEntries().size() > 0) {
            ResignBillEntryInfo info = this.editData.getEntries().get(0);
            this.comboGender.setSelectedItem((Object)info.getGender());
            this.txtIDCardNO.setText(info.getIdCardNO());
            this.txtDegree.setText(info.getDegree());
            this.dateBirthday.setValue((Object)info.getBirthday());
            this.txtServiceYear.setText(String.valueOf(info.getServiceYear()));
            this.txtPosition.setText(info.getPosition());
            this.prmptPosition.setData((Object)info.getEposition());
            this.txtJobTitle.setText(info.getJobTitle());
            this.txtGraduateSchool.setText(info.getGraduateSchool());
            this.txtSpecialty.setText(info.getSpecialty());
            this.dateEnrollDate.setValue((Object)info.getEnrollDate());
            this.datePositionDate.setValue((Object)info.getPositionDate());
            this.dateDesireDate.setValue((Object)info.getDesireDate());
            this.txtRemark.setText(info.getRemark());
            this.prmtReasonType.setData((Object)info.getReasonType());
            this.reasonTypeType = info.getReasonTypeType();
            this.txtReason.setText(info.getReason());
            this.txtSuggestion.setText(info.getSuggestion());
            this.pInfo = info.getPerson();
            this.personId = this.pInfo.getId();
            this.entryId = info.getId();
            this.prmtNominalDept.setValue((Object)info.getPersonDep());
            this.kDBizPromptBox1.setValue((Object)info.getDeptDirector());
            this.kDBizPromptBox2.setValue((Object)info.getChargeLeader());
            this.actEntryId = info.getId();
            this.actPersonId = this.personId;
            if (this.editData.getId() != null) {
                this.billId = this.editData.getId().toString();
            }
        }
    }

    protected void initOrgContextManager() {
    }

    @Override
    protected void registerContextChangeF7(IHRF7CommonRegister register) {
        this.promptOrg.setSelector((KDPromptSelector)new AdminByOrgRangePromptBox((IUIObject)this));
        this.promptOrg.setEditable(false);
    }

    private void setF7CU() throws Exception {
        CtrlUnitInfo ctrlInfo = null;
        HROrgUnitInfo hrOrg = (HROrgUnitInfo)this.prmtHROrg.getValue();
        if (hrOrg != null) {
            if (hrOrg.getCU() == null) {
                SelectorItemCollection selector = new SelectorItemCollection();
                selector.add(new SelectorItemInfo("id"));
                selector.add(new SelectorItemInfo("cu.id"));
                selector.add(new SelectorItemInfo("cu.name"));
                selector.add(new SelectorItemInfo("cu.longNumber"));
                ctrlInfo = HROrgUnitFactory.getRemoteInstance().getHROrgUnitInfo((IObjectPK)new ObjectUuidPK(hrOrg.getId()), selector).getCU();
            } else {
                ctrlInfo = hrOrg.getCU();
            }
        } else {
            ctrlInfo = SysContext.getSysContext().getCurrentCtrlUnit();
        }
        if (ctrlInfo != null) {
            this.prmtReasonType.setCurrentCtrlUnit(ctrlInfo);
        }
    }

    @Override
    public void onLoad() throws Exception {
        if (this.getOprtState() == null || "null".equalsIgnoreCase(this.getOprtState())) {
            this.setOprtState(OprtState.ADDNEW);
            this.getUIContext().put("ID", null);
        }
        this.kdtEntries.setVisible(false);
        this.comboGender.setModel((ComboBoxModel)HRAffairClientUtils.getGenderModel());
        this.prmtReasonType.setQueryInfo("com.kingdee.eas.hr.base.app.DimissionReasonQuery");
        this.prmtReasonType.setDisplayFormat("$name$");
        this.prmtReasonType.setEditFormat("$number$");
        this.prmtReasonType.setCommitFormat("$number$");
        super.onLoad();
        if (null == this.editData.getId()) {
            this.actionRemove.setEnabled(false);
        }
        this.setF7CU();
        if (OprtState.ADDNEW.equals(this.getOprtState())) {
            PersonPositionInfo ppInfo;
            HRAffairClientUtils.checkIsPersonInProcess(this.editData.getBOSType(), new ResignBillEntryInfo().getBOSType(), this.pInfo, "");
            String personId = this.pInfo.getId().toString();
            this.dateBirthday.setValue((Object)this.pInfo.getBirthday());
            this.txtIDCardNO.setText(this.pInfo.getIdCardNO());
            this.comboGender.setSelectedItem((Object)this.pInfo.getGender());
            ArrayList degreeRelInfo = HRAffairClientUtils.getDegreeRelInfo(personId);
            if (degreeRelInfo != null) {
                this.txtDegree.setText((String)degreeRelInfo.get(0));
                this.txtGraduateSchool.setText((String)degreeRelInfo.get(1));
                this.txtSpecialty.setText((String)degreeRelInfo.get(2));
            }
            if ((ppInfo = HRAffairClientUtils.getPersonPositionInfo(personId)) != null && ppInfo.getEnterDate() != null) {
                this.dateEnrollDate.setValue((Object)ppInfo.getEnterDate());
                this.txtServiceYear.setText(HRAffairClientUtils.getYearDif(ppInfo.getEnterDate(), new Date()).toString());
            } else {
                this.dateEnrollDate.setValue(null);
            }
            if (this.postRelInfo != null) {
                this.txtPosition.setText(this.postRelInfo.getPosition().getName());
                this.prmptPosition.setData((Object)this.postRelInfo.getPosition());
                this.datePositionDate.setValue((Object)this.postRelInfo.getBeginDate());
                TechnicalPostInfo jobTitleInfo = HRAffairClientUtils.getJobTitle(personId);
                if (jobTitleInfo != null) {
                    this.txtJobTitle.setText(jobTitleInfo.getName());
                }
            }
        }
        this.kdtEntries.setColumnMoveable(true);
        Object f7 = null;
        f7 = this.getCurrentHRO() != null ? new AdminByHROF7((IUIObject)this, this.getCurrentHRO().getId().toString()) : new AdminByCurrentHROF7WithOrgRangeFilter((IUIObject)this);
        int param = CustomerSettingsSwitch.getInstance().getFunctionParamValue("RESIGN_BILL");
        if (0 == param) {
            f7 = new AdminByOrgRangePromptBox((IUIObject)this);
        }
        this.prmtNominalDept.setSelector((KDPromptSelector)f7);
        this.prmtNominalDept.setEditable(false);
        EmployeeMultiF7PromptBox select = new EmployeeMultiF7PromptBox((IUIObject)this);
        select.setIsSingleSelect(true);
        this.kDBizPromptBox1.setSelector((KDPromptSelector)select);
        this.kDBizPromptBox1.setEditFormat("$number$");
        this.kDBizPromptBox1.setCommitFormat("$number$");
        this.kDBizPromptBox1.setDisplayFormat("$name$");
        this.kDBizPromptBox1.setQueryInfo("com.kingdee.eas.basedata.person.app.PersonQuery");
        this.kDBizPromptBox1.setEditable(true);
        this.kDBizPromptBox2.setSelector((KDPromptSelector)select);
        this.kDBizPromptBox2.setEditFormat("$number$");
        this.kDBizPromptBox2.setCommitFormat("$number$");
        this.kDBizPromptBox2.setDisplayFormat("$name$");
        this.kDBizPromptBox2.setQueryInfo("com.kingdee.eas.basedata.person.app.PersonQuery");
        this.kDBizPromptBox2.setEditable(true);
        this.setEnableByClient();
        this.setComboSubmitTypeValueByParam("Res001");
    }

    @Override
    public void storeFields() {
        super.storeFields();
        this.editData.setProposer(this.pInfo);
        this.editData.setApproveState((ApproveStateEnum)((Object)this.comboSubmitType.getSelectedItem()));
        this.editData.setIsMultiEntry(false);
        ResignBillEntryInfo info = null;
        if (this.editData.getEntries() != null && this.editData.getEntries().size() > 0) {
            info = this.editData.getEntries().get(0);
        } else {
            info = new ResignBillEntryInfo();
            this.editData.getEntries().add(info);
        }
        info.setPerson(this.pInfo);
        if (this.comboGender.getSelectedItem() != null) {
            info.setGender((Genders)this.comboGender.getSelectedItem());
        }
        info.setBirthday((Date)this.dateBirthday.getValue());
        if (this.txtServiceYear.getText() != null && this.txtServiceYear.getText().trim().length() > 0) {
            info.setServiceYear(Integer.valueOf(this.txtServiceYear.getText()));
        }
        info.setIdCardNO(this.txtIDCardNO.getText());
        info.setPosition(this.txtPosition.getText());
        info.setEposition((PositionInfo)this.prmptPosition.getData());
        info.setJobTitle(this.txtJobTitle.getText());
        info.setGraduateSchool(this.txtGraduateSchool.getText());
        info.setDegree(this.txtDegree.getText());
        info.setSpecialty(this.txtSpecialty.getText());
        info.setPositionDate((Date)this.datePositionDate.getValue());
        info.setEnrollDate((Date)this.dateEnrollDate.getValue());
        info.setDesireDate((Date)this.dateDesireDate.getValue());
        info.setReason(this.txtReason.getText());
        if (this.prmtReasonType.getData() != null) {
            DimissionReasonInfo diReason = (DimissionReasonInfo)this.prmtReasonType.getData();
            info.setReasonType(diReason);
            if (diReason.getDimissionReasonType() == null) {
                try {
                    diReason = DimissionReasonFactory.getRemoteInstance().getDimissionReasonInfo((IObjectPK)new ObjectUuidPK(diReason.getId()), this.getDiReasonSelectors());
                }
                catch (Exception e) {
                    this.handUIException(e);
                }
            }
            this.reasonTypeType = diReason.getDimissionReasonType();
            info.setReasonTypeType(this.reasonTypeType);
        }
        info.setSuggestion(this.txtSuggestion.getText());
        if (this.entryId != null) {
            info.setId(this.entryId);
        }
        info.setRemark(this.txtRemark.getText());
        if (this.prmtNominalDept.getValue() != null) {
            info.setPersonDep((AdminOrgUnitInfo)this.prmtNominalDept.getValue());
        }
        if (this.kDBizPromptBox1.getValue() != null) {
            info.setDeptDirector((PersonInfo)this.kDBizPromptBox1.getValue());
        }
        if (this.kDBizPromptBox2.getValue() != null) {
            info.setChargeLeader((PersonInfo)this.kDBizPromptBox1.getValue());
        }
        String versionStr = null;
        try {
            versionStr = AffairUtil.getCurrentClientName();
        }
        catch (EASBizException e) {
            this.handUIException(e);
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        if (versionStr != null && versionStr.equals("hnjt") && this.editData.getBizState().equals((Object)HRAffairState.COMPLETE) && OprtState.VIEW.equals(this.getOprtState())) {
            this.btnAffairReg.setEnabled(true);
            this.btnAffairReg.setVisible(true);
        }
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("adminOrg.id"));
        sic.add(new SelectorItemInfo("adminOrg.name"));
        sic.add(new SelectorItemInfo("adminOrg.number"));
        sic.add(new SelectorItemInfo("hrOrgUnit.id"));
        sic.add(new SelectorItemInfo("hrOrgUnit.name"));
        sic.add(new SelectorItemInfo("hrOrgUnit.number"));
        sic.add(new SelectorItemInfo("hrOrgUnit.CU.id"));
        sic.add(new SelectorItemInfo("hrOrgUnit.CU.number"));
        sic.add(new SelectorItemInfo("hrOrgUnit.CU.name"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("proposer.name"));
        sic.add(new SelectorItemInfo("proposer.id"));
        sic.add(new SelectorItemInfo("proposer.number"));
        sic.add(new SelectorItemInfo("dept"));
        sic.add(new SelectorItemInfo("phone"));
        sic.add(new SelectorItemInfo("applyDate"));
        sic.add(new SelectorItemInfo("isMultiEntry"));
        sic.add(new SelectorItemInfo("bizState"));
        sic.add(new SelectorItemInfo("approveState"));
        sic.add(new SelectorItemInfo("submitState"));
        sic.add(new SelectorItemInfo("entries.person.name"));
        sic.add(new SelectorItemInfo("entries.person.id"));
        sic.add(new SelectorItemInfo("entries.person.number"));
        sic.add(new SelectorItemInfo("entries.gender"));
        sic.add(new SelectorItemInfo("entries.desireDate"));
        sic.add(new SelectorItemInfo("entries.phone"));
        sic.add(new SelectorItemInfo("entries.reasonType.id"));
        sic.add(new SelectorItemInfo("entries.reasonType.number"));
        sic.add(new SelectorItemInfo("entries.reasonType.name"));
        sic.add(new SelectorItemInfo("entries.reasonType.dimissionReasonType.id"));
        sic.add(new SelectorItemInfo("entries.reasonType.dimissionReasonType.name"));
        sic.add(new SelectorItemInfo("entries.reasonType.dimissionReasonType.number"));
        sic.add(new SelectorItemInfo("entries.reasonTypeType.id"));
        sic.add(new SelectorItemInfo("entries.reasonTypeType.number"));
        sic.add(new SelectorItemInfo("entries.reasonTypeType.name"));
        sic.add(new SelectorItemInfo("entries.reason"));
        sic.add(new SelectorItemInfo("entries.suggestion"));
        sic.add(new SelectorItemInfo("entries.remark"));
        sic.add(new SelectorItemInfo("entries.dept"));
        sic.add(new SelectorItemInfo("entries.position"));
        sic.add(new SelectorItemInfo("entries.jobTitle"));
        sic.add(new SelectorItemInfo("entries.idCardNO"));
        sic.add(new SelectorItemInfo("entries.birthday"));
        sic.add(new SelectorItemInfo("entries.graduateSchool"));
        sic.add(new SelectorItemInfo("entries.specialty"));
        sic.add(new SelectorItemInfo("entries.degree"));
        sic.add(new SelectorItemInfo("entries.enrollDate"));
        sic.add(new SelectorItemInfo("entries.positionDate"));
        sic.add(new SelectorItemInfo("entries.serviceYear"));
        sic.add(new SelectorItemInfo("entries.deptDirector.id"));
        sic.add(new SelectorItemInfo("entries.deptDirector.name"));
        sic.add(new SelectorItemInfo("entries.deptDirector.number"));
        sic.add(new SelectorItemInfo("entries.chargeLeader.id"));
        sic.add(new SelectorItemInfo("entries.chargeLeader.number"));
        sic.add(new SelectorItemInfo("entries.chargeLeader.name"));
        sic.add(new SelectorItemInfo("entries.eposition.id"));
        sic.add(new SelectorItemInfo("entries.eposition.number"));
        sic.add(new SelectorItemInfo("entries.eposition.name"));
        sic.add(new SelectorItemInfo("entries.personDep.id"));
        sic.add(new SelectorItemInfo("entries.personDep.number"));
        sic.add(new SelectorItemInfo("entries.personDep.name"));
        return sic;
    }

    @Override
    protected void beforeStoreFields(ActionEvent e) throws Exception {
        super.beforeStoreFields(e);
        if (this.prmtReasonType.getData() == null) {
            this.prmtReasonType.requestFocusInWindow();
            throw new HRAffairException(HRAffairException.RESIGN_REASONTYPE_NOT_NULL);
        }
        if (this.txtReason.getText() == null || this.txtReason.getText().trim().length() == 0) {
            this.txtReason.requestFocusInWindow();
            throw new HRAffairException(HRAffairException.RESIGN_REASON_NOT_NULL);
        }
        if (this.dateDesireDate.getValue() == null) {
            this.dateDesireDate.requestFocusInWindow();
            throw new HRAffairException(HRAffairException.NOT_NULL, new Object[]{this.lblDesireDate.getBoundLabelText()});
        }
        if (this.prmtNominalDept.getValue() == null) {
            this.prmtNominalDept.requestFocusInWindow();
            throw new HRAffairException(HRAffairException.NOT_NULL, new Object[]{this.kDLabelContainer3.getBoundLabelText()});
        }
        if (HRAffairClientUtils.isDateBeforeEnrollDate(this.pInfo.getId().toString(), (Date)this.dateDesireDate.getValue())) {
            this.dateDesireDate.requestFocusInWindow();
            throw new HRAffairException(HRAffairException.CAN_NOT_BEFORE_ENROLLDATE, new Object[]{this.lblDesireDate.getBoundLabelText(), ""});
        }
    }

    public IObjectPK runSubmit() throws Exception {
        return ((IResignBill)this.getBizInterface()).submit2((CoreBaseInfo)this.editData);
    }

    @Override
    protected BOSObjectType getBillBOSType() {
        return new ResignBillInfo().getBOSType();
    }

    @Override
    public void actionAffairReg_actionPerformed(ActionEvent e) throws Exception {
        if (this.actPersonId != null && this.actEntryId != null && this.billId != null) {
            DataProvider data = new DataProvider();
            this.appHlp.printPreview(RESIGN_FILENAME, (Object)data, (Component)SwingUtilities.getWindowAncestor((Component)((Object)this)));
        } else {
            MsgBox.showInfo((String)EASResource.getString((String)(this.resClass + "NO_SELECT_ROW")));
        }
    }

    @Override
    protected void initWorkButton() {
        super.initWorkButton();
        this.btnCopySelect.setVisible(false);
        this.promptOrg.setEnabled(false);
    }

    @Override
    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        super.actionRemove_actionPerformed(e);
        if (this.deleteFlag) {
            this.getUIWindow().close();
        }
    }

    @Override
    protected boolean confirmRemove() {
        if (MsgBox.isYes((int)MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Confirm_Delete")))) {
            this.deleteFlag = true;
            return true;
        }
        this.deleteFlag = false;
        return false;
    }

    @Override
    public boolean isPrepareInit() {
        return true;
    }

    @Override
    public IUIActionPostman prepareInit() {
        IUIActionPostman handler = super.prepareInit();
        RequestContext request = (RequestContext)handler.getRequestContext();
        request.put("kdtIsVisible", (Object)this.kdtEntries.isVisible());
        request.put("nowClientDate", (Object)this.nowDate);
        handler.setRequestContext((Serializable)request);
        return handler;
    }

    private SelectorItemCollection getDiReasonSelectors() {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("name"));
        selector.add(new SelectorItemInfo("number"));
        selector.add(new SelectorItemInfo("dimissionReasonType.id"));
        selector.add(new SelectorItemInfo("dimissionReasonType.name"));
        selector.add(new SelectorItemInfo("dimissionReasonType.number"));
        return selector;
    }

    @Override
    protected void handlePermissionForItemAction(ItemAction action) {
    }

    public class DataProvider
    implements BOSQueryDelegate {
        public IRowSet execute(BOSQueryDataSource ds) {
            try {
                if (ResignBillSelfEditUI.this.billId != null) {
                    IAffairRegFacade iAffairReg = AffairRegFacadeFactory.getRemoteInstance();
                    if (ds.getID() != null) {
                        if (ds.getID().equals("ds6")) {
                            return iAffairReg.getAffairBillRegByEntry(AffairTypeEnum.RESIGN, ResignBillSelfEditUI.this.actEntryId, BOSUuid.read((String)ResignBillSelfEditUI.this.billId));
                        }
                        if (ds.getID().equals("ds7")) {
                            return iAffairReg.getMultiApproveDecByPerson(AffairTypeEnum.RESIGN, ResignBillSelfEditUI.this.actPersonId, BOSUuid.read((String)ResignBillSelfEditUI.this.billId));
                        }
                    }
                }
            }
            catch (BOSException e) {
                ResignBillSelfEditUI.this.handUIException(e);
            }
            catch (EASBizException e) {
                ResignBillSelfEditUI.this.handUIException(e);
            }
            return null;
        }
    }
}

