/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.affair.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.workflow.ProcessInstInfo;
import com.kingdee.bos.workflow.define.ApplicationDef;
import com.kingdee.bos.workflow.define.FunctionDef;
import com.kingdee.bos.workflow.define.ToolActivityDef;
import com.kingdee.bos.workflow.enactment.WfActivity;
import com.kingdee.bos.workflow.enactment.WfEngine;
import com.kingdee.bos.workflow.service.ormrpc.EnactmentServiceFactory;
import com.kingdee.bos.workflow.service.ormrpc.IEnactmentService;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.affair.HRAffairBillSuspendRecordFactory;
import com.kingdee.eas.hr.affair.HRAffairBillSuspendRecordInfo;
import com.kingdee.eas.hr.affair.HRAffairBizBillCollection;
import com.kingdee.eas.hr.affair.IHRAffairBizBill;
import com.kingdee.eas.hr.affair.SuspendRecordStateEnum;
import com.kingdee.eas.hr.base.BillEntryJobProcessCollection;
import com.kingdee.eas.hr.base.BillEntryJobProcessFactory;
import com.kingdee.eas.hr.base.BillEntryJobProcessInfo;
import com.kingdee.eas.hr.base.EmpPosOrgRelationCollection;
import com.kingdee.eas.hr.base.EmpPosOrgRelationFactory;
import com.kingdee.eas.hr.base.app.util.MetaDataServerUtil;
import com.kingdee.eas.hr.base.util.HRUtilExtend;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.ml.util.SHRServerResource;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class HRAffairBillSuspendRecordUtil {
    public static Boolean hrAffairBizBillIsEffective(Context ctx, BOSUuid entryId) throws BOSException {
        Boolean isHRAffairEffective = false;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("flowInAffairID", (Object)entryId.toString()));
        filterInfo.getFilterItems().add(new FilterItemInfo("flowOutAffairID", (Object)entryId.toString()));
        filterInfo.setMaskString("#0 or #1");
        view.setFilter(filterInfo);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        view.setSelector(sic);
        EmpPosOrgRelationCollection empPosOrgRelationCollection = EmpPosOrgRelationFactory.getLocalInstance((Context)ctx).getEmpPosOrgRelationCollection(view);
        if (empPosOrgRelationCollection.size() > 0) {
            isHRAffairEffective = true;
        }
        return isHRAffairEffective;
    }

    public static void updateHRAffairBizBillState(Context ctx, HRAffairBillSuspendRecordInfo hrAffairBillSuspendRecordInfo) throws EASBizException, BOSException {
        hrAffairBillSuspendRecordInfo.setState(SuspendRecordStateEnum.EFFECT);
        BOSUuid billId = hrAffairBillSuspendRecordInfo.getBillId();
        HRAffairBillSuspendRecordFactory.getLocalInstance(ctx).update((IObjectPK)new ObjectUuidPK(billId), hrAffairBillSuspendRecordInfo);
    }

    public static void updateHRAffairBizBillIsDelete(Context ctx, HRAffairBillSuspendRecordInfo hrAffairBillSuspendRecordInfo) throws EASBizException, BOSException {
        hrAffairBillSuspendRecordInfo.setIsDelete(true);
        BOSUuid billId = hrAffairBillSuspendRecordInfo.getBillId();
        HRAffairBillSuspendRecordFactory.getLocalInstance(ctx).update((IObjectPK)new ObjectUuidPK(billId), hrAffairBillSuspendRecordInfo);
    }

    public static void ProcessingBackgroundHRAffairBill(Context ctx, HRAffairBillSuspendRecordInfo hrAffairBillSuspendRecordInfo) throws BOSException, EASBizException {
        BOSUuid entryId = hrAffairBillSuspendRecordInfo.getEntryId();
        BOSUuid billId = hrAffairBillSuspendRecordInfo.getBillId();
        IHRAffairBizBill iHRAffairBizBill = (IHRAffairBizBill)MetaDataServerUtil.getBizInterface((Context)ctx, (BOSObjectType)billId.getType());
        BillEntryJobProcessCollection bejpCol = BillEntryJobProcessFactory.getLocalInstance((Context)ctx).getBillEntryJobProcessCollection("select jobProcessId where billEntryId = '" + entryId.toString() + "'");
        Map<String, String> map = HRAffairBillSuspendRecordUtil.getLastJobinstid(ctx, bejpCol);
        String jobinstid = HRAffairBillSuspendRecordUtil.getKey(map);
        String state = HRAffairBillSuspendRecordUtil.getValue(map);
        String triggerValid = HRAffairBillSuspendRecordUtil.getTriggerValid(ctx, jobinstid);
        if (triggerValid.equals("X") && !StringUtils.isEmpty((String)jobinstid) && !StringUtils.isEmpty((String)state) && state.equalsIgnoreCase("Failed")) {
            iHRAffairBizBill.entryEffect(entryId);
            HRAffairBillSuspendRecordUtil.handleJobProcessSuccess(ctx, jobinstid);
            HRAffairBillSuspendRecordUtil.updateHRAffairBizBillState(ctx, hrAffairBillSuspendRecordInfo);
        }
    }

    public static void ProcessPendingHRAffairBill(Context ctx, HRAffairBillSuspendRecordInfo hrAffairBillSuspendRecordInfo) throws BOSException, EASBizException {
        BOSUuid billId = hrAffairBillSuspendRecordInfo.getBillId();
        String procInstId = HRAffairBillSuspendRecordUtil.getProcInstId(ctx, billId.toString());
        if (!StringUtils.isEmpty((String)procInstId)) {
            String sql = "SELECT FACTINSTID as actInstId, FSTATE as state FROM T_WFR_ActInst WHERE FPROCINSTID in ('" + procInstId + "') and (FSTATE = 'open.not_running.suspended' or FSTATE = 'open.not_running.blocked')";
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
            try {
                if (rs.next()) {
                    ToolActivityDef definition;
                    ApplicationDef relatedApplication;
                    FunctionDef function;
                    String operation;
                    WfActivity activityInst;
                    String wfState = rs.getString("state");
                    String actInstId = rs.getString("actInstId");
                    if (("open.not_running.suspended".equals(wfState) || "open.not_running.blocked".equals(wfState)) && (activityInst = WfEngine.getEngine((Context)ctx).getActivityInst(actInstId)).getDefinition() != null && activityInst.getDefinition() instanceof ToolActivityDef && !StringUtils.isEmpty((String)(operation = (function = (relatedApplication = (definition = (ToolActivityDef)activityInst.getDefinition()).getRelatedApplication()).getFunction()).getOperation())) && operation.equals("ActionSetAudited")) {
                        IEnactmentService enactmentService = EnactmentServiceFactory.createEnactService((Context)ctx);
                        enactmentService.resumeProcessInst(procInstId);
                        HRAffairBillSuspendRecordUtil.updateHRAffairBizBillState(ctx, hrAffairBillSuspendRecordInfo);
                    }
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
                throw new BOSException(e.getMessage(), (Throwable)e);
            }
        }
    }

    public static HRAffairBizBillCollection getHRAffairBizBillCollection(Context ctx, BOSUuid billId) throws BOSException {
        IHRAffairBizBill iHRAffairBizBill = (IHRAffairBizBill)MetaDataServerUtil.getBizInterface((Context)ctx, (BOSObjectType)billId.getType());
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)billId.toString()));
        view.setFilter(filterInfo);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("billState"));
        view.setSelector(sic);
        HRAffairBizBillCollection hrAffairBizBillCollection = iHRAffairBizBill.getHRAffairBizBillCollection(view);
        return hrAffairBizBillCollection;
    }

    public static Map<String, String> getLastJobinstid(Context ctx, BillEntryJobProcessCollection bejpCol) throws BOSException {
        StringBuffer jobProcessIdStr = new StringBuffer();
        HashMap<String, String> map = new HashMap<String, String>();
        int size = bejpCol.size();
        for (int i = 0; i < size; ++i) {
            BillEntryJobProcessInfo bejpInfo = bejpCol.get(i);
            jobProcessIdStr.append("'");
            jobProcessIdStr.append(bejpInfo.getJobProcessId());
            if (i == size - 1) {
                jobProcessIdStr.append("'");
                continue;
            }
            jobProcessIdStr.append("',");
        }
        if (jobProcessIdStr == null || jobProcessIdStr.length() == 0) {
            return map;
        }
        String jobinstid = "";
        String state = "";
        String sql = "SELECT fjobinstid as jobinstid, fstate as state FROM t_job_inst WHERE fjobdefid in (" + jobProcessIdStr + ") order by fcreatedtime desc";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        try {
            if (rs.next()) {
                jobinstid = rs.getString("jobinstid");
                state = rs.getString("state");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        if (!StringUtils.isEmpty((String)jobinstid)) {
            map.put(jobinstid, state);
        }
        return map;
    }

    public static String getTriggerValid(Context ctx, String jobinstid) throws BOSException {
        String isValid = "";
        String sql = "SELECT jobtrigger.FID as id, jobtrigger.FISVALID as isValid FROM T_JOB_TRIGGER jobtrigger  LEFT OUTER JOIN t_job_inst inst on jobtrigger.FJOBDEFID = inst.FJOBDEFID  where inst.FJOBINSTID = '" + jobinstid + "'";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        try {
            if (rs.next()) {
                isValid = rs.getString("isValid");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        return isValid;
    }

    public static void handleJobProcessSuccess(Context ctx, String jobinstid) throws EASBizException, BOSException {
        if (!StringUtils.isEmpty((String)jobinstid)) {
            String date = HRUtilExtend.getDateStringWithMinute((Date)new Date());
            String exception = MessageFormat.format(SHRServerResource.getString((String)"com.kingdee.eas.hr.affair.AffairBizResource", (String)"label24", (Context)ctx), date);
            String updateSql = "update t_job_inst SET fstate = 'Complete', fexception = '" + exception + "' where fjobinstid = '" + jobinstid + "'";
            DbUtil.execute((Context)ctx, (String)updateSql);
        }
    }

    public static String getKey(Map<String, String> map) {
        String jobinstid = "";
        for (Map.Entry<String, String> entry : map.entrySet()) {
            jobinstid = entry.getKey();
        }
        return jobinstid;
    }

    public static String getValue(Map<String, String> map) {
        String state = "";
        for (Map.Entry<String, String> entry : map.entrySet()) {
            state = entry.getValue();
        }
        return state;
    }

    public static String getProcInstId(Context ctx, String billId) throws BOSException {
        if (billId == null) {
            return null;
        }
        String procInstId = null;
        IEnactmentService svc = EnactmentServiceFactory.createEnactService((Context)ctx);
        ProcessInstInfo[] infos = svc.getProcessInstanceByHoldedObjectId(billId);
        if (infos != null && infos.length > 0) {
            Timestamp d = null;
            int n = infos.length;
            for (int i = 0; i < n; ++i) {
                Timestamp tmp = infos[i].getCreatedTime();
                if (d != null && !tmp.after((Date)d)) continue;
                d = tmp;
                procInstId = infos[i].getProcInstId();
            }
        } else {
            infos = svc.getAllProcessInstancesByBizobjId(billId);
            String procInstIdTemp = null;
            Timestamp d = null;
            if (infos == null) {
                return procInstId;
            }
            for (int i = 0; i < infos.length; ++i) {
                if (infos[i].getParentProcInstId() != null) {
                    procInstIdTemp = infos[i].getProcInstId();
                    continue;
                }
                Timestamp tmp = infos[i].getCreatedTime();
                if (d != null && !tmp.after((Date)d)) continue;
                d = tmp;
                procInstId = infos[i].getProcInstId();
            }
            if (StringUtils.isEmpty(procInstId)) {
                procInstId = procInstIdTemp;
            }
        }
        return procInstId;
    }
}

