/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.affair.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserCollection;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.PositionInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.hr.affair.EmpEnrollBizBillEntryInfo;
import com.kingdee.eas.hr.affair.HRAffairBizBillEntryInfo;
import com.kingdee.eas.hr.affair.client.EmpEnrollBizBillEditUI;
import com.kingdee.eas.hr.base.HrInheritUserCurrentPermTransfer;
import com.kingdee.eas.hr.base.HrInheritUserHistoryPermTranfser;
import com.kingdee.eas.hr.base.IUserPermSet;
import com.kingdee.eas.hr.base.PersonStatusEnum;
import com.kingdee.eas.hr.base.UserPermSetCollection;
import com.kingdee.eas.hr.base.UserPermSetFactory;
import com.kingdee.eas.hr.base.UserPermSetInfo;
import com.kingdee.eas.hr.base.util.HrUserPermTranserHelper;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.KDTableUtil;
import com.kingdee.eas.util.client.MsgBox;
import java.util.Map;
import org.apache.log4j.Logger;

public class HrAffairPersonPermTransferUtil {
    private static Logger logger = Logger.getLogger(HrAffairPersonPermTransferUtil.class);
    public static final String INHERIT_USER_INFO = "InheritUserInfo";
    public static final String PERSON_STATUS = "PersonStatus";
    public static final String AFFAIR_ENTRY = "affairEntry";
    public static final String UserPermSet = "userPermSet";
    public static final String ParentUIOptStatus = "parentUIOptStatus";

    public static void setPersonPerm(KDTable kdtEntrys, CoreUI ui) throws BOSException {
        int rowNum = KDTableUtil.getSelectedRow((KDTable)kdtEntrys);
        if (rowNum >= 0) {
            IRow selectRow = kdtEntrys.getRow(rowNum);
            try {
                PersonInfo person = (PersonInfo)selectRow.getCell("person").getValue();
                UserCollection userColl = UserPermSetFactory.getRemoteInstance().getPersonOfUserCollection(person);
                if (userColl.size() > 0 || ui instanceof EmpEnrollBizBillEditUI) {
                    if (selectRow.getCell("position").getValue() != null) {
                        UIContext uiContext = new UIContext((Object)ui);
                        uiContext.put((Object)ParentUIOptStatus, (Object)ui.getOprtState());
                        String affairEntryID = ((BOSUuid)selectRow.getCell("id").getValue()).toString();
                        HRAffairBizBillEntryInfo entryInfo = null;
                        if (ui instanceof EmpEnrollBizBillEditUI) {
                            EmpEnrollBizBillEntryInfo empEnrollentryInfo = new EmpEnrollBizBillEntryInfo();
                            empEnrollentryInfo.setId(BOSUuid.read((String)affairEntryID));
                            empEnrollentryInfo.setAdminOrg((AdminOrgUnitInfo)selectRow.getCell("adminOrg").getValue());
                            empEnrollentryInfo.setPosition((PositionInfo)selectRow.getCell("position").getValue());
                            empEnrollentryInfo.setPerson(person);
                            empEnrollentryInfo.setEmpNumber((String)selectRow.getCell("empNumber").getValue());
                            empEnrollentryInfo.setEmpName((String)selectRow.getCell("empName").getValue());
                            entryInfo = empEnrollentryInfo;
                        } else {
                            entryInfo = new HRAffairBizBillEntryInfo();
                            entryInfo.setId(BOSUuid.read((String)affairEntryID));
                            entryInfo.setAdminOrg((AdminOrgUnitInfo)selectRow.getCell("adminOrg").getValue());
                            entryInfo.setPosition((PositionInfo)selectRow.getCell("position").getValue());
                            entryInfo.setPerson(person);
                        }
                        uiContext.put((Object)AFFAIR_ENTRY, (Object)entryInfo);
                        UserPermSetCollection userPermSet = HrAffairPersonPermTransferUtil.getUserPermSetCollection(null, affairEntryID);
                        String userPermSetUI = "com.kingdee.eas.hr.base.client.UserPermSetEditUI";
                        if (userPermSet.size() > 0) {
                            uiContext.put((Object)"ID", (Object)userPermSet.get(0).getId().toString());
                            IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(userPermSetUI, (Map)uiContext, null, OprtState.EDIT);
                            uiWindow.show();
                        } else {
                            IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(userPermSetUI, (Map)uiContext, null, OprtState.ADDNEW);
                            uiWindow.show();
                        }
                    } else {
                        String warnningInfo = EASResource.getString((String)"com.kingdee.eas.hr.base.HRBasedataResource", (String)"PersonOfPositionCantNull");
                        MsgBox.showInfo((String)warnningInfo);
                    }
                } else {
                    String warnningInfo = EASResource.getString((String)"com.kingdee.eas.hr.base.HRBasedataResource", (String)"UserMustExist");
                    MsgBox.showInfo((String)warnningInfo);
                }
            }
            catch (Exception e) {
                ExceptionHandler.handle((Throwable)e);
            }
        }
    }

    public static UserPermSetCollection getUserPermSetCollection(Context ctx, String affairEntryID) throws BOSException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("affairEntryID", (Object)affairEntryID));
        SelectorItemCollection coll = new SelectorItemCollection();
        coll.add(new SelectorItemInfo("user.id"));
        coll.add(new SelectorItemInfo("inheritUser.id"));
        coll.add(new SelectorItemInfo("isDoneNothing"));
        coll.add(new SelectorItemInfo("isClear"));
        coll.add(new SelectorItemInfo("isGetDefault"));
        coll.add(new SelectorItemInfo("isInherit"));
        coll.add(new SelectorItemInfo("personStatus"));
        coll.add(new SelectorItemInfo("effectStatus"));
        coll.add(new SelectorItemInfo("affairEntryID"));
        coll.add(new SelectorItemInfo("hrUserHisPerm.id"));
        coll.add(new SelectorItemInfo("user.person.id"));
        viewInfo.setSelector(coll);
        viewInfo.setFilter(filter);
        IUserPermSet iUserPermSet = null;
        iUserPermSet = ctx == null ? UserPermSetFactory.getRemoteInstance() : UserPermSetFactory.getLocalInstance((Context)ctx);
        UserPermSetCollection userPermSet = iUserPermSet.getUserPermSetCollection(viewInfo);
        return userPermSet;
    }

    public static void recoderUserPermForTransfer(Context ctx, HRAffairBizBillEntryInfo entry) throws BOSException, EASBizException {
    }

    public static void effectUserPermSetTransfer(Context ctx, HRAffairBizBillEntryInfo entry) throws BOSException, EASBizException {
        String affairEntryId = entry.getId().toString();
        UserPermSetCollection userColl = HrAffairPersonPermTransferUtil.getUserPermSetCollection(ctx, affairEntryId);
        if (userColl.size() > 0) {
            UserPermSetInfo userPermSet = userColl.get(0);
            if (userPermSet.isIsClear()) {
                HrUserPermTranserHelper.clearOrgAndPermOfUser((Context)ctx, (UserInfo)userPermSet.getUser());
            } else if (userPermSet.isIsGetDefault()) {
                HrUserPermTranserHelper.clearOrgAndPermOfUser((Context)ctx, (UserInfo)userPermSet.getUser());
                HrUserPermTranserHelper.setBizOrgOfUser((Context)ctx, (AdminOrgUnitInfo)entry.getAdminOrg(), (UserInfo)userPermSet.getUser());
                HrUserPermTranserHelper.addBizOrg((Context)ctx, (UserInfo)userPermSet.getUser());
                HrUserPermTranserHelper.addDefaultRole((Context)ctx, (UserInfo)userPermSet.getUser());
            } else if (userPermSet.isIsInherit()) {
                Object transfer = null;
                transfer = PersonStatusEnum.ONPOSITION.equals((Object)userPermSet.getPersonStatus()) ? new HrInheritUserCurrentPermTransfer() : new HrInheritUserHistoryPermTranfser();
                transfer.doWithInheritPermission(ctx, userPermSet);
                HrUserPermTranserHelper.setBizOrgOfUser((Context)ctx, (AdminOrgUnitInfo)entry.getAdminOrg(), (UserInfo)userPermSet.getUser());
            } else if (userPermSet.isIsDoneNothing()) {
                // empty if block
            }
            userPermSet.setEffectStatus(true);
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add(new SelectorItemInfo("effectStatus"));
            UserPermSetFactory.getLocalInstance((Context)ctx).updatePartial((CoreBaseInfo)userPermSet, selector);
        }
    }
}

