/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.managerplat.client;

import com.kingdee.bos.ctrl.swing.KDToolBar;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.ctrl.swing.tree.KingdeeTreeModel;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.client.util.PermissionHelper;
import com.kingdee.eas.base.uiframe.client.UIFactoryHelper;
import com.kingdee.eas.basedata.org.PositionInfo;
import com.kingdee.eas.basedata.person.IPerson;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.basedata.person.PersonStates;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.FrameWorkUtils;
import com.kingdee.eas.framework.client.ListUI;
import com.kingdee.eas.framework.client.RealModeIDList;
import com.kingdee.eas.framework.client.tree.KDTreeNode;
import com.kingdee.eas.hr.base.client.EmpInfoAuditCheckEvent;
import com.kingdee.eas.hr.base.client.EmpInfoAuditCheckListener;
import com.kingdee.eas.hr.base.client.IEmpInfoAudtiCheckListener;
import com.kingdee.eas.hr.compensation.client.EmployeeJournalReportUI;
import com.kingdee.eas.hr.emp.client.EmployeePerformanceEditUI;
import com.kingdee.eas.hr.emp.client.EmployeeTreeEditUI;
import com.kingdee.eas.hr.managerplat.ManagerPlatException;
import com.kingdee.eas.hr.managerplat.client.AbstractMyProfileUI;
import com.kingdee.eas.hr.managerplat.client.MyPositionNewUI;
import com.kingdee.eas.hr.time.client.MyAttendanceListUI;
import com.kingdee.eas.hr.time.client.MyLeaveListUI;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.util.Map;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;

public class MyProfileUI
extends AbstractMyProfileUI {
    private String personId = null;
    private String positionId = null;
    private CoreUIObject positionUI = null;
    private CoreUIObject empUI = null;
    private CoreUIObject salaryUI = null;
    private CoreUIObject myPerfUI = null;
    private CoreUIObject myLeaveListUI = null;
    private CoreUIObject myAttendanceListUI = null;
    private String type = null;
    private boolean hasAudit = false;

    private void initTree() {
        KDTreeNode root = new KDTreeNode((Object)EASResource.getString((String)"com.kingdee.eas.hr.managerplat.client.ManagerPlatResource.MY_PROFILE"));
        root.setText(EASResource.getString((String)"com.kingdee.eas.hr.managerplat.client.ManagerPlatResource.MY_PROFILE"));
        root.setUserObject(null);
        KDTreeNode selectednode = new KDTreeNode((Object)EASResource.getString((String)"com.kingdee.eas.hr.managerplat.client.ManagerPlatResource.MY_POSITION"));
        selectednode.setUserObject((Object)"MY_POSITION");
        selectednode.setText(EASResource.getString((String)"com.kingdee.eas.hr.managerplat.client.ManagerPlatResource.MY_POSITION"));
        root.add((MutableTreeNode)selectednode);
        KDTreeNode node = new KDTreeNode((Object)EASResource.getString((String)"com.kingdee.eas.hr.managerplat.client.ManagerPlatResource.MY_FILE"));
        node.setUserObject((Object)"MY_FILE");
        node.setText(EASResource.getString((String)"com.kingdee.eas.hr.managerplat.client.ManagerPlatResource.MY_FILE"));
        root.add((MutableTreeNode)node);
        KDTreeNode perfNode = new KDTreeNode((Object)EASResource.getString((String)"com.kingdee.eas.hr.managerplat.client.ManagerPlatResource.MY_PERF"));
        perfNode.setUserObject((Object)"MY_PERF");
        perfNode.setText(EASResource.getString((String)"com.kingdee.eas.hr.managerplat.client.ManagerPlatResource.MY_PERF"));
        root.add((MutableTreeNode)perfNode);
        KDTreeNode leaveNode = new KDTreeNode((Object)EASResource.getString((String)"com.kingdee.eas.hr.managerplat.client.ManagerPlatResource.MY_LEAVE"));
        leaveNode.setUserObject((Object)"MY_LEAVE");
        leaveNode.setText(EASResource.getString((String)"com.kingdee.eas.hr.managerplat.client.ManagerPlatResource.MY_LEAVE"));
        root.add((MutableTreeNode)leaveNode);
        KDTreeNode attendanceNode = new KDTreeNode((Object)EASResource.getString((String)"com.kingdee.eas.hr.managerplat.client.ManagerPlatResource.MY_ATT"));
        attendanceNode.setUserObject((Object)"MY_ATT");
        attendanceNode.setText(EASResource.getString((String)"com.kingdee.eas.hr.managerplat.client.ManagerPlatResource.MY_ATT"));
        root.add((MutableTreeNode)attendanceNode);
        this.treeMain.setModel((TreeModel)new KingdeeTreeModel((TreeNode)root));
        this.treeMain.setSelectionNode((DefaultKingdeeTreeNode)node);
    }

    private void setWorkButtonState() {
        if (this.type == null) {
            this.btnEdit.setVisible(false);
            this.btnAddNew.setVisible(false);
            this.btnUpdate.setVisible(false);
            this.btnDelete.setVisible(false);
            this.btnPositionOutline.setVisible(false);
            this.btnQuery.setVisible(false);
        } else if (this.type.equals("MY_FILE")) {
            this.btnEdit.setVisible(true);
            this.btnAddNew.setVisible(true);
            this.btnUpdate.setVisible(true);
            this.btnDelete.setVisible(true);
            this.btnPositionOutline.setVisible(false);
            this.btnQuery.setVisible(false);
        } else if (this.type.equals("MY_POSITION")) {
            this.btnEdit.setVisible(false);
            this.btnAddNew.setVisible(false);
            this.btnUpdate.setVisible(false);
            this.btnDelete.setVisible(false);
            this.btnPositionOutline.setVisible(true);
            this.btnQuery.setVisible(false);
        } else if (this.type.equals("MY_PERF")) {
            this.btnEdit.setVisible(false);
            this.btnAddNew.setVisible(false);
            this.btnUpdate.setVisible(false);
            this.btnDelete.setVisible(false);
            this.btnPositionOutline.setVisible(false);
            this.btnQuery.setVisible(false);
        } else if (this.type.equals("MY_LEAVE")) {
            this.btnEdit.setVisible(false);
            this.btnAddNew.setVisible(false);
            this.btnUpdate.setVisible(false);
            this.btnDelete.setVisible(false);
            this.btnPositionOutline.setVisible(false);
            this.btnQuery.setVisible(false);
        } else if (this.type.equals("MY_ATT")) {
            this.btnEdit.setVisible(false);
            this.btnAddNew.setVisible(false);
            this.btnUpdate.setVisible(false);
            this.btnDelete.setVisible(false);
            this.btnPositionOutline.setVisible(false);
            this.btnQuery.setVisible(false);
        } else {
            this.btnEdit.setVisible(false);
            this.btnAddNew.setVisible(false);
            this.btnUpdate.setVisible(false);
            this.btnDelete.setVisible(false);
            this.btnPositionOutline.setVisible(false);
            this.btnQuery.setVisible(true);
        }
    }

    private void setUIDisable(CoreUIObject ui) {
        if (ui != null) {
            ui.setVisible(false);
        }
    }

    public void checkPermission() throws Exception {
        BOSUuid hrOrgUnitId = SysContext.getSysContext().getCurrentHRUnit().getId();
        BOSUuid userId = SysContext.getSysContext().getCurrentUserInfo().getId();
        PermissionHelper.checkFunctionPermission((IObjectPK)new ObjectUuidPK(userId), (IObjectPK)new ObjectUuidPK(hrOrgUnitId), (String)"MyProfileUI_edit");
    }

    @Override
    protected void treeMain_valueChanged(TreeSelectionEvent e) throws Exception {
        super.treeMain_valueChanged(e);
        if (e.getPath().getLastPathComponent() == null) {
            if (this.positionUI != null) {
                this.paneRight.getViewport().removeAll();
                this.setUIDisable(this.positionUI);
                this.setUIDisable(this.empUI);
                this.setUIDisable(this.salaryUI);
                this.setUIDisable(this.myPerfUI);
                this.setUIDisable(this.myLeaveListUI);
                this.setUIDisable(this.myAttendanceListUI);
            }
        } else {
            KDTreeNode node = (KDTreeNode)e.getPath().getLastPathComponent();
            this.type = (String)node.getUserObject();
            if (this.type == null) {
                this.paneRight.getViewport().removeAll();
                this.setUIDisable(this.positionUI);
                this.setUIDisable(this.empUI);
                this.setUIDisable(this.salaryUI);
                this.setUIDisable(this.myPerfUI);
                this.setUIDisable(this.myLeaveListUI);
                this.setUIDisable(this.myAttendanceListUI);
            } else if (this.type.equals("MY_FILE")) {
                if (this.empUI == null) {
                    UIContext ctx = this.getEmpContext();
                    ctx.put((Object)"SHOW_BOX_MSG", (Object)Boolean.TRUE);
                    ctx.put((Object)"NO_PERMISSION", (Object)Boolean.TRUE);
                    ctx.put((Object)"FROM_WORKBENCH", (Object)Boolean.TRUE);
                    this.empUI = this.getUI(EmployeeTreeEditUI.class.getName(), ctx, OprtState.EDIT);
                    this.empUI.setBounds(0, 0, this.empUI.getWidth(), this.empUI.getHeight());
                    ((EmployeeTreeEditUI)this.empUI).addCheckAuditListener((IEmpInfoAudtiCheckListener)new EmpInfoAuditCheckListener(){

                        public void doCheckAudit(EmpInfoAuditCheckEvent e) throws Exception {
                            MyProfileUI.this.checkPermission();
                            MyProfileUI.this.checkAuditState();
                        }
                    });
                }
                this.paneRight.getViewport().removeAll();
                this.paneRight.getViewport().add((Component)this.empUI);
                this.empUI.setVisible(true);
                this.setUIDisable(this.positionUI);
                this.setUIDisable(this.salaryUI);
                this.setUIDisable(this.myPerfUI);
                this.setUIDisable(this.myLeaveListUI);
                this.setUIDisable(this.myAttendanceListUI);
            } else if (this.type.equals("MY_POSITION")) {
                if (this.positionUI == null) {
                    this.positionUI = this.getUI(MyPositionNewUI.class.getName(), this.getPositionContext(), OprtState.VIEW);
                    this.positionUI.setBounds(0, 0, this.positionUI.getPreferredSize().width, this.positionUI.getPreferredSize().height);
                }
                this.paneRight.getViewport().removeAll();
                this.paneRight.getViewport().add((Component)this.positionUI, null);
                this.positionUI.setVisible(true);
                this.setUIDisable(this.empUI);
                this.setUIDisable(this.salaryUI);
                this.setUIDisable(this.myPerfUI);
                this.setUIDisable(this.myLeaveListUI);
                this.setUIDisable(this.myAttendanceListUI);
            } else if (this.type.equals("MY_SALARY")) {
                if (this.salaryUI == null) {
                    this.salaryUI = this.getUI(EmployeeJournalReportUI.class.getName(), this.getSalaryContext(), OprtState.EDIT);
                    this.salaryUI.setBounds(0, 0, this.salaryUI.getWidth(), this.salaryUI.getHeight());
                }
                this.paneRight.getViewport().removeAll();
                this.paneRight.getViewport().add((Component)this.salaryUI);
                this.salaryUI.setVisible(true);
                this.setUIDisable(this.positionUI);
                this.setUIDisable(this.empUI);
                this.setUIDisable(this.myPerfUI);
                this.setUIDisable(this.myLeaveListUI);
                this.setUIDisable(this.myAttendanceListUI);
            } else if (this.type.equals("MY_PERF")) {
                if (this.myPerfUI == null) {
                    UIContext ctx = new UIContext((Object)this);
                    ctx.put((Object)"SHOW_BOX_MSG", (Object)Boolean.TRUE);
                    ctx.put((Object)"NO_PERMISSION", (Object)Boolean.TRUE);
                    ctx.put((Object)"FROM_WORKBENCH", (Object)Boolean.TRUE);
                    this.myPerfUI = this.getUI(EmployeePerformanceEditUI.class.getName(), ctx, OprtState.EDIT);
                    this.myPerfUI.setBounds(0, 0, this.myPerfUI.getPreferredSize().width, this.myPerfUI.getPreferredSize().height);
                }
                this.paneRight.getViewport().removeAll();
                this.paneRight.getViewport().add((Component)this.myPerfUI, null);
                this.myPerfUI.setVisible(true);
                this.setUIDisable(this.empUI);
                this.setUIDisable(this.salaryUI);
                this.setUIDisable(this.positionUI);
                this.setUIDisable(this.myLeaveListUI);
                this.setUIDisable(this.myAttendanceListUI);
            } else if (this.type.equals("MY_LEAVE")) {
                if (this.myLeaveListUI == null) {
                    this.myLeaveListUI = this.getUI(MyLeaveListUI.class.getName(), new UIContext((Object)this), OprtState.EDIT);
                    this.myLeaveListUI.setBounds(0, 0, this.myLeaveListUI.getPreferredSize().width, this.myLeaveListUI.getPreferredSize().height);
                }
                this.paneRight.getViewport().removeAll();
                this.paneRight.getViewport().add((Component)this.myLeaveListUI, null);
                this.myLeaveListUI.setVisible(true);
                this.setUIDisable(this.empUI);
                this.setUIDisable(this.salaryUI);
                this.setUIDisable(this.positionUI);
                this.setUIDisable(this.myPerfUI);
                this.setUIDisable(this.myAttendanceListUI);
            } else if (this.type.equals("MY_ATT")) {
                if (this.myAttendanceListUI == null) {
                    this.myAttendanceListUI = this.getUI(MyAttendanceListUI.class.getName(), new UIContext((Object)this), OprtState.EDIT);
                    this.myAttendanceListUI.setBounds(0, 0, this.myAttendanceListUI.getPreferredSize().width, this.myAttendanceListUI.getPreferredSize().height);
                }
                this.paneRight.getViewport().removeAll();
                this.paneRight.getViewport().add((Component)this.myAttendanceListUI, null);
                this.myAttendanceListUI.setVisible(true);
                this.setUIDisable(this.empUI);
                this.setUIDisable(this.salaryUI);
                this.setUIDisable(this.positionUI);
                this.setUIDisable(this.myPerfUI);
                this.setUIDisable(this.myLeaveListUI);
            }
            this.repaint();
        }
        this.setWorkButtonState();
    }

    private String getPrimaryPosition(String personId) throws Exception {
        PositionInfo info = PersonFactory.getRemoteInstance().getPrimaryPosition(BOSUuid.read((String)personId));
        if (info == null) {
            return null;
        }
        return info.getId().toString();
    }

    private String getCurPersonId() {
        PersonInfo info = SysContext.getSysContext().getCurrentUserInfo().getPerson();
        if (info == null) {
            return null;
        }
        return info.getId().toString();
    }

    private UIContext getEmpContext() {
        UIContext ctx = new UIContext((Object)this);
        ctx.put((Object)"ID", (Object)this.personId);
        ctx.put((Object)"isMyArchives", (Object)"isMyArchives");
        RealModeIDList idList = new RealModeIDList();
        idList.add(this.personId);
        ctx.put((Object)"IDList", (Object)idList);
        PositionInfo pInfo = new PositionInfo();
        pInfo.setId(BOSUuid.read((String)this.positionId));
        ctx.put((Object)"PositionNode", (Object)pInfo);
        this.setIsAudit(this.personId);
        return ctx;
    }

    private void setIsAudit(String personId) {
        try {
            IPerson ip = PersonFactory.getRemoteInstance();
            PersonStates state = ip.getPersonInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)personId))).getState();
            this.hasAudit = state != null && state.getValue() == 1;
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    private void checkAuditState() throws Exception {
        if (this.hasAudit) {
            throw new ManagerPlatException(ManagerPlatException.PERSON_HAS_AUDIT);
        }
    }

    private UIContext getSalaryContext() {
        UIContext ctx = new UIContext((Object)this);
        ctx.put((Object)"ID", (Object)this.personId);
        return ctx;
    }

    private CoreUIObject getUI(String ui, UIContext ctx, String oprtType) throws Exception {
        return (CoreUIObject)UIFactoryHelper.initUIObject((String)ui, (Map)ctx, null, (String)oprtType);
    }

    private UIContext getPositionContext() {
        UIContext ctx = new UIContext((Object)this);
        ctx.put((Object)"ID", (Object)this.positionId);
        return ctx;
    }

    public void onLoad() throws Exception {
        this.setPreferredSize(new Dimension(1016, 600));
        this.personId = this.getCurPersonId();
        if (this.personId == null) {
            throw new ManagerPlatException(ManagerPlatException.USER_NO_MATCH_PERSON);
        }
        this.positionId = this.getPrimaryPosition(this.personId);
        if (this.positionId == null) {
            throw new ManagerPlatException(ManagerPlatException.PERSON_NO_POSITION);
        }
        super.onLoad();
        this.initTree();
    }

    public boolean destroyWindow() {
        boolean okDestroy = true;
        if (this.empUI != null) {
            ((EmployeeTreeEditUI)this.empUI).getUIContext().put("FROM_MyProfile_HasAudit", this.hasAudit);
            okDestroy = this.empUI.destroyWindow();
        }
        if (this.positionUI != null) {
            okDestroy = this.positionUI.destroyWindow();
        }
        if (this.salaryUI != null) {
            okDestroy = this.salaryUI.destroyWindow();
        }
        if (this.myPerfUI != null) {
            okDestroy = this.myPerfUI.destroyWindow();
        }
        if (this.myLeaveListUI != null) {
            okDestroy = this.myLeaveListUI.destroyWindow();
        }
        if (this.myAttendanceListUI != null) {
            okDestroy = this.myAttendanceListUI.destroyWindow();
        }
        if (okDestroy) {
            return super.destroyWindow();
        }
        return okDestroy;
    }

    @Override
    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        super.actionEdit_actionPerformed(e);
        if (this.type.equals("MY_POSITION")) {
            ((MyPositionNewUI)this.positionUI).actionSubmit_actionPerformed(e);
            this.showSubmitSuccess();
        } else if (this.type.equals("MY_FILE") && this.empUI != null && !(((EmployeeTreeEditUI)this.empUI).getUIObj() instanceof ListUI)) {
            this.checkPermission();
            this.checkAuditState();
            ((EmployeeTreeEditUI)this.empUI).getUIContext().put("FROM_MyProfile", Boolean.TRUE);
            ((EmployeeTreeEditUI)this.empUI).actionSubmit_actionPerformed(e);
            this.showSubmitSuccess();
        }
    }

    @Override
    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        if (this.type.equals("MY_FILE") && this.empUI != null && ((EmployeeTreeEditUI)this.empUI).getUIObj() instanceof ListUI) {
            this.checkPermission();
            this.checkAuditState();
            ListUI listUI = (ListUI)((EmployeeTreeEditUI)this.empUI).getUIObj();
            Component component = this.getUIToolbarComponent((CoreUIObject)listUI, "btnAddNew");
            if (component != null && !component.isVisible()) {
                return;
            }
            listUI.getUIContext().put("NO_PERMISSION", Boolean.TRUE);
            listUI.actionAddNew_actionPerformed(e);
        }
    }

    private Component getUIToolbarComponent(CoreUIObject ui, String name) {
        if (name == null) {
            return null;
        }
        KDToolBar toolbar = ui.getUIToolBar();
        if (toolbar != null) {
            for (int i = 0; i < toolbar.getComponentCount(); ++i) {
                Component component = toolbar.getComponent(i);
                if (component == null || !name.equals(component.getName())) continue;
                return component;
            }
        }
        return null;
    }

    @Override
    public void actionDelete_actionPerformed(ActionEvent e) throws Exception {
        if (this.type.equals("MY_FILE") && this.empUI != null && ((EmployeeTreeEditUI)this.empUI).getUIObj() instanceof ListUI) {
            this.checkPermission();
            this.checkAuditState();
            ListUI listUI = (ListUI)((EmployeeTreeEditUI)this.empUI).getUIObj();
            Component component = this.getUIToolbarComponent((CoreUIObject)listUI, "btnRemove");
            if (component != null && !component.isVisible()) {
                return;
            }
            listUI.actionRemove_actionPerformed(e);
        }
    }

    @Override
    public void actionUpdate_actionPerformed(ActionEvent e) throws Exception {
        if (this.type.equals("MY_FILE") && this.empUI != null && ((EmployeeTreeEditUI)this.empUI).getUIObj() instanceof ListUI) {
            this.checkPermission();
            this.checkAuditState();
            ListUI listUI = (ListUI)((EmployeeTreeEditUI)this.empUI).getUIObj();
            Component component = this.getUIToolbarComponent((CoreUIObject)listUI, "btnEdit");
            if (component != null && !component.isVisible()) {
                return;
            }
            listUI.getUIContext().put("NO_PERMISSION", Boolean.TRUE);
            listUI.actionEdit_actionPerformed(e);
        }
    }

    private String getClassAlise() {
        String value = "";
        if (this.type.equals("MY_POSITION")) {
            value = FrameWorkUtils.getClassAlias((CoreBaseInfo)new PositionInfo());
        } else if (this.type.equals("MY_FILE") && this.empUI != null && this.empUI instanceof EmployeeTreeEditUI) {
            value = ((EmployeeTreeEditUI)this.empUI).getClassAlisePub();
        }
        return value;
    }

    protected void showSubmitSuccess() {
        String alias = this.getClassAlise();
        this.setMessageText(alias + " " + EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_Save_OK"));
        this.setNextMessageText("");
        this.setIsShowTextOnly(false);
        this.setShowMessagePolicy(0);
        this.showMessage();
    }

    @Override
    public void actionPostionOutline_actionPerformed(ActionEvent e) throws Exception {
        super.actionPostionOutline_actionPerformed(e);
        ((MyPositionNewUI)this.positionUI).actionPositionOutLine_actionPerformed(e);
    }

    @Override
    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        super.actionQuery_actionPerformed(e);
        ((EmployeeJournalReportUI)this.salaryUI).actionQuery_actionPerformed(e);
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.setButtonDefaultStyl(this.btnAddNew);
        this.btnAddNew.setIcon(EASResource.getIcon((String)"imgTbtn_new"));
        this.setButtonDefaultStyl(this.btnUpdate);
        this.btnUpdate.setIcon(EASResource.getIcon((String)"imgTbtn_edit"));
        this.setButtonDefaultStyl(this.btnDelete);
        this.btnDelete.setIcon(EASResource.getIcon((String)"imgTbtn_delete"));
        this.setButtonDefaultStyl(this.btnEdit);
        this.btnEdit.setIcon(EASResource.getIcon((String)"imgTbtn_submit"));
        this.setButtonDefaultStyl(this.btnQuery);
        this.btnQuery.setIcon(EASResource.getIcon((String)"imgTbtn_filter"));
        this.setButtonDefaultStyl(this.btnPositionOutline);
        this.btnPositionOutline.setIcon(EASResource.getIcon((String)"imgTbtn_PositionDescrip"));
        this.btnCheckInfo.setIcon(EASResource.getIcon((String)"imgTbtn_check"));
    }

    @Override
    public void actionCheckInfo_actionPerformed(ActionEvent e) throws Exception {
        PersonFactory.getRemoteInstance().checkInfo(this.personId);
        MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.basedata.person.client.PersonCheckResource.PERSONINFO_CHECK_PASS"));
    }

    protected void initUserConfig() {
    }

    protected void doFieldPermission() throws Exception {
    }

    @Override
    public boolean isPrepareInit() {
        return false;
    }
}

