/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.affair.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.PositionCollection;
import com.kingdee.eas.basedata.org.PositionFactory;
import com.kingdee.eas.basedata.org.PositionInfo;
import com.kingdee.eas.basedata.person.IPerson;
import com.kingdee.eas.basedata.person.PersonCollection;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.hr.affair.AffairBizException;
import com.kingdee.eas.hr.affair.EmpHireBizBillEntryCollection;
import com.kingdee.eas.hr.affair.EmpHireBizBillEntryFactory;
import com.kingdee.eas.hr.affair.EmpHireBizBillEntryInfo;
import com.kingdee.eas.hr.affair.EmpHireBizBillFactory;
import com.kingdee.eas.hr.affair.EmpHireBizBillInfo;
import com.kingdee.eas.hr.affair.HRAffairBizBillEntryInfo;
import com.kingdee.eas.hr.affair.HRAffairBizBillInfo;
import com.kingdee.eas.hr.affair.HRAffairException;
import com.kingdee.eas.hr.affair.IEmpHireBizBillEntry;
import com.kingdee.eas.hr.affair.app.AbstractEmpHireBizBillControllerBean;
import com.kingdee.eas.hr.affair.app.EmpHireBillBizBean;
import com.kingdee.eas.hr.base.EmpLaborRelationFactory;
import com.kingdee.eas.hr.base.EmpLaborRelationInfo;
import com.kingdee.eas.hr.base.EmpPosOrgRelationCollection;
import com.kingdee.eas.hr.base.EmpPosOrgRelationFactory;
import com.kingdee.eas.hr.base.HRBillBaseEntryInfo;
import com.kingdee.eas.hr.base.IHRBillBaseEntry;
import com.kingdee.eas.hr.base.app.HRBillAppUtils;
import com.kingdee.eas.hr.base.app.IHRBillBizBean;
import com.kingdee.eas.hr.base.app.util.AffairUnAuditAppUtils;
import com.kingdee.eas.hr.org.JobGradeInfo;
import com.kingdee.eas.hr.org.JobLevelInfo;
import com.kingdee.shr.ml.util.SHRServerResource;
import com.kingdee.util.DateTimeUtils;
import java.text.MessageFormat;
import java.util.Date;
import org.apache.axis.utils.StringUtils;
import org.apache.log4j.Logger;

public class EmpHireBizBillControllerBean
extends AbstractEmpHireBizBillControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.hr.affair.app.EmpHireBizBillControllerBean");

    @Override
    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        EmpHireBizBillInfo billInfo = (EmpHireBizBillInfo)model;
        this.checkEmployeeNumberDup(ctx, billInfo);
        return super._addnew(ctx, model);
    }

    @Override
    protected String getBillField() {
        return "bill";
    }

    @Override
    protected String getEntryField() {
        return "entrys";
    }

    @Override
    protected String getEntryEffectDateField() {
        return "bizDate";
    }

    protected String getEffectFunction() {
        return "com.kingdee.eas.hr.affair.app.EmpHireBizBillEffectFunction";
    }

    @Override
    protected IHRBillBaseEntry getEntryInterface(Context ctx) throws BOSException, EASBizException {
        return EmpHireBizBillEntryFactory.getLocalInstance(ctx);
    }

    @Override
    protected IHRBillBizBean getBizBean() {
        return new EmpHireBillBizBean();
    }

    @Override
    protected void _doWithSpecialFiledsEffect(Context ctx, HRAffairBizBillEntryInfo entry) throws BOSException, EASBizException {
        PersonCollection pCol;
        super._doWithSpecialFiledsEffect(ctx, entry);
        EmpHireBizBillEntryInfo hireEntryInfo = (EmpHireBizBillEntryInfo)entry;
        if (!StringUtils.isEmpty((String)hireEntryInfo.getEmployeeNumber())) {
            IPerson iPerson = PersonFactory.getLocalInstance((Context)ctx);
            PersonInfo personInfo = new PersonInfo();
            personInfo.put("person", (Object)hireEntryInfo.getPerson());
            personInfo.setNumber(hireEntryInfo.getEmployeeNumber());
            String columnStrings = "number";
            AffairUnAuditAppUtils.updatePersonSinglePagePartial((ICoreBase)iPerson, (CoreBaseInfo)personInfo, (String)columnStrings);
        }
        if ((pCol = PersonFactory.getLocalInstance((Context)ctx).getPersonCollection("select employeeType.id where id = '" + hireEntryInfo.getPerson().getId().toString() + "'")).size() > 0) {
            HRBillAppUtils.updateAffairBizHistory((Context)ctx, (String)pCol.get(0).getEmployeeType().getId().toString(), (String)hireEntryInfo.getId().toString());
        }
    }

    protected String getEntryIdStr(Context ctx, IObjectPK pk) throws EASBizException, BOSException {
        EmpHireBizBillInfo BillInfo = EmpHireBizBillFactory.getLocalInstance(ctx).getEmpHireBizBillInfo(pk);
        EmpHireBizBillEntryCollection billEntryCol = BillInfo.getEntrys();
        StringBuffer billEntryIdStr = new StringBuffer();
        int size = billEntryCol.size();
        for (int i = 0; i < size; ++i) {
            billEntryIdStr.append("'");
            billEntryIdStr.append(billEntryCol.get(i).getId().toString());
            if (i == size - 1) {
                billEntryIdStr.append("'");
                continue;
            }
            billEntryIdStr.append("',");
        }
        return billEntryIdStr.toString();
    }

    @Override
    protected void _setAudited(Context ctx, BOSUuid billID) throws BOSException, EASBizException {
        IEmpHireBizBillEntry iEntry = null;
        EmpHireBizBillEntryCollection entryCol = null;
        int size = 0;
        StringBuffer oql = new StringBuffer("select bizDate,position where bill = '");
        oql.append(billID).append("'");
        try {
            iEntry = EmpHireBizBillEntryFactory.getLocalInstance(ctx);
            entryCol = iEntry.getEmpHireBizBillEntryCollection(oql.toString());
        }
        catch (BOSException e) {
            e.printStackTrace();
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        if (entryCol != null) {
            size = entryCol.size();
        }
        if (size <= 0) {
            return;
        }
        for (int i = 0; i < size; ++i) {
            if (entryCol.get(i).getBizDate() != null && entryCol.get(i).getPosition() != null) continue;
            throw new AffairBizException(AffairBizException.POSITION_BIZDATE_NOTNULL);
        }
        super._setAudited(ctx, billID);
    }

    @Override
    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        EmpHireBizBillInfo billInfo = (EmpHireBizBillInfo)model;
        this.checkEmployeeNumberDup(ctx, billInfo);
        super._update(ctx, pk, model);
    }

    private void checkEmployeeNumberDup(Context ctx, EmpHireBizBillInfo billInfo) throws BOSException, EASBizException {
        IPerson iPerson = PersonFactory.getLocalInstance((Context)ctx);
        int size = billInfo.getEntrys().size();
        for (int i = 0; i < size; ++i) {
            String personNumber = billInfo.getEntrys().get(i).getEmployeeNumber();
            String personId = billInfo.getEntrys().get(i).getPerson().getId().toString();
            if (!iPerson.exists("where number='" + personNumber + "' and id<>'" + personId + "'")) continue;
            throw new HRAffairException(HRAffairException.REPEATNUMBER, new String[]{personNumber});
        }
    }

    @Override
    public void _unAuditEachEntrySpecialPropertyRecovery(Context ctx, HRAffairBizBillEntryInfo entry) throws BOSException, EASBizException {
        super._unAuditEachEntrySpecialPropertyRecovery(ctx, entry);
    }

    @Override
    protected HRAffairBizBillEntryInfo storefieldsForEntry(Context ctx, HRAffairBizBillInfo billInfo, HRAffairBizBillEntryInfo entryInfo) throws EASBizException, BOSException {
        PositionCollection positions;
        JobGradeInfo jobGradeInfo = entryInfo.getJobGrade();
        JobLevelInfo jobLevelInfo = entryInfo.getJobLevel();
        if ("KTL0IBpET46kKbTTM6T1vuZovtk=".equals(entryInfo.getHrBizDefine().getId().toString()) && entryInfo.getPosition() != null && entryInfo.getPosition().getId() != null && (positions = PositionFactory.getLocalInstance((Context)ctx).getPositionCollection("select id,adminOrgUnit.id where id = '" + entryInfo.getPosition().getId().toString() + "'")) != null && positions.size() > 0) {
            PositionInfo positionInfo = positions.get(0);
            entryInfo.setAdminOrg(positionInfo.getAdminOrgUnit());
        }
        super.storefieldsForEntry(ctx, billInfo, entryInfo);
        entryInfo.setJobGrade(jobGradeInfo);
        entryInfo.setJobLevel(jobLevelInfo);
        EmpHireBizBillEntryInfo info = (EmpHireBizBillEntryInfo)entryInfo;
        if (info.getId() != null && info.getGrade() == null && EmpHireBizBillEntryFactory.getLocalInstance(ctx).exists((IObjectPK)new ObjectUuidPK(info.getId()))) {
            info.setGrade(EmpHireBizBillEntryFactory.getLocalInstance(ctx).getEmpHireBizBillEntryInfo((IObjectPK)new ObjectUuidPK(info.getId())).getGrade());
        }
        String oql = " where person.id = '" + info.getPerson().getId().toString() + "'";
        EmpLaborRelationInfo empLaborRelationInfo = EmpLaborRelationFactory.getLocalInstance((Context)ctx).getEmpLaborRelationInfo(oql);
        if (info.getEnrollDate() == null) {
            info.setEnrollDate(empLaborRelationInfo.getEnterDate());
        }
        if (info.getPlanFormalDate() == null && empLaborRelationInfo.getPlanFormalDate() != null) {
            info.setPlanFormalDate(empLaborRelationInfo.getPlanFormalDate());
        }
        return entryInfo;
    }

    @Override
    protected void checkPersonIsResign(Context ctx, HRBillBaseEntryInfo entryInfo) throws BOSException, EASBizException {
        EmpHireBizBillEntryInfo info = (EmpHireBizBillEntryInfo)entryInfo;
        String oql = "select id,effdt,person.number,person.name where action.bizDefineType = 4 and person.id = '" + info.getPerson().getId().toString() + "' and effdt >= {ts'" + info.getBizDate() + " 00:00:00'}";
        EmpPosOrgRelationCollection empRelationColls = EmpPosOrgRelationFactory.getLocalInstance((Context)ctx).getEmpPosOrgRelationCollection(oql);
        if (empRelationColls != null && empRelationColls.size() > 0) {
            String message = SHRServerResource.getString((String)"com.kingdee.eas.hr.affair.AffairBizResource", (String)"label32", (Context)ctx);
            Object[] params = new Object[]{empRelationColls.get(0).getPerson().getName(), empRelationColls.get(0).getPerson().getName(), DateTimeUtils.format((Date)empRelationColls.get(0).getEFFDT(), (String)"yyyy-MM-dd")};
            message = MessageFormat.format(message, params);
            throw new AffairBizException(AffairBizException.BILL_CHECK_FAILED, new String[]{message});
        }
    }
}

