/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.affair.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.affair.FireBillEntryCollection;
import com.kingdee.eas.hr.affair.FireBillEntryInfo;
import com.kingdee.eas.hr.affair.FireBillFactory;
import com.kingdee.eas.hr.affair.FireBillInfo;
import com.kingdee.eas.hr.affair.HRAffairBaseInfo;
import com.kingdee.eas.hr.affair.HRAffairException;
import com.kingdee.eas.hr.affair.HRAffairPersonPreProcessFacadeFactory;
import com.kingdee.eas.hr.affair.app.AbstractFireBillControllerBean;
import com.kingdee.eas.hr.base.HRCommonException;
import com.kingdee.eas.hr.base.batch.BatchProcessedResult;
import com.kingdee.eas.util.ResourceBase;
import java.util.ArrayList;
import java.util.Date;
import java.util.Locale;

public class FireBillControllerBean
extends AbstractFireBillControllerBean {
    @Override
    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        FireBillInfo info = (FireBillInfo)model;
        FireBillEntryCollection c = info.getEntries();
        FireBillEntryInfo eInfo = null;
        int size = c.size();
        for (int i = 0; i < size; ++i) {
            eInfo = c.get(i);
            if (eInfo.getEffectDate() != null) continue;
            eInfo.setEffectDate(eInfo.getDesireDate());
        }
        return super._addnew(ctx, (IObjectValue)info);
    }

    @Override
    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        FireBillInfo info = (FireBillInfo)model;
        FireBillEntryCollection c = info.getEntries();
        FireBillEntryInfo eInfo = null;
        int size = c.size();
        for (int i = 0; i < size; ++i) {
            eInfo = c.get(i);
            if (eInfo.getEffectDate() != null) continue;
            eInfo.setEffectDate(eInfo.getDesireDate());
        }
        super._update(ctx, pk, (IObjectValue)info);
    }

    protected String getPermItemNameDelete() {
        return "FireBill_Delete";
    }

    protected String getPermItemNameAddnew() {
        return "FireBill_AddNew";
    }

    protected String getPermItemNameEdit() {
        return "FireBill_Edit";
    }

    @Override
    protected void checkBillEntry(Context ctx, HRAffairBaseInfo model) throws BOSException, EASBizException {
        BatchProcessedResult result;
        super.checkBillEntry(ctx, model);
        ArrayList<PersonInfo> persons = new ArrayList<PersonInfo>();
        FireBillInfo info = (FireBillInfo)model;
        FireBillEntryCollection c = info.getEntries();
        FireBillEntryInfo eInfo = null;
        int size = c.size();
        for (int i = 0; i < size; ++i) {
            eInfo = c.get(i);
            persons.add(eInfo.getPerson());
        }
        String billId = null;
        if (info.getId() != null) {
            billId = info.getId().toString();
        }
        if ((result = HRAffairPersonPreProcessFacadeFactory.getLocalInstance(ctx).preProcessFirePerson(persons, billId)) == null) {
            return;
        }
        if (result.isHasValidInfo()) {
            throw new HRCommonException(HRCommonException.EXCEPTION_MSG, (Object[])new String[]{result.getInvalidInfo()});
        }
    }

    @Override
    protected String getResource(Context ctx) {
        return ResourceBase.getString((String)"com.kingdee.eas.hr.affair.AFFAIRAutoGenerateResource", (String)"27_HRAffairBaseControllerBean", (Locale)ctx.getOriginLocale());
    }

    @Override
    protected void checkEffectData(Context ctx, String billID) throws BOSException, EASBizException {
        FireBillInfo billInfo = FireBillFactory.getLocalInstance(ctx).getFireBillInfo((IObjectPK)new ObjectUuidPK(billID));
        FireBillEntryCollection entryCol = billInfo.getEntries();
        Date now = new Date();
        boolean result = false;
        int size = entryCol.size();
        for (int i = 0; i < size; ++i) {
            FireBillEntryInfo entryInfo = entryCol.get(i);
            if (!now.after(entryInfo.getDesireDate())) continue;
            result = true;
            break;
        }
        if (result) {
            throw new HRAffairException(HRAffairException.CAN_NOT_UNAUDIT);
        }
    }

    @Override
    protected String getEntryIdStr(Context ctx, IObjectPK pk) throws EASBizException, BOSException {
        FireBillInfo billInfo = FireBillFactory.getLocalInstance(ctx).getFireBillInfo(pk);
        FireBillEntryCollection billEntryCol = billInfo.getEntries();
        StringBuffer billEntryIdStr = new StringBuffer();
        int size = billEntryCol.size();
        for (int i = 0; i < size; ++i) {
            billEntryIdStr.append("'");
            billEntryIdStr.append(billEntryCol.get(i).getId().toString());
            if (i == size - 1) {
                billEntryIdStr.append("'");
                continue;
            }
            billEntryIdStr.append("',");
        }
        return billEntryIdStr.toString();
    }
}

