/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.affair.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.PositionInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.affair.FlucInBizBillEntryCollection;
import com.kingdee.eas.hr.affair.FlucInBizBillEntryFactory;
import com.kingdee.eas.hr.affair.FlucInBizBillEntryInfo;
import com.kingdee.eas.hr.affair.FlucInBizBillFactory;
import com.kingdee.eas.hr.affair.FlucInBizBillInfo;
import com.kingdee.eas.hr.affair.HRAffairBizBillEntryInfo;
import com.kingdee.eas.hr.affair.HRAffairBizBillInfo;
import com.kingdee.eas.hr.affair.HRAffairException;
import com.kingdee.eas.hr.affair.app.AbstractFlucInBizBillControllerBean;
import com.kingdee.eas.hr.affair.app.FlucInBillBizBean;
import com.kingdee.eas.hr.affair.app.HrAffairFillEmptyBizDefineUtil;
import com.kingdee.eas.hr.base.EmpHRORelationHisInfo;
import com.kingdee.eas.hr.base.EmpPosOrgRelationCollection;
import com.kingdee.eas.hr.base.EmpPosOrgRelationFactory;
import com.kingdee.eas.hr.base.EmpPosOrgRelationInfo;
import com.kingdee.eas.hr.base.HRBillBaseEntryInfo;
import com.kingdee.eas.hr.base.HRBizDefineInfo;
import com.kingdee.eas.hr.base.IHRBillBaseEntry;
import com.kingdee.eas.hr.base.app.EmpPosOrgRelationQueryHelper;
import com.kingdee.eas.hr.base.app.IHRBillBizBean;
import com.kingdee.eas.hr.base.util.HRUtil;
import com.kingdee.eas.hr.base.util.HRUtilExtend;
import com.kingdee.eas.hr.contract.util.ContractUtils;
import com.kingdee.eas.hr.emp.CompleteStateEnum;
import com.kingdee.eas.hr.emp.FluctuationInOutFactory;
import com.kingdee.eas.hr.emp.FluctuationInOutInfo;
import com.kingdee.eas.hr.emp.app.util.FluctuationInOutUtil;
import com.kingdee.eas.hr.emp.app.util.SHREmpOptOrgnizationTool;
import com.kingdee.eas.hr.org.JobGradeInfo;
import com.kingdee.eas.hr.org.JobLevelInfo;
import com.kingdee.eas.util.app.DbUtil;
import java.util.Date;
import org.apache.log4j.Logger;

public class FlucInBizBillControllerBean
extends AbstractFlucInBizBillControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.hr.affair.app.FlucInBizBillControllerBean");

    @Override
    protected String getBillField() {
        return "bill";
    }

    @Override
    protected String getEntryField() {
        return "entrys";
    }

    @Override
    protected String getEntryEffectDateField() {
        return "bizDate";
    }

    protected String getEffectFunction() {
        return "com.kingdee.eas.hr.affair.app.FlucInBizBillEffectFunction";
    }

    @Override
    protected IHRBillBaseEntry getEntryInterface(Context ctx) throws BOSException, EASBizException {
        return FlucInBizBillEntryFactory.getLocalInstance(ctx);
    }

    @Override
    protected IHRBillBizBean getBizBean() {
        return new FlucInBillBizBean();
    }

    @Override
    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        FlucInBizBillInfo billInfo = (FlucInBizBillInfo)model;
        HrAffairFillEmptyBizDefineUtil.fillFlucInBizBillEntry(ctx, billInfo.getEntrys());
        return super._addnew(ctx, model);
    }

    @Override
    protected void checkBeforeSubmit(Context ctx, IObjectValue model) throws EASBizException, BOSException {
        super.checkBeforeSubmit(ctx, model);
        FlucInBizBillInfo info = (FlucInBizBillInfo)model;
        FlucInBizBillEntryCollection eColl = info.getEntrys();
        FlucInBizBillEntryInfo eInfo = null;
        for (int i = 0; i < eColl.size(); ++i) {
            eInfo = eColl.get(i);
            this.checkbizDate(ctx, eInfo);
            this.checkAddBeforeHire(ctx, eInfo);
        }
    }

    private void checkAddBeforeHire(Context ctx, FlucInBizBillEntryInfo eInfo) throws BOSException, HRAffairException {
        String personId = eInfo.getPerson().getId().toString();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("person.id", (Object)personId));
        filter.getFilterItems().add(new FilterItemInfo("isInner", (Object)true));
        filter.getFilterItems().add(new FilterItemInfo("LEFFDT", (Object)"2199-12-31"));
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("action.number"));
        sic.add(new SelectorItemInfo("EFFDT"));
        view.setFilter(filter);
        view.setSelector(sic);
        EmpPosOrgRelationCollection coll = EmpPosOrgRelationFactory.getLocalInstance((Context)ctx).getEmpPosOrgRelationCollection(view);
        for (int j = 0; j < coll.size(); ++j) {
            Date bizDate;
            EmpPosOrgRelationInfo empPosOrgRelation = coll.get(j);
            HRBizDefineInfo action = empPosOrgRelation.getAction();
            if (action == null || !"SHR03".equals(action.getNumber()) || !(bizDate = eInfo.getBizDate()).before(empPosOrgRelation.getEFFDT())) continue;
            throw new HRAffairException(HRAffairException.PERSON_HAS_HIRE_CAN_ONLY_FLUC, new Object[]{HRUtilExtend.getDateStringWithoutMininute((Date)empPosOrgRelation.getEFFDT())});
        }
    }

    private void checkbizDate(Context ctx, FlucInBizBillEntryInfo eInfo) throws BOSException, HRAffairException {
        String personId = eInfo.getPerson().getId().toString();
        EmpPosOrgRelationCollection empPosOrgRelationCol = null;
        EmpPosOrgRelationQueryHelper empPosOrgRelationHelper = new EmpPosOrgRelationQueryHelper();
        empPosOrgRelationCol = empPosOrgRelationHelper.getAppointDateAfterPrimaryPosition(ctx, personId, eInfo.getBizDate());
        if (empPosOrgRelationCol != null && empPosOrgRelationCol.size() > 0) {
            EmpPosOrgRelationInfo empPosOrgRelationInfo = empPosOrgRelationCol.get(0);
            if (eInfo.getBizDate().before(empPosOrgRelationInfo.getEFFDT())) {
                throw new HRAffairException(HRAffairException.PERSON_HAS_OPT_AT_TIME, new Object[]{HRUtilExtend.getDateStringWithoutMininute((Date)empPosOrgRelationInfo.getEFFDT())});
            }
        }
    }

    @Override
    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        FlucInBizBillInfo billInfo = (FlucInBizBillInfo)model;
        HrAffairFillEmptyBizDefineUtil.fillFlucInBizBillEntry(ctx, billInfo.getEntrys());
        FlucInBizBillEntryCollection entrys = billInfo.getEntrys();
        IObjectPK pk = super._submit(ctx, model);
        for (int i = 0; i < entrys.size(); ++i) {
            FlucInBizBillEntryInfo entry = entrys.get(i);
            String personId = entry.getPerson().getId().toString();
            FluctuationInOutInfo flucInOutInfo = FluctuationInOutUtil.getPersonFluctuationInOutInfo((Context)ctx, (String)personId);
            if (flucInOutInfo == null) continue;
            flucInOutInfo.setCompleteState(CompleteStateEnum.COMPLETING);
            flucInOutInfo.setFlucInBill(billInfo);
            flucInOutInfo.setNewPosition(entry.getPosition());
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("completeState"));
            sic.add(new SelectorItemInfo("flucInBill"));
            sic.add(new SelectorItemInfo("newPosition"));
            FluctuationInOutFactory.getLocalInstance((Context)ctx).updatePartial(flucInOutInfo, sic);
        }
        return pk;
    }

    @Override
    protected void checkAfterSubmit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        super.checkAfterSubmit(ctx, model);
    }

    @Override
    protected void _doWithPriorityThingEffect(Context ctx, HRAffairBizBillEntryInfo entry) throws BOSException, EASBizException {
        super._doWithPriorityThingEffect(ctx, entry);
        FlucInBizBillEntryInfo einfo = (FlucInBizBillEntryInfo)entry;
    }

    @Override
    protected void _doWithCommonRelationEffect(Context ctx, HRAffairBizBillEntryInfo entry) throws BOSException, EASBizException {
        super._doWithCommonRelationEffect(ctx, entry);
    }

    private void dowithPersonContract(Context ctx, FlucInBizBillEntryInfo eInfo) throws EASBizException, BOSException {
        PersonInfo pInfo = eInfo.getPerson();
        String personId = pInfo.getId().toString();
        Date contractEndDate = HRUtil.getBeforeDate((Date)eInfo.getBizDate());
        if (eInfo.isIsEndEmpContract()) {
            ContractUtils.endPersonContract((Context)ctx, (String)personId, (Date)contractEndDate);
        }
        if (eInfo.isIsEndEmpOtherContract()) {
            ContractUtils.endPersonOtherContract((Context)ctx, (String)personId, (Date)contractEndDate);
        }
    }

    @Override
    protected void _doWithSpecialFiledsEffect(Context ctx, HRAffairBizBillEntryInfo entry) throws BOSException, EASBizException {
        super._doWithSpecialFiledsEffect(ctx, entry);
        FlucInBizBillEntryInfo eInfo = (FlucInBizBillEntryInfo)entry;
        FlucInBizBillInfo billInfo = eInfo.getBill();
        String personId = entry.getPerson().getId().toString();
        FluctuationInOutInfo flucInOutInfo = FluctuationInOutUtil.getPersonFluctuationInOutInfo((Context)ctx, (String)personId);
        if (flucInOutInfo != null) {
            flucInOutInfo.setCompleteState(CompleteStateEnum.COMPLETED);
            flucInOutInfo.setFlucInBill(billInfo);
            flucInOutInfo.setNewPosition(eInfo.getPosition());
            flucInOutInfo.setEFFECT(entry.getBizDate());
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("completeState"));
            sic.add(new SelectorItemInfo("flucInBill"));
            sic.add(new SelectorItemInfo("newPosition"));
            sic.add(new SelectorItemInfo("EFFECT"));
            FluctuationInOutFactory.getLocalInstance((Context)ctx).updatePartial(flucInOutInfo, sic);
        }
        this.dowithPersonContract(ctx, eInfo);
    }

    @Override
    protected void _doWithOtherChangeEffect(Context ctx, HRAffairBizBillEntryInfo entry) throws BOSException, EASBizException {
        super._doWithOtherChangeEffect(ctx, entry);
        FlucInBizBillEntryInfo einfo = (FlucInBizBillEntryInfo)entry;
        PersonInfo pInfo = einfo.getPerson();
    }

    @Override
    protected void _entryEffect(Context ctx, HRBillBaseEntryInfo entry) throws BOSException, EASBizException {
        super._entryEffect(ctx, entry);
    }

    protected String getPermItemNameDelete() {
        return "flucIn_Delete";
    }

    protected String getPermItemNameAddnew() {
        return "flucIn_AddNew";
    }

    protected String getPermItemNameEdit() {
        return "flucIn_Update";
    }

    protected String getEntryIdStr(Context ctx, IObjectPK pk) throws EASBizException, BOSException {
        FlucInBizBillInfo BillInfo = FlucInBizBillFactory.getLocalInstance(ctx).getFlucInBizBillInfo(pk);
        FlucInBizBillEntryCollection billEntryCol = BillInfo.getEntrys();
        StringBuffer billEntryIdStr = new StringBuffer();
        int size = billEntryCol.size();
        for (int i = 0; i < size; ++i) {
            billEntryIdStr.append("'");
            billEntryIdStr.append(billEntryCol.get(i).getId().toString());
            if (i == size - 1) {
                billEntryIdStr.append("'");
                continue;
            }
            billEntryIdStr.append("',");
        }
        return billEntryIdStr.toString();
    }

    @Override
    public void _unAuditEachEntrySpecialPropertyRecovery(Context ctx, HRAffairBizBillEntryInfo entry) throws BOSException, EASBizException {
        FlucInBizBillEntryInfo entryInfo = (FlucInBizBillEntryInfo)entry;
        FluctuationInOutInfo flucInOutInfo = FluctuationInOutUtil.getFluctuationInOutInfoByInBill((Context)ctx, (String)entryInfo.getBill().getId().toString());
        if (flucInOutInfo != null) {
            flucInOutInfo.setCompleteState(CompleteStateEnum.NO_COMPLETE);
            flucInOutInfo.setNewPosition(null);
            flucInOutInfo.setFlucInBill(null);
            flucInOutInfo.setEFFECT(null);
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("completeState"));
            sic.add(new SelectorItemInfo("newPosition"));
            sic.add(new SelectorItemInfo("flucInBill"));
            sic.add(new SelectorItemInfo("EFFECT"));
            FluctuationInOutFactory.getLocalInstance((Context)ctx).updatePartial(flucInOutInfo, sic);
        }
    }

    @Override
    protected void _untiCheckBizBill(Context ctx, String billId) throws BOSException, EASBizException {
        super._untiCheckBizBill(ctx, billId);
    }

    @Override
    protected void _abortBizBill(Context ctx, String billId) throws BOSException, EASBizException {
        super._abortBizBill(ctx, billId);
        FluctuationInOutInfo flucInOutInfo = FluctuationInOutUtil.getFluctuationInOutInfoByInBill((Context)ctx, (String)billId);
        if (flucInOutInfo != null) {
            flucInOutInfo.setCompleteState(CompleteStateEnum.NO_COMPLETE);
            flucInOutInfo.setFlucInBill(null);
            flucInOutInfo.setNewPosition(null);
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("completeState"));
            sic.add(new SelectorItemInfo("flucInBill"));
            sic.add(new SelectorItemInfo("newPosition"));
            FluctuationInOutFactory.getLocalInstance((Context)ctx).updatePartial(flucInOutInfo, sic);
        }
    }

    @Override
    protected boolean isNeedDoWithUserPermission() {
        return true;
    }

    @Override
    protected void setHrOrgUnitForEntry(Context ctx, IObjectValue model, HRAffairBizBillEntryInfo entry, EmpHRORelationHisInfo buRelationInfo) {
        HRAffairBizBillInfo billInfo = (HRAffairBizBillInfo)model;
        if (entry.getHrOrgUnit() == null && billInfo.getHrOrgUnit() != null) {
            entry.setHrOrgUnit(billInfo.getHrOrgUnit());
        }
    }

    @Override
    protected void setBillUseDefault(Context ctx, IObjectValue model, HRAffairBizBillEntryInfo entry, EmpHRORelationHisInfo buRelationInfo) throws BOSException, EASBizException {
        HRAffairBizBillInfo billInfo = (HRAffairBizBillInfo)model;
        billInfo.setUseDefault(true);
        entry.setUseDefault(true);
    }

    @Override
    protected HRAffairBizBillEntryInfo storefieldsForEntry(Context ctx, HRAffairBizBillInfo billInfo, HRAffairBizBillEntryInfo entryInfo) throws EASBizException, BOSException {
        PositionInfo positionInfo;
        JobGradeInfo jobGradeInfo = entryInfo.getJobGrade();
        JobLevelInfo jobLevelInfo = entryInfo.getJobLevel();
        if (entryInfo.getAdminOrg() == null && (positionInfo = entryInfo.getPosition()) != null) {
            entryInfo.setAdminOrg(SHREmpOptOrgnizationTool.getAdminOrgUnitByPosition((Context)ctx, (String)positionInfo.getId().toString()));
        }
        super.storefieldsForEntry(ctx, billInfo, entryInfo);
        entryInfo.setJobGrade(jobGradeInfo);
        entryInfo.setJobLevel(jobLevelInfo);
        return entryInfo;
    }

    @Override
    protected void _setAuditEnd(Context ctx, BOSUuid billID) throws BOSException, EASBizException {
        super._setAuditEnd(ctx, billID);
        StringBuffer sql = new StringBuffer("update T_HR_FluctuationInOut set FCompleteState = 0 where FFlucInBill = '").append(billID).append("'");
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }
}

