/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.affair.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.basedata.org.PositionInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.eas.framework.batchHandler.ResponseContext;
import com.kingdee.eas.hr.affair.FluctuationBillEntryInfo;
import com.kingdee.eas.hr.affair.FluctuationBillInfo;
import com.kingdee.eas.hr.affair.app.AbstractFluctuationBillEditUIHandler;
import com.kingdee.eas.hr.org.JobLevelCollection;
import com.kingdee.eas.hr.org.JobLevelFactory;
import com.kingdee.util.DateTimeUtils;
import java.util.Date;

public class FluctuationBillEditUIHandler
extends AbstractFluctuationBillEditUIHandler {
    @Override
    protected void _handleInit(RequestContext request, ResponseContext response, Context context) throws Exception {
        super._handleInit(request, response, context);
        this.getUIPermissionItem(request, context);
        this.getParamValueIgnoreGroupControl(request, context);
        this.getCtrlUnitInfo(request, context);
        this.getParamValueIgnoreGroupControl(context, "Yd001");
        this.getJobLvlsByJobId(request, context);
    }

    protected void verifyInput(RequestContext request, ResponseContext response, Context context) throws Exception {
        this.checkIsPersonInProcessForFluctuation(request, context);
        super.verifyInput(request, response, context);
    }

    private void checkIsPersonInProcessForFluctuation(RequestContext request, Context context) throws BOSException, EASBizException {
        PersonInfo pInfo = null;
        FluctuationBillInfo billInfo = (FluctuationBillInfo)request.getValue();
        if (null != billInfo.getEntries()) {
            int size = billInfo.getEntries().size();
            for (int i = 0; i < size; ++i) {
                IObjectValue baseInfo;
                pInfo = billInfo.getEntries().get(i).getPerson();
                if (pInfo == null || (baseInfo = this.createNewData()) == null) continue;
                String id = "";
                if (null != request.getId()) {
                    id = request.getId().toString();
                }
                this.checkIsPersonInProcess(request, context, baseInfo.getBOSType(), this.createbillBosType(), pInfo, id);
            }
        }
    }

    @Override
    protected BOSObjectType createbillBosType() {
        return new FluctuationBillEntryInfo().getBOSType();
    }

    @Override
    protected IObjectValue createNewData() {
        FluctuationBillInfo info = new FluctuationBillInfo();
        info.setIsMultiEntry(true);
        info.setApplyDate(DateTimeUtils.truncateDate((Date)new Date()));
        if (this.nowClientDate != null) {
            info.setApplyDate(this.nowClientDate);
        }
        return info;
    }

    private void getParamValueIgnoreGroupControl(RequestContext request, Context context) throws BOSException, EASBizException {
        String hrOrgId = null;
        if (null != request.getOrg()) {
            hrOrgId = request.getOrg().toString();
        }
        this.getParamValueIgnoreGroupControl(context, "IS_FLUN_ALLHR", hrOrgId);
    }

    private void getJobLvlsByJobId(RequestContext request, Context context) throws Exception {
        FluctuationBillInfo billInfo = (FluctuationBillInfo)request.getValue();
        if ("EDIT".equals(request.getState())) {
            int size = billInfo.getEntries().size();
            for (int i = 0; i < size; ++i) {
                FluctuationBillEntryInfo billEntryInfo = billInfo.getEntries().get(i);
                PositionInfo pInfo = billEntryInfo.getNewPosition();
                if (pInfo == null || pInfo.getJob() == null) continue;
                this.getJobLvlsByJobId(context, pInfo.getJob().getId().toString());
            }
        }
    }

    protected void _handleActionAddNew(RequestContext request, ResponseContext response, Context context) throws Exception {
        this.checkPermission(request, context);
        super._handleActionAddNew(request, response, context);
    }

    @Override
    protected void _handleActionSubmit(RequestContext request, ResponseContext response, Context context) throws Exception {
        super._handleActionSubmit(request, response, context);
        this.appLogWriteAndUpdate(request, context);
    }

    @Override
    protected void _handleActionSave(RequestContext request, ResponseContext response, Context context) throws Exception {
        super._handleActionSave(request, response, context);
    }

    protected IObjectPK runSave(RequestContext request, Context context) throws Exception {
        return super.runSave(request, context);
    }

    @Override
    protected void _handleactionAddPerson(RequestContext request, ResponseContext response, Context context) throws Exception {
    }

    @Override
    protected void _handleactionDelPerson(RequestContext request, ResponseContext response, Context context) throws Exception {
    }

    @Override
    protected void _handleactionAffairReg(RequestContext request, ResponseContext response, Context context) throws Exception {
    }

    @Override
    protected void _handleActionCopyPosition(RequestContext request, ResponseContext response, Context context) throws Exception {
    }

    private JobLevelCollection getJobLvlsByJobId(Context context, String jobId) throws Exception {
        String oql = "select id, number, name, jobGrade.id, jobGrade.number, jobGrade.name where job.id = '" + jobId + "'";
        return JobLevelFactory.getLocalInstance((Context)context).getJobLevelCollection(oql);
    }
}

