/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.affair.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.affair.EmpEnrollBizBillEntryCollection;
import com.kingdee.eas.hr.affair.EmpEnrollBizBillEntryFactory;
import com.kingdee.eas.hr.affair.EmpEnrollBizBillEntryInfo;
import com.kingdee.eas.hr.affair.EmpEnrollBizBillInfo;
import com.kingdee.eas.hr.affair.HRAffairBizBillEntryInfo;
import com.kingdee.eas.hr.affair.app.AffairAuditEffectHelper;
import com.kingdee.eas.hr.base.AffairActioniOperateException;
import com.kingdee.eas.hr.base.HRBizData;
import com.kingdee.eas.hr.base.app.util.HRBizDefineAffairUtils;
import com.kingdee.shr.ml.util.SHRServerResource;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.StringUtils;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;

public class HRAffairBizBillEntryValidateHelper {
    private Boolean isEnrollAgain = Boolean.FALSE;
    private final Set<String> idCardNoSet = new HashSet<String>();
    private final Set<String> passportSet = new HashSet<String>();
    private final Set<String> empNumberSet = new HashSet<String>();

    public void validateFieldNotNull(Context ctx, HRAffairBizBillEntryInfo entry, Date effectDate) throws EASBizException, BOSException {
        AffairAuditEffectHelper helper = new AffairAuditEffectHelper();
        HRBizData bizData = helper.affairEntryConvertToBizData(ctx, effectDate, entry);
        try {
            HRBizDefineAffairUtils.validateBizData((Context)ctx, (HRBizData)bizData);
        }
        catch (EASBizException e) {
            e.printStackTrace();
            throw e;
        }
    }

    public void validPersonDup(Context ctx, EmpEnrollBizBillEntryInfo entryInfo, String billId) throws EASBizException, BOSException {
    }

    public void validPersonDup(Context ctx, EmpEnrollBizBillEntryInfo entryInfo, String billId, Boolean isEnrollAgain) throws EASBizException, BOSException {
        this.isEnrollAgain = isEnrollAgain;
        String idStr = entryInfo.getIDCardNo();
        String passStr = entryInfo.getPassportNo();
        String entryId = entryInfo.getId() == null ? null : entryInfo.getId().toString();
        String empNumber = entryInfo.getEmpNumber();
        boolean isExist = false;
        if (!StringUtils.isEmpty((String)idStr)) {
            isExist = this.validPersonByString(ctx, "IDCard", idStr, billId);
            if (this.idCardNoSet.contains(idStr)) {
                throw new AffairActioniOperateException(AffairActioniOperateException.BILLENTRYSIDCARDNODUP, new Object[]{entryInfo.getEmpNumber()});
            }
            this.idCardNoSet.add(idStr);
        } else if (!StringUtils.isEmpty((String)passStr)) {
            isExist = this.validPersonByString(ctx, "PassNo", passStr, billId);
            if (this.passportSet.contains(passStr)) {
                throw new AffairActioniOperateException(AffairActioniOperateException.BILLENTRYPASSPORTDUP, new Object[]{entryInfo.getEmpNumber()});
            }
            this.passportSet.add(passStr);
        } else {
            throw new AffairActioniOperateException(AffairActioniOperateException.NOTALLBLANK);
        }
        if (this.isEmpNumberDup(ctx, entryInfo.getEmpNumber(), billId)) {
            throw new AffairActioniOperateException(AffairActioniOperateException.EMPNUMBERDUP, new Object[]{entryInfo.getEmpNumber()});
        }
        if (this.empNumberSet.contains(empNumber)) {
            throw new AffairActioniOperateException(AffairActioniOperateException.BILLENTRYEMPNUMBERDUP, new Object[]{entryInfo.getEmpNumber()});
        }
        this.empNumberSet.add(empNumber);
    }

    private boolean isEmpNumberDup(Context ctx, String empNumber, String billId) throws BOSException, EASBizException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("empNumber", (Object)empNumber));
        if (!StringUtils.isEmpty((String)billId)) {
            filter.getFilterItems().add(new FilterItemInfo("bill.id", (Object)billId, CompareType.NOTEQUALS));
        }
        HashSet<Integer> set = this.getDumpStatusSet();
        filter.getFilterItems().add(new FilterItemInfo("bill.billState", set, CompareType.NOTINCLUDE));
        viewInfo.setFilter(filter);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("bill.number"));
        viewInfo.setSelector(selector);
        EmpEnrollBizBillEntryCollection col = EmpEnrollBizBillEntryFactory.getLocalInstance(ctx).getEmpEnrollBizBillEntryCollection(viewInfo);
        if (col.size() > 0) {
            throw new AffairActioniOperateException(AffairActioniOperateException.EMPNUMBERDUP, new Object[]{empNumber, col.get(0).getBill().getNumber()});
        }
        return false;
    }

    private boolean validPersonByString(Context ctx, String str, String idStr, String billId) throws BOSException, EASBizException {
        boolean isExist = false;
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        StringBuffer exceptStr = new StringBuffer();
        if ("IDCard".equals(str)) {
            filter.getFilterItems().add(new FilterItemInfo("IDCardNo", (Object)idStr));
            exceptStr.append(SHRServerResource.getString((String)"com.kingdee.eas.hr.affair.AffairBizResource", (String)"idCard", (Context)ctx));
        } else {
            filter.getFilterItems().add(new FilterItemInfo("passportNo", (Object)idStr));
            exceptStr.append(SHRServerResource.getString((String)"com.kingdee.eas.hr.affair.AffairBizResource", (String)"passport", (Context)ctx));
        }
        exceptStr.append(idStr);
        if (!StringUtils.isEmpty((String)billId)) {
            filter.getFilterItems().add(new FilterItemInfo("bill.id", (Object)billId, CompareType.NOTEQUALS));
        }
        HashSet<Integer> set = this.getDumpStatusSet();
        filter.getFilterItems().add(new FilterItemInfo("bill.billState", set, CompareType.NOTINCLUDE));
        viewInfo.setFilter(filter);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("bill.number"));
        viewInfo.setSelector(selector);
        EmpEnrollBizBillEntryCollection col = EmpEnrollBizBillEntryFactory.getLocalInstance(ctx).getEmpEnrollBizBillEntryCollection(viewInfo);
        if (col.size() > 0) {
            isExist = true;
            throw new AffairActioniOperateException(AffairActioniOperateException.IDCARDNOORPASSPORTHASEXITS, new Object[]{exceptStr.toString(), col.get(0).getBill().getNumber()});
        }
        return isExist;
    }

    private HashSet<Integer> getDumpStatusSet() {
        HashSet<Integer> set = new HashSet<Integer>();
        set.add(3);
        set.add(4);
        return set;
    }

    public static String getDateString(Date date) {
        return DateTimeUtils.format((Date)date, (String)"yyyy-MM-dd");
    }

    public void validPersonDup(Context ctx, EmpEnrollBizBillInfo billInfo) throws EASBizException, BOSException {
        String billId = billInfo.getId() != null ? billInfo.getId().toString() : null;
        EmpEnrollBizBillEntryCollection entrys = billInfo.getEntrys();
        int size = entrys.size();
        for (int i = 0; i < size; ++i) {
            this.validPersonDup(ctx, entrys.get(i), billId);
        }
    }
}

