/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.affair.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.affair.HRAffairBaseInfo;
import com.kingdee.eas.hr.affair.HRAffairException;
import com.kingdee.eas.hr.affair.HRAffairPersonPreProcessFacadeFactory;
import com.kingdee.eas.hr.affair.HireBillEntryCollection;
import com.kingdee.eas.hr.affair.HireBillEntryInfo;
import com.kingdee.eas.hr.affair.HireBillFactory;
import com.kingdee.eas.hr.affair.HireBillInfo;
import com.kingdee.eas.hr.affair.app.AbstractHireBillControllerBean;
import com.kingdee.eas.hr.base.HRCommonException;
import com.kingdee.eas.hr.base.batch.BatchProcessedResult;
import com.kingdee.eas.hr.org.IPersonPlan;
import com.kingdee.eas.hr.org.PersonPlanFactory;
import com.kingdee.eas.util.ResourceBase;
import java.util.ArrayList;
import java.util.Date;
import java.util.Locale;

public class HireBillControllerBean
extends AbstractHireBillControllerBean {
    @Override
    protected void checkBillEntry(Context ctx, HRAffairBaseInfo model) throws BOSException, EASBizException {
        BatchProcessedResult result;
        super.checkBillEntry(ctx, model);
        ArrayList<PersonInfo> persons = new ArrayList<PersonInfo>();
        HireBillInfo info = (HireBillInfo)model;
        HireBillEntryCollection c = info.getEntries();
        HireBillEntryInfo eInfo = null;
        int size = c.size();
        for (int i = 0; i < size; ++i) {
            eInfo = c.get(i);
            IPersonPlan iPPlan = PersonPlanFactory.getLocalInstance((Context)ctx);
            iPPlan.canAddPerson(eInfo.getEposition().getId().toString());
            persons.add(eInfo.getPerson());
        }
        String billId = null;
        if (info.getId() != null) {
            billId = info.getId().toString();
        }
        if ((result = HRAffairPersonPreProcessFacadeFactory.getLocalInstance(ctx).preProcessHirePerson(persons, billId)) == null) {
            return;
        }
        if (result.isHasValidInfo()) {
            throw new HRCommonException(HRCommonException.EXCEPTION_MSG, (Object[])new String[]{result.getInvalidInfo()});
        }
    }

    protected String getPermItemNameDelete() {
        return "HireBill_Delete";
    }

    protected String getPermItemNameAddnew() {
        return "HireBill_AddNew";
    }

    protected String getPermItemNameEdit() {
        return "HireBill_Edit";
    }

    @Override
    protected String getResource(Context ctx) {
        return ResourceBase.getString((String)"com.kingdee.eas.hr.affair.AFFAIRAutoGenerateResource", (String)"26_HRAffairBaseControllerBean", (Locale)ctx.getOriginLocale());
    }

    @Override
    protected void checkEffectData(Context ctx, String billID) throws BOSException, EASBizException {
        HireBillInfo billInfo = HireBillFactory.getLocalInstance(ctx).getHireBillInfo((IObjectPK)new ObjectUuidPK(billID));
        HireBillEntryCollection entryCol = billInfo.getEntries();
        Date now = new Date();
        boolean result = false;
        int size = entryCol.size();
        for (int i = 0; i < size; ++i) {
            HireBillEntryInfo entryInfo = entryCol.get(i);
            if (!now.after(entryInfo.getHireDate())) continue;
            result = true;
            break;
        }
        if (result) {
            throw new HRAffairException(HRAffairException.CAN_NOT_UNAUDIT);
        }
    }

    @Override
    protected String getEntryIdStr(Context ctx, IObjectPK pk) throws EASBizException, BOSException {
        HireBillInfo billInfo = HireBillFactory.getLocalInstance(ctx).getHireBillInfo(pk);
        HireBillEntryCollection billEntryCol = billInfo.getEntries();
        StringBuffer billEntryIdStr = new StringBuffer();
        int size = billEntryCol.size();
        for (int i = 0; i < size; ++i) {
            billEntryIdStr.append("'");
            billEntryIdStr.append(billEntryCol.get(i).getId().toString());
            if (i == size - 1) {
                billEntryIdStr.append("'");
                continue;
            }
            billEntryIdStr.append("',");
        }
        return billEntryIdStr.toString();
    }
}

