/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.affair.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.PositionInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.affair.AffairBizHistoryFactory;
import com.kingdee.eas.hr.affair.AffairBizHistoryInfo;
import com.kingdee.eas.hr.affair.app.HRAffairBillBizBean;
import com.kingdee.eas.hr.base.HRBillBaseEntryInfo;
import com.kingdee.eas.hr.base.HRBillBaseInfo;
import com.kingdee.eas.hr.base.LoanOwnerEnum;
import com.kingdee.util.StringUtils;

public class LoanBackBillBizBean
extends HRAffairBillBizBean {
    @Override
    protected void saveAffairHistory(Context ctx, HRBillBaseEntryInfo entry) throws BOSException, EASBizException {
        String billField = this.getBillField();
        String entryBizDate = this.getEntryEffectDateField();
        if (StringUtils.isEmpty((String)billField)) {
            return;
        }
        HRBillBaseInfo bill = (HRBillBaseInfo)entry.get(billField);
        if (bill != null) {
            AffairBizHistoryInfo historyInfo = new AffairBizHistoryInfo();
            historyInfo.setBillID(bill.getId());
            historyInfo.setBillBOSType(bill.getBOSType().toString());
            historyInfo.setBillAdmin(bill.getAdminOrg());
            historyInfo.setHrOrgUnit(bill.getHrOrgUnit());
            historyInfo.setEntryID(entry.getId());
            if (entry.get("owner") != null) {
                historyInfo.setOwner(LoanOwnerEnum.getEnum((String)entry.get("owner").toString()));
            }
            AdminOrgUnitInfo oldAdmin = null;
            AdminOrgUnitInfo newAdmin = null;
            PositionInfo oldPosition = null;
            PositionInfo newPosition = null;
            if (!StringUtils.isEmpty((String)entryBizDate)) {
                historyInfo.setEffectDate(entry.getDate(entryBizDate));
            }
            if (!StringUtils.isEmpty((String)this.getPersonField())) {
                historyInfo.setPerson((PersonInfo)entry.get(this.getPersonField()));
            }
            if (!StringUtils.isEmpty((String)this.getOldAdminField())) {
                oldAdmin = (AdminOrgUnitInfo)entry.get(this.getOldAdminField());
                historyInfo.setOldAdmin(oldAdmin);
            }
            if (!StringUtils.isEmpty((String)this.getNewAdminField())) {
                newAdmin = (AdminOrgUnitInfo)entry.get(this.getNewAdminField());
                historyInfo.setNewAdmin(newAdmin);
            }
            if (!StringUtils.isEmpty((String)this.getOldPositionField())) {
                oldPosition = (PositionInfo)entry.get(this.getOldPositionField());
                historyInfo.setOldPosition(oldPosition);
            }
            if (!StringUtils.isEmpty((String)this.getNewPositionField())) {
                newPosition = (PositionInfo)entry.get(this.getNewPositionField());
                historyInfo.setNewPosition(newPosition);
            }
            historyInfo.setTuned(false);
            this.setHistoryAdminInOut(historyInfo, oldAdmin, newAdmin, oldPosition, newPosition);
            AffairBizHistoryFactory.getLocalInstance(ctx).addnew(historyInfo);
        }
    }
}

