/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.affair.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.framework.DynamicObjectFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.workflow.exception.WfParticipantException;
import com.kingdee.bos.workflow.participant.Person;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.IFullOrgUnit;
import com.kingdee.eas.basedata.org.IPositionMember;
import com.kingdee.eas.basedata.org.JobInfo;
import com.kingdee.eas.basedata.org.PositionFactory;
import com.kingdee.eas.basedata.org.PositionInfo;
import com.kingdee.eas.basedata.org.PositionMemberCollection;
import com.kingdee.eas.basedata.org.PositionMemberFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.basedata.person.app.PersonToWFAdapter;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.affair.EnrollBillCollection;
import com.kingdee.eas.hr.affair.EnrollBillFactory;
import com.kingdee.eas.hr.affair.FluctuationBillCollection;
import com.kingdee.eas.hr.affair.FluctuationBillFactory;
import com.kingdee.eas.hr.affair.IEnrollBill;
import com.kingdee.eas.hr.affair.IFluctuationBill;
import com.kingdee.eas.hr.emp.IPersonPosition;
import com.kingdee.eas.hr.emp.PersonPositionCollection;
import com.kingdee.eas.hr.emp.PersonPositionFactory;
import com.kingdee.eas.hr.org.JobGradeInfo;
import com.kingdee.eas.hr.org.JobLevelInfo;
import com.kingdee.eas.hr.time.TimeAttendanceInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;

public class WorkflowUtils {
    public static int getPositionLevelByUserId(Context ctx, Object userId, String hierarchyId) throws BOSException, EASBizException {
        int level = 0;
        StringBuffer sb = new StringBuffer();
        sb.append("SELECT flevel \n");
        sb.append("FROM t_org_positionhierarchy \n");
        sb.append("where fhierarchyid = ?  \n");
        sb.append("and fchildid in ( \n");
        sb.append("select fpositionid from t_org_positionmember where fpersonid in  \n");
        sb.append("(select fpersonid from t_pm_user where fid = ?) \n");
        sb.append(" ) \n");
        sb.append("order by flevel \n");
        IRowSet rows = DbUtil.executeQuery((Context)ctx, (String)sb.toString(), (Object[])new Object[]{hierarchyId, userId.toString()});
        try {
            if (rows.next()) {
                level = rows.getInt("flevel");
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return level;
    }

    public static boolean isSamePrincipalPosition(Context ctx, String oldPositionId, String newPositionId) throws BOSException, EASBizException {
        return (oldPositionId = WorkflowUtils.getPrincialPosition(ctx, oldPositionId)).equals(newPositionId = WorkflowUtils.getPrincialPosition(ctx, newPositionId));
    }

    public static BOSUuid getHROrgIdByPosition(Context ctx, BOSUuid positionId) throws BOSException, EASBizException {
        String oql = "select hrOrgUnit.id where id = '" + positionId + "'";
        return PositionFactory.getLocalInstance((Context)ctx).getPositionCollection(oql).get(0).getHrOrgUnit().getId();
    }

    public static boolean isSameStr(BOSUuid str1, BOSUuid str2) {
        return str1.toString().equals(str2.toString());
    }

    public static JobGradeInfo getJobGradeByPersonId(Context ctx, String personId) throws BOSException, EASBizException {
        String oql;
        JobGradeInfo info = null;
        IPersonPosition ipp = PersonPositionFactory.getLocalInstance((Context)ctx);
        PersonPositionCollection c = ipp.getPersonPositionCollection(oql = "select jobGrade.* where person.id = '" + personId + "'");
        if (c.size() > 0) {
            info = c.get(0).getJobGrade();
        }
        return info;
    }

    public static JobInfo getJobByPersonId(Context ctx, String personId) throws BOSException, EASBizException {
        JobInfo info = null;
        String oql = "select position.job.*, position.job.jobType.*, position.job.jobCategory.* where isPrimary = 1 and person.id = '" + personId + "'";
        PositionMemberCollection c = PositionMemberFactory.getLocalInstance((Context)ctx).getPositionMemberCollection(oql);
        if (c.size() > 0) {
            info = c.get(0).getPosition().getJob();
        }
        return info;
    }

    public static JobLevelInfo getJobLevelByPersonId(Context ctx, String personId) throws BOSException, EASBizException {
        String oql;
        JobLevelInfo info = null;
        IPersonPosition ipp = PersonPositionFactory.getLocalInstance((Context)ctx);
        PersonPositionCollection c = ipp.getPersonPositionCollection(oql = "select jobLevel.* where person.id = '" + personId + "'");
        if (c.size() > 0) {
            info = c.get(0).getJobLevel();
        }
        return info;
    }

    public static PositionInfo getPositionByPersonId(Context ctx, String personId) throws BOSException, EASBizException {
        PositionInfo info = null;
        String oql = "select position.* where isPrimary = 1 and person.id = '" + personId + "'";
        PositionMemberCollection c = PositionMemberFactory.getLocalInstance((Context)ctx).getPositionMemberCollection(oql);
        if (c.size() > 0) {
            info = c.get(0).getPosition();
        }
        return info;
    }

    public static String getPrimaryPositionByPersonId(Context ctx, String personId) throws BOSException, EASBizException {
        String oql = "select position.id where isPrimary = 1 and person.id = '" + personId + "'";
        PositionMemberCollection c = PositionMemberFactory.getLocalInstance((Context)ctx).getPositionMemberCollection(oql);
        if (c.size() > 0) {
            return c.get(0).getPosition().getId().toString();
        }
        return null;
    }

    public static IObjectValue getFirstEntryByBillId(Context ctx, BOSUuid billId) throws BOSException, EASBizException {
        Object info = null;
        String oql = "select entries.* where id = '" + billId + "'";
        IObjectCollection ic = DynamicObjectFactory.getLocalInstance((Context)ctx).getCollection(billId.getType(), oql);
        if (ic.size() > 0) {
            return ((IObjectCollection)ic.getObject(0).get("entries")).getObject(0);
        }
        return null;
    }

    public static TimeAttendanceInfo getLeaveTypeByBillId(Context ctx, BOSUuid billId) throws BOSException, EASBizException {
        Object info = null;
        String oql = "select entries.type.* where id = '" + billId + "'";
        IObjectCollection ic = DynamicObjectFactory.getLocalInstance((Context)ctx).getCollection(billId.getType(), oql);
        if (ic.size() > 0) {
            return (TimeAttendanceInfo)((IObjectCollection)ic.getObject(0).get("entries")).getObject(0).get("type");
        }
        return null;
    }

    public static PersonInfo getEntryPersonInfoByBillId(Context ctx, BOSUuid billId) throws BOSException, EASBizException {
        String oql = "select entries.person.* where id = '" + billId + "'";
        IObjectCollection ic = DynamicObjectFactory.getLocalInstance((Context)ctx).getCollection(billId.getType(), oql);
        if (ic.size() > 0) {
            return (PersonInfo)((IObjectCollection)ic.getObject(0).get("entries")).getObject(0).get("person");
        }
        return null;
    }

    public static String getPositionIdByBillId(Context ctx, BOSUuid billId) throws BOSException, EASBizException {
        PersonInfo info = WorkflowUtils.getEntryPersonInfoByBillId(ctx, billId);
        if (info != null) {
            return WorkflowUtils.getPrimaryPositionByPersonId(ctx, info.getId().toString());
        }
        return null;
    }

    public static String getPositionIdByHireBill(Context ctx, BOSUuid billId) throws BOSException, EASBizException {
        PersonInfo info = WorkflowUtils.getEntryPersonInfoByBillId(ctx, billId);
        if (info != null) {
            return WorkflowUtils.getPrimaryPositionByPersonId(ctx, info.getId().toString());
        }
        return null;
    }

    public static String getPositionIdByEnrollBill(Context ctx, BOSUuid billId) throws BOSException, EASBizException {
        IEnrollBill ie = EnrollBillFactory.getLocalInstance(ctx);
        EnrollBillCollection c = ie.getEnrollBillCollection("select entries.position.id where id = '" + billId.toString() + "'");
        String positionId = null;
        if (c.size() > 0) {
            positionId = c.get(0).getEntries().get(0).getPosition().getId().toString();
        }
        return positionId;
    }

    public static String[] getOldNewPositionCUNumber(Context ctx, BOSUuid billId) throws BOSException, EASBizException {
        String oldCUNum = null;
        String newCUNum = null;
        IFluctuationBill ifl = FluctuationBillFactory.getLocalInstance(ctx);
        FluctuationBillCollection c = ifl.getFluctuationBillCollection("select entries.oldPosition.CU.number, entries.newPosition.CU.number where id = '" + billId.toString() + "'");
        if (c.size() > 0) {
            oldCUNum = c.get(0).getEntries().get(0).getOldPosition().getCU().getNumber();
            newCUNum = c.get(0).getEntries().get(0).getNewPosition().getCU().getNumber();
        }
        return new String[]{oldCUNum, newCUNum};
    }

    public static String[] getOldNewPositionId(Context ctx, BOSUuid billId) throws BOSException, EASBizException {
        String oldPositionId = null;
        String newPositionId = null;
        IFluctuationBill ifl = FluctuationBillFactory.getLocalInstance(ctx);
        FluctuationBillCollection c = ifl.getFluctuationBillCollection("select entries.oldPosition.id, entries.newPosition.id where id = '" + billId.toString() + "'");
        if (c.size() > 0) {
            oldPositionId = c.get(0).getEntries().get(0).getOldPosition().getId().toString();
            newPositionId = c.get(0).getEntries().get(0).getNewPosition().getId().toString();
        }
        return new String[]{oldPositionId, newPositionId};
    }

    public static String getPrincialPosition(Context ctx, String positionId) throws BOSException, EASBizException {
        String positionId2;
        IRowSet rows;
        StringBuffer sb = new StringBuffer();
        sb.append("SELECT FResponPositionID  \n");
        sb.append("FROM T_ORG_ADMIN  \n");
        sb.append("WHERE FID IN  \n");
        sb.append("(SELECT FAdminOrgUnitID  \n");
        sb.append("FROM T_ORG_POSITION  \n");
        sb.append("WHERE FID = ?)  \n");
        try {
            rows = DbUtil.executeQuery((Context)ctx, (String)sb.toString(), (Object[])new Object[]{positionId});
            if (!rows.next()) {
                return positionId;
            }
            positionId2 = rows.getString("FResponPositionId");
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        if (positionId.equals(positionId2)) {
            sb = new StringBuffer();
            sb.append("SELECT FResponPositionID  \n");
            sb.append("FROM T_ORG_ADMIN  \n");
            sb.append("WHERE FID IN (  \n");
            sb.append("\tSELECT FParentID  \n");
            sb.append("\tFROM T_ORG_ADMIN  \n");
            sb.append("\tWHERE FID IN (  \n");
            sb.append("\tSELECT FAdminOrgUnitID  \n");
            sb.append("\tFROM T_ORG_POSITION  \n");
            sb.append("WHERE FID = ?) ) \n");
            try {
                rows = DbUtil.executeQuery((Context)ctx, (String)sb.toString(), (Object[])new Object[]{positionId});
                if (rows.next()) {
                    positionId2 = rows.getString("FResponPositionId");
                }
            }
            catch (Exception e) {
                throw new BOSException((Throwable)e);
            }
        }
        return positionId2;
    }

    public static Person[] getPrincipalByPosition(Context ctx, String positionId) throws BOSException, EASBizException {
        IRowSet rows;
        StringBuffer sb = new StringBuffer();
        sb.append("SELECT FResponPositionID  \n");
        sb.append("FROM T_ORG_ADMIN  \n");
        sb.append("WHERE FID IN  \n");
        sb.append("(SELECT FAdminOrgUnitID  \n");
        sb.append("FROM T_ORG_POSITION  \n");
        sb.append("WHERE FID = ?)  \n");
        String positionId2 = "";
        try {
            rows = DbUtil.executeQuery((Context)ctx, (String)sb.toString(), (Object[])new Object[]{positionId});
            if (rows.next()) {
                positionId2 = rows.getString("FResponPositionId");
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        if (positionId.equals(positionId2)) {
            sb = new StringBuffer();
            sb.append("SELECT FResponPositionID  \n");
            sb.append("FROM T_ORG_ADMIN  \n");
            sb.append("WHERE FID IN (  \n");
            sb.append("\tSELECT FParentID  \n");
            sb.append("\tFROM T_ORG_ADMIN  \n");
            sb.append("\tWHERE FID IN (  \n");
            sb.append("\tSELECT FAdminOrgUnitID  \n");
            sb.append("\tFROM T_ORG_POSITION  \n");
            sb.append("WHERE FID = ?)  )\n");
            try {
                rows = DbUtil.executeQuery((Context)ctx, (String)sb.toString(), (Object[])new Object[]{positionId});
                if (rows.next()) {
                    positionId2 = rows.getString("FResponPositionId");
                }
            }
            catch (Exception e) {
                throw new BOSException((Throwable)e);
            }
        }
        return new PersonToWFAdapter().getPositionHolders(ctx, positionId2);
    }

    public static int getJobGrade(Context ctx, String personId) throws BOSException, EASBizException {
        String oql;
        IPersonPosition ipp = PersonPositionFactory.getLocalInstance((Context)ctx);
        PersonPositionCollection c = ipp.getPersonPositionCollection(oql = "select jobGrade.grade where person.id = '" + personId + "'");
        int jobGrade = c.size() > 0 ? c.get(0).getJobGrade().getGrade() : -1;
        return jobGrade;
    }

    public static Person[] getMLHeaderPrincipal(Context ctx, String personId) throws WfParticipantException {
        String longNumber = "";
        try {
            IPositionMember ipm = PositionMemberFactory.getLocalInstance((Context)ctx);
            longNumber = ipm.getPositionMemberCollection("select position.adminOrgUnit.longNumber where person.id = '" + personId + "' and isPrimary = 1").get(0).getPosition().getAdminOrgUnit().getId().toString();
        }
        catch (Exception e) {
            throw new WfParticipantException((Throwable)e);
        }
        String typeId = "00000000-0000-0000-0000-0000000000100FE9F8B5";
        StringBuffer sb = new StringBuffer();
        sb.append("SELECT FResponPositionId  \n");
        sb.append("FROM T_ORG_Admin  \n");
        sb.append("WHERE FLongNumber = SUBString(?, 1, len(FLongNumber))  \n");
        sb.append("AND FLevel <= 3    \n");
        sb.append("AND FID IN (  \n");
        sb.append("select FFromUnitID  \n");
        sb.append("from T_ORG_UNITRELATION  \n");
        sb.append("\tWHERE FTypeRelationId = ?  \n");
        sb.append("and FToUnitID = 'CYX1uAEPEADgAAJmwKgSXMznrtQ=')  \n");
        sb.append("ORDER BY FLONGNUMBER desc \n");
        String positionId = "";
        try {
            IRowSet rows = DbUtil.executeQuery((Context)ctx, (String)sb.toString(), (Object[])new Object[]{longNumber, typeId});
            if (rows.next()) {
                positionId = rows.getString("FResponPositionId");
            }
        }
        catch (Exception e) {
            throw new WfParticipantException((Throwable)e);
        }
        return new PersonToWFAdapter().getPositionHolders(ctx, positionId);
    }

    public static Person[] getMLBranchPrincipal(Context ctx, String personId) throws WfParticipantException {
        String adminOrgId = "";
        try {
            IPositionMember ipm = PositionMemberFactory.getLocalInstance((Context)ctx);
            adminOrgId = ipm.getPositionMemberCollection("select position.adminOrgUnit.id where person.id = '" + personId + "' and isPrimary = 1").get(0).getPosition().getAdminOrgUnit().getId().toString();
        }
        catch (Exception e) {
            throw new WfParticipantException((Throwable)e);
        }
        String typeId = "00000000-0000-0000-0000-0000000000100FE9F8B5";
        StringBuffer sb = new StringBuffer();
        sb.append("SELECT FResponPositionId  \n");
        sb.append("FROM T_ORG_Admin  \n");
        sb.append("WHERE FID IN(  \n");
        sb.append("SELECT FToUnitId    \n");
        sb.append("\tFROM T_ORG_UNITRELATION  \n");
        sb.append("\tWHERE FTypeRelationId = ?  \n");
        sb.append("\tAND FFromUnitId = ?)  \n");
        String positionId = "";
        try {
            IRowSet rows = DbUtil.executeQuery((Context)ctx, (String)sb.toString(), (Object[])new Object[]{typeId, adminOrgId});
            if (rows.next()) {
                positionId = rows.getString("FResponPositionId");
            }
        }
        catch (Exception e) {
            throw new WfParticipantException((Throwable)e);
        }
        return new PersonToWFAdapter().getPositionHolders(ctx, positionId);
    }

    public static Person[] getOrgJobHolder(Context ctx, String orgId, String jobId) throws WfParticipantException {
        IFullOrgUnit iOrg;
        try {
            iOrg = FullOrgUnitFactory.getLocalInstance((Context)ctx);
        }
        catch (BOSException e) {
            throw new WfParticipantException((Throwable)e);
        }
        FullOrgUnitInfo orgInfo = null;
        try {
            orgInfo = iOrg.getFullOrgUnitInfo("select longNumber, isAdminOrgUnit where id = '" + orgId + "'");
        }
        catch (EASBizException e) {
            throw new WfParticipantException((Throwable)e);
        }
        catch (BOSException e) {
            throw new WfParticipantException((Throwable)e);
        }
        if (!orgInfo.isIsAdminOrgUnit()) {
            return new Person[0];
        }
        String longNumber = orgInfo.getLongNumber();
        String locale = "_" + ctx.getLocale().toString();
        StringBuffer sb = new StringBuffer();
        sb.append("select p.fname" + locale + " as empName, p.fid as empId,  u.fname" + locale + " as userName, u.fid as userId  \n");
        sb.append("from t_bd_person p  \n");
        sb.append("inner join t_pm_user u on u.fpersonid = p.fid  \n");
        sb.append("where p.fid in (  \n");
        sb.append("      select fpersonId  \n");
        sb.append("      from t_org_PositionMember  \n");
        sb.append("      where fpositionId in (  \n");
        sb.append("            SELECT p.fid  \n");
        sb.append("            FROM T_ORG_Position p  \n");
        sb.append("            INNER JOIN T_ORG_JOB J ON P.FJOBID = J.FID  \n");
        sb.append("            WHERE FAdminOrgUnitID in (  \n");
        sb.append("                  SELECT FID from t_Org_Admin where flongNumber = ? OR FlongNumber like ?  \n");
        sb.append("            )   \n");
        sb.append("            AND J.FID = ?  \n");
        sb.append("      )  \n");
        sb.append(")  \n");
        Person[] persons = null;
        try {
            IRowSet rows = DbUtil.executeQuery((Context)ctx, (String)sb.toString(), (Object[])new Object[]{longNumber, longNumber + "!%", jobId});
            persons = new Person[rows.size()];
            int i = 0;
            while (rows.next()) {
                persons[i] = new Person();
                persons[i].setEmployeeId(rows.getString("empId"));
                persons[i].setEmployeeName(ctx.getLocale(), rows.getString("empName"));
                persons[i].setUserId(rows.getString("userId"));
                persons[i].setUserName(ctx.getLocale(), rows.getString("userName"));
                ++i;
            }
        }
        catch (Exception e) {
            throw new WfParticipantException((Throwable)e);
        }
        return persons;
    }

    public static Person[] getMLHRPrincipal(Context ctx, String personId) throws WfParticipantException {
        String adminOrgId = "";
        try {
            IPositionMember ipm = PositionMemberFactory.getLocalInstance((Context)ctx);
            adminOrgId = ipm.getPositionMemberCollection("select position.adminOrgUnit.id where person.id = '" + personId + "' and isPrimary = 1").get(0).getPosition().getAdminOrgUnit().getId().toString();
        }
        catch (Exception e) {
            throw new WfParticipantException((Throwable)e);
        }
        String typeId = "00000000-0000-0000-0000-0000000000100FE9F8B5";
        StringBuffer sb = new StringBuffer();
        sb.append("SELECT FResponPositionId  \n");
        sb.append("FROM T_ORG_Admin  \n");
        sb.append("WHERE FID IN  \n");
        sb.append("(SELECT FFromUnitId  \n");
        sb.append("FROM T_ORG_UNITRELATION U  \n");
        sb.append("INNER JOIN T_Org_Admin A ON U.FFromUnitId = A.FID  \n");
        sb.append("WHERE U.FToUnitId in  \n");
        sb.append("(\tSELECT FToUnitId    \n");
        sb.append("\tFROM T_ORG_UNITRELATION  \n");
        sb.append("\tWHERE FTypeRelationId = ?  \n");
        sb.append("\tAND FFromUnitId = ?)  \n");
        sb.append("and U.FTypeRelationId = ?  \n");
        sb.append("and A.FNumber like '%XZ')  \n");
        String positionId = "";
        try {
            IRowSet rows = DbUtil.executeQuery((Context)ctx, (String)sb.toString(), (Object[])new Object[]{typeId, adminOrgId, typeId});
            if (rows.next()) {
                positionId = rows.getString("FResponPositionId");
            }
        }
        catch (Exception e) {
            throw new WfParticipantException((Throwable)e);
        }
        return new PersonToWFAdapter().getPositionHolders(ctx, positionId);
    }

    public static boolean hasSupervisor(Context ctx, String userId) throws BOSException {
        boolean value = false;
        StringBuffer sb = new StringBuffer();
        sb.append("select fpersonid   \n");
        sb.append("from t_org_positionmember  \n");
        sb.append("where fpositionid in (  \n");
        sb.append("SELECT FPARENTID  \n");
        sb.append("FROM T_org_positionhierarchy  \n");
        sb.append("where fchildid in (   \n");
        sb.append("SELECT FPOSITIONID  \n");
        sb.append("FROM T_org_positionMEMBER  \n");
        sb.append("WHERE FPERSONID IN (  \n");
        sb.append("select fpersonid   \n");
        sb.append("from t_pm_user  \n");
        sb.append("where fid = ?  \n");
        sb.append(") and fisprimary = 1))  \n");
        sb.append("and fisprimary = 1  \n");
        try {
            IRowSet rows = DbUtil.executeQuery((Context)ctx, (String)sb.toString(), (Object[])new Object[]{userId});
            if (rows.next()) {
                value = true;
            }
        }
        catch (Exception e) {
            throw new WfParticipantException((Throwable)e);
        }
        return value;
    }
}

