/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.base.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.CryptoUtil;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.permission.Administrator;
import com.kingdee.eas.base.permission.UserException;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.base.HRCommonToolFacadeFactory;
import com.kingdee.eas.hr.base.client.AbstractDataExportUI;
import com.kingdee.eas.hr.compensation.util.HRTableTools;
import com.kingdee.eas.tools.datatask.DEBaseInfo;
import com.kingdee.eas.tools.datatask.DEDataExportImplHelper;
import com.kingdee.eas.tools.datatask.DEDataTypeEnum;
import com.kingdee.eas.tools.datatask.DEScriptTypeEnum;
import com.kingdee.eas.tools.datatask.DEtoolSolutionFactory;
import com.kingdee.eas.tools.datatask.DEtoolSolutionInfo;
import com.kingdee.eas.tools.datatask.IDEtoolSolution;
import com.kingdee.eas.tools.datatask.SqlFileSelector;
import com.kingdee.eas.util.client.KDTableUtil;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JOptionPane;
import javax.swing.JPasswordField;
import org.apache.log4j.Logger;

public class DataExportUI
extends AbstractDataExportUI {
    private static final long serialVersionUID = -356931055081555049L;
    private static final Logger logger = CoreUIObject.getLogger(DataExportUI.class);
    private SqlFileSelector sqlFileSelect = null;
    DEtoolSolutionInfo dEtoolSolutionInfo = null;
    private BufferedWriter sqlOut = null;

    public DataExportUI() throws Exception {
        this.toolBar.setVisible(false);
        boolean b = this.isLogin();
        if (!b) {
            this.abort();
        }
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.dEtoolSolutionInfo = (DEtoolSolutionInfo)this.getUIContext().get("dEtoolSolutionInfo");
        this.sqlFileSelect = new SqlFileSelector((Component)((Object)this), "SAVE");
        this.sqlFileSelect.setDefFileName("_tmpsql_");
        this.prmtExport.setSelector((KDPromptSelector)this.sqlFileSelect);
        this.initTableSettingInfo();
    }

    public void actionExport_actionPerformed(ActionEvent e) throws Exception {
        String txtTableNames = this.txtTableName.getText();
        if (StringUtils.isEmpty((String)txtTableNames)) {
            return;
        }
        File file = (File)this.sqlFileSelect.getData();
        File tempFile = null;
        if (file == null) {
            file = new File(this.prmtExport.getText());
            if (!file.getParentFile().exists()) {
                file.getParentFile().mkdirs();
            }
            tempFile = new File(this.prmtExport.getText());
        } else {
            tempFile = new File(file.getName());
        }
        if (tempFile.exists()) {
            tempFile.delete();
        }
        String[] tableNames = this.initTableNames(txtTableNames);
        String initDataSql = HRCommonToolFacadeFactory.getRemoteInstance().getTableInitDataSql(tableNames);
        ByteArrayOutputStream basqlout = new ByteArrayOutputStream();
        this.sqlOut = new BufferedWriter(new OutputStreamWriter((OutputStream)basqlout, "utf-8"));
        this.sqlOut.write(initDataSql);
        this.sqlOut.flush();
        int fileCount = 0;
        String outputInfo = com.kingdee.eas.util.client.EASResource.getString((String)"com.kingdee.eas.tools.datatask.DATATASKAutoGenerateResource", (String)"9_DEExportUI");
        String sqlFilepath = "";
        String xmlFilepath = "";
        DEDataExportImplHelper.writeFile((byte[])basqlout.toByteArray(), (String)file.getPath());
        sqlFilepath = file.getPath();
        outputInfo = outputInfo + com.kingdee.eas.util.client.EASResource.getString((String)"com.kingdee.eas.tools.datatask.DATATASKAutoGenerateResource", (String)"10_DEExportUI") + ++fileCount + com.kingdee.eas.util.client.EASResource.getString((String)"com.kingdee.eas.tools.datatask.DATATASKAutoGenerateResource", (String)"11_DEExportUI") + sqlFilepath + "\n" + xmlFilepath;
        MsgBox.showInfo((Component)((Object)this), (String)outputInfo);
    }

    private String[] initTableNames(String tableNames) {
        String[] tableName = tableNames.split(";");
        return tableName;
    }

    private boolean isLogin() throws EASBizException {
        UserInfo userInfo = ContextHelperFactory.getRemoteInstance().getCurrentUser();
        if (Administrator.isSuperCUAdmin((IObjectPK)new ObjectUuidPK(userInfo.getId()))) {
            return true;
        }
        if ("00000000-0000-0000-0000-00000000000013B7DE7F".equals(userInfo.getId().toString())) {
            return true;
        }
        try {
            userInfo = UserFactory.getRemoteInstance().getUserByID((IObjectPK)new ObjectUuidPK("00000000-0000-0000-0000-00000000000013B7DE7F"));
        }
        catch (BOSException e) {
            logger.error((Object)"", (Throwable)e);
        }
        JPasswordField pwd = new JPasswordField();
        Object[] message = new Object[]{com.kingdee.eas.util.client.EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"49_FMIsqlUI"), pwd};
        int res = JOptionPane.showConfirmDialog((Component)((Object)this), message, " ", 2, 3);
        if (res != 0) {
            return false;
        }
        String logonPassword = new String(pwd.getPassword());
        return DataExportUI.matchPassword(userInfo, logonPassword);
    }

    public static boolean matchPassword(UserInfo userInfo, String password) throws EASBizException {
        if (StringUtils.isEmpty((String)password)) {
            return StringUtils.isEmpty((String)userInfo.getPassword());
        }
        return DataExportUI.encrypt(userInfo.getId().toString(), password).equals(userInfo.getPassword());
    }

    public static String encrypt(String userID, String password) throws EASBizException {
        try {
            return CryptoUtil.encrypt((String)(userID + password.trim()));
        }
        catch (Exception e) {
            throw new UserException(UserException.ENCRYPT_FAIL);
        }
    }

    @Override
    public void exportSqlAction_actionPerformed(ActionEvent e) throws Exception {
        int size = this.setTable.getRowCount();
        for (int i = 0; i < size; ++i) {
            DEDataTypeEnum dataTypeEnum;
            String dataType;
            File tempFile;
            String filePath;
            File file;
            DEBaseInfo dEBaseInfo = new DEBaseInfo();
            dEBaseInfo.CUR_CHAR_SEPERATOR = ";";
            dEBaseInfo.CUR_SCTYPE = DEScriptTypeEnum.KSQL;
            String whereInfo = (String)HRTableTools.getTableSelectCellValue((KDTable)this.setTable, (String)"whereInfo", (int)i);
            if (!StringUtils.isEmpty((String)whereInfo)) {
                dEBaseInfo.numberStr = whereInfo;
            }
            if (!(file = new File(filePath = (String)HRTableTools.getTableSelectCellValue((KDTable)this.setTable, (String)"filePath", (int)i))).getParentFile().exists()) {
                file.getParentFile().mkdirs();
            }
            if ((tempFile = new File(file.getName())).exists()) {
                tempFile.delete();
            }
            if (StringUtils.isEmpty((String)(dataType = (String)HRTableTools.getTableSelectCellValue((KDTable)this.setTable, (String)"dataType", (int)i)))) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.hr.base.HRBaseBizResource", (String)"label123"));
            }
            dEBaseInfo.ExportDataType = dataTypeEnum = DEDataTypeEnum.getEnum((String)dataType);
            IDEtoolSolution dataCenterFacade = DEtoolSolutionFactory.getRemoteInstance();
            byte[] tempByte = null;
            DEBaseInfo rsdEBaseInfo = null;
            try {
                String tableName = (String)HRTableTools.getTableSelectCellValue((KDTable)this.setTable, (String)"tableName", (int)i);
                rsdEBaseInfo = dataCenterFacade.exportSqlData(DEDataExportImplHelper.str2Ary((String)tableName), dEBaseInfo);
            }
            catch (Exception bos) {
                bos.printStackTrace();
                MsgBox.showInfo((Component)((Object)this), (String)com.kingdee.eas.util.client.EASResource.getString((String)"com.kingdee.eas.tools.datatask.DATATASKAutoGenerateResource", (String)"8_DEExportUI"));
            }
            if (rsdEBaseInfo == null) continue;
            int fileCount = 0;
            String outputInfo = com.kingdee.eas.util.client.EASResource.getString((String)"com.kingdee.eas.tools.datatask.DATATASKAutoGenerateResource", (String)"9_DEExportUI");
            String sqlFilepath = "";
            String xmlFilepath = "";
            if (rsdEBaseInfo.sql != null && rsdEBaseInfo.sql.length > 0) {
                tempByte = rsdEBaseInfo.sql;
                DEDataExportImplHelper.writeFile((byte[])tempByte, (String)file.getPath());
                sqlFilepath = file.getPath();
                ++fileCount;
            }
            if (rsdEBaseInfo.xml != null && rsdEBaseInfo.xml.length > 0) {
                int idx = file.getPath().indexOf(46);
                xmlFilepath = file.getPath().substring(0, idx) + ".xml";
                DEDataExportImplHelper.writeFile((byte[])rsdEBaseInfo.xml, (String)xmlFilepath);
                ++fileCount;
            }
            outputInfo = outputInfo + com.kingdee.eas.util.client.EASResource.getString((String)"com.kingdee.eas.tools.datatask.DATATASKAutoGenerateResource", (String)"10_DEExportUI") + fileCount + com.kingdee.eas.util.client.EASResource.getString((String)"com.kingdee.eas.tools.datatask.DATATASKAutoGenerateResource", (String)"11_DEExportUI") + sqlFilepath + "\n" + xmlFilepath;
        }
        MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.hr.base.HRBaseBizResource", (String)"label122"));
    }

    @Override
    public void saveInfoAction_actionPerformed(ActionEvent e) throws Exception {
        int rowCount = this.setTable.getRowCount();
        ArrayList dataList = new ArrayList();
        for (int i = 0; i < rowCount; ++i) {
            HashMap<String, String> tableMap = new HashMap<String, String>();
            String tableName = (String)HRTableTools.getTableSelectCellValue((KDTable)this.setTable, (String)"tableName", (int)i);
            tableMap.put("tableName", tableName);
            String filePath = (String)HRTableTools.getTableSelectCellValue((KDTable)this.setTable, (String)"filePath", (int)i);
            tableMap.put("filePath", filePath);
            String whereInfo = (String)HRTableTools.getTableSelectCellValue((KDTable)this.setTable, (String)"whereInfo", (int)i);
            tableMap.put("whereInfo", whereInfo);
            String dataType = (String)HRTableTools.getTableSelectCellValue((KDTable)this.setTable, (String)"dataType", (int)i);
            tableMap.put("dataType", dataType);
            tableMap.put("impType", "2");
            dataList.add(tableMap);
        }
        if (dataList.size() > 0) {
            HRCommonToolFacadeFactory.getRemoteInstance().saveTableSettingInfo(dataList, "2");
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.hr.base.HRBaseBizResource", (String)"label2"));
        }
    }

    private void initTableSettingInfo() throws BOSException {
        int i;
        this.setTable.checkParsed();
        List dataList = HRCommonToolFacadeFactory.getRemoteInstance().getTableSettingInfo("2");
        Map dataMap = null;
        int size = dataList.size();
        for (i = 0; i < size; ++i) {
            dataMap = (Map)dataList.get(i);
            IRow row = this.setTable.addRow();
            row.getCell("tableName").setValue(dataMap.get("tableName"));
            row.getCell("filePath").setValue(dataMap.get("filePath"));
            row.getCell("whereInfo").setValue(dataMap.get("whereInfo"));
            row.getCell("dataType").setValue(dataMap.get("dataType"));
        }
        dataList = HRCommonToolFacadeFactory.getRemoteInstance().getTableSettingInfo("1");
        size = dataList.size();
        for (i = 0; i < size; ++i) {
            dataMap = (Map)dataList.get(i);
            String tableName = (String)dataMap.get("tableName");
            String filePath = (String)dataMap.get("filePath");
            this.txtTableName.setText(tableName);
            this.prmtExport.setText(filePath);
            this.sqlFileSelect.setDefFileName(filePath);
            this.prmtExport.setSelector((KDPromptSelector)this.sqlFileSelect);
        }
    }

    @Override
    public void addRowAction_actionPerformed(ActionEvent e) throws Exception {
        this.setTable.addRow();
    }

    @Override
    public void delRowAction_actionPerformed(ActionEvent e) throws Exception {
        int rowIndex = KDTableUtil.getSelectedRow((KDTable)this.setTable);
        this.setTable.removeRow(rowIndex);
    }

    @Override
    public void saveExportAction_actionPerformed(ActionEvent e) throws Exception {
        if (!StringUtils.isEmpty((String)this.txtTableName.getText()) && !StringUtils.isEmpty((String)this.prmtExport.getText())) {
            ArrayList dataList = new ArrayList();
            HashMap<String, String> tableMap = new HashMap<String, String>();
            tableMap.put("tableName", this.txtTableName.getText());
            tableMap.put("filePath", this.prmtExport.getText());
            dataList.add(tableMap);
            HRCommonToolFacadeFactory.getRemoteInstance().saveTableSettingInfo(dataList, "1");
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.hr.base.HRBaseBizResource", (String)"label2"));
        }
    }
}

