/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.base.client;

import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.KDRadioButton;
import com.kingdee.bos.ctrl.swing.KDSpinner;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.hr.base.EmpDynamicFilterInfo;
import com.kingdee.eas.hr.base.client.AbstractEmpDynamicCollectionFilterUI;
import com.kingdee.eas.hr.emp.client.EmployeeClientUtils;
import com.kingdee.eas.hr.org.client.AdminByOrgRangePromptBox;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.DateTimeUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.swing.DefaultComboBoxModel;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import org.apache.log4j.Logger;

public class EmpDynamicCollectionFilterUI
extends AbstractEmpDynamicCollectionFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(EmpDynamicCollectionFilterUI.class);
    String periodType = "PERIODTYPE_YEAR";
    private String resourcePath = "com.kingdee.eas.hr.base.EmpDynamicCollectionResource";
    private boolean hasInit = false;
    private static final int MONTHS_OF_YEAR = 12;
    private static final int MONTHS_OF_HALFYEAR = 6;
    private static final int MONTHS_OF_QUARTER = 3;

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        AdminByOrgRangePromptBox aSel = new AdminByOrgRangePromptBox("false");
        aSel.showChkSealUp(true);
        this.prmtOrgUnit.setSelector((KDPromptSelector)aSel);
        this.prmtOrgUnit.setEditable(false);
        this.initSpinnerYear(this.spStartYear);
        this.initSpinnerYear(this.spEndYear);
        this.initStartCombMonth(this.combStartMoth);
        this.initEndMonth(this.combEndMonth);
        this.chkShowBZ.setVisible(false);
        this.initInterval("YEAR");
    }

    private void initEndMonth(KDComboBox combEndMonth) {
        Calendar now = Calendar.getInstance();
        for (int i = 1; i <= 12; ++i) {
            combEndMonth.addItem((Object)String.valueOf(i));
        }
        combEndMonth.setSelectedItem((Object)String.valueOf(now.get(2) + 1));
    }

    private void initStartCombMonth(KDComboBox combStartMoth) {
        Calendar now = Calendar.getInstance();
        for (int i = 1; i <= 12; ++i) {
            combStartMoth.addItem((Object)String.valueOf(i));
        }
        combStartMoth.setSelectedItem((Object)String.valueOf(1));
    }

    private void initSpinnerYear(KDSpinner spnYear) {
        Calendar instance = Calendar.getInstance();
        int thisYear = instance.get(1);
        SpinnerNumberModel yModel = new SpinnerNumberModel(thisYear, thisYear - 100, thisYear + 100, 1);
        spnYear.setModel((SpinnerModel)yModel);
    }

    public CustomerParams getCustomerParams() {
        AdminOrgUnitInfo admin = (AdminOrgUnitInfo)this.prmtOrgUnit.getValue();
        int adminLevel = 0;
        String longNumber = null;
        String adminID = null;
        if (admin != null) {
            longNumber = admin.getLongNumber();
            adminLevel = admin.getLevel();
            adminID = admin.getId().toString();
        }
        HashMap dateMap = (HashMap)this.getDatesMap();
        Date[] dates = (Date[])dateMap.get("dates");
        int[] yearMonth = (int[])dateMap.get("yearMonth");
        CustomerParams params = new CustomerParams();
        params.putDate("startTime", dates[0]);
        params.putDate("endTime", dates[1]);
        params.putInt("startYear", yearMonth[0]);
        params.putInt("endYear", yearMonth[1]);
        params.putInt("startMonth", yearMonth[2]);
        params.putInt("endMonth", yearMonth[3]);
        params.putInt("adminLevel", adminLevel);
        params.putInt("showLevel", Integer.parseInt(this.combLevel.getSelectedItem().toString()));
        params.addCustomerParam("longNumber", longNumber);
        params.addCustomerParam("adminId", adminID);
        params.addCustomerParam("periodType", this.periodType);
        params.putBoolean("isShowDuringData", Boolean.valueOf(this.chkShowDuringData.isSelected()).booleanValue());
        params.putBoolean("isShowSealUpOrg", Boolean.valueOf(this.chkShowSealUp.isSelected()).booleanValue());
        params.putBoolean("isShowVirtualOrg", Boolean.valueOf(this.chkShowVirtualOrg.isSelected()).booleanValue());
        IntvlType intervalType = (IntvlType)this.combRange.getSelectedItem();
        if (intervalType == null) {
            params.addCustomerParam("intervalType", "QUARTER");
        } else {
            params.addCustomerParam("intervalType", intervalType.getValue());
        }
        return params;
    }

    public void setCustomerParams(CustomerParams cp) {
        super.setCustomerParams(cp);
        if (cp == null) {
            try {
                this.initDefaultSchema();
            }
            catch (Exception e) {
                this.handUIException(e);
            }
            return;
        }
        EmpDynamicFilterInfo filterInfo = new EmpDynamicFilterInfo();
        filterInfo.setEndYear(cp.getInt("endYear"));
        filterInfo.setStartYear(cp.getInt("startYear"));
        filterInfo.setEndMonth(cp.getInt("endMonth"));
        filterInfo.setAdminLongNumber(cp.getCustomerParam("longNumber"));
        filterInfo.setShowLevel(cp.getInt("showLevel"));
        filterInfo.setStartMonth(cp.getInt("startMonth"));
        filterInfo.setShowDuringData(cp.getBoolean("isShowDuringData"));
        filterInfo.setAdminLevel(cp.getInt("adminLevel"));
        filterInfo.setStartTime(cp.getDate("startTime"));
        filterInfo.setEndTime(cp.getDate("endTime"));
        filterInfo.setPeriodType(cp.getCustomerParam("periodType"));
        filterInfo.setShowSealUpOrg(cp.getBoolean("isShowSealUpOrg"));
        filterInfo.setShowVirtualOrg(cp.getBoolean("isShowVirtualOrg"));
        filterInfo.setAdminID(cp.getCustomerParam("adminId"));
        filterInfo.setIntervalType(cp.getCustomerParam("intervalType"));
        try {
            this.setDatas(filterInfo);
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    private void setDatas(EmpDynamicFilterInfo filterInfo) throws Exception {
        this.periodType = filterInfo.getPeriodType();
        if ("PERIODTYPE_TIME".equals(filterInfo.getPeriodType())) {
            this.spStartYear.setEnabled(true);
            this.spEndYear.setEnabled(true);
            this.combStartMoth.setEnabled(true);
            this.combEndMonth.setEnabled(true);
            this.radioTime.setSelected(true);
            this.initInterval("YEAR");
        } else {
            if ("PERIOD_HALFYEAR".equals(filterInfo.getPeriodType())) {
                this.rdHalfYear.setSelected(true);
                this.initInterval("HALFYEAR");
            } else if ("PERIODTYPE_MONTH".equals(filterInfo.getPeriodType())) {
                this.rdMoth.setSelected(true);
                this.initInterval("MONTH");
            } else if ("PERIODTYPE_QUARTER".equals(filterInfo.getPeriodType())) {
                this.rdQuarter.setSelected(true);
                this.initInterval("QUARTER");
            } else if ("PERIODTYPE_YEAR".equals(filterInfo.getPeriodType())) {
                this.rdYear.setSelected(true);
                this.initInterval("YEAR");
            }
            this.spStartYear.setEnabled(false);
            this.spEndYear.setEnabled(false);
            this.combStartMoth.setEnabled(false);
            this.combEndMonth.setEnabled(false);
        }
        this.spStartYear.setValue((Object)filterInfo.getStartYear());
        this.spEndYear.setValue((Object)filterInfo.getEndYear());
        this.combStartMoth.setSelectedIndex(filterInfo.getStartMonth() - 1);
        this.combEndMonth.setSelectedIndex(filterInfo.getEndMonth() - 1);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("longNumber"));
        sic.add(new SelectorItemInfo("level"));
        AdminOrgUnitInfo orgInfo = AdminOrgUnitFactory.getRemoteInstance().getAdminOrgUnitInfo((IObjectPK)new ObjectUuidPK(filterInfo.getAdminID()), sic);
        this.prmtOrgUnit.setValue((Object)orgInfo);
        this.setComboBoxLevel(orgInfo, this.combLevel);
        if (this.combLevel.getModel().getSize() < filterInfo.getShowLevel()) {
            DefaultComboBoxModel<Integer> model = new DefaultComboBoxModel<Integer>();
            for (int i = 1; i <= filterInfo.getShowLevel(); ++i) {
                model.addElement(i);
            }
            this.combLevel.setModel(model);
        }
        this.combLevel.setSelectedIndex(filterInfo.getShowLevel() - 1);
        this.chkShowVirtualOrg.setSelected(filterInfo.isShowVirtualOrg());
        this.chkShowSealUp.setSelected(filterInfo.isShowSealUpOrg());
        this.chkShowDuringData.setSelected(filterInfo.isShowDuringData());
        if (filterInfo.getIntervalType() != null) {
            int size = this.combRange.getItemCount();
            for (int i = 0; i < size; ++i) {
                if (!((IntvlType)this.combRange.getItemAt(i)).getValue().equals(filterInfo.getIntervalType())) continue;
                this.combRange.setSelectedIndex(i);
                break;
            }
        }
    }

    public void setComboBoxLevel(AdminOrgUnitInfo adminInfo, KDComboBox comboBox) throws Exception {
        comboBox.removeAllItems();
        String longNumber = null;
        boolean isOrg = false;
        longNumber = adminInfo.getLongNumber();
        isOrg = true;
        if (longNumber != null) {
            int[] datas = EmployeeClientUtils.getLevelByLongNumber((String)longNumber, (boolean)isOrg);
            int level = datas[0] - datas[1] + 1;
            adminInfo.setLevel(datas[1]);
            DefaultComboBoxModel<Integer> model = new DefaultComboBoxModel<Integer>();
            for (int i = 1; i <= level; ++i) {
                model.addElement(i);
            }
            comboBox.setModel(model);
        }
    }

    public void initDefaultSchema() throws Exception {
        if (!this.hasInit) {
            this.rdYear.setSelected(true);
            this.hasInit = true;
        }
    }

    private Map getDatesMap() {
        HashMap<String, Object[]> dateMap = new HashMap<String, Object[]>();
        int startYear = 0;
        int endYear = 0;
        int startMonth = 0;
        int endMonth = 0;
        Date startTime = null;
        Date endTime = null;
        Date today = new Date();
        Date[] dates = new Date[2];
        int[] yearMonth = new int[4];
        if ("PERIODTYPE_MONTH" == this.periodType) {
            startYear = today.getYear() + 1900;
            endYear = today.getYear() + 1900;
            startMonth = today.getMonth() + 1;
            endMonth = today.getMonth() + 1;
            startTime = new Date(today.getYear(), today.getMonth(), 1);
            int month = today.getMonth();
            endTime = month == 11 ? DateTimeUtils.addDay((Date)new Date(today.getYear(), today.getMonth() + 1, 1), (long)-1L) : DateTimeUtils.addDay((Date)new Date(today.getYear(), today.getMonth() + 1, 1), (long)-1L);
        } else if ("PERIODTYPE_QUARTER" == this.periodType) {
            int quarter = DateTimeUtils.getQuarter((Date)today);
            startTime = new Date(today.getYear(), 3 * (quarter - 1), 1);
            endTime = quarter == 4 ? DateTimeUtils.addDay((Date)new Date(today.getYear(), today.getMonth() + 1, 1), (long)-1L) : DateTimeUtils.addDay((Date)new Date(today.getYear(), today.getMonth() + 1, 1), (long)-1L);
            startYear = today.getYear() + 1900;
            endYear = today.getYear() + 1900;
            startMonth = (quarter - 1) * 3 + 1;
            endMonth = today.getMonth() + 1;
        } else if ("PERIOD_HALFYEAR" == this.periodType) {
            startYear = today.getYear() + 1900;
            endYear = today.getYear() + 1900;
            if (today.getMonth() < 6) {
                startMonth = 1;
                endMonth = today.getMonth() + 1;
                startTime = new Date(today.getYear(), 0, 1);
                endTime = DateTimeUtils.addDay((Date)new Date(today.getYear(), today.getMonth() + 1, 1), (long)-1L);
            } else {
                startMonth = 7;
                endMonth = today.getMonth() + 1;
                startTime = new Date(today.getYear(), 6, 1);
                endTime = DateTimeUtils.addDay((Date)new Date(today.getYear(), today.getMonth() + 1, 1), (long)-1L);
            }
        } else if ("PERIODTYPE_YEAR" == this.periodType) {
            startTime = new Date(today.getYear(), 0, 1);
            endTime = DateTimeUtils.addDay((Date)new Date(today.getYear(), today.getMonth() + 1, 1), (long)-1L);
            startYear = today.getYear() + 1900;
            endYear = today.getYear() + 1900;
            startMonth = 1;
            endMonth = today.getMonth() + 1;
        } else {
            startYear = (Integer)this.spStartYear.getValue();
            endYear = (Integer)this.spEndYear.getValue();
            endMonth = Integer.parseInt(this.combEndMonth.getSelectedItem().toString());
            startMonth = Integer.parseInt(this.combStartMoth.getSelectedItem().toString());
            startTime = new Date(startYear - 1900, startMonth - 1, 1);
            endTime = DateTimeUtils.addDay((Date)new Date(endYear - 1900, endMonth, 1), (long)-1L);
        }
        endTime = DateTimeUtils.addSecond((Date)DateTimeUtils.addDay((Date)endTime, (long)1L), (long)-1L);
        dates[0] = startTime;
        dates[1] = endTime;
        yearMonth[0] = startYear;
        yearMonth[1] = endYear;
        yearMonth[2] = startMonth;
        yearMonth[3] = endMonth;
        dateMap.put("dates", dates);
        dateMap.put("yearMonth", yearMonth);
        return dateMap;
    }

    @Override
    protected void prmtOrgUnit_dataChanged(DataChangeEvent e) throws Exception {
        EmployeeClientUtils.setComboBoxLevel((DataChangeEvent)e, (KDComboBox)this.combLevel);
    }

    private void radioActionPerformed(ActionEvent e) throws Exception {
        KDRadioButton radio = (KDRadioButton)e.getSource();
        if (radio == this.radioTime) {
            this.spStartYear.setEnabled(true);
            this.spEndYear.setEnabled(true);
            this.combStartMoth.setEnabled(true);
            this.combEndMonth.setEnabled(true);
            this.periodType = "PERIODTYPE_TIME";
            this.initInterval("YEAR");
        } else {
            this.spStartYear.setEnabled(false);
            this.spEndYear.setEnabled(false);
            this.combStartMoth.setEnabled(false);
            this.combEndMonth.setEnabled(false);
            if (radio == this.rdHalfYear) {
                this.periodType = "PERIOD_HALFYEAR";
                this.initInterval("HALFYEAR");
            } else if (radio == this.rdYear) {
                this.periodType = "PERIODTYPE_YEAR";
                this.initInterval("YEAR");
            } else if (radio == this.rdMoth) {
                this.periodType = "PERIODTYPE_MONTH";
                this.initInterval("MONTH");
            } else {
                this.periodType = "PERIODTYPE_QUARTER";
                this.initInterval("QUARTER");
            }
        }
    }

    public void clear() {
        super.clear();
        this.prmtOrgUnit.setValue(null);
        this.combLevel.setSelectedItem(null);
        this.chkShowSealUp.setSelected(false);
        this.chkShowVirtualOrg.setSelected(false);
        this.rdYear.setSelected(true);
        this.chkShowDuringData.setSelected(false);
        this.chkShowBZ.setSelected(false);
        this.initSpinnerYear(this.spStartYear);
        this.initSpinnerYear(this.spEndYear);
        this.initInterval("YEAR");
    }

    @Override
    protected void rdYear_actionPerformed(ActionEvent e) throws Exception {
        this.radioActionPerformed(e);
    }

    public boolean verify() {
        if (this.prmtOrgUnit.getValue() == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)this.resourcePath, (String)"FILLORG"));
            SysUtil.abort();
        }
        if (this.radioTime.isSelected()) {
            int startYear = (Integer)this.spStartYear.getValue();
            int endYear = (Integer)this.spEndYear.getValue();
            int endMonth = Integer.parseInt(this.combEndMonth.getSelectedItem().toString());
            int startMonth = Integer.parseInt(this.combStartMoth.getSelectedItem().toString());
            Date startTime = new Date(startYear - 1900, startMonth - 1, 1);
            Date endTime = new Date(endYear - 1900, endMonth - 1, 1);
            if (endTime.after(new Date())) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)this.resourcePath, (String)"NOLATENOW"));
                SysUtil.abort();
            }
            if (startTime.after(endTime)) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)this.resourcePath, (String)"STARTNOLAST"));
                SysUtil.abort();
            }
        }
        return super.verify();
    }

    @Override
    protected void rdHalfYear_actionPerformed(ActionEvent e) throws Exception {
        this.radioActionPerformed(e);
    }

    @Override
    protected void rdQuarter_actionPerformed(ActionEvent e) throws Exception {
        this.radioActionPerformed(e);
    }

    @Override
    protected void rdMoth_actionPerformed(ActionEvent e) throws Exception {
        this.radioActionPerformed(e);
    }

    @Override
    protected void radioTime_actionPerformed(ActionEvent e) throws Exception {
        this.radioActionPerformed(e);
    }

    private void initInterval(String type) {
        DefaultComboBoxModel<IntvlType> model = new DefaultComboBoxModel<IntvlType>();
        if (type.endsWith("MONTH")) {
            model.addElement(new IntvlType("MONTH", EASResource.getString((String)"com.kingdee.eas.hr.emp.EmployeeResource.MONTH")));
        } else if (type.endsWith("QUARTER")) {
            model.addElement(new IntvlType("MONTH", EASResource.getString((String)"com.kingdee.eas.hr.emp.EmployeeResource.MONTH")));
            model.addElement(new IntvlType("QUARTER", EASResource.getString((String)"com.kingdee.eas.hr.emp.EmployeeResource.QUARTER")));
        } else if (type.endsWith("HALFYEAR")) {
            model.addElement(new IntvlType("MONTH", EASResource.getString((String)"com.kingdee.eas.hr.emp.EmployeeResource.MONTH")));
            model.addElement(new IntvlType("QUARTER", EASResource.getString((String)"com.kingdee.eas.hr.emp.EmployeeResource.QUARTER")));
            model.addElement(new IntvlType("HALFYEAR", EASResource.getString((String)"com.kingdee.eas.hr.emp.EmployeeResource.HALFYEAR")));
        } else if (type.endsWith("YEAR")) {
            model.addElement(new IntvlType("MONTH", EASResource.getString((String)"com.kingdee.eas.hr.emp.EmployeeResource.MONTH")));
            model.addElement(new IntvlType("QUARTER", EASResource.getString((String)"com.kingdee.eas.hr.emp.EmployeeResource.QUARTER")));
            model.addElement(new IntvlType("HALFYEAR", EASResource.getString((String)"com.kingdee.eas.hr.emp.EmployeeResource.HALFYEAR")));
            model.addElement(new IntvlType("YEAR", EASResource.getString((String)"com.kingdee.eas.hr.emp.EmployeeResource.YEAR")));
        }
        this.combRange.setModel(model);
    }

    private String getIntervalTypeByDate(Date beginDate, Date endDate) {
        int beginYear = DateTimeUtils.getYear((Date)beginDate);
        int endYear = DateTimeUtils.getYear((Date)endDate);
        int beginMonth = DateTimeUtils.getMonth((Date)beginDate);
        int endMonth = DateTimeUtils.getMonth((Date)endDate);
        int interval = (endYear - beginYear) * 12 + (endMonth - beginMonth);
        if (interval >= 11) {
            return "YEAR";
        }
        if (interval >= 5) {
            return "HALFYEAR";
        }
        if (interval >= 2) {
            return "QUARTER";
        }
        return "MONTH";
    }

    private static class IntvlType {
        String _value;
        String _alias;

        public IntvlType(String value, String alias) {
            this._value = value;
            this._alias = alias;
        }

        public String getValue() {
            return this._value;
        }

        public String getAlias() {
            return this._alias;
        }

        public String toString() {
            return this._alias;
        }
    }
}

