/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.base.client;

import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDScrollPane;
import com.kingdee.eas.hr.base.client.DesignerPanel;
import com.kingdee.eas.hr.base.client.Node;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.image.BufferedImage;

public class OutLinePanel
extends KDPanel {
    private DesignerPanel designerPanel;
    private Rectangle oldRect = null;
    private Point oldPoint = new Point();
    private boolean isDraging = false;
    private BufferedImage bufferedImage = null;

    public OutLinePanel(DesignerPanel designer) {
        this.setBackground(Color.WHITE);
        this.designerPanel = designer;
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                OutLinePanel.this.outLintMousePressed(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                OutLinePanel.this.outLintMouseReleased(e);
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent e) {
                OutLinePanel.this.outLintMouseDragged(e);
            }
        });
    }

    public void outLintMouseReleased(MouseEvent e) {
        this.isDraging = false;
    }

    public void outLintMousePressed(MouseEvent e) {
        if (this.oldRect.contains(e.getPoint())) {
            this.oldPoint = e.getPoint();
            return;
        }
        this.oldRect.x = this.oldRect.x + e.getPoint().x - (this.oldRect.x + 25);
        this.oldRect.y = this.oldRect.y + e.getPoint().y - (this.oldRect.y + 25);
        this.repaint();
    }

    public void outLintMouseDragged(MouseEvent e) {
        this.isDraging = true;
        if (e.getPoint().x < 0 || e.getPoint().x > this.getWidth() || e.getPoint().y < 0 || e.getPoint().y > this.getHeight()) {
            return;
        }
        if (!this.oldRect.contains(e.getPoint())) {
            return;
        }
        this.oldRect.x = this.oldRect.x + e.getPoint().x - this.oldPoint.x;
        this.oldRect.y = this.oldRect.y + e.getPoint().y - this.oldPoint.y;
        this.repaint();
        int rx = (int)((double)this.oldRect.x / ((double)this.getWidth() / (double)this.designerPanel.getWidth()));
        int ry = (int)((double)this.oldRect.y / ((double)this.getWidth() / (double)this.designerPanel.getWidth()));
        KDScrollPane scrollPanel = (KDScrollPane)this.designerPanel.getParent().getParent();
        scrollPanel.getHorizontalScrollBar().setValue(rx);
        scrollPanel.getVerticalScrollBar().setValue(ry);
        this.oldPoint = e.getPoint();
    }

    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2d = null;
        if (!this.isDraging) {
            this.bufferedImage = (BufferedImage)this.designerPanel.createImage(this.getWidth(), this.getHeight());
            g2d = (Graphics2D)this.bufferedImage.getGraphics();
            g2d.setColor(this.designerPanel.getBackground());
            g2d.fillRect(0, 0, this.getWidth(), this.getHeight());
            g2d.setColor(Color.BLACK);
            g2d.scale((double)this.getWidth() / this.designerPanel.getPreferredSize().getWidth(), (double)this.getHeight() / this.designerPanel.getPreferredSize().getHeight());
            this.designerPanel.print(g2d);
        }
        g2d = (Graphics2D)g;
        if (this.bufferedImage != null) {
            g2d.drawImage(this.bufferedImage, null, 0, 0);
        }
        g2d.setColor(Color.BLUE);
        g2d.setStroke(new BasicStroke(3.0f));
        if (this.oldRect == null) {
            Node rootNode = this.designerPanel.getRootNode();
            if (rootNode == null) {
                this.oldRect = new Rectangle(0, 0, 50, 50);
            } else {
                int x = (int)((double)rootNode.getX() * ((double)this.getWidth() / (double)this.designerPanel.getWidth())) - 25;
                int y = (int)((double)rootNode.getY() * ((double)this.getHeight() / (double)this.designerPanel.getHeight())) - 25;
                if (y < 0) {
                    y = 0;
                }
                this.oldRect = new Rectangle(x, y, 50, 50);
            }
        }
        g2d.drawRect(this.oldRect.x, this.oldRect.y, this.oldRect.width, this.oldRect.height);
    }
}

