/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.base.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserCollection;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.PositionInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.hr.base.UserPermSetFactory;
import com.kingdee.eas.hr.base.UserPermSetInfo;
import com.kingdee.eas.hr.base.client.AbstractPositionOfUserListUI;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.KDTableUtil;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.event.ActionEvent;
import javax.swing.JButton;
import org.apache.log4j.Logger;

public class PositionOfUserListUI
extends AbstractPositionOfUserListUI {
    private static final long serialVersionUID = -2444596480237727738L;
    private static final Logger logger = CoreUIObject.getLogger(PositionOfUserListUI.class);
    protected boolean isCanceled = true;
    protected PersonInfo personInfo = null;

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected JButton getDefaultButton() {
        return this.btnConfirm;
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.tblMain.checkParsed();
        this.fillPositionOfUserData();
        this.tblMain.getSelectManager().setSelectMode(2);
    }

    private void fillPositionOfUserData() {
        UserPermSetInfo userPermSet = (UserPermSetInfo)this.getUIContext().get("userPermSet");
        AdminOrgUnitInfo adminOrg = userPermSet.getAdminOrgUnit();
        PositionInfo position = userPermSet.getPosition();
        try {
            UserCollection userColl = UserPermSetFactory.getRemoteInstance().getPositionOfUserCollection(adminOrg, position);
            int size = userColl.size();
            for (int i = 0; i < size; ++i) {
                IRow row = this.tblMain.addRow();
                row.getCell("personNum").setValue((Object)userColl.get(i).getPerson().getNumber());
                row.getCell("personName").setValue((Object)userColl.get(i).getPerson().getName());
                row.getCell("personID").setValue((Object)userColl.get(i).getPerson().getId());
                row.getCell("id").setValue((Object)userColl.get(i).getId());
                row.getCell("user").setValue((Object)userColl.get(i));
                row.getCell("curStatus").setValue(userColl.get(i).get("PersonStatusEnum"));
            }
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
        }
    }

    @Override
    public void actionConfirm_actionPerformed(ActionEvent e) throws Exception {
        int curNum = KDTableUtil.getSelectedRow((KDTable)this.tblMain);
        if (curNum >= 0) {
            IRow row = this.tblMain.getRow(curNum);
            BOSUuid personID = (BOSUuid)row.getCell("personID").getValue();
            this.personInfo = new PersonInfo();
            this.personInfo.setName(row.getCell("personName").getValue().toString());
            this.personInfo.setNumber(row.getCell("personNum").getValue().toString());
            this.personInfo.setId(personID);
            UserInfo userInfo = (UserInfo)row.getCell("user").getValue();
            userInfo.setPerson(this.personInfo);
            this.personInfo.put("InheritUserInfo", (Object)userInfo);
            this.personInfo.put("PersonStatus", row.getCell("curStatus").getValue());
            this.isCanceled = false;
            this.getUIWindow().close();
        } else {
            String warnningInfo = EASResource.getString((String)"com.kingdee.eas.hr.base.HRBasedataResource", (String)"UserMustExist");
            MsgBox.showError((String)warnningInfo);
        }
    }

    @Override
    public void actionCancelSelect_actionPerformed(ActionEvent e) throws Exception {
        this.isCanceled = true;
        this.getUIWindow().close();
    }

    @Override
    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        super.tblMain_tableClicked(e);
        if (e.getClickCount() == 2) {
            this.actionConfirm_actionPerformed(null);
        }
    }
}

