/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.base.client.util;

import com.kingdee.bos.ctrl.common.LanguageManager;
import com.kingdee.bos.ctrl.kdf.table.KDTMenuManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.KDFileChooser;
import com.kingdee.eas.base.log.client.ExcelFileFilter;
import com.kingdee.eas.util.client.EASResource;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.Date;
import java.util.Hashtable;
import javax.swing.filechooser.FileFilter;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFDataFormat;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFRichTextString;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.VerticalAlignment;

public class ExcelHelper {
    private Hashtable keyCol = new Hashtable();

    private void addValueCell(HSSFSheet sht, int rowNum, int colNum, Object value, HSSFCellStyle valueStyle) throws Exception {
        HSSFCell cell = this.getCell(sht, rowNum, colNum);
        if (value == null) {
            value = "";
        }
        if (value instanceof String) {
            cell.setCellType(CellType.STRING);
            cell.setCellValue((String)value);
            cell.setCellStyle(valueStyle);
        } else if (value instanceof Float) {
            cell.setCellValue((double)((Float)value).floatValue());
        } else if (value instanceof Integer) {
            cell.setCellValue((double)((Integer)value).intValue());
        } else if (value instanceof Double) {
            cell.setCellValue(((Double)value).doubleValue());
        } else if (value instanceof BigDecimal) {
            cell.setCellValue(((BigDecimal)value).doubleValue());
        } else if (value instanceof Date) {
            cell.setCellValue((Date)value);
        } else if (value instanceof Boolean) {
            cell.setCellValue(((Boolean)value).booleanValue());
        } else if (value instanceof HSSFRichTextString) {
            cell.setCellValue((RichTextString)((HSSFRichTextString)value));
        } else {
            cell.setCellType(CellType.STRING);
            cell.setCellValue(value.toString());
        }
    }

    private HSSFCellStyle createValueCellStyle(HSSFWorkbook workbook) {
        HSSFCellStyle valueStyle = null;
        if (valueStyle == null) {
            valueStyle = workbook.createCellStyle();
            valueStyle.setAlignment(HorizontalAlignment.LEFT);
            valueStyle.setHidden(true);
            valueStyle.setLocked(false);
            BorderStyle borderstyle = BorderStyle.DOTTED;
            valueStyle.setBorderLeft(borderstyle);
            valueStyle.setBorderRight(borderstyle);
            valueStyle.setBorderTop(borderstyle);
            valueStyle.setBorderBottom(borderstyle);
            short backColorIndex = IndexedColors.BLACK.index;
            valueStyle.setBottomBorderColor(backColorIndex);
            valueStyle.setTopBorderColor(backColorIndex);
            valueStyle.setLeftBorderColor(backColorIndex);
            valueStyle.setRightBorderColor(backColorIndex);
            valueStyle.setVerticalAlignment(VerticalAlignment.CENTER);
            HSSFFont defaultFont = workbook.createFont();
            defaultFont.setFontName(EASResource.getString((String)"com.kingdee.eas.tools.datatask.DATATASKAutoGenerateResource", (String)"46_ExternalExcelDataWriter"));
            defaultFont.setColor(IndexedColors.BLACK.index);
            short size = 12;
            defaultFont.setFontHeightInPoints(size);
            valueStyle.setFont(defaultFont);
            valueStyle.setDataFormat(HSSFDataFormat.getBuiltinFormat((String)"@"));
        }
        return valueStyle;
    }

    private HSSFCell getCell(HSSFSheet sht, int rowNum, int colNum) {
        int rowCount = sht.getPhysicalNumberOfRows();
        HSSFRow row = null;
        row = rowNum >= rowCount ? sht.createRow(rowNum) : sht.getRow(rowNum);
        HSSFCell cell = row.getCell((int)((short)colNum));
        if (cell == null) {
            cell = row.createCell((int)((short)colNum));
        }
        return cell;
    }

    private HSSFWorkbook createOvercastWriter(String fileName) throws Exception {
        HSSFWorkbook writeBook = new HSSFWorkbook();
        int numbCount = writeBook.getNumberOfSheets();
        for (int i = 0; i < numbCount; ++i) {
            String sheetName;
            String curSheetName = writeBook.getSheetName(i);
            if (curSheetName.compareTo(sheetName = null) != 0) continue;
            writeBook.removeSheetAt(i);
            break;
        }
        return writeBook;
    }

    private HSSFCellStyle createTitleCellStyle(HSSFWorkbook workbook) {
        HSSFCellStyle titleStyle = null;
        titleStyle = workbook.createCellStyle();
        titleStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        titleStyle.setFillForegroundColor(IndexedColors.LEMON_CHIFFON.index);
        titleStyle.setAlignment(HorizontalAlignment.CENTER);
        titleStyle.setHidden(false);
        titleStyle.setLocked(false);
        titleStyle.setBorderLeft(BorderStyle.NONE);
        titleStyle.setBorderRight(BorderStyle.NONE);
        titleStyle.setBorderTop(BorderStyle.NONE);
        titleStyle.setBorderBottom(BorderStyle.NONE);
        short backColorIndex = IndexedColors.BLACK.index;
        titleStyle.setBottomBorderColor(backColorIndex);
        titleStyle.setTopBorderColor(backColorIndex);
        titleStyle.setLeftBorderColor(backColorIndex);
        titleStyle.setRightBorderColor(backColorIndex);
        titleStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        titleStyle.setFillBackgroundColor(IndexedColors.GREY_25_PERCENT.index);
        HSSFFont defaultFont = workbook.createFont();
        defaultFont.setFontName(EASResource.getString((String)"com.kingdee.eas.tools.datatask.DATATASKAutoGenerateResource", (String)"46_ExternalExcelDataWriter"));
        defaultFont.setColor(IndexedColors.ROSE.index);
        short size = 12;
        defaultFont.setFontHeight(size);
        defaultFont.setFontHeightInPoints(size);
        titleStyle.setFont(defaultFont);
        return titleStyle;
    }

    File getSelectedFile(KDFileChooser fileChooser) {
        File file = fileChooser.getSelectedFile();
        if (file != null) {
            String path = file.getAbsolutePath();
            FileFilter ext = fileChooser.getFileFilter();
            if (ext != null && !ext.accept(file)) {
                if (ext instanceof ExcelFileFilter) {
                    path = path + ".xls";
                }
                file = new File(path);
            }
        }
        return file;
    }

    private void openFile(String tempFileName, KDTable table) {
        block5: {
            try {
                KDTMenuManager.openFileInExcel((String)tempFileName);
            }
            catch (IOException e2) {
                KDFileChooser fileChooser = this.getFileChooser();
                int result = fileChooser.showSaveDialog((Component)table);
                if (result != 0) break block5;
                File dest = this.getSelectedFile(fileChooser);
                try {
                    File src = new File(tempFileName);
                    if (dest.exists()) {
                        dest.delete();
                    }
                    src.renameTo(dest);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    KDFileChooser getFileChooser() {
        String title = LanguageManager.getLangMessage((String)"FileChooserTitle", KDTMenuManager.class, (String)"Save As...");
        KDFileChooser fileChooser = new KDFileChooser();
        fileChooser.setDialogTitle(title);
        fileChooser.setFileFilter((FileFilter)new ExcelFileFilter());
        return fileChooser;
    }
}

