/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.base.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.hr.base.EmpJobGradeFacadeFactory;
import com.kingdee.eas.hr.base.EmpJobGradeInfo;
import com.kingdee.eas.hr.base.app.HRBillAppUtils;
import com.kingdee.eas.hr.base.app.util.AffairUnAuditAppUtils;
import com.kingdee.eas.hr.emp.EmployeeJobGradeHistoryCollection;
import com.kingdee.eas.hr.emp.EmployeeJobGradeHistoryFactory;
import com.kingdee.eas.hr.emp.EmployeeJobGradeHistoryInfo;
import com.kingdee.eas.hr.emp.PersonPositionFactory;
import com.kingdee.eas.hr.emp.PersonPositionInfo;
import java.util.Date;

public class EmpJobGradeFacadeHelper {
    public static void updatePersonPositonJobGrade(Context ctx, EmpJobGradeInfo info) throws EASBizException, BOSException {
        PersonPositionInfo pInfo = new PersonPositionInfo();
        pInfo.setId(info.getPerson().getId());
        EmpJobGradeInfo stateInfo = EmpJobGradeFacadeFactory.getLocalInstance(ctx).getAppointDateEmpJobGrade(info.getPerson().getId().toString(), new Date());
        if (stateInfo != null) {
            pInfo.setJobGrade(stateInfo.getJobGrade());
            pInfo.setJobGradeEndDate(stateInfo.getEffectStartDate());
        } else {
            pInfo.setJobGrade(null);
            pInfo.setJobGradeEndDate(null);
        }
        pInfo.setPerson(info.getPerson());
        AffairUnAuditAppUtils.updatePersonSinglePagePartial((ICoreBase)PersonPositionFactory.getLocalInstance((Context)ctx), (CoreBaseInfo)pInfo, "jobGrade,jobGradeEndDate");
    }

    public static void recoveryJobGradeHistory(Context ctx, EmpJobGradeInfo info) throws EASBizException, BOSException {
        if (info.getEffectStartDate() == null) {
            return;
        }
    }

    private static EmployeeJobGradeHistoryInfo getLatestJobGradeHistory(Context ctx, EmpJobGradeInfo info) throws BOSException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("person.id", (Object)info.getPerson().getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("jobGrade.id", (Object)info.getJobGrade().getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("jobGradeEndDate", (Object)HRBillAppUtils.getPreviousDay(info.getEffectStartDate())));
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(filter);
        EmployeeJobGradeHistoryCollection jobgradehisColl = EmployeeJobGradeHistoryFactory.getLocalInstance((Context)ctx).getEmployeeJobGradeHistoryCollection(viewInfo);
        if (jobgradehisColl == null || jobgradehisColl.size() == 0) {
            return null;
        }
        return jobgradehisColl.get(0);
    }
}

