/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.base.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.HistoryConstant;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.base.EmpFlowInOutCollection;
import com.kingdee.eas.hr.base.EmpFlowInOutFactory;
import com.kingdee.eas.hr.base.EmpFlowInOutInfo;
import com.kingdee.eas.hr.base.EmpPositionInfo;
import com.kingdee.eas.hr.base.util.HRUtil;
import java.util.Date;

public class FlowInOutQueryHelper {
    protected EmpFlowInOutInfo getInActiveEmpPosOrgRelaByPositionAndDate(Context ctx, Date appointDate, EmpPositionInfo empPositionInfo) throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("person.id", (Object)empPositionInfo.getPersonInfo().getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("adminOrg.id", (Object)empPositionInfo.getAdminInfo().getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("position.id", (Object)empPositionInfo.getPositionInfo().getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("assignType", (Object)new Integer(empPositionInfo.getAssignType().getValue())));
        filter.getFilterItems().add(new FilterItemInfo("positionstatus", (Object)new Integer(0), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo(HistoryConstant.EFFDT, (Object)appointDate, CompareType.LESS));
        filter.getFilterItems().add(new FilterItemInfo(HistoryConstant.LEFFDT, (Object)appointDate, CompareType.GREATER));
        view.setFilter(filter);
        view.setSelector(this.getSelector());
        EmpFlowInOutCollection empFlowInOutColl = EmpFlowInOutFactory.getLocalInstance(ctx).getEmpFlowInOutCollection(view);
        if (empFlowInOutColl != null && empFlowInOutColl.size() > 0) {
            return empFlowInOutColl.get(0);
        }
        return null;
    }

    public EmpFlowInOutInfo getPrePrimaryPositionChangeInActive(Context ctx, EmpFlowInOutInfo newInfo, boolean isSameDatePersonChange) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("person.id", (Object)newInfo.getPerson().getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("assignType", (Object)new Integer(1)));
        filter.getFilterItems().add(new FilterItemInfo("positionstatus", (Object)new Integer(0), CompareType.EQUALS));
        if (isSameDatePersonChange) {
            filter.getFilterItems().add(new FilterItemInfo(HistoryConstant.LEFFDT, (Object)HRUtil.getBeforeDate(newInfo.getEFFDT()), CompareType.EQUALS));
        } else {
            filter.getFilterItems().add(new FilterItemInfo(HistoryConstant.LEFFDT, (Object)newInfo.getEFFDT(), CompareType.EQUALS));
        }
        view.setFilter(filter);
        view.setSelector(this.getSelector());
        EmpFlowInOutCollection flowInOutCollection = EmpFlowInOutFactory.getLocalInstance(ctx).getEmpFlowInOutCollection(view);
        if (flowInOutCollection != null && flowInOutCollection.size() > 0) {
            return flowInOutCollection.get(0);
        }
        return null;
    }

    public SelectorItemCollection getSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("person.id"));
        sic.add(new SelectorItemInfo("person.name"));
        sic.add(new SelectorItemInfo("person.number"));
        sic.add(new SelectorItemInfo("adminOrg.id"));
        sic.add(new SelectorItemInfo("adminOrg.name"));
        sic.add(new SelectorItemInfo("adminOrg.number"));
        sic.add(new SelectorItemInfo("adminOrg.displayName"));
        sic.add(new SelectorItemInfo("position.id"));
        sic.add(new SelectorItemInfo("position.name"));
        sic.add(new SelectorItemInfo("position.number"));
        sic.add(new SelectorItemInfo("position.PositionType.id"));
        sic.add(new SelectorItemInfo("position.PositionType.name"));
        sic.add(new SelectorItemInfo("position.PositionType.number"));
        sic.add(new SelectorItemInfo("relateAdmin.id"));
        sic.add(new SelectorItemInfo("relateAdmin.name"));
        sic.add(new SelectorItemInfo("relateAdmin.number"));
        sic.add(new SelectorItemInfo("actionReason.id"));
        sic.add(new SelectorItemInfo("actionReason.name"));
        sic.add(new SelectorItemInfo("actionReason.number"));
        sic.add(new SelectorItemInfo("laborRelation.laborRelationState.id"));
        sic.add(new SelectorItemInfo("laborRelation.laborRelationState.name"));
        sic.add(new SelectorItemInfo("laborRelation.laborRelationState.number"));
        sic.add(new SelectorItemInfo("positionstatus"));
        sic.add(new SelectorItemInfo("action.id"));
        sic.add(new SelectorItemInfo("action.name"));
        sic.add(new SelectorItemInfo("action.number"));
        sic.add(new SelectorItemInfo("assignType"));
        sic.add(new SelectorItemInfo(HistoryConstant.EFFDT));
        sic.add(new SelectorItemInfo(HistoryConstant.LEFFDT));
        sic.add(new SelectorItemInfo("flowInAffairID"));
        sic.add(new SelectorItemInfo("flowOutAffairID"));
        sic.add(new SelectorItemInfo("bizDate"));
        sic.add(new SelectorItemInfo("RCD"));
        sic.add(new SelectorItemInfo("empPosOrgRelation.id"));
        sic.add(new SelectorItemInfo("parent.id"));
        sic.add(new SelectorItemInfo("id"));
        return sic;
    }
}

