/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.base.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.base.app.AbstractHRAuditFacadeControllerBean;
import com.kingdee.eas.hr.compensation.CmpSchemeCollection;
import com.kingdee.eas.hr.compensation.CmpSchemeFactory;
import com.kingdee.eas.hr.compensation.CmpSchemeInfo;
import com.kingdee.eas.hr.compensation.CmpSchemePersonFactory;
import com.kingdee.eas.hr.compensation.CmpSchemePersonInfo;
import com.kingdee.eas.hr.compensation.ICmpScheme;
import com.kingdee.eas.hr.compensation.ICmpSchemePerson;
import com.kingdee.eas.hr.compensation.util.HRSchemeUtils;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import org.apache.log4j.Logger;

public class HRAuditFacadeControllerBean
extends AbstractHRAuditFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.hr.base.app.HRAuditFacadeControllerBean");

    @Override
    protected void _deleteDupData(Context ctx) throws BOSException, EASBizException {
        logger.debug((Object)"delete cmpScheme dup data\uff08auto\uff09begin : \n");
        CmpSchemeCollection c = CmpSchemeFactory.getLocalInstance((Context)ctx).getCmpSchemeCollection("select * where enable = 1");
        String horTabName = null;
        String hisTabName = null;
        CmpSchemeInfo info = null;
        int size = c.size();
        for (int i = 0; i < size; ++i) {
            info = c.get(i);
            horTabName = info.getHorTableName();
            hisTabName = info.getHisTableName();
            logger.debug((Object)("scheme name : " + info.getName() + " \n"));
            if (this.deleteTableDupData(ctx, horTabName)) {
                logger.debug((Object)("delete cmpScheme dup data\uff08auto\uff09delete datas : " + horTabName + " \n "));
            }
            if (!this.deleteTableDupData(ctx, hisTabName)) continue;
            logger.debug((Object)("delete cmpScheme dup data\uff08auto\uff09delete datas : " + hisTabName + " \n "));
        }
        if (this.deleteTableDupData(ctx, "T_HR_CMPSCHEMEPERSON")) {
            logger.debug((Object)"delete cmpScheme dup data\uff08auto\uff09delete T_HR_CMPSCHEMEPERSON datas \n ");
        }
        logger.debug((Object)"delete cmpScheme dup data\uff08auto\uff09end");
    }

    @Override
    protected IObjectCollection _checkDataValid(Context ctx) throws BOSException, EASBizException {
        CmpSchemeCollection invalidSchms = new CmpSchemeCollection();
        ICmpScheme icmp = CmpSchemeFactory.getLocalInstance((Context)ctx);
        CmpSchemeCollection c = icmp.getCmpSchemeCollection("select * where enable = 1");
        String horTabName = null;
        String hisTabName = null;
        CmpSchemeInfo info = null;
        int size = c.size();
        for (int i = 0; i < size; ++i) {
            info = c.get(i);
            horTabName = info.getHorTableName();
            hisTabName = info.getHisTableName();
            if (this.isValid(ctx, horTabName) && this.isValid(ctx, hisTabName)) continue;
            invalidSchms.add(info);
        }
        return invalidSchms;
    }

    @Override
    protected IObjectCollection _checkPersonValid(Context ctx) throws BOSException, EASBizException {
        CmpSchemeCollection invalidSchms = new CmpSchemeCollection();
        ICmpScheme icmp = CmpSchemeFactory.getLocalInstance((Context)ctx);
        StringBuffer sb = new StringBuffer();
        sb.append("select distinct fcmpschemeid  FROM T_HR_CMPSCHEMEPERSON ");
        sb.append("WHERE fcmpschemeid in (select fid from t_hr_cmpscheme where fenable = 1) ");
        sb.append("\t\tgroup by fcmpschemeid, fpersonid having count(*) > 1 ");
        IRowSet rows = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
        if (rows.size() > 0) {
            ArrayList<String> list = new ArrayList<String>();
            String schemeId = null;
            try {
                while (rows.next()) {
                    schemeId = rows.getString("fcmpschemeid");
                    list.add(schemeId);
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
            if (list.size() > 0) {
                HashSet<String> set = new HashSet<String>();
                int size = list.size();
                for (int i = 0; i < size; ++i) {
                    set.add(list.get(i).toString());
                }
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("id", set, CompareType.INCLUDE));
                EntityViewInfo evi = new EntityViewInfo();
                evi.setFilter(filter);
                CmpSchemeCollection tmpC = icmp.getCmpSchemeCollection(evi);
                int size2 = tmpC.size();
                for (int i = 0; i < size2; ++i) {
                    invalidSchms.add(tmpC.get(i));
                }
            }
        }
        return invalidSchms;
    }

    @Override
    protected IRowSet _getInvalidPerson(Context ctx, String schemeId) throws BOSException, EASBizException {
        String localLanguage = ctx.getLocale().getLanguage();
        StringBuffer sb = new StringBuffer();
        sb.append("  \n");
        sb.append(" select p.fnumber, p.fname_" + localLanguage + ", s.fname_" + localLanguage + ", a.flongnumber, \n");
        sb.append(" a.fdisplayname_" + localLanguage + ", m.fid, m.fpersonid, m.fpositionid, m.fadminorgunitid \n");
        sb.append(" from t_hr_cmpschemeperson m \n");
        sb.append(" inner join t_bd_person p on p.fid = m.fpersonid \n");
        sb.append(" left outer join t_org_position s on s.fid = m.fpositionid \n");
        sb.append(" left outer join t_org_admin a on a.fid = m.fadminorgunitid \n");
        sb.append(" where m.fcmpschemeid = ?  \n");
        sb.append(" and fpersonid in  \n");
        sb.append(" \t(select distinct fpersonid \n");
        sb.append(" \tfrom t_hr_cmpschemeperson  \n");
        sb.append(" \twhere fcmpschemeid = ? \n");
        sb.append(" \tgroup by fpersonid \n");
        sb.append(" \thaving count(*) > 1) \n");
        sb.append(" order by p.fnumber \n");
        return DbUtil.executeQuery((Context)ctx, (String)sb.toString(), (Object[])new Object[]{schemeId, schemeId});
    }

    @Override
    protected IRowSet _getInvalidData(Context ctx, String schemeId) throws BOSException, EASBizException {
        String localLanguage = ctx.getLocale().getLanguage();
        ICmpScheme icmp = CmpSchemeFactory.getLocalInstance((Context)ctx);
        CmpSchemeInfo info = icmp.getCmpSchemeInfo("select * where id = '" + schemeId + "'");
        if (info.getEnable().getValue() != 1) {
            return DbUtil.executeQuery((Context)ctx, (String)"SELECT FID AS PERSONNUMBER, FID AS PERSONNAME, FID AS POSITIONNAME, FID AS ADMINLONGNUMBER, FID AS ADMINLONGNAME, FID AS PERIOD FROM T_BD_PERSON WHERE 1>1 ");
        }
        String horTabName = info.getHorTableName();
        String hisTabName = info.getHisTableName();
        StringBuffer sb = new StringBuffer();
        sb.append(" select p.fnumber as personNumber, p.fname_" + localLanguage + " as personName, \n");
        sb.append(" s.fname_" + localLanguage + " as positionName, a.flongnumber as adminLongNumber,  \n");
        sb.append(" a.fdisplayname_" + localLanguage + " as adminLongName, c.fname_" + localLanguage + " as period,  \n");
        sb.append(" d.*  \n");
        sb.append(" from  \n");
        sb.append(" (select cur.* \n");
        sb.append(" from ");
        sb.append(horTabName);
        sb.append(" cur \n");
        sb.append(" inner join  \n");
        sb.append(" (select fperiod, fpersonid from ");
        sb.append(horTabName);
        sb.append(" group by fperiod, fpersonid having count(*) > 1)  cur_dup \n");
        sb.append(" on cur_dup.fperiod = cur.fperiod and cur_dup.fpersonid = cur.fpersonid \n");
        if (hisTabName != null && hisTabName.trim().length() > 0) {
            sb.append(" union \n");
            sb.append(" select his.* \n");
            sb.append(" from ");
            sb.append(hisTabName);
            sb.append(" his \n");
            sb.append(" inner join  \n");
            sb.append(" (select fperiod, fpersonid from ");
            sb.append(hisTabName);
            sb.append(" group by fperiod, fpersonid having count(*) > 1)  his_dup \n");
            sb.append(" on his_dup.fperiod = his.fperiod and his_dup.fpersonid = his.fpersonid \n");
        }
        sb.append(" ) d  \n");
        sb.append(" inner join t_bd_person p on p.fid = d.fpersonid \n");
        sb.append(" left outer join t_org_position s on s.fid = d.fpositionid \n");
        sb.append(" left outer join t_org_admin a on a.fid = d.fadminorgunitid \n");
        sb.append(" inner join t_hr_cmpperiod c on c.fid = d.fperiod \n");
        sb.append(" order by c.fbegindate desc, p.fnumber    \t \n");
        return DbUtil.executeQuery((Context)ctx, (String)sb.toString());
    }

    @Override
    protected void _fixSchemeData(Context ctx) throws BOSException, EASBizException {
    }

    private boolean isValid(Context ctx, String tableName) throws BOSException, EASBizException {
        String sql = "select fpersonid, FPERIOD from " + tableName + "group by fperiod, fpersonid having count(*) > 1";
        IRowSet rows = DbUtil.executeQuery((Context)ctx, (String)sql);
        return rows.size() <= 0;
    }

    private boolean deleteTableDupData(Context ctx, String tableName) throws BOSException, EASBizException {
        if (tableName == null || tableName.trim().length() == 0) {
            return false;
        }
        IRowSet rowsAll = DbUtil.executeQuery((Context)ctx, (String)("SELECT COUNT(*) AS FCOUNT FROM " + tableName));
        IRowSet rowsDistinct = DbUtil.executeQuery((Context)ctx, (String)("SELECT COUNT(*) AS FCOUNT FROM (SELECT DISTINCT * FROM " + tableName + ") A"));
        int allCount = 0;
        int distinctCount = 0;
        try {
            if (rowsAll.next()) {
                allCount = rowsAll.getInt("FCOUNT");
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        try {
            if (rowsDistinct.next()) {
                distinctCount = rowsDistinct.getInt("FCOUNT");
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        if (allCount == distinctCount) {
            return false;
        }
        try {
            HRSchemeUtils.createTableBackup((Context)ctx, (String)tableName);
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        String tmpTable = this.createTmpTable(ctx, tableName);
        DbUtil.execute((Context)ctx, (String)("DELETE FROM " + tableName));
        DbUtil.execute((Context)ctx, (String)("INSERT INTO " + tableName + " SELECT * FROM " + tmpTable));
        return true;
    }

    public String createTmpTable(Context ctx, String tablename) throws BOSException {
        String tablename_bak = null;
        try {
            tablename_bak = TempTablePool.getInstance((Context)ctx).createTempTableName();
        }
        catch (Exception e) {
            throw new BOSException();
        }
        DbUtil.execute((Context)ctx, (String)(" select distinct * into " + tablename_bak + " from " + tablename));
        return tablename_bak;
    }

    private String getInClause(String[] personIds) {
        StringBuffer sql = new StringBuffer();
        if (personIds.length == 0) {
            sql.append("'@@'");
        } else {
            for (int i = 0; i < personIds.length; ++i) {
                if (i == 0) {
                    sql.append("'");
                } else {
                    sql.append(",'");
                }
                sql.append(personIds[i]);
                sql.append("'");
            }
        }
        return sql.toString();
    }

    private CmpSchemeCollection getCmpSchemes(Context ctx, String[] personIds) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("select distinct fcmpschemeid  \n");
        sql.append("from t_hr_cmpschemeperson  \n");
        sql.append("where fcmpschemeid in (select fid from t_hr_cmpscheme where fenable = 1)  \n");
        sql.append("and fpersonid in(");
        sql.append(this.getInClause(personIds));
        sql.append(")");
        IRowSet rows = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        if (rows.size() == 0) {
            return new CmpSchemeCollection();
        }
        HashSet<String> set = new HashSet<String>();
        try {
            while (rows.next()) {
                set.add(rows.getString("fcmpschemeid"));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", set, CompareType.INCLUDE));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        return CmpSchemeFactory.getLocalInstance((Context)ctx).getCmpSchemeCollection(evi);
    }

    private void _delSchmPersonDatas(Context ctx, String[] ids) throws BOSException, EASBizException {
        String sql = "select horTableName, hisTableName";
        String delSql = "delete from $table$ where fpersonid = ? and fpositionid = ? and  fadminOrgUnitId = ?";
        String delSql2 = "delete from $table$ where fpersonid = ? and fpositionid is null and  fadminOrgUnitId = ?";
        String delSql3 = "delete from $table$ where fpersonid = ? and fpositionid = ? and  fadminOrgUnitId is null";
        String delSql4 = "delete from $table$ where fpersonid = ? and fpositionid is null and  fadminOrgUnitId is null";
        String hisTable = null;
        ICmpSchemePerson icsp = CmpSchemePersonFactory.getLocalInstance((Context)ctx);
        CmpSchemePersonInfo pInfo = null;
        for (int i = 0; i < ids.length; ++i) {
            String adminOrgUnitId;
            pInfo = icsp.getCmpSchemePersonInfo(sql);
            String horTable = pInfo.getCmpScheme().getHorTableName();
            hisTable = pInfo.getCmpScheme().getHisTableName();
            String personId = pInfo.getPerson().getId().toString();
            String positionId = pInfo.getPosition() == null ? null : pInfo.getPosition().getId().toString();
            String string = adminOrgUnitId = pInfo.getAdminOrgUnit() == null ? null : pInfo.getAdminOrgUnit().getId().toString();
            if (positionId == null && adminOrgUnitId == null) {
                DbUtil.execute((Context)ctx, (String)delSql4.replaceAll("$table$", horTable), (Object[])new Object[]{personId});
            } else if (positionId != null && adminOrgUnitId == null) {
                DbUtil.execute((Context)ctx, (String)delSql3.replaceAll("$table$", horTable), (Object[])new Object[]{personId, positionId});
            } else if (adminOrgUnitId != null && positionId == null) {
                DbUtil.execute((Context)ctx, (String)delSql2.replaceAll("$table$", horTable), (Object[])new Object[]{personId, adminOrgUnitId});
            } else {
                DbUtil.execute((Context)ctx, (String)delSql.replaceAll("$table$", horTable), (Object[])new Object[]{personId, positionId, adminOrgUnitId});
            }
            if (hisTable == null) continue;
            if (positionId == null && adminOrgUnitId == null) {
                DbUtil.execute((Context)ctx, (String)delSql4.replaceAll("$table$", hisTable), (Object[])new Object[]{personId});
                continue;
            }
            if (positionId != null && adminOrgUnitId == null) {
                DbUtil.execute((Context)ctx, (String)delSql3.replaceAll("$table$", hisTable), (Object[])new Object[]{personId, positionId});
                continue;
            }
            if (adminOrgUnitId != null && positionId == null) {
                DbUtil.execute((Context)ctx, (String)delSql2.replaceAll("$table$", hisTable), (Object[])new Object[]{personId, adminOrgUnitId});
                continue;
            }
            DbUtil.execute((Context)ctx, (String)delSql.replaceAll("$table$", hisTable), (Object[])new Object[]{personId, positionId, adminOrgUnitId});
        }
    }

    @Override
    protected void _delSchmPersons(Context ctx, String[] ids) throws BOSException, EASBizException {
        logger.debug((Object)"delete cmpScheme persons(_delSchmPersons) begin : \n");
        logger.debug((Object)"_delSchmPersons backup hortable and histable begin : \n");
        CmpSchemeCollection c = this.getCmpSchemes(ctx, ids);
        int size = c.size();
        if (size == 0) {
            return;
        }
        String hisTabName = null;
        CmpSchemeInfo info = null;
        for (int i = 0; i < size; ++i) {
            info = c.get(i);
            String horTabName = info.getHorTableName();
            hisTabName = info.getHisTableName();
            try {
                HRSchemeUtils.createTableBackup((Context)ctx, (String)horTabName);
                if (hisTabName == null) continue;
                HRSchemeUtils.createTableBackup((Context)ctx, (String)hisTabName);
                continue;
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
        }
        logger.debug((Object)"_delSchmPersons delete persondatas begin : \n");
        this._delSchmPersonDatas(ctx, ids);
        logger.debug((Object)"_delSchmPersons backup T_HR_CMPSCHEMEPERSON begin : \n");
        try {
            HRSchemeUtils.createTableBackup((Context)ctx, (String)"T_HR_CMPSCHEMEPERSON");
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        logger.debug((Object)"_delSchmPersons delete persons begin : \n");
        DbUtil.execute((Context)ctx, (String)("Delete FROM T_HR_CMPSCHEMEPERSON where FID in (" + this.getInClause(ids) + ")"));
        logger.debug((Object)"delete cmpScheme persons(_delSchmPersons) end : \n");
    }

    @Override
    protected void _delSchmDatas(Context ctx, ArrayList keys) throws BOSException, EASBizException {
        HashMap map = null;
        Object[] params = null;
        String sql = null;
        int size = keys.size();
        for (int i = 0; i < size; ++i) {
            map = (HashMap)keys.get(i);
            sql = (String)map.get("sql");
            params = (Object[])map.get("params");
            DbUtil.execute((Context)ctx, (String)sql, (Object[])params);
        }
    }
}

