/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.base.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.function.FunctionObjectInfo;
import com.kingdee.bos.metadata.function.OperationInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.service.IServiceContext;
import com.kingdee.bos.service.job.IJobService;
import com.kingdee.bos.service.job.JobServiceFactory;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.workflow.ProcessInstInfo;
import com.kingdee.bos.workflow.define.KpdlParser;
import com.kingdee.bos.workflow.define.ScheduleDef;
import com.kingdee.bos.workflow.define.ScheduleType;
import com.kingdee.bos.workflow.monitor.WfUtil;
import com.kingdee.bos.workflow.service.EnactmentServiceProxy;
import com.kingdee.bos.workflow.service.ormrpc.EnactmentServiceFactory;
import com.kingdee.bos.workflow.service.ormrpc.IEnactmentService;
import com.kingdee.eas.base.codingrule.CodingRuleException;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.base.multiapprove.ApproveResult;
import com.kingdee.eas.base.multiapprove.IMultiApprove;
import com.kingdee.eas.base.multiapprove.MultiApproveFactory;
import com.kingdee.eas.base.multiapprove.MultiApproveInfo;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.HROrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.affair.AffairBizException;
import com.kingdee.eas.hr.affair.CheckHireBizBillInfo;
import com.kingdee.eas.hr.affair.FlucInBizBillInfo;
import com.kingdee.eas.hr.affair.HRAffairException;
import com.kingdee.eas.hr.affair.LoanBackBizBillInfo;
import com.kingdee.eas.hr.affair.LoanBizBillInfo;
import com.kingdee.eas.hr.affair.LoanInBizBillInfo;
import com.kingdee.eas.hr.affair.OnPositionBizBillInfo;
import com.kingdee.eas.hr.affair.PluralityDelBizBillInfo;
import com.kingdee.eas.hr.affair.PluralityReplaceBizBillInfo;
import com.kingdee.eas.hr.affair.ReinviteBizBillInfo;
import com.kingdee.eas.hr.affair.ReinviteFireBizBillInfo;
import com.kingdee.eas.hr.base.ApproveTypeEnum;
import com.kingdee.eas.hr.base.BillEntryJobProcessCollection;
import com.kingdee.eas.hr.base.BillEntryJobProcessFactory;
import com.kingdee.eas.hr.base.BillEntryJobProcessInfo;
import com.kingdee.eas.hr.base.CodingRuleManageFacadeFactory;
import com.kingdee.eas.hr.base.FieldMappingException;
import com.kingdee.eas.hr.base.HRBaseException;
import com.kingdee.eas.hr.base.HRBillBaseEntryInfo;
import com.kingdee.eas.hr.base.HRBillBaseInfo;
import com.kingdee.eas.hr.base.HRBillStateEnum;
import com.kingdee.eas.hr.base.HRCommonException;
import com.kingdee.eas.hr.base.IHRBillBase;
import com.kingdee.eas.hr.base.IHRBillBaseEntry;
import com.kingdee.eas.hr.base.app.AbstractHRBillBaseControllerBean;
import com.kingdee.eas.hr.base.app.BillExtendBeanProcess;
import com.kingdee.eas.hr.base.app.HRBillBeanBizFactory;
import com.kingdee.eas.hr.base.app.IHRBillBizBean;
import com.kingdee.eas.hr.base.app.PlugInBeanFactory;
import com.kingdee.eas.hr.base.app.PlugInBeanProxy;
import com.kingdee.eas.hr.base.app.config.HRBillBaseConfigReader;
import com.kingdee.eas.hr.base.app.util.HRWorkFlowCheckUtil;
import com.kingdee.eas.hr.base.app.util.MetaDataServerUtil;
import com.kingdee.eas.hr.base.app.util.SHRSameDatePersonChangeUtil;
import com.kingdee.eas.hr.base.util.HRParamUtil;
import com.kingdee.eas.hr.base.util.IReflectMethod;
import com.kingdee.eas.hr.base.util.MappingApplyUtil;
import com.kingdee.eas.hr.base.util.ReflectUtil;
import com.kingdee.eas.hr.org.PersonPlanBizBillInfo;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.ml.util.SHRServerResource;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.StringUtils;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.text.MessageFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import org.apache.log4j.Logger;

public class HRBillBaseControllerBean
extends AbstractHRBillBaseControllerBean {
    private static Logger logger = Logger.getLogger(HRBillBaseControllerBean.class);
    private IHRBillBizBean bizBean = null;

    protected void _checkNumDup(Context ctx, HRBillBaseInfo info) throws BOSException, EASBizException {
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("number", (Object)info.getNumber(), CompareType.EQUALS));
        if (super._exists(ctx, filterInfo)) {
            String alias = "";
            EntityObjectInfo entityInfo = MetaDataLoaderFactory.getRemoteMetaDataLoader().getEntity(info.getBOSType());
            alias = entityInfo.getAlias();
            throw new EASBizException(EASBizException.CHECKDUPNUMBER, new Object[]{info.getString("number"), MessageFormat.format(SHRServerResource.getString((String)"com.kingdee.eas.hr.base.HRBaseBizResource", (String)"label115", (Context)ctx), alias)});
        }
    }

    protected void _checkNumberDup(Context ctx, IObjectValue model) throws BOSException, EASBizException {
    }

    protected void setNumberFromCodingRule(Context ctx, HRBillBaseInfo model) throws BOSException, EASBizException {
        String orgID = null;
        if (model.getHrOrgUnit() != null) {
            orgID = model.getHrOrgUnit().getId().toString();
        }
        String number = null;
        ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        boolean codeRuleisExist = orgID != null && iCodingRuleManager.isExist((IObjectValue)model, orgID);
        boolean isSetNumber = true;
        if (codeRuleisExist && iCodingRuleManager.getRuleStatus((IObjectValue)model, orgID).isModifiable() && !StringUtils.isEmpty((String)model.getNumber())) {
            isSetNumber = false;
        }
        if (codeRuleisExist && isSetNumber) {
            number = iCodingRuleManager.getNumber((IObjectValue)model, orgID);
            for (int numberCount = 0; super._exists(ctx, "where number = '" + number + "'") && numberCount < 5000; ++numberCount) {
                number = iCodingRuleManager.getNumber((IObjectValue)model, orgID);
            }
        }
        if (number != null) {
            model.setNumber(number);
        }
    }

    protected void _addnew(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        HRBillBaseInfo info = (HRBillBaseInfo)model;
        if (info.getHrOrgUnit() == null) {
            throw new HRCommonException(HRCommonException.HRO_NULL);
        }
        this.initBizBean(ctx);
        this._check(ctx, pk, model);
        this.setNumberFromCodingRule(ctx, info);
        if (this.bizBean != null) {
            this.bizBean._check(ctx, pk, model);
            this.bizBean._processBeforeAddNew(ctx, model);
        }
        this._checkNumDup(ctx, info);
        super._addnew(ctx, pk, (IObjectValue)info);
        if (this.bizBean != null) {
            info = this.getHRBillBaseInfo(ctx, pk);
            info.setSendValue((HRBillBaseInfo)model);
            this.bizBean._addnew(ctx, pk, (IObjectValue)info);
        }
    }

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        HRBillBaseInfo info = (HRBillBaseInfo)model;
        if (info == null) {
            return null;
        }
        if (info.getHrOrgUnit() == null) {
            throw new HRCommonException(HRCommonException.HRO_NULL);
        }
        this.initBizBean(ctx);
        this._check(ctx, null, model);
        this.setNumberFromCodingRule(ctx, info);
        if (this.bizBean != null) {
            this.bizBean._check(ctx, null, model);
            this.bizBean._processBeforeAddNew(ctx, model);
        }
        this._checkNumDup(ctx, info);
        IObjectPK pk = super._addnew(ctx, (IObjectValue)info);
        if (this.bizBean != null) {
            info = this.getHRBillBaseInfo(ctx, pk);
            info.setSendValue((HRBillBaseInfo)model);
            this.bizBean._addnew(ctx, pk, (IObjectValue)info);
        }
        return pk;
    }

    protected void _checkNumDup(Context ctx, IObjectPK pk, HRBillBaseInfo info) throws BOSException, EASBizException {
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("number", (Object)info.getNumber(), CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)pk.toString(), CompareType.NOTEQUALS));
        if (super._exists(ctx, filterInfo)) {
            throw new EASBizException(EASBizException.CHECKDUPNUMBER, new Object[]{info.getString("number"), ""});
        }
    }

    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        HRBillBaseInfo info = (HRBillBaseInfo)model;
        if (info.getHrOrgUnit() == null) {
            throw new HRCommonException(HRCommonException.HRO_NULL);
        }
        this._checkNumDup(ctx, pk, (HRBillBaseInfo)model);
        this.initBizBean(ctx);
        HRBillBaseInfo oldInfo = (HRBillBaseInfo)this.getValue(ctx, pk);
        model.put("oldBillStateForCheck", (Object)oldInfo.getBillState());
        this._check(ctx, pk, model);
        if (this.bizBean != null) {
            this.bizBean._check(ctx, pk, model);
        }
        super._update(ctx, pk, model);
        if (this.bizBean != null) {
            info = this.getHRBillBaseInfo(ctx, pk);
            info.setSendValue((HRBillBaseInfo)model);
            this.bizBean._update(ctx, pk, (IObjectValue)info);
        }
    }

    protected void checkHRBillWorkFlowIsEdit(Context ctx, HRBillBaseInfo info, HRBillStateEnum oldBillState) throws BOSException, EASBizException {
        HRWorkFlowCheckUtil.checkHRBillIsEdit(ctx, info, oldBillState);
    }

    protected void _reverseSave(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        if (this.isNeedReverseSave()) {
            super._reverseSave(ctx, pk, model);
        }
    }

    protected Date getEffectDate(HRBillBaseEntryInfo entry) throws BOSException, EASBizException {
        Date effectDate = null;
        if (this.getEntryEffectDateField() != null && (effectDate = entry.getDate(this.getEntryEffectDateField())) != null) {
            effectDate = DateTimeUtils.truncateDate((Date)effectDate);
        }
        return effectDate;
    }

    protected Date getEffectTime(HRBillBaseEntryInfo entry) throws BOSException, EASBizException {
        Date effectDate = null;
        if (this.getEntryEffectTimeField() != null) {
            effectDate = entry.getDate(this.getEntryEffectTimeField());
        } else {
            effectDate = entry.getDate(this.getEntryEffectDateField());
            if (effectDate != null) {
                effectDate = DateTimeUtils.truncateDate((Date)effectDate);
            }
        }
        return effectDate;
    }

    @Override
    protected void _setAudited(Context ctx, BOSUuid billID) throws BOSException, EASBizException {
        if (billID == null) {
            return;
        }
        HRBillBaseInfo model = this.getHRBillBaseInfo(ctx, (IObjectPK)new ObjectUuidPK(billID));
        ObjectUuidPK pk = new ObjectUuidPK(billID);
        String description = this.getLogDescription(ctx, model);
        IObjectPK logPK = description == null ? null : LogUtil.beginLogWithDescription((Context)ctx, (String)"batchAudit", (BOSObjectType)billID.getType(), (IObjectPK)pk, (String)model.getNumber(), (String)description);
        this._auditEntryEffect(ctx, billID);
        if (logPK != null) {
            LogUtil.afterLog((Context)ctx, (IObjectPK)logPK);
        }
        this._sendAssignedMsgToXT(ctx, billID);
    }

    @Override
    protected void _auditEntryEffect(Context ctx, BOSUuid billID) throws BOSException, EASBizException {
        if (billID == null) {
            return;
        }
        SHRSameDatePersonChangeUtil util = new SHRSameDatePersonChangeUtil();
        HRBillBaseInfo model = this.getHRBillBaseInfo(ctx, (IObjectPK)new ObjectUuidPK(billID));
        HRBillBaseEntryInfo entry = null;
        String entryField = this.getEntryField();
        String billField = this.getBillField();
        if (this.bizBean != null) {
            this.bizBean._personPlanChek(ctx, (IObjectValue)model);
        }
        IObjectCollection entries = (IObjectCollection)model.get(entryField);
        this.initBizBean(ctx);
        if (entries == null) {
            throw new AffairBizException(AffairBizException.ENRTY_IS_NULL);
        }
        Date now = new Date();
        Date effectDate = null;
        int size = entries.size();
        for (int i = 0; i < size; ++i) {
            entry = (HRBillBaseEntryInfo)entries.getObject(i);
            this.setIsSameDatePersonChange(ctx, util, entry);
            entry.put(billField, model);
            effectDate = this.getEffectTime(entry);
            if (null == effectDate) {
                effectDate = this.getEffectDate(entry);
            }
            entry.put(this.getEntryEffectDateField(), effectDate);
            if (effectDate != null && now.before(effectDate) && this.checkIsCreateJob()) {
                this._beforeEffectBeforeBackJob(ctx, entry);
                if (this.bizBean != null) {
                    this.bizBean._beforeEffectBeforeBackJob(ctx, entry);
                }
                this.setBillRelateInfo(ctx, entry.getId());
                this.createBackGroundJob(ctx, (IObjectValue)entry, "entryID");
            } else {
                this._beforeEffectOnNoJob(ctx, entry);
                if (this.bizBean != null) {
                    this.bizBean._beforeEffectOnNoJob(ctx, entry);
                }
                this._entryEffectCommon(ctx, entry.getId());
            }
            this._entryEffectOthers(ctx, entry);
            this.setProgressData(i + 1, size, billID.toString());
        }
        this.updateBillState(ctx, billID, HRBillStateEnum.AUDITED);
        if (this.bizBean != null) {
            this.bizBean._setBillState(ctx, billID, HRBillStateEnum.AUDITED);
        }
        if (ApproveTypeEnum.DIRECT.equals((Object)model.getApproveType())) {
            this.saveMultiApproveInfo(ctx, billID);
        }
    }

    public void setProgressData(int curEntryNo, int entrysCount, String billId) {
    }

    public void setIsSameDatePersonChange(Context ctx, SHRSameDatePersonChangeUtil util, HRBillBaseEntryInfo entry) throws BOSException {
    }

    protected void setUnauditIsSameDatePersonChange(Context ctx, HRBillBaseEntryInfo entry) throws BOSException {
    }

    protected void _entryEffectOthers(Context ctx, HRBillBaseEntryInfo entry) throws BOSException, EASBizException {
    }

    public void setBillRelateInfo(Context ctx, BOSUuid entryID) throws EASBizException, BOSException {
    }

    private String getLogDescription(Context ctx, HRBillBaseInfo model) throws BOSException, EASBizException {
        String description = null;
        if (model instanceof OnPositionBizBillInfo) {
            description = ResourceBase.getString((String)"com.kingdee.eas.hr.affair.AFFAIRAutoGenerateResource", (String)"83_HRBillBaseControllerBean", (Locale)ctx.getLocale());
        } else if (model instanceof ReinviteFireBizBillInfo) {
            description = ResourceBase.getString((String)"com.kingdee.eas.hr.affair.AFFAIRAutoGenerateResource", (String)"84_HRBillBaseControllerBean", (Locale)ctx.getLocale());
        } else if (model instanceof ReinviteBizBillInfo) {
            description = ResourceBase.getString((String)"com.kingdee.eas.hr.affair.AFFAIRAutoGenerateResource", (String)"85_HRBillBaseControllerBean", (Locale)ctx.getLocale());
        } else if (model instanceof LoanBizBillInfo) {
            description = ResourceBase.getString((String)"com.kingdee.eas.hr.affair.AFFAIRAutoGenerateResource", (String)"86_HRBillBaseControllerBean", (Locale)ctx.getLocale());
        } else if (model instanceof LoanInBizBillInfo) {
            description = ResourceBase.getString((String)"com.kingdee.eas.hr.affair.AFFAIRAutoGenerateResource", (String)"87_HRBillBaseControllerBean", (Locale)ctx.getLocale());
        } else if (model instanceof LoanBackBizBillInfo) {
            description = ResourceBase.getString((String)"com.kingdee.eas.hr.affair.AFFAIRAutoGenerateResource", (String)"88_HRBillBaseControllerBean", (Locale)ctx.getLocale());
        } else if (model instanceof PluralityReplaceBizBillInfo) {
            description = ResourceBase.getString((String)"com.kingdee.eas.hr.affair.AFFAIRAutoGenerateResource", (String)"89_HRBillBaseControllerBean", (Locale)ctx.getLocale());
        } else if (model instanceof PluralityDelBizBillInfo) {
            description = ResourceBase.getString((String)"com.kingdee.eas.hr.affair.AFFAIRAutoGenerateResource", (String)"90_HRBillBaseControllerBean", (Locale)ctx.getLocale());
        } else if (model instanceof FlucInBizBillInfo) {
            description = ResourceBase.getString((String)"com.kingdee.eas.hr.affair.AFFAIRAutoGenerateResource", (String)"91_HRBillBaseControllerBean", (Locale)ctx.getLocale());
        } else if (model instanceof CheckHireBizBillInfo) {
            description = ResourceBase.getString((String)"com.kingdee.eas.hr.affair.AFFAIRAutoGenerateResource", (String)"92_HRBillBaseControllerBean", (Locale)ctx.getLocale());
        } else if (model instanceof PersonPlanBizBillInfo) {
            description = ResourceBase.getString((String)"com.kingdee.eas.hr.affair.AFFAIRAutoGenerateResource", (String)"93_HRBillBaseControllerBean", (Locale)ctx.getLocale());
        }
        if (description != null) {
            description = description + "_" + ResourceBase.getString((String)"com.kingdee.eas.hr.affair.AFFAIRAutoGenerateResource", (String)"32_HRAffairBaseControllerBean", (Locale)ctx.getLocale());
        }
        return description;
    }

    private void saveMultiApproveInfo(Context ctx, BOSUuid billId) throws BOSException, EASBizException {
        IMultiApprove im = MultiApproveFactory.getLocalInstance((Context)ctx);
        MultiApproveInfo info = new MultiApproveInfo();
        info.setIsPass(ApproveResult.PASS);
        info.setOpinion(ResourceBase.getString((String)"com.kingdee.eas.hr.base.BASEAutoGenerateResource", (String)"0_HRBillBaseControllerBean", (Locale)ctx.getLocale()));
        info.setBillId(billId);
        info.setBosTypeStr(billId.getType().toString());
        im.addnew((CoreBaseInfo)info);
    }

    @Override
    protected void _setAuditEnd(Context ctx, BOSUuid billID) throws BOSException, EASBizException {
        this.updateBillState(ctx, billID, HRBillStateEnum.AUDITEND);
        this.initBizBean(ctx);
        if (this.bizBean != null) {
            this.bizBean._setBillState(ctx, billID, HRBillStateEnum.AUDITEND);
        }
    }

    @Override
    protected void _setAuditing(Context ctx, BOSUuid billID) throws BOSException, EASBizException {
        this.updateBillState(ctx, billID, HRBillStateEnum.AUDITING);
        this.initBizBean(ctx);
        if (this.bizBean != null) {
            this.bizBean._setBillState(ctx, billID, HRBillStateEnum.AUDITING);
        }
    }

    @Override
    protected void _setSubmited(Context ctx, BOSUuid billID) throws BOSException, EASBizException {
        this.updateBillState(ctx, billID, HRBillStateEnum.SUBMITED);
        this.initBizBean(ctx);
        if (this.bizBean != null) {
            this.bizBean._setBillState(ctx, billID, HRBillStateEnum.SUBMITED);
        }
    }

    protected void updateBillState(Context ctx, BOSUuid billID, HRBillStateEnum state) throws BOSException, EASBizException {
        if (billID == null || state == null) {
            return;
        }
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("billState"));
        selector.add(new SelectorItemInfo("bizDate"));
        selector.add(new SelectorItemInfo("approveType"));
        selector.add(new SelectorItemInfo("auditor"));
        if (this.exists(ctx, (IObjectPK)new ObjectUuidPK(billID))) {
            HRBillBaseInfo model = this.getHRBillBaseInfo(ctx, (IObjectPK)new ObjectUuidPK(billID), selector);
            model.setBillState(state);
            if (state.equals((Object)HRBillStateEnum.SAVED) || state.equals((Object)HRBillStateEnum.SUBMITED)) {
                model.setBizDate(null);
            } else {
                model.setBizDate(DateTimeUtils.truncateDate((Date)new Date()));
            }
            if (ApproveTypeEnum.DIRECT.equals((Object)model.getApproveType())) {
                model.setAuditor(ContextUtil.getCurrentUserInfo((Context)ctx));
            }
            this.updatePartial(ctx, (CoreBaseInfo)model, selector);
        }
    }

    @Override
    protected void _entryEffectCommon(Context ctx, BOSUuid entryID) throws BOSException, EASBizException {
        if (entryID == null) {
            throw new AffairBizException(AffairBizException.ENTRY_ID_IS_NULL);
        }
        HRBillBaseEntryInfo entry = null;
        HRBillBaseInfo bill = null;
        entry = this.getEntryInterface(ctx).getHRBillBaseEntryInfo((IObjectPK)new ObjectUuidPK(entryID), this.getEntrySelector());
        String billField = this.getBillField();
        String entryField = this.getEntryField();
        if (entry != null && !StringUtils.isEmpty((String)billField) && !StringUtils.isEmpty((String)entryField)) {
            IObjectCollection entries;
            bill = (HRBillBaseInfo)entry.get(billField);
            if (bill != null && (entries = (IObjectCollection)(bill = this.getHRBillBaseInfo(ctx, (IObjectPK)new ObjectUuidPK(bill.getId()), this.getBillSelector())).get(entryField)) != null) {
                entries.clear();
                entries.addObject((IObjectValue)entry);
            }
            entry.put(billField, bill);
        }
        try {
            SHRSameDatePersonChangeUtil util = new SHRSameDatePersonChangeUtil();
            this.setIsSameDatePersonChange(ctx, util, entry);
            this._entryEffect(ctx, entry);
            this.initBizBean(ctx);
            if (this.bizBean != null) {
                this.bizBean.setHROrgUnit(this.getHROrgUnit(ctx, new ObjectUuidPK(entryID)));
                this.bizBean._entryEffect(ctx, entry);
            }
            if (bill != null) {
                this._mappingSubmit(ctx, bill);
            }
        }
        catch (EASBizException e) {
            e.printStackTrace();
            this.executeOther(ctx, entry, (Exception)((Object)e));
            throw e;
        }
        catch (BOSException e) {
            e.printStackTrace();
            this.executeOther(ctx, entry, (Exception)((Object)e));
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.executeOther(ctx, entry, e);
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
    }

    protected boolean isNeedMappingReWrite(Context ctx, HRBillBaseInfo bill) {
        return true;
    }

    @Override
    protected final void _entryEffect(Context ctx, BOSUuid entryID) throws BOSException, EASBizException {
        if (entryID != null) {
            HRBillBaseEntryInfo entry = this.getEntryInterface(ctx).getHRBillBaseEntryInfo((IObjectPK)new ObjectUuidPK(entryID));
            HROrgUnitInfo hro = this.getHROrgUnit(ctx, new ObjectUuidPK(entryID));
            if (ContextUtil.getCurrentUserInfo((Context)ctx) == null) {
                UserInfo user = UserFactory.getLocalInstance((Context)ctx).getUser("administrator");
                ContextUtil.setCurrentUserInfo((Context)ctx, (UserInfo)user);
            }
            if (ContextUtil.getCurrentHRUnit((Context)ctx) == null) {
                ContextUtil.setCurrentHRUnit((Context)ctx, (HROrgUnitInfo)hro);
            }
            this._beforeEffectOnBackJob(ctx, entry);
            this.initBizBean(ctx);
            if (this.bizBean != null) {
                this.bizBean.setHROrgUnit(hro);
                this.bizBean._beforeEffectOnBackJob(ctx, entry);
            }
        }
        this._entryEffectCommon(ctx, entryID);
    }

    protected HROrgUnitInfo getHROrgUnit(Context ctx, ObjectUuidPK objectUuidPK) throws EASBizException, BOSException {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo(this.getBillField() + ".id"));
        selector.add(new SelectorItemInfo(this.getBillField() + ".hrOrgUnit.id"));
        HRBillBaseEntryInfo entryInfo = this.getEntryInterface(ctx).getHRBillBaseEntryInfo((IObjectPK)objectUuidPK, selector);
        HROrgUnitInfo hrOrgUnitInfo = ((HRBillBaseInfo)entryInfo.get(this.getBillField())).getHrOrgUnit();
        return hrOrgUnitInfo;
    }

    protected void _mappingSubmit(Context ctx, HRBillBaseInfo model) throws BOSException, EASBizException {
        try {
            String hrOrgID = null;
            if (model.getHrOrgUnit() != null) {
                hrOrgID = model.getHrOrgUnit().getId().toString();
            }
            MappingApplyUtil.mappingSubmit(ctx, (IObjectValue)model, hrOrgID);
        }
        catch (BOSException e) {
            e.printStackTrace();
            logger.error((Object)("@HR_FieldMapping_Error0:" + e.getMessage()), e.getCause());
            throw new BOSException(e.getMessage());
        }
        catch (EASBizException e) {
            e.printStackTrace();
            logger.error((Object)("@HR_FieldMapping_Error0:" + e.getMessage()), e.getCause());
            throw new FieldMappingException(FieldMappingException.MAPPINGINVALID, new Object[]{e.getMessage()});
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error((Object)("@HR_FieldMapping_Error1:" + e.getMessage()), e.getCause());
            throw new FieldMappingException(FieldMappingException.MAPPINGEFFECTERROR);
        }
    }

    protected void createBackGroundJob(Context ctx, IObjectValue ov, String jobKey) throws EASBizException, BOSException {
        EnactmentServiceProxy service = new EnactmentServiceProxy(ctx);
        String funcName = this.getEffectFunction(ctx);
        if (!StringUtils.isEmpty((String)funcName)) {
            MetaDataPK functionPK = new MetaDataPK(funcName);
            FunctionObjectInfo function = MetaDataLoaderFactory.getMetaDataLoader((Context)ctx).getFunction((IMetaDataPK)functionPK);
            OperationInfo operation = function.getOperation().get(0);
            HashMap<String, Object> jobContext = new HashMap<String, Object>();
            jobContext.put(jobKey, ov.get("id"));
            Date date = this.getBackGroundJobDate(ov);
            String jobProcessDefID = service.createJobProcessDef(this.getEffectProcessName(ctx, ov), function, operation, jobContext, this.getSchedule(date), ctx.getLocale());
            if (!StringUtils.isEmpty((String)jobProcessDefID)) {
                String sql = "update t_job_def set fproxyuserid = fcreateuserid where fjobdefid = '" + jobProcessDefID + "'";
                DbUtil.execute((Context)ctx, (String)sql);
            }
            BillEntryJobProcessInfo bejpInfo = new BillEntryJobProcessInfo();
            bejpInfo.setId(BOSUuid.create((String)"CC1195F2"));
            bejpInfo.setBillEntryId(ov.get("id").toString());
            bejpInfo.setJobProcessId(jobProcessDefID);
            BillEntryJobProcessFactory.getLocalInstance(ctx).addnew((CoreBaseInfo)bejpInfo);
        }
    }

    protected Date getBackGroundJobDate(IObjectValue ov) throws BOSException, EASBizException {
        SecureRandom rd = null;
        try {
            rd = SecureRandom.getInstance("SHA1PRNG");
        }
        catch (NoSuchAlgorithmException e) {
            throw new BOSException();
        }
        Date date = ov.getDate(this.getEntryEffectDateField());
        date = DateTimeUtils.addMinute((Date)date, (long)(60 + rd.nextInt(60)));
        date = DateTimeUtils.addSecond((Date)date, (long)rd.nextInt(60));
        return date;
    }

    protected String getSchedule(Date date) {
        Date dt = date;
        ScheduleDef define = new ScheduleDef(null);
        define.setType(ScheduleType.ONETIME);
        define.setBeginTime(dt);
        define.setEndTime(dt);
        define.setUseCalendar(false);
        define.setInstructionType(1);
        define.setDefine(this.getScheduleDate(dt));
        String scheduleXML = KpdlParser.scheduleToString((ScheduleDef)define);
        return scheduleXML;
    }

    private String getScheduleDate(Date date) {
        int year = DateTimeUtils.getYear((Date)date);
        int month = DateTimeUtils.getMonth((Date)date);
        int day = DateTimeUtils.getDay((Date)date);
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        int hour = cal.get(11);
        int minute = cal.get(12);
        int second = cal.get(13);
        String value = second + " " + minute + " " + hour + " " + day + " " + month + " ? " + year;
        return value;
    }

    protected String getEffectProcessName(Context ctx, IObjectValue ov) throws EASBizException, BOSException {
        BOSUuid id = (BOSUuid)ov.get("id");
        BOSObjectType type = id.getType();
        IMetaDataLoader loader = MetaDataLoaderFactory.getMetaDataLoader((Context)ctx);
        EntityObjectInfo eInfo = loader.getEntity(type);
        String alias = eInfo.getAlias();
        return alias + "(" + id.toString() + ")";
    }

    protected void _dispachIntermitNumber(Context ctx, IObjectPK pk) throws CodingRuleException, EASBizException, BOSException {
        CodingRuleManageFacadeFactory.getLocalInstance(ctx).recycleNumber(pk, null, null);
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        HRBillBaseInfo info = (HRBillBaseInfo)this._getValue(ctx, pk);
        this.checkBillCanRemoved(info);
        this._dispachIntermitNumber(ctx, pk);
        this.initBizBean(ctx);
        if (this.bizBean != null) {
            this.bizBean._delete(ctx, pk);
        }
        super._delete(ctx, pk);
    }

    private void initBizBean(Context ctx) throws BOSException, EASBizException {
        if (this.bizBean == null) {
            this.bizBean = this.getBizBean();
            if (this.bizBean != null) {
                BillExtendBeanProcess billExtend = BillExtendBeanProcess.getInstance(this.bizBean.getExtendBillName(ctx));
                PlugInBeanProxy plugIn = null;
                IMetaDataLoader loader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
                EntityObjectInfo entity = loader.getEntity(this.getBOSType());
                if (entity != null) {
                    String fullName = entity.getFullName();
                    try {
                        plugIn = PlugInBeanFactory.getPlugIn(ctx, fullName);
                    }
                    catch (Exception e) {
                        throw new BOSException("PlugInBean Get Error:" + e.getMessage(), e.getCause());
                    }
                }
                IReflectMethod[] decorators = null;
                if (plugIn != null && billExtend != null) {
                    decorators = new IReflectMethod[]{plugIn, billExtend};
                } else if (billExtend != null) {
                    decorators = new IReflectMethod[]{billExtend};
                } else if (plugIn != null) {
                    decorators = new IReflectMethod[]{plugIn};
                }
                if (decorators != null) {
                    try {
                        this.bizBean = new HRBillBeanBizFactory(this.bizBean).getBizProxy(decorators);
                    }
                    catch (Throwable e) {
                        throw new BOSException("bizBean:" + this.bizBean.getExtendBillName(ctx) + ";plugin:" + plugIn, e);
                    }
                }
            }
        }
    }

    protected final IHRBillBizBean getBizBeanProxy(Context ctx) throws BOSException, EASBizException {
        this.initBizBean(ctx);
        return this.bizBean;
    }

    private IObjectValue _getBillValue(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        this.initBizBean(ctx);
        if (this.bizBean != null) {
            model = this.bizBean._getBillValue(ctx, model);
        }
        return model;
    }

    private IObjectCollection _getBillCollection(Context ctx, IObjectCollection col) throws BOSException {
        try {
            this.initBizBean(ctx);
            if (this.bizBean != null) {
                col = this.bizBean._getBillCollection(ctx, col);
            }
        }
        catch (EASBizException e) {
            throw new BOSException(e.getMessage(), e.getCause());
        }
        return col;
    }

    @Override
    protected IObjectCollection _getCollection(Context ctx, IServiceContext svcCtx, EntityViewInfo view) throws BOSException {
        IObjectCollection col = super._getCollection(ctx, svcCtx, view);
        return this._getBillCollection(ctx, col);
    }

    @Override
    protected IObjectCollection _getCollection(Context ctx, IServiceContext svcCtx, String oql) throws BOSException {
        IObjectCollection col = super._getCollection(ctx, svcCtx, oql);
        return this._getBillCollection(ctx, col);
    }

    @Override
    protected IObjectCollection _getCollection(Context ctx, IServiceContext svcCtx) throws BOSException {
        IObjectCollection col = super._getCollection(ctx, svcCtx);
        return this._getBillCollection(ctx, col);
    }

    @Override
    protected IObjectValue _getValue(Context ctx, IObjectPK pk, SelectorItemCollection selector) throws BOSException, EASBizException {
        IObjectValue model = super._getValue(ctx, pk, selector);
        return this._getBillValue(ctx, model);
    }

    @Override
    protected IObjectValue _getValue(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        IObjectValue model = super._getValue(ctx, pk);
        return this._getBillValue(ctx, model);
    }

    @Override
    protected IObjectValue _getValue(Context ctx, String oql) throws BOSException, EASBizException {
        IObjectValue model = super._getValue(ctx, oql);
        return this._getBillValue(ctx, model);
    }

    protected void _check(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        HRBillBaseInfo info = (HRBillBaseInfo)model;
        if (info == null) {
            return;
        }
        HRBillStateEnum state = (HRBillStateEnum)((Object)info.get("oldBillStateForCheck"));
        if (HRBillStateEnum.AUDITED.equals((Object)state) || HRBillStateEnum.AUDITEND.equals((Object)state)) {
            throw new AffairBizException(AffairBizException.BILL_CHECK_FAILED, new Object[]{(Object)((Object)state) + ResourceBase.getString((String)"com.kingdee.eas.hr.base.BASEAutoGenerateResource", (String)"1_HRBillBaseControllerBean", (Locale)ctx.getLocale())});
        }
        this.checkHRBillWorkFlowIsEdit(ctx, info, state);
    }

    protected void _entryEffect(Context ctx, HRBillBaseEntryInfo entry) throws BOSException, EASBizException {
    }

    protected void _beforeEffectOnNoJob(Context ctx, HRBillBaseEntryInfo entry) throws BOSException, EASBizException {
    }

    protected void _beforeEffectBeforeBackJob(Context ctx, HRBillBaseEntryInfo entry) throws BOSException, EASBizException {
    }

    protected void _beforeEffectOnBackJob(Context ctx, HRBillBaseEntryInfo entry) throws BOSException, EASBizException {
    }

    protected SelectorItemCollection getBillSelector() throws BOSException, EASBizException {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("number"));
        selector.add(new SelectorItemInfo("name"));
        selector.add(new SelectorItemInfo("billState"));
        selector.add(new SelectorItemInfo("approveType"));
        selector.add(new SelectorItemInfo("hrOrgUnit.id"));
        selector.add(new SelectorItemInfo("hrOrgUnit.CU.id"));
        selector.add(new SelectorItemInfo("adminOrg.id"));
        return selector;
    }

    protected SelectorItemCollection getEntrySelector() throws BOSException, EASBizException {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("*"));
        String billField = this.getBillField();
        if (!StringUtils.isEmpty((String)billField)) {
            selector.add(new SelectorItemInfo(billField + ".id"));
        }
        return selector;
    }

    protected String getBillField() throws BOSException, EASBizException {
        String billField = null;
        HRBillBaseConfigReader reader = this.getConfigReader();
        if (reader != null) {
            billField = reader.getField("bill");
        }
        if (StringUtils.isEmpty(billField)) {
            billField = "bill";
        }
        return billField;
    }

    protected String getEntryField() throws BOSException, EASBizException {
        String entryField = null;
        HRBillBaseConfigReader reader = this.getConfigReader();
        if (reader != null) {
            entryField = reader.getField("entry");
        }
        if (StringUtils.isEmpty(entryField)) {
            entryField = "entrys";
        }
        return entryField;
    }

    protected String getEntryEffectDateField() throws BOSException, EASBizException {
        String bizDateField = null;
        HRBillBaseConfigReader reader = this.getConfigReader();
        if (reader != null) {
            bizDateField = reader.getField("entry_effect_date");
        }
        if (StringUtils.isEmpty(bizDateField)) {
            bizDateField = "bizDate";
        }
        return bizDateField;
    }

    protected String getEntryEffectTimeField() throws BOSException, EASBizException {
        return "bizTime";
    }

    protected String getEffectFunction() throws BOSException, EASBizException {
        HRBillBaseConfigReader reader = this.getConfigReader();
        if (reader != null) {
            return reader.getFunction("entry_effect");
        }
        return null;
    }

    protected String getEffectFunction(Context ctx) throws BOSException, EASBizException {
        return this.getEffectFunction();
    }

    protected IHRBillBaseEntry getEntryInterface(Context ctx) throws BOSException, EASBizException {
        EntityObjectInfo entityInfo;
        LinkPropertyInfo prop;
        EntityObjectInfo clienEntityInfo;
        String factory;
        String factory2;
        IHRBillBaseEntry iHRBillBaseEntry = null;
        HRBillBaseConfigReader reader = this.getConfigReader();
        if (reader != null && (factory2 = reader.getFactory("entry_instance_factory")) != null) {
            iHRBillBaseEntry = (IHRBillBaseEntry)ReflectUtil.getLocalInstance(factory2, ctx);
        }
        if (iHRBillBaseEntry == null && (factory = (clienEntityInfo = (prop = (LinkPropertyInfo)(entityInfo = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx).getEntity(this.getBOSType())).getPropertyByNameRuntime(this.getEntryField())).getRelationship().getSupplierObject()).getBusinessImplFactory()) != null) {
            String bosType = (String)clienEntityInfo.get("bosType");
            iHRBillBaseEntry = (IHRBillBaseEntry)BOSObjectFactory.createBOSObject((Context)ctx, (BOSObjectType)new BOSObjectType(bosType));
        }
        return iHRBillBaseEntry;
    }

    protected boolean isNeedReverseSave() {
        return false;
    }

    protected IHRBillBizBean getBizBean() throws BOSException, EASBizException {
        HRBillBaseConfigReader reader = this.getConfigReader();
        if (reader != null) {
            return (IHRBillBizBean)reader.getObject("biz");
        }
        return null;
    }

    protected String getConfigXML() {
        return null;
    }

    protected HRBillBaseConfigReader getConfigReader() throws BOSException, EASBizException {
        return HRBillBaseConfigReader.getConfig(this.getClass(), this.getConfigXML());
    }

    protected String getPermItemNameDelete() {
        return null;
    }

    protected String getPermItemNameAddnew() {
        return null;
    }

    protected String getPermItemNameEdit() {
        return null;
    }

    @Override
    protected void _passUnaudit(Context ctx, BOSUuid billId) throws BOSException, EASBizException {
        if (billId == null) {
            return;
        }
        String billID = billId.toString();
        HRBillBaseInfo model = this.getHRBillBaseInfo(ctx, (IObjectPK)new ObjectUuidPK(billID));
        this.initBizBean(ctx);
        String entryField = this.getEntryField();
        String billField = this.getBillField();
        HRBillBaseEntryInfo entry = null;
        boolean result = false;
        IObjectCollection entries = (IObjectCollection)model.get(entryField);
        if (entries == null) {
            return;
        }
        Date now = new Date();
        Date effectDate = null;
        int size = entries.size();
        for (int i = 0; i < size; ++i) {
            entry = (HRBillBaseEntryInfo)entries.getObject(i);
            entry.put(billField, model);
            this.setUnauditIsSameDatePersonChange(ctx, entry);
            effectDate = this.getEffectDate(entry);
            if (effectDate == null || !now.after(effectDate)) continue;
            result = true;
        }
        if (result) {
            this.processAlreadyEffectUnAudit(ctx, model);
        } else {
            this.processUnEffectUnAudit(ctx, billID);
        }
        this.processUnAuidtCommon(ctx, billID);
    }

    public void processUnEffectUnAudit(Context ctx, String billID) throws BOSException, EASBizException {
        this.dropJobProcess(ctx, this.getEntryIdStr(ctx, (IObjectPK)new ObjectUuidPK(billID)));
        this.untiCheckWorkFlow(ctx, billID);
    }

    public void processAlreadyEffectUnAudit(Context ctx, HRBillBaseInfo model) throws EASBizException, BOSException {
        String entryField = this.getEntryField();
        String billField = this.getBillField();
        HRBillBaseEntryInfo entry = null;
        IObjectCollection entries = (IObjectCollection)model.get(entryField);
        if (entries == null) {
            return;
        }
        Date now = new Date();
        Date effectDate = null;
        int size = entries.size();
        for (int i = 0; i < size; ++i) {
            entry = (HRBillBaseEntryInfo)entries.getObject(i);
            entry.put(billField, model);
            effectDate = this.getEffectDate(entry);
            if (effectDate == null) continue;
            if (now.after(effectDate)) {
                this.processAlreadyEffectUnAuditEachEntry(ctx, entry, effectDate);
                continue;
            }
            this.dropJobProcess(ctx, "'" + entry.getId().toString() + "'");
        }
        this.untiCheckWorkFlow(ctx, model.getId().toString());
    }

    protected void clearProcInstBizInfo(Context ctx, HRBillBaseInfo model) throws BOSException {
        HRBillBaseInfo billInfo = model;
        String delSql = "delete from T_WFR_ProcInstBizObj where fBizObjID = '" + billInfo.getId() + "'";
        DbUtil.execute((Context)ctx, (String)delSql);
    }

    protected void processAlreadyEffectUnAuditEachEntry(Context ctx, HRBillBaseEntryInfo model, Date effectDate) throws EASBizException, BOSException {
        if (logger.isInfoEnabled()) {
            logger.info((Object)"HRBillBaseControllerBean#processAlreadyEffectUnAuditEachEntry");
        }
    }

    private void processUnAuidtCommon(Context ctx, String billID) throws BOSException, EASBizException {
        this.updateBillState(ctx, BOSUuid.read((String)billID), HRBillStateEnum.SAVED);
        if (this.bizBean != null) {
            this.bizBean._setBillState(ctx, BOSUuid.read((String)billID), HRBillStateEnum.SAVED);
        }
        boolean isRollBackShowMultiApproveInfo = false;
        String paramNum = "IS_ROLLBACK_AFTER_SHOW_MULTIAPPROVEINFO";
        HRBillBaseInfo model = this.getHRBillBaseInfo(ctx, (IObjectPK)new ObjectUuidPK(billID));
        HROrgUnitInfo hrOrgUnitIfo = model.getHrOrgUnit();
        String hrOrgUnitId = hrOrgUnitIfo.getId() == null ? null : hrOrgUnitIfo.getId().toString();
        isRollBackShowMultiApproveInfo = HRParamUtil.getParamOfHR(ctx, paramNum, hrOrgUnitId);
        if (!isRollBackShowMultiApproveInfo) {
            MultiApproveFactory.getLocalInstance((Context)ctx).delete("WHERE billId = '" + billID + "'");
        }
    }

    protected String getEntryIdStr(Context ctx, IObjectPK pk) throws EASBizException, BOSException {
        return null;
    }

    private void dropJobProcess(Context ctx, String billEntryIdStr) throws EASBizException, BOSException {
        block8: {
            BillEntryJobProcessCollection bejpCol = BillEntryJobProcessFactory.getLocalInstance(ctx).getBillEntryJobProcessCollection("where billEntryId in (" + billEntryIdStr + ")");
            StringBuffer jobProcessIdStr = new StringBuffer();
            int size = bejpCol.size();
            for (int i = 0; i < size; ++i) {
                BillEntryJobProcessInfo bejpInfo = bejpCol.get(i);
                jobProcessIdStr.append("'");
                jobProcessIdStr.append(bejpInfo.getJobProcessId());
                if (i == size - 1) {
                    jobProcessIdStr.append("'");
                    continue;
                }
                jobProcessIdStr.append("',");
            }
            if (jobProcessIdStr == null || jobProcessIdStr.length() == 0) {
                return;
            }
            IJobService jobService = JobServiceFactory.getLocalInstance((Context)ctx);
            String sql = "SELECT FID FROM T_JOB_Trigger WHERE FJobDefID in (" + jobProcessIdStr + ")";
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            try {
                if (rs.next()) {
                    rs.beforeFirst();
                    while (rs.next()) {
                        String triggerId = rs.getString(1);
                        jobService.disableTrigger(triggerId);
                    }
                    break block8;
                }
                throw new HRAffairException(HRAffairException.TRY_LATER_TIME);
            }
            catch (HRAffairException e1) {
                throw e1;
            }
            catch (Exception e) {
                throw new BOSException(e.getMessage(), (Throwable)e);
            }
        }
    }

    @Override
    protected boolean _isExistProcDef(Context ctx, String functionName, String operationName) throws BOSException, EASBizException {
        if (functionName == null || operationName == null) {
            return false;
        }
        String userID = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
        String procDef = EnactmentServiceFactory.createEnactService((Context)ctx).findProcDef(userID, functionName, operationName);
        return procDef != null && !"".equals(procDef.trim());
    }

    @Override
    protected void _setSaved(Context ctx, BOSUuid billID) throws BOSException, EASBizException {
        this.updateBillState(ctx, billID, HRBillStateEnum.SAVED);
        this.initBizBean(ctx);
        if (this.bizBean != null) {
            this.bizBean._setBillState(ctx, billID, HRBillStateEnum.SAVED);
        }
    }

    private void checkBillCanRemoved(HRBillBaseInfo info) throws AffairBizException {
        HRBillStateEnum billState = info.getBillState();
        boolean isRemovable = true;
        if (HRBillStateEnum.SUBMITED.equals((Object)billState) || HRBillStateEnum.AUDITING.equals((Object)billState)) {
            isRemovable = false;
        }
        if (!isRemovable) {
            throw new AffairBizException(AffairBizException.BILLCANTDELETE);
        }
    }

    @Override
    protected IObjectPK _submitEffect(Context ctx, CoreBaseInfo model) throws BOSException, EASBizException {
        HRBillBaseInfo bill = (HRBillBaseInfo)model;
        bill.setApproveType(ApproveTypeEnum.DIRECT);
        IObjectPK objectPK = super.save(ctx, model);
        this.setAudited(ctx, BOSUuid.read((String)objectPK.toString()));
        return objectPK;
    }

    @Override
    protected void _abortBizBill(Context ctx, String billId) throws BOSException, EASBizException {
        if (!StringUtils.isEmpty((String)billId)) {
            IHRBillBase iHRBillBase = (IHRBillBase)MetaDataServerUtil.getBizInterface(ctx, BOSUuid.read((String)billId).getType());
            HRBillBaseInfo billInfo = iHRBillBase.getHRBillBaseInfo((IObjectPK)new ObjectUuidPK(billId));
            HRBillStateEnum billState = billInfo.getBillState();
            if (HRBillStateEnum.SUBMITED.equals((Object)billState) || HRBillStateEnum.AUDITING.equals((Object)billState) || HRBillStateEnum.AUDITEND.equals((Object)billState)) {
                iHRBillBase.setSaved(BOSUuid.read((String)billId));
                this.abortWorkFlow(ctx, billId);
                this.clearProcInstBizInfo(ctx, billInfo);
            } else {
                throw new AffairBizException(AffairBizException.BILLSTATECANTSUPPORT);
            }
        }
    }

    protected void abortWorkFlow(Context ctx, String billId) throws BOSException {
        IEnactmentService service = EnactmentServiceFactory.createEnactService((Context)ctx);
        ProcessInstInfo[] procInsts = service.getProcessInstanceByHoldedObjectId(billId);
        if (procInsts == null || procInsts.length <= 0) {
            return;
        }
        ProcessInstInfo processInstInfo = null;
        int length = procInsts.length;
        for (int i = 0; i < length; ++i) {
            if (!procInsts[i].getState().startsWith("open")) continue;
            processInstInfo = procInsts[i];
        }
        if (processInstInfo != null) {
            service.abortProcessInst(processInstInfo.getProcInstId().toString());
        }
    }

    @Override
    protected void _untiCheckBizBill(Context ctx, String billId) throws BOSException, EASBizException {
        if (!StringUtils.isEmpty((String)billId)) {
            IHRBillBase iHRBillBase = (IHRBillBase)MetaDataServerUtil.getBizInterface(ctx, BOSUuid.read((String)billId).getType());
            HRBillBaseInfo billInfo = iHRBillBase.getHRBillBaseInfo((IObjectPK)new ObjectUuidPK(billId));
            HRBillStateEnum billState = billInfo.getBillState();
            if (HRBillStateEnum.AUDITED.equals((Object)billState)) {
                iHRBillBase.setSubmited(BOSUuid.read((String)billId));
                iHRBillBase.passUnaudit(BOSUuid.read((String)billId));
            } else {
                throw new AffairBizException(HRBaseException.BILLSTATECANUNCHECK);
            }
        }
    }

    @Override
    protected void _sendAssignedMsgToXT(Context ctx, BOSUuid billID) throws BOSException, EASBizException {
    }

    protected IHRBillBizBean getParentBizBean() {
        return this.bizBean;
    }

    protected boolean checkIsCreateJob() {
        return true;
    }

    protected void untiCheckWorkFlow(Context ctx, String billId) throws BOSException {
        IEnactmentService service = EnactmentServiceFactory.createEnactService((Context)ctx);
        ProcessInstInfo[] procInsts = service.getProcessInstanceByHoldedObjectId(billId);
        if (procInsts == null || procInsts.length <= 0) {
            return;
        }
        ProcessInstInfo processInstInfo = null;
        int length = procInsts.length;
        for (int i = 0; i < length; ++i) {
            if (!procInsts[i].getState().startsWith("open")) continue;
            processInstInfo = procInsts[i];
        }
        try {
            String sql;
            IRowSet rs;
            if (processInstInfo != null && (rs = DbUtil.executeQuery((Context)ctx, (String)(sql = "SELECT FASSIGNID,FPERSONUSERID,FISSENDMSG,FBIZPACKAGE,FBIZFUNCTION FROM t_wfr_assign where FBIZOBJID = ?"), (Object[])new Object[]{billId})).size() > 0) {
                WfUtil wfUtil = new WfUtil(ctx);
                String message = SHRServerResource.getString((String)"com.kingdee.eas.hr.base.HRBaseBizResource", (String)"label174", (Context)ctx);
                wfUtil.abort(processInstInfo.getProcInstId().toString(), message);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
    }

    protected void executeOther(Context ctx, HRBillBaseEntryInfo entry, Exception exception) throws BOSException {
    }
}

